/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.ras.xci.XCICustomLoggers;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.NameTest;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.CopiedCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedComment;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedPI;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedText;
import com.ibm.xml.xci.dp.cache.dom.EmptyNodeList;
import com.ibm.xml.xci.dp.cache.dom.FastAccessSupport;
import com.ibm.xml.xci.dp.cache.dom.InternalNodeData;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.dom.mediator.CopiedCacheMediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.Mediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.NullDataFactory;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingCursorMediator;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.DMUtil;
import com.ibm.xml.xci.dp.util.EmptyCData;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.dp.util.fixers.MoveFixer;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.ItemPSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DOMCachedNode
extends AbstractCursor
implements NodeTest,
Node,
ItemCopier {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final Cursor.Profile FROZEN_CACHE_NODE_PROFILE = Cursor.Profile.FROZEN.union(Cursor.Profile.SET_VALUE.union(Cursor.Profile.REMOVE_ATTRIBUTE.union(Cursor.Profile.REMOVE_SUBTREE.union(Cursor.Profile.IS_DEEP_EQUAL_TO))));
    private static final Logger logger = LoggerUtil.getLogger(DOMCachedNode.class);
    protected CacheManager cache;
    protected DOMCachedContainer parent;
    protected DOMCachedNode following;
    protected DOMCachedNode preceding;
    protected int state;
    protected InternalNodeData internalNodeData;
    static final VolatileCData EMPTY_QNAME_VOLATILECDATA = new EmptyCData(TypeRegistry.XSQNAME);

    protected DOMCachedNode(CacheManager cacheManager) {
        super(cacheManager.factory(), false);
        this.cache = cacheManager;
        if (this.itemKind() == 9) {
            this.internalNodeData = this.cache.createUserData(this);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "DOMCachedNode", "creating a new DOMCachedNode: " + this.toStringLazy() + "\nCache manager = " + this.getCache() + " | Mediator (default) = " + this.getCache().mediator() + " | Mediator (for node) = " + this.getMediatorData());
        }
    }

    protected DOMCachedNode(CacheManager cacheManager, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        this(cacheManager);
        if (dOMCachedContainer != null) {
            this.setParent(dOMCachedContainer);
            if (dOMCachedNode == null) {
                if (this.itemKind() == 4) {
                    ((DOMCachedElement)dOMCachedContainer).addBuiltNamespace((DOMCachedNamespace)this);
                } else if (this.itemKind() == 2) {
                    ((DOMCachedElement)dOMCachedContainer).addBuiltAttribute((DOMCachedAttribute)this);
                } else {
                    dOMCachedContainer.addBuiltFirstChild(this);
                }
            } else {
                assert (dOMCachedContainer == dOMCachedNode.getBuiltParent()) : "Cannot have siblings with different parents!";
                dOMCachedContainer.addBuiltNextChild(this, dOMCachedNode);
            }
        }
        this.cache.registerNode(this);
    }

    protected boolean isAncestor(DOMCachedNode dOMCachedNode) {
        return dOMCachedNode == this || this.parent != null && this.parent.isAncestor(dOMCachedNode);
    }

    public final CacheManager getCache() {
        return this.cache;
    }

    public final boolean isCopy() {
        if (this.internalNodeData != null) {
            return this.internalNodeData.getOriginalNode() != null;
        }
        return false;
    }

    public int getCacheNodeKind() {
        return this.itemKind();
    }

    public abstract boolean satisfies(NodeTest var1);

    public DOMCachedNode getCachedRoot() {
        return this.getBuiltRoot();
    }

    public DOMCachedNode getBuiltRoot() {
        return this.cache.getBuiltRootNode();
    }

    public final DOMCachedContainer getBuiltParent() {
        return this.parent;
    }

    public final DOMCachedContainer getCachedParent() {
        return this.parent;
    }

    public abstract DOMCachedAttribute getCachedFirstAttribute();

    public abstract DOMCachedAttribute getCachedLastAttribute();

    public abstract DOMCachedAttribute getCachedNamedAttribute(NodeTest var1);

    public DOMCachedNamespace getCachedNamedNamespace(NodeTest nodeTest) {
        return null;
    }

    public DOMCachedNamespace getCachedNamedNamespace(String string2, String string3) {
        return null;
    }

    protected DOMCachedAttribute getBuiltNamedAttribute(NodeTest nodeTest) {
        return null;
    }

    public DOMCachedNamespace getCachedFirstNamespaceNode() {
        return null;
    }

    @Override
    public Cursor itemCopy(Cursor.Profile profile, Map<String, Object> map2) {
        Object object2;
        Object object3;
        Object object5;
        boolean bl = LoggerUtil.isAnyTracingEnabled();
        boolean bl2 = !CacheManager.needSDOGMCompatibility(this.factory);
        int n2 = 0;
        if (map2 != null) {
            object5 = map2.get("copy-on-write");
            if (object5 != null && object5 instanceof Boolean) {
                bl2 = (Boolean)object5;
            }
            if (bl2) {
                for (String object42 : map2.keySet()) {
                    if ("copy-on-write".equals(object42)) continue;
                    if ("copy-preserve-schema-declarations".equals(object42)) {
                        object3 = map2.get("copy-preserve-schema-declarations");
                        if (object3 == null || !(object3 instanceof Boolean)) continue;
                        n2 = (Boolean)object3 != false ? n2 | 0x80 : n2;
                        continue;
                    }
                    if ("copy-preserve-psvi".equals(object42)) {
                        object3 = map2.get("copy-preserve-psvi");
                        if (object3 == null || !(object3 instanceof Boolean)) continue;
                        n2 = (Boolean)object3 != false ? n2 | 2 : n2;
                        continue;
                    }
                    bl2 = false;
                    break;
                }
            }
        }
        if (bl) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "itemCopy", "CopyOnwrite= " + bl2 + ", called for node:" + this.toStringLazy(null, "", true));
            }
            if (logger.isLoggable(Level.FINEST)) {
                object5 = null;
                if (map2 != null) {
                    object2 = new StringBuilder(map2.size());
                    Iterator<String> exception = map2.keySet().iterator();
                    ((StringBuilder)object2).append('{');
                    while (exception.hasNext()) {
                        object3 = exception.next();
                        ((StringBuilder)object2).append('(');
                        ((StringBuilder)object2).append((String)object3);
                        ((StringBuilder)object2).append(',');
                        ((StringBuilder)object2).append(map2.get(object3));
                        ((StringBuilder)object2).append(')');
                    }
                    ((StringBuilder)object2).append('}');
                    object5 = ((StringBuilder)object2).toString();
                }
                logger.logp(Level.FINEST, logger.getName(), "itemCopy", "Parameters={" + (String)object5 + "}");
            }
        }
        if (bl2) {
            if (this.isCleanCopy()) {
                object2 = this.getOriginalNode();
                while (((DOMCachedNode)object2).isCleanCopy()) {
                    object2 = ((DOMCachedNode)object2).getOriginalNode();
                }
                if (bl && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "itemCopy", "About to make a CLEAN copy from node: " + ((DOMCachedNode)object2).toStringLazy(null, "", true));
                }
                object5 = ((DOMCachedNode)object2).cache.copy((DOMCachedNode)object2, profile, true, bl2, n2);
            } else {
                if (bl && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "itemCopy", "About to make a CHAINED copy from the entry node");
                }
                object5 = this.cache.copy(this, profile, true, bl2, n2);
            }
        } else {
            if (bl && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "itemCopy", "NOT doing copy-on-write");
            }
            object2 = new HashMap();
            object2.put("FAST_ACCESS", new Byte(0));
            RequestInfo requestInfo = new RequestInfo(profile.union(Copier.TARGET_FEATURES), (Map<String, Object>)object2);
            if (map2 == null) {
                map2 = new HashMap<String, Object>();
            }
            map2.put("ITEM_COPY_REQUEST_INFO", requestInfo);
            object5 = super.itemCopy(profile, map2);
        }
        object2 = (DOMCachedNode)object5.unwrap();
        if (!bl2) {
            ((DOMCachedNode)object2).setState(LazyLoadingHelper.markAllResolved(((DOMCachedNode)object2).state));
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            try {
                DOMCachedNode dOMCachedNode = (DOMCachedNode)object5.unwrap();
                logger.logp(Level.FINER, logger.getName(), "itemCopy", "Copied item= " + dOMCachedNode.toStringLazy());
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return object5;
    }

    public boolean isCleanCopy() {
        if (!this.isCopy()) {
            return false;
        }
        return !this.isDirty();
    }

    public DOMCachedNamespace getCachedLastNamespaceNode() {
        return null;
    }

    public abstract DOMCachedNode getCachedFirstChild();

    public DOMCachedNode getCachedFirstChild(NodeTest nodeTest) {
        return null;
    }

    public abstract DOMCachedNode getCachedLastChild();

    public DOMCachedNode getCachedFollowingSibling() {
        if (this.following == null && !LazyLoadingHelper.isFollowingBuilt(this.state)) {
            this.cache.mediator(this).buildNext(this);
            this.setState(LazyLoadingHelper.markFollowingResolved(this.state));
        }
        return this.following;
    }

    public DOMCachedNode getCachedFollowingSibling(NodeTest nodeTest) {
        if (nodeTest == null) {
            return this.getCachedFollowingSibling();
        }
        for (DOMCachedNode dOMCachedNode = this.getCachedFollowingSibling(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getCachedFollowingSibling()) {
            if (!dOMCachedNode.satisfies(nodeTest)) continue;
            return dOMCachedNode;
        }
        return null;
    }

    public final DOMCachedNode getBuiltFollowingSibling() {
        return this.following;
    }

    public void setBuiltFollowingSibling(DOMCachedNode dOMCachedNode) {
        CharSequence charSequence;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            charSequence = dOMCachedNode == null ? "" : dOMCachedNode.toStringLazy();
            logger.logp(Level.FINEST, logger.getName(), "setBuiltFollowingSibling", "this = " + this.toStringLazy() + "node passed in = " + (String)charSequence + "\nStack trace=" + XCIErrorHelper.getStackTrace(15));
        }
        if (dOMCachedNode == this) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Adding cycle to: ");
            ((StringBuilder)charSequence).append(this.toStringLazy());
            ((StringBuilder)charSequence).append("\nStack trace:");
            ((StringBuilder)charSequence).append(XCIErrorHelper.getStackTrace(20));
            FFDCUtil.log(XCIErrorHelper.createInternalException(((StringBuilder)charSequence).toString()), this);
        }
        this.following = dOMCachedNode;
    }

    public void setBuiltPrecedingSibling(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            String string2 = dOMCachedNode == null ? "" : dOMCachedNode.toStringLazy();
            logger.logp(Level.FINEST, logger.getName(), "setBuiltPrecedingSibling", "this = " + this.toStringLazy() + "node passed in = " + string2 + "\nStack trace=" + XCIErrorHelper.getStackTrace(15));
        }
        this.preceding = dOMCachedNode;
    }

    public DOMCachedNode getBuiltFollowingSibling(NodeTest nodeTest) {
        if (nodeTest == null) {
            return this.getBuiltFollowingSibling();
        }
        for (DOMCachedNode dOMCachedNode = this.getBuiltFollowingSibling(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltFollowingSibling()) {
            if (!dOMCachedNode.satisfies(nodeTest)) continue;
            return dOMCachedNode;
        }
        return null;
    }

    public DOMCachedNode getCachedPrecedingSibling() {
        return this.getBuiltPrecedingSibling();
    }

    public DOMCachedNode getCachedPrecedingSibling(NodeTest nodeTest) {
        return this.getBuiltPrecedingSibling(nodeTest);
    }

    protected DOMCachedNode getBuiltPrecedingSibling(NodeTest nodeTest) {
        DOMCachedNode dOMCachedNode = this.preceding;
        while (dOMCachedNode != null) {
            if (nodeTest == null || dOMCachedNode.satisfies(nodeTest)) {
                return dOMCachedNode;
            }
            dOMCachedNode = dOMCachedNode.preceding;
        }
        return null;
    }

    public final DOMCachedNode getBuiltPrecedingSibling() {
        return this.preceding;
    }

    public DOMCachedAttribute getBuiltFirstAttribute() {
        return null;
    }

    public DOMCachedAttribute getBuiltLastAttribute() {
        return null;
    }

    public DOMCachedNamespace getBuiltFirstNamespace() {
        return null;
    }

    public DOMCachedNamespace getBuiltLastNamespace() {
        return null;
    }

    public DOMCachedNode getBuiltFirstChild() {
        return null;
    }

    public DOMCachedNode getBuiltFirstChild(NodeTest nodeTest) {
        return null;
    }

    public final void visitAttributes() {
        MiscHelpers.visitAttributes(this);
    }

    public final void visitNamespaceNodes() {
        MiscHelpers.visitNamespaceNodes(this);
    }

    public final void visitChildren() {
        MiscHelpers.visitChildren(this);
    }

    public final void visitSubtree() {
        MiscHelpers.visitSubtree(this);
    }

    public final Map getDOMUserData() {
        return this.internalNodeData.getDOMUserData();
    }

    public final void setDOMUserData(Map map2) {
        this.internalNodeData.setDOMUserData(map2);
    }

    public final void setMediatorData(Mediator mediator) {
        this.internalNodeData.setMediatorData(mediator);
    }

    public final Mediator getMediatorData() {
        if (this.internalNodeData != null) {
            return this.internalNodeData.getMediatorData();
        }
        return null;
    }

    public final DOMCachedNode getOriginalNode() {
        if (this.internalNodeData != null) {
            return this.internalNodeData.getOriginalNode();
        }
        return null;
    }

    public final void setOriginalNode(DOMCachedNode dOMCachedNode) {
        this.internalNodeData.setOriginalNode(dOMCachedNode);
    }

    public final InternalNodeData getInternalNodeData() {
        return this.internalNodeData;
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int n2) {
        if (LoggerUtil.isAnyTracingEnabled()) {
            boolean bl = XCICustomLoggers.objectCacheMutationLogger.isLoggable(Level.FINEST);
            boolean bl2 = logger.isLoggable(Level.FINEST);
            if (bl || bl2) {
                String string2 = "Setting new state {" + DMUtil.stateSource(n2) + "} into node: " + this.toStringLazy();
                if (bl) {
                    XCICustomLoggers.objectCacheMutationLogger.logp(Level.FINEST, XCICustomLoggers.objectCacheMutationLogger.getName(), "setState", string2 + "\nStack Trace:" + XCIErrorHelper.getStackTrace(20));
                } else if (bl2) {
                    logger.logp(Level.FINEST, logger.getName(), "setState", string2);
                }
            }
        }
        this.state = n2;
    }

    public final void dereference() {
        this.cache.unreferenced(this);
    }

    public final DOMCachedNode reference() {
        this.cache.referenced(this);
        return this;
    }

    public void unlink() {
        this.unlink(true);
    }

    public void unlink(boolean bl) {
        if (this.following != null && this.isCopy() && this.cache != this.following.cache) {
            this.makeCopy(this.following);
        }
        if (this.parent != null) {
            if (this.itemKind() == 4) {
                DOMCachedElement dOMCachedElement = (DOMCachedElement)this.parent;
                if (dOMCachedElement.builtFirstNamespace == this) {
                    dOMCachedElement.builtFirstNamespace = (DOMCachedNamespace)this.following;
                }
            } else if (this.itemKind() == 2) {
                DOMCachedElement dOMCachedElement = (DOMCachedElement)this.parent;
                if (dOMCachedElement.builtFirstAttribute == this) {
                    dOMCachedElement.builtFirstAttribute = (DOMCachedAttribute)this.following;
                }
            } else if (this.parent.builtFirstChild == this) {
                this.parent.setBuiltFirstChild(this.following);
            }
        }
        if (this.preceding != null) {
            this.preceding.setBuiltFollowingSibling(this.following);
        }
        if (this.following != null) {
            this.following.preceding = this.preceding;
        }
        if (bl) {
            this.checkAdjacent(this.preceding, this.following);
        }
        this.parent = null;
        this.preceding = null;
        this.setBuiltFollowingSibling(null);
    }

    public void updateCacheLazy(CacheManager cacheManager) {
        boolean bl = LoggerUtil.isAnyTracingEnabled();
        if (bl && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "updateCacheLazy", "We are about to update the CacheManager of the following tree: \n" + this.toStringLazy(null, "", true) + "\n New CacheManager=" + cacheManager + "\n Stack Trace: " + XCIErrorHelper.getStackTrace(20));
        }
        if (this.isCopy() && this.cache != null) {
            Mediator mediator;
            Mediator mediator2 = mediator = this.getMediatorData() != null ? this.getMediatorData().getWrappedMediator() : null;
            if (mediator instanceof CopiedCacheMediator) {
                ((CopiedCacheMediator)mediator).copySubtreeLazy(this, this.cache);
                if (bl && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "updateCacheLazy", "Finished preparing copied node: \n" + this.toStringLazy(null, "", true));
                }
            }
        }
        this.internalUpdateLazySubtree(this, cacheManager);
        CacheManager.mergeReferencedCopies(this.cache, cacheManager);
        if (this.cache.getAttemptFastSerialization()) {
            cacheManager.setAttemptFastSerialization(true);
        }
        if (this.cache.getContainsMovedCopy() || this.isCopy()) {
            cacheManager.setContainsMovedCopy(true);
        }
        this.setCacheManager(cacheManager);
        if (bl && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "updateCacheLazy", "Finished updating CacheManager for tree: \n" + this.toStringLazy(null, "", true));
        }
    }

    public boolean hasFastChildCopy(DOMCachedNode dOMCachedNode) {
        return false;
    }

    protected void internalUpdateLazySubtree(DOMCachedNode dOMCachedNode, CacheManager cacheManager) {
        for (DOMCachedNamespace dOMCachedNamespace = dOMCachedNode.getBuiltFirstNamespace(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getBuiltFollowingNamespaceNode()) {
            dOMCachedNamespace.setCacheManager(cacheManager);
        }
        for (DOMCachedAttribute dOMCachedAttribute = dOMCachedNode.getBuiltFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getBuiltFollowingAttribute()) {
            MiscHelpers.updateAttribute(dOMCachedAttribute, cacheManager);
        }
        DOMCachedNode dOMCachedNode2 = dOMCachedNode.getBuiltFirstChild();
        while (dOMCachedNode2 != null) {
            this.internalUpdateLazySubtree(dOMCachedNode2, cacheManager);
            DOMCachedNode dOMCachedNode3 = dOMCachedNode2.getBuiltFollowingSibling();
            dOMCachedNode2.setCacheManager(cacheManager);
            dOMCachedNode2 = dOMCachedNode3;
        }
    }

    public void updateCacheEntire(CacheManager cacheManager) {
        Mediator mediator;
        boolean bl = LoggerUtil.isAnyTracingEnabled();
        if (bl && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "updateCacheEntire", "We are about to update the CacheManager of the following tree: \n" + this.toStringLazy(null, "", true) + "\n New CacheManager=" + cacheManager + "\n Stack Trace: " + XCIErrorHelper.getStackTrace(20));
        }
        if (this.isCopy() && (mediator = this.getMediatorData().getWrappedMediator()) instanceof CopiedCacheMediator) {
            ((CopiedCacheMediator)mediator).copySubtreeEager(this);
            if (bl && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "updateCacheEntire", "Finished preparing copied node: \n" + this.toStringLazy(null, "", true));
            }
        }
        MiscHelpers.updateEntireSubtree(this, cacheManager);
        if (this instanceof DOMCachedAttribute) {
            MiscHelpers.updateAttribute((DOMCachedAttribute)this, cacheManager);
        }
        CacheManager.mergeReferencedCopies(this.cache, cacheManager);
        if (this.cache.getAttemptFastSerialization()) {
            cacheManager.setAttemptFastSerialization(true);
        }
        if (this.cache.getContainsMovedCopy()) {
            cacheManager.setContainsMovedCopy(true);
        }
        this.setCacheManager(cacheManager);
        this.cache.rootNode = this;
    }

    public int depth() {
        return this.parent == null ? 0 : 1 + this.parent.depth();
    }

    public boolean isDirty() {
        return BitMaskHelper.stateContains(this.state, 131072);
    }

    public boolean isSubtreeDirty() {
        return BitMaskHelper.stateContains(this.state, 0x100000);
    }

    public boolean isMutationMapQueued() {
        return BitMaskHelper.stateContains(this.state, 0x200000);
    }

    public boolean isParentChainMutationMapQueue(boolean bl) {
        if (this.parent == null) {
            return this.isMutationMapQueued();
        }
        if (!bl && this.isMutationMapQueued()) {
            return true;
        }
        if (this.parent.isParentChainMutationMapQueue(false)) {
            this.setState(BitMaskHelper.stateSet(this.getState(), 0x200000));
            return true;
        }
        return false;
    }

    public DOMCachedElement addCachedElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        DOMCachedElement dOMCachedElement;
        if (xSTypeDefinition == null) {
            xSTypeDefinition = TypeRegistry.XSANYTYPE;
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "addCachedElement", "area=" + area.toString() + " from node=" + this.toStringLazy());
        }
        this.cache.ensureStateResolved(this, area);
        this.cache.notifyNodeAboutToChangeToCopies(this, area.immediateArea());
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                dOMCachedElement = this.cache.makeCachedElement(volatileCData, xSTypeDefinition, null, null, false, (DOMCachedContainer)this, null);
                break;
            }
            case LAST_CHILD: {
                dOMCachedElement = this.cache.makeCachedElement(volatileCData, xSTypeDefinition, null, null, false, (DOMCachedContainer)this, this.getCachedLastChild());
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                dOMCachedElement = this.cache.makeCachedElement(volatileCData, xSTypeDefinition, null, null, false, this.getBuiltParent(), this);
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
        if (BitMaskHelper.stateContains(dOMCachedElement.state, 64)) {
            dOMCachedElement.setState(LazyLoadingHelper.markAllExceptChildrenResolved(dOMCachedElement.state));
        } else {
            dOMCachedElement.setState(dOMCachedElement.state | LazyLoadingHelper.markAllResolved());
        }
        this.setDirty(dOMCachedElement);
        dOMCachedElement.setState(dOMCachedElement.state | 0x400000);
        return dOMCachedElement;
    }

    protected DOMCachedNode removeCachedSubtree(Cursor.Area area) {
        DOMCachedNode dOMCachedNode;
        this.setState(BitMaskHelper.stateSet(this.state, 16));
        this.cache.ensureStateResolved(this, area);
        if (area == Cursor.Area.SELF) {
            if (this.itemKind() == 1) {
                ((DOMCachedElement)this).saveNSList(true);
            }
            this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.SUBTREE.immediateArea(), true);
        } else {
            this.cache.notifyNodeAboutToChangeToCopies(this, area.immediateArea(), true);
        }
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                dOMCachedNode = this.getBuiltFirstChild();
                if (dOMCachedNode != null) {
                    dOMCachedNode.setDirty();
                }
                if (dOMCachedNode == null) break;
                if (!LazyLoadingHelper.isSubtreeBuilt(dOMCachedNode.state)) {
                    dOMCachedNode.visitChildren();
                }
                if (!LazyLoadingHelper.isFollowingBuilt(dOMCachedNode.state)) {
                    dOMCachedNode.getCachedFollowingSibling();
                }
                ((DOMCachedContainer)this).unlinkChild(dOMCachedNode);
                break;
            }
            case LAST_CHILD: {
                dOMCachedNode = this.getCachedLastChild();
                if (dOMCachedNode != null) {
                    dOMCachedNode.setDirty();
                }
                ((DOMCachedContainer)this).unlinkChild(dOMCachedNode);
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                dOMCachedNode = this.getBuiltFollowingSibling();
                if (dOMCachedNode != null) {
                    dOMCachedNode.setDirty();
                }
                if (dOMCachedNode == null) break;
                dOMCachedNode.getCachedFollowingSibling();
                this.getBuiltParent().unlinkChild(dOMCachedNode);
                break;
            }
            case SELF: {
                this.setDirty();
                if (this.getBuiltParent() != null) {
                    dOMCachedNode = this;
                    dOMCachedNode.getCachedFollowingSibling();
                    this.getBuiltParent().unlinkChild(dOMCachedNode);
                    break;
                }
                dOMCachedNode = null;
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
        if (dOMCachedNode != null) {
            dOMCachedNode.updateCacheLazy(this.cache.getNewInstance());
            dOMCachedNode.cache.rootNode = dOMCachedNode;
        }
        return dOMCachedNode;
    }

    @Override
    public Cursor.Profile profile() {
        return FROZEN_CACHE_NODE_PROFILE;
    }

    @Override
    public final Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public final Cursor.Profile futureProfile() {
        return this.cache.featuresLimit(this);
    }

    @Override
    public abstract short itemKind();

    @Override
    public boolean itemIsAtomic() {
        return false;
    }

    @Override
    public boolean itemIsID() {
        return false;
    }

    @Override
    public VolatileCData itemName() {
        return EMPTY_QNAME_VOLATILECDATA;
    }

    @Override
    public abstract VolatileCData itemValue();

    @Override
    public abstract Chars itemSValue();

    public CharSequence getString(VolatileCData volatileCData) {
        if (volatileCData.getSize() == 1) {
            return volatileCData;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = volatileCData.getSize();
        for (int i = 1; i <= n2; ++i) {
            if (i != 1) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(volatileCData);
        }
        return stringBuilder;
    }

    @Override
    public abstract void setItemValue(VolatileCData var1);

    @Override
    public void setItemName(VolatileCData volatileCData) {
        throw XCIErrorHelper.createBadContextItemException("setItemName", this.itemKind());
    }

    public void setItemPSVI(ItemPSVI itemPSVI, boolean bl) {
        throw XCIErrorHelper.createBadContextItemException("setItemPSVI", this.itemKind());
    }

    @Override
    public void setItemPSVI(ItemPSVI itemPSVI) {
        throw XCIErrorHelper.createBadContextItemException("setItemPSVI", this.itemKind());
    }

    @Override
    public void setItemXSType(XSTypeDefinition xSTypeDefinition) {
        throw XCIErrorHelper.createBadContextItemException("setItemXSType", this.itemKind());
    }

    protected void checkSetItemName(VolatileCData volatileCData) {
        if (volatileCData == null) {
            throw XCIErrorHelper.createBadArgumentException("name", "null");
        }
        try {
            volatileCData.getQNameNamespaceURI(1);
        }
        catch (XCIDynamicErrorException xCIDynamicErrorException) {
            throw XCIErrorHelper.createBadArgumentException("name", volatileCData.toString());
        }
    }

    @Override
    public ExtendedNamespaceContext itemNamespaceContext() {
        return this.itemNamespaceContext(false);
    }

    @Override
    public ExtendedNamespaceContext itemNamespaceContext(boolean bl) {
        return null;
    }

    @Override
    public boolean toSelf() {
        return true;
    }

    @Override
    public void release() {
        this.cache.free(this);
        super.release();
    }

    @Override
    public final Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        return this.cache.fork(this, profile, bl, profile2);
    }

    @Override
    public long contextPosition() {
        if (this.parent != null) {
            return 1L;
        }
        long l = 0L;
        DOMCachedNode dOMCachedNode = this;
        while (dOMCachedNode != null) {
            ++l;
            dOMCachedNode = dOMCachedNode.preceding;
        }
        return l;
    }

    @Override
    public long contextSize() {
        if (this.parent != null) {
            return 1L;
        }
        long l = this.contextPosition();
        DOMCachedNode dOMCachedNode = this.following;
        while (dOMCachedNode != null) {
            ++l;
            dOMCachedNode = dOMCachedNode.following;
        }
        return l;
    }

    @Override
    public boolean itemIsSameDocument(Cursor cursor2) {
        if (!((cursor2 = cursor2.unwrap()) instanceof DOMCachedNode)) {
            return false;
        }
        return this.getBuiltRoot() == ((DOMCachedNode)cursor2).getBuiltRoot();
    }

    @Override
    public boolean itemIsSameNode(Cursor cursor2) {
        return this == cursor2.unwrap();
    }

    @Override
    public boolean contextIsSingleton() {
        return this.parent != null || this.preceding == null && this.following == null;
    }

    @Override
    public Object exportAs(String string2, boolean bl) {
        if ("expdom2".equals(string2) || "expdom1".equals(string2)) {
            return bl ? this : this.reference();
        }
        return super.exportAs(string2, bl);
    }

    @Override
    public Class<?> exportAsClass(String string2) {
        if ("expdom2".equals(string2) || "expdom1".equals(string2)) {
            return Node.class;
        }
        return super.exportAsClass(string2);
    }

    @Override
    public boolean openMutation(Cursor.Area area) {
        return this.cache.openMutation(this, area);
    }

    @Override
    public void closeMutation() {
        this.cache.closeMutation(this);
    }

    @Override
    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        throw XCIErrorHelper.createBadContextItemException("addAttribute", this.itemKind());
    }

    @Override
    public boolean removeAttribute(VolatileCData volatileCData) {
        throw XCIErrorHelper.createBadContextItemException("removeAttribute", this.itemKind());
    }

    @Override
    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        short s = this.itemKind();
        short[] sArray = new short[]{2, 4};
        Cursor.Area[] areaArray = new Cursor.Area[]{Cursor.Area.FIRST_CHILD, Cursor.Area.LAST_CHILD, Cursor.Area.FOLLOWING_SIBLING};
        if (XCIErrorHelper.checkDisallowedKind(s, sArray)) {
            throw XCIErrorHelper.createBadContextItemException("addElement", s);
        }
        if (!XCIErrorHelper.checkAllowedArea(area, areaArray)) {
            throw XCIErrorHelper.createBadArgumentException("where", area.toString());
        }
        if (volatileCData == null) {
            throw XCIErrorHelper.createBadArgumentException("value", "null");
        }
        try {
            volatileCData.getQNameNamespaceURI(1);
        }
        catch (XCIDynamicErrorException xCIDynamicErrorException) {
            throw XCIErrorHelper.createBadArgumentException("name", volatileCData.toString());
        }
        if (!XCIErrorHelper.addElementOrTextCheck(area, s)) {
            throw XCIErrorHelper.createBadMutationCombination(s);
        }
        this.addCachedElement(area, volatileCData, xSTypeDefinition);
    }

    @Override
    public void addText(Cursor.Area area, VolatileCData volatileCData) {
        short s = this.itemKind();
        if (!XCIErrorHelper.checkAddText(area, s)) {
            throw XCIErrorHelper.createBadMutationCombination(s);
        }
        if (volatileCData == null) {
            throw XCIErrorHelper.createBadArgumentException("value", "null");
        }
        this.cache.ensureStateResolved(this, area);
        this.cache.notifyNodeAboutToChangeToCopies(this, area.immediateArea());
        DOMCachedNode dOMCachedNode = null;
        boolean bl = false;
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                if (this.checkAdjacent(this.getBuiltFirstChild(), volatileCData, false)) {
                    bl = true;
                    dOMCachedNode = this.getBuiltFirstChild();
                    break;
                }
                dOMCachedNode = this.cache.makeCachedText(volatileCData, false, false, (DOMCachedContainer)this, null);
                break;
            }
            case LAST_CHILD: {
                if (this.checkAdjacent(this.getCachedLastChild(), volatileCData, true)) {
                    bl = true;
                    dOMCachedNode = this.getCachedLastChild();
                    break;
                }
                dOMCachedNode = this.cache.makeCachedText(volatileCData, false, false, (DOMCachedContainer)this, this.getCachedLastChild());
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                if (this.checkAdjacent(this, volatileCData, true)) {
                    bl = true;
                    dOMCachedNode = this;
                    break;
                }
                if (this.checkAdjacent(this.following, volatileCData, false)) {
                    bl = true;
                    dOMCachedNode = this;
                    break;
                }
                dOMCachedNode = this.cache.makeCachedText(volatileCData, false, false, this.getBuiltParent(), this);
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
        if (!bl) {
            dOMCachedNode.setState(LazyLoadingHelper.markAllResolved());
        }
        this.setDirty(dOMCachedNode);
        dOMCachedNode.setState(BitMaskHelper.stateSet(dOMCachedNode.state, 0x400000));
    }

    protected boolean checkAdjacent(DOMCachedNode dOMCachedNode, VolatileCData volatileCData, boolean bl) {
        if (dOMCachedNode == null) {
            return false;
        }
        if (dOMCachedNode instanceof DOMCachedText) {
            DOMCachedText dOMCachedText = (DOMCachedText)dOMCachedNode;
            String string2 = bl ? dOMCachedText.getData().concat(volatileCData.toString()) : volatileCData.toString().concat(dOMCachedText.getData());
            dOMCachedText.setData(string2);
            return true;
        }
        return false;
    }

    protected boolean checkAdjacent(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        if (dOMCachedNode != null && dOMCachedNode2 != null && dOMCachedNode instanceof DOMCachedText && dOMCachedNode2 instanceof DOMCachedText) {
            if (dOMCachedNode.isCopy() || dOMCachedNode2.isCopy()) {
                DOMCachedNode dOMCachedNode3 = dOMCachedNode.getCachedFollowingSibling();
                assert (dOMCachedNode3 != null);
                while (dOMCachedNode3.getCachedFollowingSibling() != null) {
                    dOMCachedNode3 = dOMCachedNode3.getCachedFollowingSibling();
                }
                if (this.isCopy()) {
                    this.makeCopy(dOMCachedNode3);
                } else if (dOMCachedNode.isCopy()) {
                    dOMCachedNode.makeCopy(dOMCachedNode3);
                } else {
                    dOMCachedNode2.makeCopy(dOMCachedNode3);
                }
            }
            this.checkAdjacent(dOMCachedNode, dOMCachedNode2.itemValue(), true);
            dOMCachedNode.setDirty();
            dOMCachedNode.setBuiltFollowingSibling(dOMCachedNode2.getCachedFollowingSibling());
            dOMCachedNode.setState(BitMaskHelper.stateSet(dOMCachedNode.state, 512));
            dOMCachedNode2.unlink(false);
            return true;
        }
        return false;
    }

    @Override
    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        DOMCachedComment dOMCachedComment;
        this.cache.ensureStateResolved(this, area);
        this.cache.notifyNodeAboutToChangeToCopies(this, area.immediateArea());
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                dOMCachedComment = this.cache.makeCachedComment(volatileCData, (DOMCachedContainer)this, null);
                break;
            }
            case LAST_CHILD: {
                dOMCachedComment = this.cache.makeCachedComment(volatileCData, (DOMCachedContainer)this, this.getCachedLastChild());
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                dOMCachedComment = this.cache.makeCachedComment(volatileCData, this.getBuiltParent(), this);
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
        dOMCachedComment.setState(LazyLoadingHelper.markAllResolved());
        this.setDirty(dOMCachedComment);
        dOMCachedComment.setState(BitMaskHelper.stateSet(dOMCachedComment.state, 0x400000));
    }

    @Override
    public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        DOMCachedPI dOMCachedPI;
        this.cache.ensureStateResolved(this, area);
        this.cache.notifyNodeAboutToChangeToCopies(this, area.immediateArea());
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                dOMCachedPI = this.cache.makeCachedPI(volatileCData, volatileCData2, (DOMCachedContainer)this, null);
                break;
            }
            case LAST_CHILD: {
                dOMCachedPI = this.cache.makeCachedPI(volatileCData, volatileCData2, (DOMCachedContainer)this, this.getCachedLastChild());
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                dOMCachedPI = this.cache.makeCachedPI(volatileCData, volatileCData2, this.getBuiltParent(), this);
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
        dOMCachedPI.setState(LazyLoadingHelper.markAllResolved());
        this.setDirty(dOMCachedPI);
        dOMCachedPI.setState(BitMaskHelper.stateSet(dOMCachedPI.state, 0x400000));
    }

    @Override
    public void addCopy(Cursor.Area area, Cursor cursor2) {
        MiscHelpers.verifyMutation(cursor2.itemKind(), this.itemKind(), area);
        Cursor cursor3 = this.fork(false, Copier.TARGET_FEATURES, Copier.TARGET_FEATURES);
        Copier.copy(cursor2, cursor3, area);
    }

    @Override
    public boolean removeSubtree(Cursor.Area area) {
        short s = this.itemKind();
        short[] sArray = new short[]{2, 4};
        Cursor.Area[] areaArray = new Cursor.Area[]{Cursor.Area.FIRST_CHILD, Cursor.Area.LAST_CHILD, Cursor.Area.FOLLOWING_SIBLING, Cursor.Area.SELF};
        if (XCIErrorHelper.checkDisallowedKind(s, sArray)) {
            throw XCIErrorHelper.createBadContextItemException("removeSubtree", s);
        }
        if (area == null) {
            throw XCIErrorHelper.createBadArgumentException("where", "null");
        }
        if (!XCIErrorHelper.checkAllowedArea(area, areaArray)) {
            throw XCIErrorHelper.createBadArgumentException("where", area.toString());
        }
        if (!XCIErrorHelper.removeSubtreeCheck(area, s)) {
            return false;
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "removeSubtree", "area=" + area.toString() + " from node=" + this.toStringLazy());
        }
        return this.removeCachedSubtree(area) != null;
    }

    @Override
    public void move(Cursor.Area area, Cursor cursor2) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "move", "moving node into area=" + area.toString());
        }
        if (cursor2.unwrap() instanceof DOMCachedNode) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "move", "moving DOMCachedNode=" + ((DOMCachedNode)cursor2.unwrap()).toStringLazy());
            }
            if (this == cursor2.unwrap()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Introducing a direct cycle into the data model by adding node [");
                stringBuilder.append(this.toStringLazy());
                stringBuilder.append("] into its own ");
                stringBuilder.append(area.toString());
                FFDCUtil.log(XCIErrorHelper.createInternalException(stringBuilder.toString()), this);
                return;
            }
            MiscHelpers.verifyMutation(cursor2.itemKind(), this.itemKind(), area);
            this.cache.ensureStateResolved(this, area);
            this.cache.notifyNodeAboutToChangeToCopies(this, area.immediateArea());
            List<DOMCachedNode> list = this.processSequenceList(area, cursor2);
            this.moveSequence(area, list);
            list.clear();
            this.setDirty(this);
            this.cache.incrementMutationVersion();
            return;
        }
        MoveFixer.move(this, area, cursor2);
    }

    protected void moveSequence(Cursor.Area area, List<DOMCachedNode> list) {
        DOMCachedContainer dOMCachedContainer = null;
        if (this instanceof DOMCachedContainer) {
            dOMCachedContainer = (DOMCachedContainer)this;
        }
        switch (area.immediateArea()) {
            case LAST_CHILD: {
                dOMCachedContainer.addBuiltLastChild(list);
                break;
            }
            case FIRST_CHILD: {
                dOMCachedContainer.addBuiltFirstChild(list);
                break;
            }
            case NAMESPACE_DECLS: {
                ((DOMCachedElement)dOMCachedContainer).addBuiltNamespace(list);
                break;
            }
            case ATTRIBUTE: {
                ((DOMCachedElement)dOMCachedContainer).addBuiltAttribute(list);
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                if (this.parent == null) {
                    this.addBuiltNextSiblingParentless(list);
                    break;
                }
                this.parent.addBuiltNextChild(list, this);
                break;
            }
            default: {
                throw XCIErrorHelper.createBadArgumentException("where", area.toString());
            }
        }
    }

    public List<DOMCachedNode> processSequenceList(Cursor.Area area, Cursor cursor2) {
        DOMCachedNode dOMCachedNode;
        ArrayList<DOMCachedNode> arrayList = new ArrayList<DOMCachedNode>();
        switch (area.immediateArea()) {
            case IMMEDIATE_FOLLOWING: {
                dOMCachedNode = this.parent;
                break;
            }
            default: {
                dOMCachedNode = this;
            }
        }
        cursor2 = cursor2.fork(false, Cursor.Profile.MINIMAL_NAVIGATION, Cursor.Profile.MINIMAL_NAVIGATION);
        do {
            if (cursor2 instanceof CopiedCacheCursor) {
                ((CopiedCacheCursor)cursor2).copyTo(Cursor.Area.SELF);
            }
            DOMCachedNode dOMCachedNode2 = (DOMCachedNode)cursor2.unwrap();
            dOMCachedNode2.setState(BitMaskHelper.stateSet(dOMCachedNode2.getState(), 0x400000));
            dOMCachedNode2.getCache().notifyNodeAboutToChangeToCopies(dOMCachedNode2, Cursor.Area.ImmediateAreas.SUBTREE, true);
            dOMCachedNode2.getCache().ensureStateResolved(dOMCachedNode2, Cursor.Area.FOLLOWING_SIBLING);
            if (dOMCachedNode2.itemKind() == 1) {
                ((DOMCachedElement)dOMCachedNode2).saveNSList(true);
                ((DOMCachedElement)dOMCachedNode2).loadNSList(dOMCachedNode);
            }
            if (dOMCachedNode2.isCopy()) {
                dOMCachedNode.cache.setContainsMovedCopy(true);
            }
            arrayList.add(dOMCachedNode2);
        } while (cursor2.toNext());
        cursor2.release();
        for (int i = 0; i < arrayList.size(); ++i) {
            DOMCachedNode dOMCachedNode3 = (DOMCachedNode)arrayList.get(i);
            dOMCachedNode3.unlink();
            if (dOMCachedNode3.cache != this.cache) {
                dOMCachedNode3.updateCacheLazy(this.cache);
            }
            dOMCachedNode3.preceding = i == 0 ? null : (DOMCachedNode)arrayList.get(i - 1);
            dOMCachedNode3.setBuiltFollowingSibling(i + 1 >= arrayList.size() ? null : (DOMCachedNode)arrayList.get(i + 1));
            if (dOMCachedNode3.preceding != null && dOMCachedNode3.preceding.following == null) {
                dOMCachedNode3.preceding.setBuiltFollowingSibling(dOMCachedNode3);
            }
            int n2 = dOMCachedNode3.getState();
            dOMCachedNode3.setState(n2 | 0x80 | 0x200);
            if (this.checkAdjacent(dOMCachedNode3.preceding, dOMCachedNode3)) {
                arrayList.remove(i);
                --i;
            }
            if (dOMCachedNode3.parent != null) {
                this.setDirty(dOMCachedNode3.parent);
            }
            if (dOMCachedNode3.preceding == null && area == Cursor.Area.FOLLOWING_SIBLING) {
                dOMCachedNode3.preceding = this;
            }
            dOMCachedNode3.setParent((DOMCachedContainer)dOMCachedNode);
            if (dOMCachedNode == null) continue;
            this.setDirty(dOMCachedNode);
            dOMCachedNode.setState(BitMaskHelper.stateSet(dOMCachedNode.state, 0x100000));
            if (dOMCachedNode3.itemKind() != 1 || !LazyLoadingHelper.isChildrenResolved(dOMCachedNode.state) || LazyLoadingHelper.isChildrenResolved(dOMCachedNode3.state) && LazyLoadingHelper.isDeepSubtreeResolved(dOMCachedNode3.state)) continue;
            dOMCachedNode.setState(BitMaskHelper.stateUnset(dOMCachedNode.state, 12));
            DOMCachedNode dOMCachedNode4 = dOMCachedNode;
            while (dOMCachedNode4 != null) {
                dOMCachedNode4.setState(BitMaskHelper.stateUnset(dOMCachedNode4.state, 8192));
                dOMCachedNode4 = dOMCachedNode4.parent;
                if (dOMCachedNode4 != dOMCachedNode) continue;
            }
        }
        return arrayList;
    }

    protected void setDirty(DOMCachedNode dOMCachedNode) {
        MiscHelpers.setDirty(dOMCachedNode);
    }

    public void setDirty() {
        this.setDirty(this);
    }

    @Override
    public VolatileCData serialize(Map<String, Object> map2) {
        Cursor cursor2 = this.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION);
        VolatileCData volatileCData = this.cache.serialize(cursor2, map2);
        cursor2.release();
        return volatileCData;
    }

    @Override
    public boolean itemIsBeforeNode(Cursor cursor2) {
        DOMCachedNode dOMCachedNode = this;
        if (cursor2 instanceof FastAccessSupport) {
            if (cursor2.exportAsClass("exportdatatobject") != null) {
                cursor2.exportAs("exportdatatobject", false);
            }
        } else if (cursor2.unwrap() instanceof FastAccessSupport && cursor2.unwrap().exportAsClass("exportdatatobject") != null) {
            cursor2.unwrap().exportAs("exportdatatobject", false);
        }
        if (!this.itemIsSameDocument(cursor2)) {
            return this.factory().getSessionContext().documentIsBefore(this.itemDocumentIdentity(), cursor2.itemDocumentIdentity());
        }
        DOMCachedNode dOMCachedNode2 = (DOMCachedNode)cursor2.unwrap();
        if (!this.itemSameOriginalDocument(dOMCachedNode2) || BitMaskHelper.stateContains(this.state, 0x400000) || BitMaskHelper.stateContains(dOMCachedNode2.state, 0x400000)) {
            return this.slowItemIsBeforeNode(dOMCachedNode2);
        }
        if (this.itemKind() == 1 && ((DOMCachedElement)this).mutationVersion < this.cache.getMutationVersion() && DOMCachedNode.recursiveWalk((DOMCachedContainer)this)) {
            return this.slowItemIsBeforeNode(dOMCachedNode2);
        }
        if (dOMCachedNode2.itemKind() == 1 && ((DOMCachedElement)dOMCachedNode2).mutationVersion < this.cache.getMutationVersion() && DOMCachedNode.recursiveWalk((DOMCachedContainer)dOMCachedNode2)) {
            return this.slowItemIsBeforeNode(dOMCachedNode2);
        }
        if (dOMCachedNode == dOMCachedNode2) {
            return false;
        }
        if (dOMCachedNode.getSubtreeID() == -1 && dOMCachedNode2.getSubtreeID() == -1) {
            return dOMCachedNode.getNodeID() < dOMCachedNode2.getNodeID();
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "itemIsBeforeNode", "About to use the subtreeID for a fast skipped-node comparison!");
        }
        if (dOMCachedNode.getSubtreeID() != -1 && dOMCachedNode2.getSubtreeID() != -1) {
            return this.compareSubtreeIDs(dOMCachedNode.getExpandedSubtreeID((short)0), dOMCachedNode2.getExpandedSubtreeID((short)0));
        }
        if (dOMCachedNode.getSubtreeID() != -1) {
            return this.compareSubtreeWithNodeID(dOMCachedNode.getExpandedSubtreeID((short)0), dOMCachedNode2.getNodeID());
        }
        return !this.compareSubtreeWithNodeID(dOMCachedNode2.getExpandedSubtreeID((short)0), dOMCachedNode.getNodeID());
    }

    protected short[] getExpandedSubtreeID(short s) {
        short[] sArray;
        if (this.parent != null && this.parent.getSubtreeID() != -1) {
            sArray = this.parent.getExpandedSubtreeID((short)(s + 1));
            sArray[sArray.length - (s + 1)] = this.getSubtreeID();
        } else {
            sArray = new short[s + 1];
            sArray[0] = this.getSubtreeID();
        }
        return sArray;
    }

    protected boolean compareSubtreeIDs(short[] sArray, short[] sArray2) {
        int n2 = -2;
        int n3 = -2;
        int n4 = 0;
        int n5 = 0;
        int n6 = sArray.length;
        int n7 = sArray2.length;
        do {
            if ((n2 = sArray[n4]) == (n3 = sArray2[n5])) continue;
            return n2 < n3;
        } while (++n4 < n6 && ++n5 < n7);
        return n6 < n7;
    }

    protected boolean compareSubtreeWithNodeID(short[] sArray, int n2) {
        short s = sArray[0];
        return s < n2;
    }

    public boolean slowItemIsBeforeNode(DOMCachedNode dOMCachedNode) {
        int n2;
        DOMCachedNode dOMCachedNode2 = this;
        int n3 = this.depth();
        if (n3 < (n2 = dOMCachedNode.depth())) {
            do {
                dOMCachedNode = dOMCachedNode.parent;
            } while (n3 < --n2);
            if (dOMCachedNode2 == dOMCachedNode) {
                return true;
            }
        } else {
            while (n3 > n2) {
                dOMCachedNode2 = dOMCachedNode2.parent;
                --n3;
            }
            if (dOMCachedNode2 == dOMCachedNode) {
                return false;
            }
        }
        assert (n2 == n3 && dOMCachedNode2 != dOMCachedNode) : "comparison balancing messed up!?";
        while (dOMCachedNode2.parent != null && dOMCachedNode2.parent != dOMCachedNode.parent) {
            assert (dOMCachedNode.parent != null) : "comparison balancing messed up!?";
            dOMCachedNode2 = dOMCachedNode2.parent;
            dOMCachedNode = dOMCachedNode.parent;
        }
        if (dOMCachedNode2.parent == null) {
            assert (dOMCachedNode.parent == null) : "comparison balancing messed up!?";
            return dOMCachedNode.hashCode() - dOMCachedNode2.hashCode() < 0;
        }
        if (dOMCachedNode2.itemKind() == 2) {
            if (dOMCachedNode.itemKind() == 2) {
                for (DOMCachedAttribute dOMCachedAttribute = ((DOMCachedElement)dOMCachedNode2.parent).getCachedFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
                    if (dOMCachedAttribute == dOMCachedNode2) {
                        return true;
                    }
                    if (dOMCachedAttribute != dOMCachedNode) continue;
                    return false;
                }
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CHILD_NOT_FOUND", new String[]{"attribute"}));
            }
            return dOMCachedNode.itemKind() != 4;
        }
        if (dOMCachedNode2.itemKind() == 4) {
            if (dOMCachedNode.itemKind() == 4) {
                for (DOMCachedNamespace dOMCachedNamespace = ((DOMCachedElement)dOMCachedNode2.parent).getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
                    if (dOMCachedNamespace == dOMCachedNode2) {
                        return true;
                    }
                    if (dOMCachedNamespace != dOMCachedNode) continue;
                    return false;
                }
                throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CHILD_NOT_FOUND", new String[]{"namespace"}));
            }
            return true;
        }
        if (dOMCachedNode.itemKind() == 2 || dOMCachedNode.itemKind() == 4) {
            return false;
        }
        for (DOMCachedNode dOMCachedNode3 = dOMCachedNode2.parent.getCachedFirstChild(); dOMCachedNode3 != null; dOMCachedNode3 = dOMCachedNode3.getCachedFollowingSibling()) {
            if (dOMCachedNode3 == dOMCachedNode2) {
                return true;
            }
            if (dOMCachedNode3 != dOMCachedNode) continue;
            return false;
        }
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_CHILD_NOT_FOUND", new String[]{"element child"}));
    }

    protected boolean itemSameOriginalDocument(DOMCachedNode dOMCachedNode) {
        return this.cache.mediator(this, false).documentID() == dOMCachedNode.cache.mediator(dOMCachedNode, false).documentID();
    }

    @Override
    public abstract boolean test(Cursor var1);

    @Override
    public boolean allowsAttribute(VolatileCData volatileCData) {
        return false;
    }

    @Override
    public boolean allowsNamespace(VolatileCData volatileCData) {
        return false;
    }

    @Override
    public boolean allowsComment() {
        return false;
    }

    @Override
    public boolean allowsDocument() {
        return false;
    }

    @Override
    public boolean allowsElement(VolatileCData volatileCData) {
        return false;
    }

    @Override
    public boolean allowsProcessingInstruction(String string2) {
        return false;
    }

    @Override
    public boolean allowsText() {
        return false;
    }

    @Override
    public NameTest theNameTest() {
        return null;
    }

    @Override
    public abstract String getNodeName();

    @Override
    public abstract String getNodeValue();

    @Override
    public void setNodeValue(String string2) throws DOMException {
    }

    @Override
    public abstract short getNodeType();

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public NodeList getChildNodes() {
        return EmptyNodeList.INSTANCE;
    }

    @Override
    public Node getFirstChild() {
        return this.getCachedFirstChild();
    }

    @Override
    public Node getLastChild() {
        return this.getCachedLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        return this.getCachedPrecedingSibling();
    }

    @Override
    public Node getNextSibling() {
        return this.getCachedFollowingSibling();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        if (this.itemKind() == 9) {
            return null;
        }
        return this.cache.getCachedDocument();
    }

    @Override
    public Node insertBefore(Node node2, Node node3) throws DOMException {
        throw XCIErrorHelper.createDOMException((short)9);
    }

    @Override
    public Node replaceChild(Node node2, Node node3) throws DOMException {
        throw XCIErrorHelper.createDOMException((short)3);
    }

    @Override
    public Node removeChild(Node node2) throws DOMException {
        throw XCIErrorHelper.createDOMException((short)3);
    }

    @Override
    public Node appendChild(Node node2) throws DOMException {
        throw XCIErrorHelper.createDOMException((short)3);
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public Node cloneNode(boolean bl) {
        return null;
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String string2, String string3) {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String string2) throws DOMException {
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public short compareDocumentPosition(Node node2) throws DOMException {
        if (this == node2) {
            return 0;
        }
        if (node2 == null || !(node2 instanceof DOMCachedNode)) {
            throw XCIErrorHelper.createDOMException((short)9);
        }
        DOMCachedNode dOMCachedNode = (DOMCachedNode)node2;
        if (!this.itemIsSameDocument(dOMCachedNode)) {
            if (this.factory().getSessionContext().documentIsBefore(this.itemDocumentIdentity(), dOMCachedNode.itemDocumentIdentity())) {
                return 37;
            }
            return 35;
        }
        if (this.itemIsBeforeNode(dOMCachedNode)) {
            DOMCachedContainer dOMCachedContainer = dOMCachedNode.parent;
            while (dOMCachedContainer != null) {
                if (dOMCachedContainer == this) {
                    return 20;
                }
                dOMCachedContainer = dOMCachedContainer.parent;
            }
            if (this.getFirstChild() == dOMCachedNode) {
                return 20;
            }
            return 4;
        }
        DOMCachedContainer dOMCachedContainer = this.parent;
        while (dOMCachedContainer != null) {
            if (dOMCachedContainer == dOMCachedNode) {
                return 10;
            }
            dOMCachedContainer = dOMCachedContainer.parent;
        }
        if (dOMCachedNode.getFirstChild() == this) {
            return 10;
        }
        return 2;
    }

    @Override
    public boolean isSameNode(Node node2) {
        return node2 == this;
    }

    @Override
    public boolean isEqualNode(Node node2) {
        if (node2 == null) {
            return false;
        }
        if (this.isSameNode(node2)) {
            return true;
        }
        this.normalize();
        node2.normalize();
        if (this.getNodeType() != node2.getNodeType()) {
            return false;
        }
        if (!this.checkEquality(this.getNodeName(), node2.getNodeName())) {
            return false;
        }
        if (!this.checkEquality(this.getLocalName(), node2.getLocalName())) {
            return false;
        }
        if (!this.checkEquality(this.getNamespaceURI(), node2.getNamespaceURI())) {
            return false;
        }
        if (!this.checkEquality(this.getPrefix(), node2.getPrefix())) {
            return false;
        }
        if (!this.checkEquality(this.getNodeValue(), node2.getNodeValue())) {
            return false;
        }
        if (!this.checkEquality(this.getAttributes(), node2.getAttributes())) {
            return false;
        }
        NodeList nodeList = this.getChildNodes();
        NodeList nodeList2 = node2.getChildNodes();
        if (nodeList == null || nodeList2 == null) {
            if (nodeList != null || nodeList2 != null) {
                return false;
            }
        } else {
            if (nodeList.getLength() != nodeList2.getLength()) {
                return false;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).isEqualNode(nodeList2.item(i))) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkEquality(NamedNodeMap namedNodeMap, NamedNodeMap namedNodeMap2) {
        if (namedNodeMap == null || namedNodeMap2 == null) {
            if (namedNodeMap != null || namedNodeMap2 != null) {
                return false;
            }
        } else {
            if (namedNodeMap.getLength() != namedNodeMap2.getLength()) {
                return false;
            }
            int n2 = namedNodeMap.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node2 = namedNodeMap.item(0);
                boolean bl = false;
                for (int j = 0; j < n2; ++j) {
                    if (!node2.isEqualNode(namedNodeMap2.item(j))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkEquality(String string2, String string3) {
        if (string2 != null) {
            return string2.equals(string3);
        }
        return string3 == null;
    }

    @Override
    public String getBaseURI() {
        String string2 = this.itemBaseURI();
        return string2 == null ? null : string2;
    }

    @Override
    public boolean isDefaultNamespace(String string2) {
        return string2.equals(this.lookupNamespaceURI(null));
    }

    @Override
    public String lookupNamespaceURI(String string2) {
        return this.parent == null ? null : this.parent.lookupNamespaceURI(string2);
    }

    @Override
    public String lookupPrefix(String string2) {
        return this.parent == null ? null : this.parent.lookupPrefix(string2);
    }

    @Override
    public String getTextContent() throws DOMException {
        return StringChars.toString(this.itemStringValueAsChars());
    }

    @Override
    public void setTextContent(String string2) throws DOMException {
    }

    @Override
    public Object getUserData(String string2) {
        if (this.internalNodeData.getDOMUserData() == null) {
            return null;
        }
        DataAndHandler dataAndHandler = (DataAndHandler)this.internalNodeData.getDOMUserData().get(string2);
        if (dataAndHandler == null) {
            return null;
        }
        return dataAndHandler.data;
    }

    @Override
    public Object setUserData(String string2, Object object2, UserDataHandler userDataHandler) {
        Object object3 = this.getUserData(string2);
        HashMap<String, DataAndHandler> hashMap = this.internalNodeData.getDOMUserData();
        if (hashMap == null) {
            hashMap = new HashMap<String, DataAndHandler>();
            this.internalNodeData.setDOMUserData(hashMap);
        }
        hashMap.put(string2, new DataAndHandler(object2, userDataHandler));
        return object3;
    }

    public void setInternalNodeData(InternalNodeData internalNodeData) {
        this.internalNodeData = internalNodeData;
    }

    @Override
    public Object getFeature(String string2, String string3) {
        return null;
    }

    @Override
    public int copyNode(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
        if (this.cache.getItemCopier() != null) {
            return this.cache.getItemCopier().copyNode(cursor2, cursor3, area);
        }
        return 0;
    }

    @Override
    public Cursor.Profile sourceProfile() {
        if (this.cache.getItemCopier() != null) {
            return this.cache.getItemCopier().sourceProfile();
        }
        return Copier.SOURCE_FEATURES;
    }

    @Override
    public Cursor.Profile targetProfile(Cursor.Area area) {
        if (this.cache.getItemCopier() != null) {
            return this.cache.getItemCopier().sourceProfile();
        }
        return Copier.TARGET_FEATURES;
    }

    public abstract DOMCachedAttribute getCachedNamedAttribute(String var1, String var2);

    public boolean equals(Object object2) {
        if (object2 == this) {
            return true;
        }
        if (object2 instanceof Cursor) {
            return this == ((Cursor)object2).unwrap();
        }
        return false;
    }

    protected String printName() {
        VolatileCData volatileCData = this.itemName();
        if (volatileCData == null || volatileCData.isEmpty()) {
            return "";
        }
        String string2 = volatileCData.getQNamePrefix(1);
        String string3 = volatileCData.getQNameLocalPart(1);
        String string4 = volatileCData.getQNameNamespaceURI(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        stringBuilder.append(string4);
        stringBuilder.append('}');
        if (string2 != null && string2.length() != 0) {
            stringBuilder.append(string2);
            stringBuilder.append(':');
        }
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    public void printXQuery(Writer writer) {
        try {
            this.getBuiltRoot().printXQuery(writer, "", true);
            StringBuilder stringBuilder = new StringBuilder();
            DOMCachedNode dOMCachedNode = this;
            while (dOMCachedNode != null) {
                stringBuilder.insert(0, dOMCachedNode.sequenceLocator());
                dOMCachedNode = dOMCachedNode.parent;
            }
            writer.write(stringBuilder.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected abstract void printXQuery(Writer var1, String var2, boolean var3) throws IOException;

    String sequenceLocator() {
        switch (this.itemKind()) {
            case 9: {
                return "";
            }
            case 2: {
                return "/@" + this.itemName();
            }
        }
        int n2 = 0;
        for (DOMCachedNode dOMCachedNode = this; dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltPrecedingSibling()) {
            if (!this.test(dOMCachedNode)) continue;
            ++n2;
        }
        switch (this.itemKind()) {
            case 1: {
                return "/" + this.itemName().toString() + "[" + n2 + "]";
            }
            case 3: {
                return "/text()[" + n2 + "]";
            }
            case 7: {
                return "/processing-instruction(" + this.itemName().getString(1) + ")[" + n2 + "]";
            }
            case 8: {
                return "/comment()[" + n2 + "]";
            }
        }
        return "?";
    }

    public String toStringLazy() {
        return this.toStringLazy(null, "", false);
    }

    public String toStringLazy(Writer writer, String string2, boolean bl) {
        if (writer == null) {
            writer = new StringWriter();
        }
        try {
            this.printXQuery(writer, string2, bl);
            writer.write(string2 + " | nodeID=" + this.getNodeID() + " | subtreeID=" + this.getSubtreeIDAsString() + " | CacheManager=" + LoggerUtil.getUniqueString(this.cache) + " | JVM Object info=" + LoggerUtil.getUniqueString(this) + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return writer.toString();
    }

    public String toString() {
        return this.toStringLazy();
    }

    protected String getSubtreeIDAsString() {
        short[] sArray;
        short[] sArray2 = sArray = this.getSubtreeID() == -1 ? null : this.getExpandedSubtreeID((short)0);
        if (sArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = sArray.length;
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(sArray[i]);
            if (i + 1 >= n2) continue;
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    protected String printState() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  (: state:" + DMUtil.stateSource(this.state));
        stringBuilder.append(" [bitset=" + this.state + "] :)");
        return stringBuilder.toString();
    }

    protected String printUserData() {
        if (this.getInternalNodeData() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" (: user data:" + this.getInternalNodeData().toString());
            stringBuilder.append(" :)");
            return stringBuilder.toString();
        }
        return null;
    }

    public void setCacheManager(CacheManager cacheManager) {
        short s;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "setCacheManager", "setting the new cache manager{ " + cacheManager.toString() + "} into node " + this.toStringLazy());
        }
        if (this.internalNodeData != null) {
            if (this.internalNodeData.getMediatorData() == null) {
                if (this.cache.mediator().getWrappedMediator() instanceof CopiedCacheMediator || this.cache.mediator().getWrappedMediator() instanceof StreamingCursorMediator) {
                    this.internalNodeData.setMediatorData(this.cache.mediator());
                } else if (cacheManager.mediator().getWrappedMediator() instanceof StreamingCursorMediator) {
                    this.internalNodeData.setMediatorData(cacheManager.mediator());
                } else {
                    Cursor cursor2 = this.cache.mediator().focus();
                    if (cursor2 != null) {
                        this.internalNodeData.setMediatorData(new StreamingCursorMediator(cursor2, cursor2.profile()));
                    }
                }
            }
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "setCacheManager", "Changed user data:" + this.internalNodeData.toString());
            }
        }
        this.cache = cacheManager;
        if (this.getNodeID() == -2) {
            if (this.getField((byte)4) != null) {
                this.setField(-1, (byte)4);
            }
        } else {
            this.setNodeID(-1);
        }
        if ((s = this.itemKind()) == 1 || s == 9) {
            this.setState(this.getState() | 0x10000000);
        }
    }

    public int getNodeID() {
        if (this.internalNodeData != null) {
            return this.internalNodeData.getNodeID();
        }
        return -2;
    }

    @Override
    public long itemNodeIdentity() {
        long l = this.getNodeID();
        if (l == -1L) {
            l = this.cache.getNextGlobalID();
            this.setNodeID((int)l);
        } else if (l == -2L) {
            Object object2 = this.getField((byte)4);
            if (object2 instanceof Integer) {
                l = ((Integer)object2).longValue();
            } else if (object2 instanceof Long) {
                l = (Long)object2;
            }
            if (object2 != null && l != -1L) {
                return l;
            }
            l = this.cache.getNextGlobalID();
            if (this.internalNodeData == null) {
                this.internalNodeData = NullDataFactory.INSTANCE.createEmptyNodeID();
            }
            assert (this.internalNodeData != null);
            this.setField(l, (byte)4);
        }
        return l;
    }

    public void setNodeID(int n2) {
        if (this.internalNodeData != null) {
            this.internalNodeData.setNodeID(n2);
        }
    }

    public void buildSubtreeID(int n2) {
        if (this.getSubtreeID() == -1) {
            this.setSubtreeID((short)n2);
            if (this.itemKind() == 1) {
                DOMCachedElement dOMCachedElement = (DOMCachedElement)this;
                for (DOMCachedNode dOMCachedNode = dOMCachedElement.getBuiltFirstNamespace(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltFollowingSibling()) {
                    this.cache.registerNode(dOMCachedNode);
                }
                for (DOMCachedNode dOMCachedNode = dOMCachedElement.getBuiltFirstAttribute(); dOMCachedNode != null; dOMCachedNode = dOMCachedNode.getBuiltFollowingSibling()) {
                    this.cache.registerNode(dOMCachedNode);
                }
            }
        }
    }

    public void setSubtreeID(short s) {
        if (this.internalNodeData != null) {
            this.internalNodeData.setSubtreeID(s);
        }
    }

    public short getSubtreeID() {
        return this.internalNodeData == null ? (short)-1 : this.internalNodeData.getSubtreeID();
    }

    public void addBuiltNextSiblingParentless(List<DOMCachedNode> list) {
        if (this.following != null) {
            DOMCachedNode dOMCachedNode = list.get(list.size() - 1);
            dOMCachedNode.setBuiltFollowingSibling(this.following);
            this.following.preceding = dOMCachedNode;
        }
        list.get((int)0).preceding = this;
        this.setBuiltFollowingSibling(list.get(0));
    }

    public void addSiblingID(short s) {
        this.setSubtreeID((short)(s + 1));
    }

    @Override
    public long itemDocumentIdentity() {
        return this.cache.documentIdentify();
    }

    @Override
    public void setItemBaseURI(String string2) {
    }

    @Override
    public String itemBaseUri() {
        return this.itemBaseURI();
    }

    @Override
    public String itemBaseURI() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.itemBaseURI();
    }

    @Override
    public boolean contextIsAtomsOnly() {
        return false;
    }

    @Override
    public boolean contextIsNodesOnly() {
        return true;
    }

    @Override
    public boolean contextIsSingleDoc() {
        return true;
    }

    private static boolean recursiveWalk(DOMCachedContainer dOMCachedContainer) {
        DOMCachedContainer dOMCachedContainer2 = dOMCachedContainer.parent;
        if (dOMCachedContainer2 == null) {
            if (BitMaskHelper.stateContains(dOMCachedContainer.state, 0x400000)) {
                return true;
            }
            if (dOMCachedContainer.itemKind() == 1) {
                ((DOMCachedElement)dOMCachedContainer).mutationVersion = dOMCachedContainer.cache.getMutationVersion();
            }
            return false;
        }
        if (BitMaskHelper.stateContains(dOMCachedContainer.state, 0x400000)) {
            return true;
        }
        if (DOMCachedNode.recursiveWalk(dOMCachedContainer2)) {
            dOMCachedContainer2.setState(BitMaskHelper.stateSet(dOMCachedContainer2.state, 0x400000));
            return true;
        }
        if (dOMCachedContainer2.itemKind() == 1) {
            ((DOMCachedElement)dOMCachedContainer2).mutationVersion = dOMCachedContainer.cache.getMutationVersion();
        }
        return false;
    }

    @Override
    public DocumentInfo itemDocumentInfo() {
        if (this.itemKind() == 9) {
            this.getCachedFirstChild();
        }
        return this.cache.getDocumentInfo();
    }

    protected DOMCachedNode makeCopy(DOMCachedNode dOMCachedNode) {
        Mediator mediator = this.getMediatorData();
        if (mediator != null && mediator.getWrappedMediator() instanceof CopiedCacheMediator) {
            return ((CopiedCacheMediator)mediator.getWrappedMediator()).copiedManager.copyToOriginalNode(dOMCachedNode);
        }
        if (this.cache.isCopy()) {
            return this.cache.copyToOriginalNode(dOMCachedNode);
        }
        return dOMCachedNode;
    }

    public Object getField(byte by2) {
        return this.internalNodeData == null ? null : this.internalNodeData.getExtraField(by2);
    }

    public void setField(Object object2, byte by2) {
        if (this.internalNodeData == null) {
            this.internalNodeData = NullDataFactory.INSTANCE.createEmptyDynamic();
        }
        this.internalNodeData = this.internalNodeData.setExtraField(object2, by2);
    }

    public void linkInBetween(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        if (this == dOMCachedNode || this == dOMCachedNode2) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "linkInBetween", "tried to add a cycle with: " + this.toStringLazy() + " \n in between newPrevious= " + dOMCachedNode + " \n and newFollowing= " + dOMCachedNode2 + "\nStack=" + XCIErrorHelper.getStackTrace(15));
            }
            return;
        }
        this.linkToPrevious(dOMCachedNode);
        this.linkToFollowing(dOMCachedNode2);
    }

    public void linkToPrevious(DOMCachedNode dOMCachedNode) {
        if (this == dOMCachedNode) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "linkInBetween", "tried to add a cycle with: " + this.toStringLazy() + " \n into newPrevious= " + dOMCachedNode + "\nStack=" + XCIErrorHelper.getStackTrace(15));
            }
            return;
        }
        this.setBuiltPrecedingSibling(dOMCachedNode);
        if (dOMCachedNode != null) {
            dOMCachedNode.setBuiltFollowingSibling(this);
        }
    }

    public void linkToFollowing(DOMCachedNode dOMCachedNode) {
        if (this == dOMCachedNode) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "linkInBetween", "tried to add a cycle with: " + this.toStringLazy() + " \n into newFollowing= " + dOMCachedNode + "\nStack=" + XCIErrorHelper.getStackTrace(15));
            }
            return;
        }
        this.setBuiltFollowingSibling(dOMCachedNode);
        if (dOMCachedNode != null) {
            if (dOMCachedNode.parent != null && dOMCachedNode.parent.getBuiltFirstChild() == dOMCachedNode) {
                dOMCachedNode.parent.setBuiltFirstChild(this);
            }
            dOMCachedNode.setBuiltPrecedingSibling(this);
        }
    }

    public void setParent(DOMCachedContainer dOMCachedContainer) {
        this.parent = dOMCachedContainer;
    }

    public void handleCopyList() {
    }

    class DataAndHandler {
        final Object data;
        final UserDataHandler handler;

        DataAndHandler(Object object2, UserDataHandler userDataHandler) {
            this.data = object2;
            this.handler = userDataHandler;
        }
    }
}

