/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.errors.DynamicErrorException;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import javax.xml.namespace.QName;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public abstract class DOMCachedSimple
extends DOMCachedNode
implements CharacterData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected CData data;

    protected DOMCachedSimple(CacheManager cacheManager, VolatileCData volatileCData, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        super(cacheManager, dOMCachedContainer, dOMCachedNode);
        assert (volatileCData != null) : "Cannot create simply typed node with no data!";
        this.data = volatileCData == null ? null : volatileCData.constant(true);
    }

    public DOMCachedAttribute getCachedFirstAttribute() {
        return null;
    }

    public DOMCachedAttribute getCachedLastAttribute() {
        return null;
    }

    public DOMCachedAttribute getCachedNamedAttribute(NodeTest nodeTest) {
        return null;
    }

    public DOMCachedAttribute getCachedNamedAttribute(QName qName) {
        return null;
    }

    public DOMCachedAttribute getCachedNamedAttribute(String string2, String string3) {
        return null;
    }

    public DOMCachedNode getCachedFirstChild() {
        return null;
    }

    public DOMCachedNode getCachedLastChild() {
        return null;
    }

    public DOMCachedAttribute getBuiltFirstAttribute() {
        return null;
    }

    public DOMCachedAttribute getBuiltLastAttribute() {
        return null;
    }

    public DOMCachedNode getBuiltFirstChild() {
        return null;
    }

    public VolatileCData itemValue() {
        return this.data;
    }

    public Chars itemSValue() {
        if (this.data == null) {
            return StringChars.EMPTY;
        }
        return this.data;
    }

    public XSTypeDefinition itemXSType() {
        switch (this.itemKind()) {
            case 3: {
                return TypeRegistry.XSUNTYPEDATOMIC;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
        }
        return this.data.getXSTypeDefinition();
    }

    public void setItemValue(VolatileCData volatileCData) {
        short[] sArray = new short[]{2, 3, 8, 7};
        short s = this.itemKind();
        if (volatileCData == null) {
            throw XCIErrorHelper.createBadArgumentException("newValue", "null");
        }
        if (!XCIErrorHelper.checkAllowedKind(s, sArray)) {
            throw XCIErrorHelper.createBadContextItemException("setItemValue", s);
        }
        this.cache.notifyNodeAboutToChangeToCopies(this, Cursor.Area.ImmediateAreas.SELF);
        this.data = volatileCData.constant(true);
        this.setDirty(this);
        if (this.parent != null && this.parent.itemKind() == 1) {
            ((DOMCachedElement)this.parent).clearPSVI();
        }
    }

    public String getNodeValue() {
        return this.itemTypedValue().toString();
    }

    public void setNodeValue(String string2) throws DOMException {
        try {
            this.setItemValue(this.factory().data((CharSequence)this.data, this.data == null ? TypeRegistry.XSUNTYPEDATOMIC : this.data.getXSTypeDefinition(), false));
        }
        catch (DynamicErrorException dynamicErrorException) {
            // empty catch block
        }
    }

    public String getData() throws DOMException {
        return this.data.toString();
    }

    public void setData(String string2) throws DOMException {
        try {
            this.data = this.factory.data((CharSequence)string2, (XSSimpleTypeDefinition)this.itemXSType(), false);
        }
        catch (DynamicErrorException dynamicErrorException) {
            throw XCIErrorHelper.createDOMException((short)7);
        }
    }

    public int getLength() {
        return this.data.length();
    }

    public String substringData(int n2, int n3) throws DOMException {
        if (n2 < 0 || n2 + n3 > this.data.length()) {
            throw XCIErrorHelper.createDOMException((short)1);
        }
        return ((Object)this.data.subSequence(n2, n2 + n3)).toString();
    }

    public void appendData(String string2) throws DOMException {
        this.replaceData(this.getLength(), 0, string2);
    }

    public void insertData(int n2, String string2) throws DOMException {
        this.replaceData(n2, 0, string2);
    }

    public void deleteData(int n2, int n3) throws DOMException {
        this.replaceData(n2, n3, "");
    }

    public void replaceData(int n2, int n3, String string2) throws DOMException {
        if (n2 < 0 || n2 + n3 > this.data.length()) {
            throw XCIErrorHelper.createDOMException((short)1);
        }
    }

    public ExtendedNamespaceContext itemNamespaceContext(boolean bl) {
        if (bl) {
            return this.parent == null ? null : this.parent.itemNamespaceContext();
        }
        return null;
    }
}

