/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedSimple;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.errors.DynamicErrorException;
import com.ibm.xml.xci.internal.values.MTOMCData;
import com.ibm.xml.xci.internal.values.StoredCharsCData;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public class DOMCachedText
extends DOMCachedSimple
implements CDATASection {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2011. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public DOMCachedText(CacheManager cacheManager, VolatileCData volatileCData, boolean bl, boolean bl2, DOMCachedContainer dOMCachedContainer, DOMCachedNode dOMCachedNode) {
        super(cacheManager, volatileCData, dOMCachedContainer, dOMCachedNode);
        if (bl) {
            this.setState(BitMaskHelper.stateSet(this.state, 16384));
        }
        if (bl2) {
            this.setState(BitMaskHelper.stateSet(this.state, 32768));
        }
        if (cacheManager.isMTOMEnabled() && volatileCData instanceof MTOMCData) {
            ((MTOMCData)volatileCData).resolveMTOM(new Copier.PathComputerImpl(dOMCachedContainer));
            cacheManager.mediator().reportMutation(this, false);
            this.setDirty();
        }
    }

    public boolean satisfies(NodeTest nodeTest) {
        return nodeTest == null || nodeTest.allowsText();
    }

    public VolatileCData itemTypedValue() {
        if (this.data.getXSTypeDefinition() == TypeRegistry.XSUNTYPEDATOMIC) {
            return this.data;
        }
        if (this.data instanceof StoredCharsCData) {
            return new StoredCharsCData((Chars)this.data.getOriginalLexicalValue(), TypeRegistry.XSUNTYPEDATOMIC);
        }
        return new StoredCharsCData(this.data, TypeRegistry.XSUNTYPEDATOMIC);
    }

    public short itemKind() {
        return 3;
    }

    public boolean itemIsAtomic() {
        return BitMaskHelper.stateContains(this.state, 32768);
    }

    public boolean itemIsCData() {
        return BitMaskHelper.stateContains(this.state, 16384);
    }

    public boolean test(Cursor cursor2) {
        return cursor2.itemKind() == 3;
    }

    public boolean allowsText() {
        return true;
    }

    public String getNodeName() {
        return this.itemIsCData() ? "#cdata-section" : "#text";
    }

    public short getNodeType() {
        return this.itemIsCData() ? (short)4 : 3;
    }

    public Text splitText(int n2) throws DOMException {
        int n3 = this.getLength();
        if (n2 < 0 || n2 > n3) {
            throw XCIErrorHelper.createDOMException((short)1);
        }
        try {
            boolean bl = BitMaskHelper.stateContains(this.state, 512);
            DOMCachedText dOMCachedText = new DOMCachedText(this.cache, this.factory.data(this.data.subSequence(0, n2), (XSSimpleTypeDefinition)this.itemXSType(), false), this.itemIsCData(), this.itemIsAtomic(), this.parent, this);
            this.data = this.factory.data(this.data.subSequence(n2), (XSSimpleTypeDefinition)this.itemXSType(), false);
            return dOMCachedText;
        }
        catch (DynamicErrorException dynamicErrorException) {
            throw XCIErrorHelper.createDOMException((short)7);
        }
    }

    public boolean isElementContentWhitespace() {
        int n2 = this.data.length();
        for (int i = 0; i < n2; ++i) {
            if (Character.isWhitespace(this.data.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String getWholeText() {
        Object object2;
        DOMCachedNode dOMCachedNode;
        DOMCachedText dOMCachedText = this;
        for (dOMCachedNode = this.getCachedPrecedingSibling(); dOMCachedNode != null && dOMCachedNode instanceof DOMCachedText; dOMCachedNode = dOMCachedNode.getCachedPrecedingSibling()) {
            dOMCachedText = (DOMCachedText)dOMCachedNode;
        }
        dOMCachedNode = this;
        for (object2 = this.getCachedFollowingSibling(); object2 != null && object2 instanceof DOMCachedText; object2 = ((DOMCachedNode)object2).getCachedFollowingSibling()) {
            dOMCachedNode = (DOMCachedText)object2;
        }
        if (dOMCachedText == dOMCachedNode) {
            return this.data.toString();
        }
        object2 = new StringBuilder();
        for (DOMCachedText dOMCachedText2 = dOMCachedText; dOMCachedText2 != dOMCachedNode; dOMCachedText2 = (DOMCachedText)dOMCachedText2.getCachedFollowingSibling()) {
            ((StringBuilder)object2).append(dOMCachedText2.data);
        }
        ((StringBuilder)object2).append(((DOMCachedText)dOMCachedNode).data);
        return ((StringBuilder)object2).toString();
    }

    public Text replaceWholeText(String string2) throws DOMException {
        DOMCachedNode dOMCachedNode;
        DOMCachedNode dOMCachedNode2;
        DOMCachedText dOMCachedText = this;
        for (dOMCachedNode2 = this.getCachedPrecedingSibling(); dOMCachedNode2 != null && dOMCachedNode2 instanceof DOMCachedText; dOMCachedNode2 = dOMCachedNode2.getCachedPrecedingSibling()) {
            dOMCachedText = (DOMCachedText)dOMCachedNode2;
        }
        dOMCachedNode2 = this;
        for (dOMCachedNode = this.getCachedFollowingSibling(); dOMCachedNode != null && dOMCachedNode instanceof DOMCachedText; dOMCachedNode = dOMCachedNode.getCachedFollowingSibling()) {
            dOMCachedNode2 = (DOMCachedText)dOMCachedNode;
        }
        for (dOMCachedNode = dOMCachedText; dOMCachedNode != dOMCachedNode2; dOMCachedNode = (DOMCachedText)dOMCachedNode.getCachedFollowingSibling()) {
            this.parent.removeChild(dOMCachedNode);
        }
        if (string2 == null || string2.length() == 0) {
            this.parent.removeChild(dOMCachedNode2);
            return null;
        }
        try {
            ((DOMCachedText)dOMCachedNode2).data = this.factory.data((CharSequence)string2, (XSSimpleTypeDefinition)this.itemXSType(), false);
        }
        catch (DynamicErrorException dynamicErrorException) {
            throw XCIErrorHelper.createDOMException((short)7);
        }
        return this;
    }

    protected void printXQuery(Writer writer, String string2, boolean bl) throws IOException {
        if (this.data != null) {
            writer.write(string2 + " text{ " + CharsBase.toEncodedString(this.data) + " }" + this.printState() + this.printUserData());
        } else {
            writer.write(string2 + " text{}" + this.printState() + this.printUserData());
        }
    }

    public void setLogging(boolean bl) {
    }

    public boolean isLogging() {
        return false;
    }

    public String itemBaseURI() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.itemBaseURI();
    }

    public void setItemBaseURI(String string2) {
    }

    public Chars itemStringValueAsChars() {
        return this.data;
    }

    public Chars itemSValue() {
        return this.itemStringValueAsChars();
    }

    public void setData(String string2) throws DOMException {
        try {
            this.data = this.factory.data((CharSequence)string2, null, false);
        }
        catch (DynamicErrorException dynamicErrorException) {
            throw XCIErrorHelper.createDOMException((short)7);
        }
    }
}

