/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.errors.XCIUnsupportedOperationException;
import com.ibm.xml.xci.res.XCIMessages;

public class NoMutationCacheCursor
extends CacheCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile FEATURES_LIMIT = Cursor.Profile.RANDOM_ACCESS.union(Cursor.Profile.SEQUENCE.union(Cursor.Profile.ALWAYS_VALID.union(Cursor.Profile.XSPSVINFO.union(Cursor.Profile.POSITION.union(Cursor.Profile.IS_DEEP_EQUAL_TO.union(Cursor.Profile.TO_FOLLOWING_SIBLINGS.union(Cursor.Profile.TO_PRECEDING_SIBLINGS.union(Cursor.Profile.NODE_IDENTITY))))))));
    private long cachedSize = -1L;
    private long cachedPosition = -1L;

    public NoMutationCacheCursor(DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl) {
        super(dOMCachedNode, profile, bl);
        if (bl) {
            this.cachedPosition = 1L;
            this.cachedSize = 1L;
        }
    }

    public NoMutationCacheCursor(DOMCachedNode dOMCachedNode, boolean bl) {
        super(dOMCachedNode, bl);
        if (bl) {
            this.cachedPosition = 1L;
            this.cachedSize = 1L;
        }
    }

    public NoMutationCacheCursor(CacheCursor cacheCursor, Cursor.Profile profile, boolean bl) {
        super(cacheCursor, profile, bl);
        if (bl) {
            this.cachedPosition = 1L;
            this.cachedSize = 1L;
        } else if (cacheCursor instanceof NoMutationCacheCursor) {
            this.cachedPosition = ((NoMutationCacheCursor)cacheCursor).cachedPosition;
            this.cachedSize = ((NoMutationCacheCursor)cacheCursor).cachedSize;
        }
    }

    protected final void replaceContextNodeAndState(DOMCachedNode dOMCachedNode, short s) {
        this.cachedPosition = 1L;
        this.cachedSize = s == 0 ? 1L : -1L;
        super.replaceContextNodeAndState(dOMCachedNode, s);
    }

    public long contextPosition() {
        if (this.cachedPosition == -1L) {
            this.cachedPosition = super.contextPosition();
        }
        return this.cachedPosition;
    }

    public long contextSize() {
        if (this.cachedSize == -1L) {
            this.cachedSize = super.contextSize();
        }
        return this.cachedSize;
    }

    public boolean toNext() {
        boolean bl = super.toNext();
        if (bl && this.cachedPosition != -1L) {
            ++this.cachedPosition;
        }
        return bl;
    }

    public boolean toPrevious() {
        boolean bl = super.toPrevious();
        if (bl && this.cachedPosition != -1L) {
            --this.cachedPosition;
        }
        return bl;
    }

    public boolean toPosition(long l) {
        boolean bl = super.toPosition(l);
        if (bl) {
            this.cachedPosition = l;
        }
        return bl;
    }

    public boolean openMutation(Cursor.Area area) {
        throw new XCIUnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"openMutation"}));
    }

    public Cursor.Profile profile() {
        return FEATURES_LIMIT;
    }

    public boolean toSelf() {
        this.cachedPosition = 1L;
        this.cachedSize = 1L;
        return super.toSelf();
    }
}

