/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.ExtendedNamespaceContext;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.CacheNodeSequence;
import com.ibm.xml.xci.dp.cache.dom.CopiedCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xml4j.api.s1.xs.ItemPSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StreamingCacheCursor
extends AbstractCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile PROFILE_LIMIT = Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION.union(Cursor.Profile.XSPSVINFO);
    private static final Logger logger = LoggerUtil.getLogger(StreamingCacheCursor.class);
    private Cursor.Profile profile;
    protected static final short STATE_IN_ATTRIBUTE = 0;
    protected static final short STATE_IN_CHILDREN = 1;
    protected static final short STATE_STACK = 2;
    protected static final short STATE_IN_NS_NODE = 3;
    protected static final short STATE_DONE = 4;
    protected static final short STATE_IN_TOP_LEVEL_SEQ = 5;
    protected DOMCachedNode rootNode;
    protected final boolean self;
    protected DOMCachedNode contextNode;
    protected short state;
    private int assertOnlyReferenceCounter;

    protected StreamingCacheCursor(DOMCachedNode dOMCachedNode, Cursor.Profile profile, boolean bl) {
        super(dOMCachedNode.factory());
        if (LoggerUtil.isAnyTracingEnabled()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "StreamingCacheCursor", "Created a new StreamingCacheCursor from a DOMCachedNode=" + dOMCachedNode.toStringLazy() + " | Self = " + bl + "\nNeeded Features=" + profile + "\nStack trace= " + XCIErrorHelper.getStackTrace(10));
            } else if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "StreamingCacheCursor", "Created a new CacheCursor from a DOMCachedNode. Self =" + bl);
            }
        }
        this.rootNode = dOMCachedNode.reference();
        this.contextNode = dOMCachedNode.reference();
        this.state = (short)5;
        this.profile = profile;
        this.self = bl;
        assert (this.initReferenceCounter());
    }

    private final boolean initReferenceCounter() {
        this.assertOnlyReferenceCounter = 0;
        return true;
    }

    private final boolean incrementReferenceCounter() {
        ++this.assertOnlyReferenceCounter;
        return true;
    }

    private final boolean decrementReferenceCounter() {
        --this.assertOnlyReferenceCounter;
        return true;
    }

    @Override
    public Cursor.Profile profile() {
        return PROFILE_LIMIT;
    }

    @Override
    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public Cursor.Profile futureProfile() {
        return CacheCursor.FEATURES_LIMIT;
    }

    @Override
    public boolean itemIsAtomic() {
        return false;
    }

    @Override
    public short itemKind() {
        return this.contextNode.itemKind();
    }

    @Override
    public VolatileCData itemName() {
        return this.contextNode.itemName();
    }

    @Override
    public ExtendedNamespaceContext itemNamespaceContext() {
        return this.contextNode.itemNamespaceContext();
    }

    @Override
    public ExtendedNamespaceContext itemNamespaceContext(boolean bl) {
        return this.contextNode.itemNamespaceContext(bl);
    }

    @Override
    public ItemPSVI itemXSPSVInfo() {
        return this.contextNode.itemXSPSVInfo();
    }

    @Override
    public void setItemPSVI(ItemPSVI itemPSVI) {
        this.contextNode.setItemPSVI(itemPSVI);
    }

    @Override
    public XSTypeDefinition itemXSType() {
        return this.contextNode.itemXSType();
    }

    @Override
    public QName itemTypeName() {
        return this.contextNode.itemTypeName();
    }

    @Override
    public VolatileCData itemValue() {
        return this.contextNode.itemTypedValue();
    }

    @Override
    public VolatileCData itemStringValue() {
        return this.contextNode.itemStringValue();
    }

    @Override
    public boolean toNamespaceDecls() {
        DOMCachedNamespace dOMCachedNamespace = this.contextNode.getCachedFirstNamespaceNode();
        if (dOMCachedNamespace != null) {
            this.contextNode = dOMCachedNamespace;
            this.state = (short)3;
            return true;
        }
        this.state = (short)2;
        return false;
    }

    @Override
    public boolean toAttributes(NodeTest nodeTest) {
        DOMCachedAttribute dOMCachedAttribute = this.contextNode.getCachedFirstAttribute();
        if (dOMCachedAttribute != null) {
            this.contextNode = dOMCachedAttribute;
            this.state = 0;
            return true;
        }
        this.state = (short)2;
        return false;
    }

    @Override
    public boolean toChildren(NodeTest nodeTest) {
        DOMCachedNode dOMCachedNode = this.contextNode.getCachedFirstChild();
        if (dOMCachedNode != null) {
            this.contextNode = dOMCachedNode;
            this.state = 1;
            return true;
        }
        this.state = (short)2;
        return false;
    }

    @Override
    public boolean toNext() {
        switch (this.state) {
            case 0: {
                DOMCachedAttribute dOMCachedAttribute = ((DOMCachedAttribute)this.contextNode).getCachedFollowingAttribute();
                if (dOMCachedAttribute != null) {
                    this.contextNode = dOMCachedAttribute;
                    return true;
                }
                return false;
            }
            case 3: {
                DOMCachedNamespace dOMCachedNamespace = ((DOMCachedNamespace)this.contextNode).getCachedFollowingNamespaceNode();
                if (dOMCachedNamespace != null) {
                    this.contextNode = dOMCachedNamespace;
                    return true;
                }
                return false;
            }
            case 1: {
                DOMCachedNode dOMCachedNode = this.contextNode.getCachedFollowingSibling();
                if (dOMCachedNode != null) {
                    this.contextNode = dOMCachedNode;
                    return true;
                }
                return false;
            }
            case 5: {
                if (this.self) {
                    this.state = (short)4;
                    return false;
                }
                DOMCachedNode dOMCachedNode = this.contextNode.getCachedFollowingSibling();
                if (dOMCachedNode == null) {
                    this.state = (short)4;
                    return false;
                }
                this.rootNode = dOMCachedNode;
                this.contextNode = dOMCachedNode;
                return true;
            }
            case 4: {
                return false;
            }
        }
        throw new XCIDynamicErrorException(XCIMessages.createXCIMessage("ER_ILLEGAL_INTERNAL_VALUE", new String[]{"state", Integer.toString(this.state)}));
    }

    @Override
    public void release() {
        Object object2;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            object2 = this.contextNode == null ? "null" : this.contextNode.toStringLazy();
            logger.logp(Level.FINER, logger.getName(), "release", "entry contextNode: " + (String)object2 + "\n entry state: " + this.state + "\n entry self: " + this.self + "\n entry rootNode: " + this.rootNode.toStringLazy());
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, logger.getName(), "release", "Stack trace: " + XCIErrorHelper.getStackTrace(15));
            }
        }
        switch (this.state) {
            case 0: 
            case 1: 
            case 3: {
                object2 = this.contextNode.getCache().getBuiltRootNode();
                if (object2 instanceof CacheManager.ManufacturedRootNode) {
                    if (BitMaskHelper.stateContains(this.contextNode.state, 0x20000000)) {
                        this.contextNode = object2;
                    } else {
                        DOMCachedNode dOMCachedNode = this.contextNode;
                        while (dOMCachedNode.preceding != null) {
                            dOMCachedNode = dOMCachedNode.preceding;
                        }
                        this.contextNode = dOMCachedNode == ((CacheManager.ManufacturedRootNode)object2).builtFirstChild ? object2 : this.contextNode.getBuiltParent();
                    }
                } else {
                    this.contextNode = this.contextNode.getBuiltParent();
                }
            }
            case 2: {
                this.state = (short)(this.rootNode == this.contextNode ? 5 : 1);
                break;
            }
            case 5: {
                this.state = (short)4;
            }
            case 4: {
                this.contextNode = null;
            }
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            object2 = this.contextNode == null ? "null" : this.contextNode.toStringLazy();
            logger.logp(Level.FINER, logger.getName(), "release", "exit contextNode: " + (String)object2 + "\n exit state: " + this.state + "\n exit self: " + this.self + "\n exit rootNode: " + this.rootNode.toStringLazy());
        }
    }

    @Override
    public DocumentInfo itemDocumentInfo() {
        return this.contextNode.getCache().getDocumentInfo();
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        if (profile.containedIn(this.contextNode.profile())) {
            return this.contextNode.reference();
        }
        if (profile.containedIn(this.profile())) {
            assert (this.incrementReferenceCounter());
            return this;
        }
        CacheCursor cacheCursor = this.contextNode.cache.popCacheCursor(this.contextNode, profile, bl || this.state == 5 && this.self);
        return this.factory().proxy(cacheCursor, profile, bl, null, null);
    }

    @Override
    public boolean isWrapped() {
        return true;
    }

    @Override
    public Cursor unwrap() {
        return this.contextNode;
    }

    @Override
    public boolean toSelf() {
        return true;
    }

    @Override
    public VolatileCData serialize(Map<String, Object> map2) {
        return this.contextNode.cache.serialize(this, map2);
    }

    @Override
    public Cursor sequenceConcat(Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Cursor cursor3 = null;
        if (!bl4) {
            cursor2 = cursor2.fork(false);
        }
        if (cursor2.unwrap() instanceof DOMCachedNode) {
            if (cursor2 instanceof CacheNodeSequence) {
                cursor3 = CacheNodeSequence.prependSequence(this, (CacheNodeSequence)cursor2, bl, bl2);
                bl4 = false;
            } else {
                cursor3 = CacheNodeSequence.getNewSequence(this, cursor2, false, bl2);
            }
        } else {
            cursor3 = AbstractCursor.defaultSequenceConcatWithMultidoc(this, cursor2, profile, profile2, bl, bl2, bl3, bl4);
        }
        if (bl4) {
            cursor2.release();
        }
        if (bl3) {
            this.release();
        }
        return cursor3;
    }

    @Override
    public boolean contextIsAtomsOnly() {
        return false;
    }

    @Override
    public boolean contextIsNodesOnly() {
        return true;
    }

    @Override
    public Cursor.ItemValueOrigin itemAttributeValueOrigin() {
        return this.contextNode.itemAttributeValueOrigin();
    }

    @Override
    public boolean itemIsSameDocument(Cursor cursor2) {
        CopiedCacheCursor.handlePotentialCopy(cursor2);
        return this.contextNode.itemIsSameDocument(cursor2);
    }

    @Override
    public boolean itemIsSameNode(Cursor cursor2) {
        CopiedCacheCursor.handlePotentialCopy(cursor2);
        return this.contextNode.itemIsSameNode(cursor2);
    }

    @Override
    public boolean itemIsBeforeNode(Cursor cursor2) {
        CopiedCacheCursor.handlePotentialCopy(cursor2);
        return this.contextNode.itemIsBeforeNode(cursor2);
    }
}

