/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom.ds;

import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.dp.cache.dom.ds.DSSimpleElementClass;
import com.ibm.xml.xci.dp.cache.dom.ds.NodeClass;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.IdentityHashMap;
import java.util.Map;

public class PatternAnalyzer {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Map<XSElementDeclaration, NodeClass> nodeClasses = new IdentityHashMap<XSElementDeclaration, NodeClass>();
    protected CursorFactory cursorFactory;

    public PatternAnalyzer(CursorFactory cursorFactory) {
        this.cursorFactory = cursorFactory;
    }

    public NodeClass getNodeClass(XSElementDeclaration xSElementDeclaration) {
        NodeClass nodeClass = this.nodeClasses.get(xSElementDeclaration);
        if (nodeClass == null) {
            switch (this.analyze(xSElementDeclaration.getTypeDefinition())) {
                case 10: {
                    nodeClass = new DSSimpleElementClass(this.cursorFactory.data((CharSequence)xSElementDeclaration.getNamespace(), xSElementDeclaration.getName(), null), xSElementDeclaration);
                    break;
                }
                default: {
                    return null;
                }
            }
            this.nodeClasses.put(xSElementDeclaration, nodeClass);
        }
        return nodeClass;
    }

    protected int analyze(XSTypeDefinition xSTypeDefinition) {
        if (xSTypeDefinition.getTypeCategory() == 16) {
            return 10;
        }
        return 0;
    }
}

