/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom.helpers;

import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.helpers.ReferenceCounter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapReferenceCounter<K extends DOMCachedNode>
extends ReferenceCounter<K> {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final Map<K, Integer> refs = new HashMap<K, Integer>();

    @Override
    public void referenced(K k) {
        Integer n2 = this.refs.get(k);
        if (n2 == null) {
            this.refs.put(k, 1);
        } else {
            this.refs.put(k, n2 + 1);
        }
    }

    @Override
    public void dereferenced(K k) {
        Integer n2 = this.refs.get(k);
        assert (n2 > 0);
        if (n2 == 1) {
            this.refs.remove(k);
        } else {
            this.refs.put(k, n2 - 1);
        }
    }

    public boolean isEmpty() {
        return this.refs.size() == 0;
    }
}

