/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom.helpers;

import com.ibm.xml.xci.errors.XCIUnsupportedOperationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSListIterator<T>
implements Iterator<T> {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)(C) Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final List<T> nsList;
    private final int length;
    private int index = -2;

    public NSListIterator(List<T> list) {
        this.nsList = list;
        this.length = list.size();
    }

    @Override
    public boolean hasNext() {
        if (this.index < this.length) {
            T t;
            if (this.index >= 0 && this.index % 2 == 0 && ((t = this.nsList.get(this.index + 1)) == null || "".equals(t))) {
                this.index += 2;
                return this.hasNext();
            }
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        assert (this.hasNext());
        String string2 = null;
        if (this.index == -2) {
            string2 = "xml";
        } else if (this.index == -1) {
            string2 = "http://www.w3.org/XML/1998/namespace";
        } else {
            try {
                string2 = this.nsList.get(this.index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }
        ++this.index;
        return (T)string2;
    }

    @Override
    public void remove() {
        throw new XCIUnsupportedOperationException();
    }
}

