/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom.mediator;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.CopiedCacheCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedSimple;
import com.ibm.xml.xci.dp.cache.dom.InternalNodeDataFactory;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.dom.mediator.CopiedDataFactory;
import com.ibm.xml.xci.dp.cache.dom.mediator.NoMediator;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import java.lang.ref.Reference;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CopiedCacheMediator
extends NoMediator {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected final CacheManager originalManager;
    public final CacheManager copiedManager;
    protected final Map<DOMCachedNode, DOMCachedNode> copiedNodes;
    protected CursorWithOriginal headCursorWithOriginal;
    public boolean checkedThread;
    private static final Logger logger = LoggerUtil.getLogger(CopiedCacheMediator.class);
    private int options;

    public CopiedCacheMediator(CacheManager cacheManager, CacheManager cacheManager2) {
        super(cacheManager.factory());
        this.originalManager = cacheManager;
        this.copiedManager = cacheManager2;
        this.copiedNodes = new IdentityHashMap<DOMCachedNode, DOMCachedNode>();
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "CopiedCacheMediator", "Finished building a CopiedCacheMediator for threadID : " + Thread.currentThread().getId());
        }
    }

    public final DOMCachedNode getCopiedNode(DOMCachedNode dOMCachedNode) {
        return this.copiedNodes.get(dOMCachedNode);
    }

    public final DOMCachedNode getCopiedNodeDeep(DOMCachedNode dOMCachedNode) {
        DOMCachedNode dOMCachedNode2 = this.copiedNodes.get(dOMCachedNode);
        if (dOMCachedNode2 == null && dOMCachedNode.isCleanCopy()) {
            DOMCachedNode dOMCachedNode3 = dOMCachedNode.getOriginalNode();
            DOMCachedNode dOMCachedNode4 = dOMCachedNode;
            while (dOMCachedNode3 != null && dOMCachedNode4 != dOMCachedNode3 && (dOMCachedNode2 = this.copiedNodes.get(dOMCachedNode3)) == null) {
                dOMCachedNode4 = dOMCachedNode3;
                dOMCachedNode3 = dOMCachedNode3.isCleanCopy() ? dOMCachedNode3.getOriginalNode() : null;
            }
        }
        return dOMCachedNode2;
    }

    public final synchronized void internalSetCopiedNode(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        this.copiedNodes.put(dOMCachedNode, dOMCachedNode2);
    }

    public final void setCopiedNode(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "setCopiedNode", "original node: " + dOMCachedNode.toStringLazy() + "\n copy node: " + dOMCachedNode2.toStringLazy() + "\n CopiedCacheMediator = " + this.toString());
        }
        if (this.copiedNodes.get(dOMCachedNode) != null && LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "setCopiedNode", "old copy = " + this.copiedNodes.get(dOMCachedNode).toStringLazy(null, "", true) + "\n new copy = " + dOMCachedNode2.toStringLazy(null, "", true));
        }
        dOMCachedNode2.setState(BitMaskHelper.stateSet(dOMCachedNode2.getState(), 0x400000));
        this.internalSetCopiedNode(dOMCachedNode, dOMCachedNode2);
        this.applyOptions(dOMCachedNode, dOMCachedNode2);
    }

    public void registerCopiedCursorWithOriginal(CopiedCacheCursor copiedCacheCursor) {
        CursorWithOriginal cursorWithOriginal = new CursorWithOriginal(copiedCacheCursor);
        cursorWithOriginal.next = this.headCursorWithOriginal;
        this.headCursorWithOriginal = cursorWithOriginal;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            int n2 = 0;
            CursorWithOriginal cursorWithOriginal2 = this.headCursorWithOriginal;
            while (cursorWithOriginal2 != null) {
                ++n2;
                cursorWithOriginal2 = cursorWithOriginal2.next;
            }
            logger.logp(Level.FINEST, logger.getName(), "registerCopiedCursorWithOriginal", "Registering a new CopiedCacheCursor for notification inside a list of size=" + n2 + "\n stack:\n " + XCIErrorHelper.getStackTrace(30));
        }
    }

    public void unregisterCopiedCursorWithOriginal(CopiedCacheCursor copiedCacheCursor) {
        if (this.headCursorWithOriginal == null) {
            return;
        }
        if (this.headCursorWithOriginal.myCursor == copiedCacheCursor) {
            CursorWithOriginal cursorWithOriginal = this.headCursorWithOriginal;
            this.headCursorWithOriginal = cursorWithOriginal.next;
            return;
        }
        CursorWithOriginal cursorWithOriginal = this.headCursorWithOriginal;
        while (cursorWithOriginal.next != null) {
            if (cursorWithOriginal.next.myCursor == copiedCacheCursor) {
                CursorWithOriginal cursorWithOriginal2 = cursorWithOriginal.next;
                cursorWithOriginal.next = cursorWithOriginal2.next;
                return;
            }
            cursorWithOriginal = cursorWithOriginal.next;
        }
    }

    public void nodeAboutToChange(DOMCachedNode dOMCachedNode, Cursor.Area.ImmediateAreas immediateAreas) {
        DOMCachedNode dOMCachedNode2;
        Object object2;
        DOMCachedNode dOMCachedNode3;
        DOMCachedNode dOMCachedNode4;
        this.copiedManager.setReadOnlyTransform(false);
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "nodeAboutToChange", "Entering nodeAboutToChange.  Original=" + dOMCachedNode.toStringLazy() + "\n Area=" + immediateAreas.toString() + "\n CopiedCacheMediator=" + this.toString() + "\n CopiedNodes Map= " + this.dumpCopiedNodes());
        }
        if (this.copiedNodes == null) {
            return;
        }
        if (dOMCachedNode.isCopy() && this.getCopiedNode(dOMCachedNode.getOriginalNode()) == dOMCachedNode) {
            if (immediateAreas == Cursor.Area.FOLLOWING_SIBLING.immediateArea()) {
                dOMCachedNode4 = dOMCachedNode.getCachedFollowingSibling();
                if (dOMCachedNode4 != null && this.getCopiedNode(dOMCachedNode4.getOriginalNode()) == dOMCachedNode4) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, logger.getName(), "nodeAboutToChange", "Going into following node's copySubtreeLazy ! Node = " + dOMCachedNode4.toStringLazy(null, "", true) + "\n\nStack Trace = " + XCIErrorHelper.getStackTrace(20));
                    }
                    this.copySubtreeLazy(dOMCachedNode4, dOMCachedNode4.getCache());
                    return;
                }
            } else {
                if (immediateAreas != Cursor.Area.SELF.immediateArea() && immediateAreas != Cursor.Area.ATTRIBUTES.immediateArea() && immediateAreas != Cursor.Area.NAMESPACE_DECLS.immediateArea()) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, logger.getName(), "nodeAboutToChange", "Going into copySubtreeLazy ! Node = " + dOMCachedNode.toStringLazy(null, "", true) + "\n\nStack Trace = " + XCIErrorHelper.getStackTrace(20));
                    }
                    this.copySubtreeLazy(dOMCachedNode, dOMCachedNode.getCache());
                    return;
                }
                return;
            }
        }
        if ((dOMCachedNode4 = this.getCopiedNodeDeep(dOMCachedNode)) == null) {
            dOMCachedNode3 = null;
            for (object2 = dOMCachedNode.getBuiltParent(); object2 != null && (dOMCachedNode3 = this.getCopiedNode((DOMCachedNode)object2)) == null; object2 = ((DOMCachedNode)object2).getBuiltParent()) {
            }
            if (dOMCachedNode3 == null) {
                return;
            }
            dOMCachedNode2 = this.getCopiedNode(dOMCachedNode.getCachedParent());
            if (dOMCachedNode.itemKind() == 4) {
                if (dOMCachedNode2 != null && LazyLoadingHelper.isNamespacesBuilt(dOMCachedNode2.getState())) {
                    return;
                }
            } else if (dOMCachedNode.itemKind() == 2) {
                if (dOMCachedNode2 != null && LazyLoadingHelper.isAttributesBuilt(dOMCachedNode2.getState())) {
                    return;
                }
            } else {
                if (dOMCachedNode2 != null && LazyLoadingHelper.isChildrenResolved(dOMCachedNode2.getState())) {
                    return;
                }
                if (dOMCachedNode2 == null && dOMCachedNode3 != null && LazyLoadingHelper.isChildrenResolved(dOMCachedNode3.getState())) {
                    return;
                }
            }
        }
        if (dOMCachedNode4 == null && (dOMCachedNode4 = this.copyToOriginalNode(dOMCachedNode)) == null) {
            return;
        }
        switch (immediateAreas) {
            case SUBTREE: {
                this.copySubtreeLazy(dOMCachedNode4, dOMCachedNode4.getCache());
                object2 = dOMCachedNode4.getBuiltParent();
                if (object2 != null && ((DOMCachedNode)object2).isCopy()) {
                    dOMCachedNode4 = object2;
                    dOMCachedNode = dOMCachedNode4.getOriginalNode();
                }
            }
            case FIRST_CHILD: 
            case LAST_CHILD: {
                if (LazyLoadingHelper.isLastChildBuilt(dOMCachedNode4.getState())) break;
                dOMCachedNode3 = dOMCachedNode.getCachedFirstChild();
                if (dOMCachedNode3 == null) {
                    if (!BitMaskHelper.stateContains(dOMCachedNode4.getState(), 64)) {
                        dOMCachedNode4.setState(LazyLoadingHelper.markChildrenResolved(dOMCachedNode4.getState()));
                        break;
                    }
                    dOMCachedNode4.getCachedFirstChild();
                    break;
                }
                while (dOMCachedNode3.getCachedFollowingSibling() != null) {
                    dOMCachedNode3 = dOMCachedNode3.getCachedFollowingSibling();
                }
                dOMCachedNode2 = this.copyToOriginalNode(dOMCachedNode3);
                if (BitMaskHelper.stateContains(dOMCachedNode4.getState(), 64)) break;
                if (dOMCachedNode2 != null) {
                    dOMCachedNode2.setState(LazyLoadingHelper.markFollowingResolved(dOMCachedNode2.getState()));
                }
                dOMCachedNode4.setState(LazyLoadingHelper.markChildrenResolved(dOMCachedNode4.getState()));
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                dOMCachedNode3 = LazyLoadingHelper.isFollowingBuilt(dOMCachedNode4.getState()) ? dOMCachedNode4.getBuiltFollowingSibling() : dOMCachedNode.getCachedFollowingSibling();
                dOMCachedNode2 = dOMCachedNode4.getCachedParent();
                if (dOMCachedNode3 == null) {
                    if (dOMCachedNode2 == null || !BitMaskHelper.stateContains(dOMCachedNode2.getState(), 64)) {
                        dOMCachedNode4.setState(LazyLoadingHelper.markFollowingResolved(dOMCachedNode4.getState()));
                        if (dOMCachedNode2 == null) break;
                        dOMCachedNode2.setState(LazyLoadingHelper.markChildrenResolved(dOMCachedNode2.getState()));
                        break;
                    }
                    if (dOMCachedNode2 == null) break;
                    dOMCachedNode4.getCachedFollowingSibling();
                    break;
                }
                while (dOMCachedNode3.getCachedFollowingSibling() != null) {
                    dOMCachedNode3 = dOMCachedNode3.getCachedFollowingSibling();
                }
                DOMCachedNode dOMCachedNode5 = this.copyToOriginalNode(dOMCachedNode3);
                if (dOMCachedNode2 != null && BitMaskHelper.stateContains(dOMCachedNode2.getState(), 64)) break;
                if (dOMCachedNode5 != null) {
                    dOMCachedNode5.setState(LazyLoadingHelper.markFollowingResolved(dOMCachedNode5.getState()));
                }
                if (dOMCachedNode2 == null) break;
                dOMCachedNode2.setState(LazyLoadingHelper.markChildrenResolved(dOMCachedNode2.getState()));
                break;
            }
            case NAMESPACE_DECLS: {
                DOMCachedNode dOMCachedNode6;
                DOMCachedSimple dOMCachedSimple;
                if (!LazyLoadingHelper.isLastNamespaceBuilt(dOMCachedNode4.getState())) {
                    dOMCachedSimple = dOMCachedNode.getCachedLastNamespaceNode();
                    if (dOMCachedSimple == null) {
                        dOMCachedNode4.setState(LazyLoadingHelper.markNamespacesResolved(dOMCachedNode4.getState()));
                    } else {
                        dOMCachedNode6 = this.copyToOriginalNode(dOMCachedSimple);
                        if (dOMCachedNode6 != null) {
                            dOMCachedNode6.setState(LazyLoadingHelper.markFollowingResolved(dOMCachedNode6.getState()));
                        }
                        dOMCachedNode4.setState(LazyLoadingHelper.markNamespacesResolved(dOMCachedNode4.getState()));
                    }
                }
            }
            case ATTRIBUTE: {
                if (LazyLoadingHelper.isLastAttributeBuilt(dOMCachedNode4.getState())) break;
                DOMCachedSimple dOMCachedSimple = dOMCachedNode.getCachedLastAttribute();
                if (dOMCachedSimple == null) {
                    dOMCachedNode4.setState(LazyLoadingHelper.markAttributesResolved(dOMCachedNode4.getState()));
                    break;
                }
                DOMCachedNode dOMCachedNode6 = this.copyToOriginalNode(dOMCachedSimple);
                if (dOMCachedNode6 != null) {
                    dOMCachedNode6.setState(LazyLoadingHelper.markFollowingResolved(dOMCachedNode6.getState()));
                }
                dOMCachedNode4.setState(LazyLoadingHelper.markAttributesResolved(dOMCachedNode4.getState()));
                break;
            }
            case SELF: {
                break;
            }
            default: {
                if (dOMCachedNode4 != null) break;
                dOMCachedNode4 = this.copyToOriginalNode(dOMCachedNode);
            }
        }
        if (dOMCachedNode4 != null) {
            MiscHelpers.setDirty(dOMCachedNode4);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            object2 = dOMCachedNode4 == null ? "null" : dOMCachedNode4.toStringLazy(null, "", true);
            logger.logp(Level.FINEST, logger.getName(), "nodeAboutToChange", "Exiting nodeAboutToChange.  Original (lazy recursive)= \n" + dOMCachedNode.toStringLazy(null, "", true) + "\n Copy (lazy recursive)= \n" + (String)object2 + "\n Area=" + immediateAreas.toString() + "\n CopiedNodes Map= " + this.dumpCopiedNodes());
        }
    }

    public final void copySubtreeLazy(DOMCachedNode dOMCachedNode, CacheManager cacheManager) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "copySubtreeLazy", "Entering copySubtreeLazy for node : " + dOMCachedNode.toStringLazy());
        }
        for (DOMCachedNamespace dOMCachedNamespace = dOMCachedNode.getBuiltFirstNamespace(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getBuiltFollowingNamespaceNode()) {
            if (dOMCachedNamespace.getCache() == cacheManager) continue;
            this.copyToOriginalNode(dOMCachedNamespace);
        }
        for (DOMCachedAttribute dOMCachedAttribute = dOMCachedNode.getBuiltFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getBuiltFollowingAttribute()) {
            if (dOMCachedAttribute.getCache() == cacheManager) continue;
            this.copyToOriginalNode(dOMCachedAttribute);
        }
        DOMCachedNode dOMCachedNode2 = dOMCachedNode.getBuiltFirstChild();
        while (dOMCachedNode2 != null) {
            this.copySubtreeLazy(dOMCachedNode2, cacheManager);
            DOMCachedNode dOMCachedNode3 = dOMCachedNode2.getBuiltFollowingSibling();
            if (dOMCachedNode2.getCache() != cacheManager) {
                this.copyToOriginalNode(dOMCachedNode2);
            }
            dOMCachedNode2 = dOMCachedNode3;
        }
    }

    public boolean nativeCOWNode(DOMCachedNode dOMCachedNode) {
        return dOMCachedNode.getCache() == this.copiedManager;
    }

    public final DOMCachedNode copyToOriginalNode(DOMCachedNode dOMCachedNode) {
        return this.copyToOriginalNode(dOMCachedNode, false);
    }

    public final DOMCachedNode copyToOriginalNode(DOMCachedNode dOMCachedNode, boolean bl) {
        Object object2;
        if (dOMCachedNode == null) {
            return null;
        }
        boolean bl2 = LoggerUtil.isAnyTracingEnabled();
        String string2 = null;
        DOMCachedNode dOMCachedNode2 = this.copiedManager.getCopiedNodeDeep(dOMCachedNode);
        if (dOMCachedNode2 == null && dOMCachedNode.itemKind() == 2) {
            this.copiedManager.incrementNamespaceVersion();
        }
        if (bl2 && logger.isLoggable(Level.FINER)) {
            string2 = XCIErrorHelper.getStackTrace(15);
            object2 = dOMCachedNode2 == null ? "null" : dOMCachedNode2.toStringLazy();
            logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "Inside mediator= " + this.toString() + "\n original node=" + dOMCachedNode.toStringLazy() + " | nodeCopy=" + (String)object2 + "\nStack trace=" + string2);
        }
        if (dOMCachedNode2 != null && bl && dOMCachedNode2.getOriginalNode() != dOMCachedNode) {
            if (bl2 && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "copyToOriginalNode", "Setting nodeCopy to null because it is not a direct COW of the original");
            }
            dOMCachedNode2 = null;
        }
        if (dOMCachedNode2 == null) {
            Object object3;
            Object object4;
            CacheManager cacheManager;
            DOMCachedNode dOMCachedNode3;
            if (dOMCachedNode.isCopy() && this.getCopiedNode(dOMCachedNode.getOriginalNode()) == dOMCachedNode) {
                return dOMCachedNode;
            }
            object2 = dOMCachedNode;
            DOMCachedContainer dOMCachedContainer = ((DOMCachedNode)object2).getBuiltParent();
            DOMCachedNode dOMCachedNode4 = null;
            while (dOMCachedContainer != null) {
                dOMCachedNode4 = this.getCopiedNode(dOMCachedContainer);
                if (dOMCachedNode4 != null) {
                    if (bl || !BitMaskHelper.stateContains(dOMCachedNode4.getState(), 64) || !dOMCachedNode4.hasFastChildCopy((DOMCachedNode)object2)) break;
                    if (bl2 && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, logger.getName(), "copyToOriginalNode", "Jumping out from copy because we found an ancestor [1] that already had an independent fast access node stored corresponding to a parent-chain member of the original.\n [1] " + dOMCachedNode4.toStringLazy(null, "", true));
                    }
                    if (!BitMaskHelper.stateContains(((DOMCachedNode)object2).getState(), 256)) {
                        return null;
                    }
                    if (!bl2 || !logger.isLoggable(Level.FINE)) break;
                    logger.logp(Level.FINE, logger.getName(), "copyToOriginalNode", "Original ancestor contained native-data, so it means that a swap happened to the original node. Go ahead with the copy");
                    break;
                }
                object2 = dOMCachedContainer;
                dOMCachedContainer = ((DOMCachedNode)object2).getBuiltParent();
            }
            if (dOMCachedNode4 == null) {
                return null;
            }
            DOMCachedNode dOMCachedNode5 = bl || dOMCachedNode.getCachedPrecedingSibling() == null ? null : this.copyToOriginalNode(dOMCachedNode.getBuiltPrecedingSibling());
            dOMCachedNode2 = this.copiedManager.getCopiedNodeDeep(dOMCachedNode);
            if (dOMCachedNode2 != null) {
                if (bl && dOMCachedNode2.getOriginalNode() != dOMCachedNode) {
                    if (bl2 && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, logger.getName(), "copyToOriginalNode", "[2] Setting nodeCopy to null because it is not a direct COW of the original");
                    }
                    dOMCachedNode2 = null;
                } else {
                    return dOMCachedNode2;
                }
            }
            if (dOMCachedNode5 != null && LazyLoadingHelper.isFollowingBuilt(dOMCachedNode5.getState()) && (dOMCachedNode3 = dOMCachedNode5.getBuiltFollowingSibling()) != dOMCachedNode) {
                boolean bl3 = false;
                while (dOMCachedNode.getOriginalNode() != null) {
                    if ((dOMCachedNode = dOMCachedNode.getOriginalNode()) != dOMCachedNode3) continue;
                    bl3 = true;
                }
                if (!bl3 && dOMCachedNode3 != null && BitMaskHelper.stateContains(dOMCachedNode3.getState(), 256) && !dOMCachedNode3.getCache().isReadOnlyTransform()) {
                    if (bl2 && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "We hit the special NDH-swap scenario where we need to fix the link from our copy [1] into the new original [2]: \n[1] " + dOMCachedNode3.toStringLazy() + "\n[2] " + dOMCachedNode.toStringLazy());
                    }
                    dOMCachedNode3.setOriginalNode(dOMCachedNode);
                    this.setCopiedNode(dOMCachedNode, dOMCachedNode3);
                    return dOMCachedNode3;
                }
                if (!bl3) {
                    if (bl2 && logger.isLoggable(Level.FINER)) {
                        String string3 = dOMCachedNode3 == null ? "null" : dOMCachedNode3.toStringLazy();
                        logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "We are trying to make a copy of original node [1] but our current preceding node [2] has a different node [3] as its following sibling.\n[1]original node=  " + dOMCachedNode.toStringLazy() + "\n[2]preceding= " + dOMCachedNode5.toStringLazy() + "\n[3]following= " + string3 + "\nStack trace=" + string2);
                    }
                    return null;
                }
            }
            if (bl2 && logger.isLoggable(Level.FINER)) {
                if (dOMCachedNode5 == null) {
                    logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "precedingCopy = null \nStack trace=" + string2);
                } else {
                    logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "preceding =" + dOMCachedNode5.toStringLazy() + "\nStack trace=" + string2);
                }
            }
            if (bl) {
                dOMCachedNode3 = null;
            } else {
                DOMCachedNode dOMCachedNode6 = dOMCachedNode3 = dOMCachedNode5 == null ? this.copyToOriginalNode(dOMCachedNode.getBuiltParent()) : dOMCachedNode5.getBuiltParent();
            }
            if (dOMCachedNode3 != null && dOMCachedNode5 == null) {
                DOMCachedNode dOMCachedNode7 = null;
                if (dOMCachedNode.itemKind() == 4 && LazyLoadingHelper.isFirstNamespaceBuilt(dOMCachedNode3.getState())) {
                    dOMCachedNode7 = dOMCachedNode3.getBuiltFirstNamespace();
                } else if (dOMCachedNode.itemKind() == 2 && LazyLoadingHelper.isFirstAttributeBuilt(dOMCachedNode3.getState())) {
                    dOMCachedNode7 = dOMCachedNode3.getBuiltFirstAttribute();
                } else if (dOMCachedNode.itemKind() != 4 && dOMCachedNode.itemKind() != 2 && LazyLoadingHelper.isFirstChildBuilt(dOMCachedNode3.getState())) {
                    dOMCachedNode7 = dOMCachedNode3.getBuiltFirstChild();
                }
                if (dOMCachedNode7 != null && dOMCachedNode7 != dOMCachedNode) {
                    boolean bl4 = false;
                    while (dOMCachedNode.getOriginalNode() != null) {
                        if ((dOMCachedNode = dOMCachedNode.getOriginalNode()) != dOMCachedNode7) continue;
                        bl4 = true;
                    }
                    if (!bl4) {
                        if (bl2 && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "We are trying to make a copy of original node [1] but our current parent node [2] has a different node [3] as its child.\n[1]original node=  " + dOMCachedNode.toStringLazy() + "\n[2]parent= " + dOMCachedNode3.toStringLazy() + "\n[3]child= " + dOMCachedNode7.toStringLazy() + "\nStack trace=" + string2);
                        }
                        return null;
                    }
                }
            }
            if (bl2 && logger.isLoggable(Level.FINER)) {
                if (dOMCachedNode3 == null) {
                    logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "parentCopy = null \nStack trace=" + string2);
                } else {
                    logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "parentCopy =" + dOMCachedNode3.toStringLazy() + "\nStack trace=" + string2);
                }
            }
            if (dOMCachedNode5 == null) {
                if (dOMCachedNode3 != null) {
                    if (dOMCachedNode.itemKind() == 4) {
                        if (bl2 && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "erasing first namespace decl");
                        }
                        ((DOMCachedElement)dOMCachedNode3).setBuiltFirstNamespace(null);
                    } else if (dOMCachedNode.itemKind() == 2) {
                        if (bl2 && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "erasing first attribute");
                        }
                        ((DOMCachedElement)dOMCachedNode3).setBuiltFirstAttribute(null);
                    } else {
                        if (bl2 && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "erasing first child");
                        }
                        ((DOMCachedContainer)dOMCachedNode3).setBuiltFirstChild(null);
                    }
                }
            } else {
                if (bl2 && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "erasing following sibling");
                }
                dOMCachedNode5.setBuiltFollowingSibling(null);
            }
            CacheManager cacheManager2 = cacheManager = dOMCachedNode3 == null ? this.copiedManager : dOMCachedNode3.getCache();
            if (bl2 && logger.isLoggable(Level.FINER)) {
                String string4 = dOMCachedNode.getBuiltPrecedingSibling() == null ? "null" : dOMCachedNode.getBuiltPrecedingSibling().toStringLazy();
                object4 = dOMCachedNode.getBuiltParent() == null ? "null" : dOMCachedNode.getBuiltParent().toStringLazy();
                object3 = dOMCachedNode5 == null ? "null" : dOMCachedNode5.toStringLazy();
                String string5 = dOMCachedNode3 == null ? "null" : dOMCachedNode3.toStringLazy();
                logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "about to make copy: \n original=" + dOMCachedNode.toStringLazy() + "\n original.preceding=" + string4 + "\n original.parent=" + (String)object4 + "\n precedingCopy=" + (String)object3 + "\n parentCopy=" + string5);
            }
            dOMCachedNode2 = cacheManager.copySingleNode(dOMCachedNode, dOMCachedNode3, dOMCachedNode5, bl, this, this.options != 0);
            if (dOMCachedNode.isCopy()) {
                DOMCachedNode dOMCachedNode8 = dOMCachedNode.getOriginalNode();
                while (dOMCachedNode8 != null && this.copiedNodes.get(dOMCachedNode8) == null) {
                    this.copiedManager.setCopiedNode(dOMCachedNode8, dOMCachedNode2);
                    dOMCachedNode8 = dOMCachedNode8.isCopy() ? dOMCachedNode8.getOriginalNode() : null;
                }
            }
            if (dOMCachedNode2.getInternalNodeData() == null) {
                if (bl2 && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "nodeCopy didn't have an user data, so creating a copied user data for it +and setting the mediator to: + " + dOMCachedNode3.getMediatorData());
                }
                dOMCachedNode2.setInternalNodeData(CopiedDataFactory.INSTANCE.create(dOMCachedNode2));
                dOMCachedNode2.setMediatorData(dOMCachedNode3.getMediatorData());
            }
            dOMCachedNode2.setOriginalNode(dOMCachedNode);
            if (dOMCachedNode2.getMediatorData() != null && !(dOMCachedNode2.getMediatorData().getWrappedMediator() instanceof CopiedCacheMediator)) {
                if (bl2 && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "nodeCopy had a mediator set which was NOT a copied mediator. It was " + dOMCachedNode2.getMediatorData());
                }
                dOMCachedNode2.setMediatorData(this);
            }
            if (dOMCachedNode3 != null) {
                if (dOMCachedNode2.itemKind() == 4) {
                    dOMCachedNode3.setState(LazyLoadingHelper.markFirstNamespaceResolved(dOMCachedNode3.getState()));
                } else if (dOMCachedNode2.itemKind() == 2) {
                    dOMCachedNode3.setState(LazyLoadingHelper.markFirstAttributeResolved(dOMCachedNode3.getState()));
                } else {
                    dOMCachedNode3.setState(LazyLoadingHelper.markFirstChildResolved(dOMCachedNode3.getState()));
                }
            }
            if (dOMCachedNode5 != null) {
                dOMCachedNode5.setState(LazyLoadingHelper.markFollowingResolved(dOMCachedNode5.getState()));
            }
            this.updateLiveCursors(dOMCachedNode, dOMCachedNode2);
            CacheManager.CopyReference copyReference = this.copiedManager.getCopiedManagers();
            if (copyReference != null) {
                object4 = copyReference;
                while (object4 != null) {
                    if (((Reference)object4).get() != null) {
                        object3 = ((CacheManager)((Reference)object4).get()).getCopiedMediator();
                        if (bl) {
                            ((CopiedCacheMediator)object3).copyToOriginalNode(dOMCachedNode2, true);
                        } else {
                            ((CopiedCacheMediator)object3).nodeAboutToChange(dOMCachedNode2, Cursor.Area.SUBTREE.immediateArea());
                        }
                    }
                    object4 = ((CacheManager.CopyReference)object4).nextReference;
                }
            }
            if (!bl && BitMaskHelper.stateContains(dOMCachedNode2.getState(), 0x8000000)) {
                dOMCachedNode2.handleCopyList();
            }
        }
        if (bl2 && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "copyToOriginalNode", "original node=" + dOMCachedNode.toStringLazy() + " | nodeCopy=" + dOMCachedNode2.toStringLazy());
        }
        return dOMCachedNode2;
    }

    public void updateLiveCursors(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), "updateLiveCursors", "updating list of cursors, which was triggered by this stack:\n " + XCIErrorHelper.getStackTrace(30));
        }
        CursorWithOriginal cursorWithOriginal = this.headCursorWithOriginal;
        while (cursorWithOriginal != null) {
            cursorWithOriginal.myCursor.notifyCopy(dOMCachedNode, dOMCachedNode2);
            cursorWithOriginal = cursorWithOriginal.next;
        }
    }

    public boolean buildChildren(DOMCachedNode dOMCachedNode, NodeTest nodeTest) {
        DOMCachedNode dOMCachedNode2;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "buildChildren", "parent = " + dOMCachedNode.toStringLazy() + "\ntest = " + nodeTest);
        }
        if ((dOMCachedNode2 = dOMCachedNode.getOriginalNode()) == null) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "buildChildren", "The parent passed in did not have any original data: " + dOMCachedNode.toStringLazy());
            }
            return false;
        }
        if (dOMCachedNode2 == dOMCachedNode) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "buildChildren", "this node references itself as the original, exiting : " + dOMCachedNode.toStringLazy());
            }
            return false;
        }
        DOMCachedNode dOMCachedNode3 = dOMCachedNode2.getCachedFirstChild();
        if (dOMCachedNode.getBuiltFirstChild() == null) {
            ((DOMCachedContainer)dOMCachedNode).setBuiltFirstChild(dOMCachedNode3);
            if (dOMCachedNode3 != null && (dOMCachedNode.getCache().getContainsMovedCopy() || dOMCachedNode.getMediatorData() != this)) {
                this.copyToOriginalNode(dOMCachedNode3);
            }
            return dOMCachedNode3 != null;
        }
        return true;
    }

    public boolean buildAttributes(DOMCachedElement dOMCachedElement, NodeTest nodeTest) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "buildAttributes", "owner = " + dOMCachedElement.toStringLazy() + "\ntest = " + nodeTest);
        }
        if (dOMCachedElement.getOriginalNode() == dOMCachedElement) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "buildAttributes", "this node references itself as the original, exiting : " + dOMCachedElement.toStringLazy());
            }
            return false;
        }
        if (dOMCachedElement.getOriginalNode() == null) {
            return false;
        }
        DOMCachedAttribute dOMCachedAttribute = ((DOMCachedElement)dOMCachedElement.getOriginalNode()).getCachedFirstAttribute();
        if (dOMCachedElement.getBuiltFirstAttribute() == null) {
            dOMCachedElement.setBuiltFirstAttribute(dOMCachedAttribute);
            if (dOMCachedAttribute != null && (dOMCachedElement.getCache().getContainsMovedCopy() || dOMCachedElement.getMediatorData() != this)) {
                this.copyToOriginalNode(dOMCachedAttribute);
            }
            return dOMCachedAttribute != null;
        }
        return true;
    }

    public boolean buildNamespaceNodes(DOMCachedElement dOMCachedElement, NodeTest nodeTest) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "buildNamespaceNodes", "owner = " + dOMCachedElement.toStringLazy() + "\ntest = " + nodeTest);
        }
        if (dOMCachedElement.getOriginalNode() == dOMCachedElement) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "buildNamespaceNodes", "this node references itself as the original, exiting : " + dOMCachedElement.toStringLazy());
            }
            return false;
        }
        if (dOMCachedElement.getOriginalNode() == null) {
            return false;
        }
        DOMCachedNamespace dOMCachedNamespace = ((DOMCachedElement)dOMCachedElement.getOriginalNode()).getCachedFirstNamespaceNode();
        if (dOMCachedElement.getBuiltFirstNamespace() == null) {
            dOMCachedElement.setBuiltFirstNamespace(dOMCachedNamespace);
            if (dOMCachedNamespace != null && (dOMCachedElement.getCache().getContainsMovedCopy() || dOMCachedElement.getMediatorData() != this)) {
                this.copyToOriginalNode(dOMCachedNamespace);
            }
            return dOMCachedNamespace != null;
        }
        return true;
    }

    public boolean buildNext(DOMCachedNode dOMCachedNode) {
        DOMCachedNode dOMCachedNode2;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "buildNext", "calling buildNext for node: " + dOMCachedNode.toStringLazy() + "\nCache manager = " + dOMCachedNode.getCache() + " | Mediator (default) = " + dOMCachedNode.getCache().mediator() + " | Mediator (for node) = " + dOMCachedNode.getMediatorData());
        }
        if ((dOMCachedNode2 = dOMCachedNode.getOriginalNode()) == dOMCachedNode) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "buildNext", "this node references itself as the original, exiting : " + dOMCachedNode.toStringLazy());
            }
            return false;
        }
        if (dOMCachedNode2 == null) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "buildNext", "this node does not contain an original reference. exiting : " + dOMCachedNode.toStringLazy());
            }
            return false;
        }
        switch (dOMCachedNode.itemKind()) {
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                DOMCachedNode dOMCachedNode3 = dOMCachedNode2.getCachedFollowingSibling();
                if (dOMCachedNode.getBuiltFollowingSibling() == null) {
                    dOMCachedNode.setBuiltFollowingSibling(dOMCachedNode3);
                    if (dOMCachedNode3 != null && dOMCachedNode.getCache().getContainsMovedCopy()) {
                        this.copyToOriginalNode(dOMCachedNode3);
                    }
                    return dOMCachedNode3 != null;
                }
                return true;
            }
            case 2: {
                DOMCachedAttribute dOMCachedAttribute = ((DOMCachedAttribute)dOMCachedNode2).getCachedFollowingAttribute();
                if (dOMCachedAttribute == dOMCachedNode) {
                    if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, logger.getName(), "buildNext", "tried to set a cycle for the attribute :  " + dOMCachedNode.toStringLazy());
                    }
                    return false;
                }
                if (dOMCachedNode.getBuiltFollowingSibling() == null) {
                    dOMCachedNode.setBuiltFollowingSibling(dOMCachedAttribute);
                    if (dOMCachedAttribute != null && dOMCachedNode.getCache().getContainsMovedCopy()) {
                        this.copyToOriginalNode(dOMCachedAttribute);
                    }
                    return dOMCachedAttribute != null;
                }
                return true;
            }
            case 4: {
                DOMCachedNamespace dOMCachedNamespace = ((DOMCachedNamespace)dOMCachedNode2).getCachedFollowingNamespaceNode();
                if (dOMCachedNode.getBuiltFollowingSibling() == null) {
                    dOMCachedNode.setBuiltFollowingSibling(dOMCachedNamespace);
                    if (dOMCachedNamespace != null && dOMCachedNode.getCache().getContainsMovedCopy()) {
                        this.copyToOriginalNode(dOMCachedNamespace);
                    }
                    return dOMCachedNamespace != null;
                }
                return true;
            }
        }
        return false;
    }

    public ItemCopier getItemCopier(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "getItemCopier", "requesting a new itemCopier for mediator: " + this.originalManager.mediator() + " | originalNode: " + dOMCachedNode.getOriginalNode().toStringLazy() + " | itemCopier: " + this.originalManager.mediator().getItemCopier(dOMCachedNode.getOriginalNode()));
        }
        return new CopiedItemCopier(this.originalManager.mediator().getItemCopier(dOMCachedNode.getOriginalNode()));
    }

    public Cursor focus() {
        return this.originalManager.mediator().focus();
    }

    public String dumpCopiedNodes() {
        if (this.copiedNodes == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (DOMCachedNode dOMCachedNode : this.copiedNodes.keySet()) {
            stringBuilder.append('\n');
            stringBuilder.append("Original = ");
            stringBuilder.append(dOMCachedNode.toStringLazy());
            stringBuilder.append('\n');
            stringBuilder.append("Copied = ");
            stringBuilder.append(this.copiedNodes.get(dOMCachedNode).toStringLazy());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public final void copySubtreeEager(DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "copySubtreeEager", "Entering copySubtreeEager for node : " + dOMCachedNode.toStringLazy());
        }
        for (DOMCachedNamespace dOMCachedNamespace = dOMCachedNode.getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
            if (this.nativeCOWNode(dOMCachedNamespace)) continue;
            this.copyToOriginalNode(dOMCachedNamespace);
        }
        for (DOMCachedAttribute dOMCachedAttribute = dOMCachedNode.getCachedFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
            if (this.nativeCOWNode(dOMCachedAttribute)) continue;
            this.copyToOriginalNode(dOMCachedAttribute);
        }
        DOMCachedNode dOMCachedNode2 = dOMCachedNode.getCachedFirstChild();
        while (dOMCachedNode2 != null) {
            this.copySubtreeEager(dOMCachedNode2);
            DOMCachedNode dOMCachedNode3 = dOMCachedNode2.getCachedFollowingSibling();
            if (!this.nativeCOWNode(dOMCachedNode2)) {
                this.copyToOriginalNode(dOMCachedNode2);
            }
            dOMCachedNode2 = dOMCachedNode3;
        }
    }

    public void setOptions(int n2) {
        this.options = n2;
    }

    public void applyOptions(DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        short s = dOMCachedNode2.itemKind();
        if ((this.options & 2) != 0 && (s == 1 || s == 2) && dOMCachedNode.itemXSPSVInfo() != null) {
            dOMCachedNode2.setItemPSVI(dOMCachedNode.itemXSPSVInfo(), false);
        }
        if ((this.options & 0x80) != 0) {
            if (s == 1) {
                dOMCachedNode2.setItemXSElementDeclaration(dOMCachedNode.itemXSElementDeclaration());
            } else if (s == 2) {
                dOMCachedNode2.setItemXSAttributeDeclaration(dOMCachedNode.itemXSAttributeDeclaration());
            }
        }
        if (s == 1 && BitMaskHelper.stateContains(dOMCachedNode.getState(), 256)) {
            Object object2 = dOMCachedNode.getField((byte)3);
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, logger.getName(), "applyOptions", "Setting the native data: " + object2 + "\n from original=" + dOMCachedNode.toStringLazy() + "\n into copy=" + dOMCachedNode2.toStringLazy());
            }
            dOMCachedNode2.setField(object2, (byte)3);
            dOMCachedNode2.setState(BitMaskHelper.stateSet(dOMCachedNode2.getState(), 256));
        }
    }

    public void notifyCopyMediator(CopiedCacheMediator copiedCacheMediator) {
        this.notifyCopyMediator(copiedCacheMediator, false);
    }

    private synchronized Object[] getCopies() {
        return this.copiedNodes.values().toArray();
    }

    public void notifyCopyMediator(CopiedCacheMediator copiedCacheMediator, boolean bl) {
        Object[] objectArray = this.getCopies();
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            copiedCacheMediator.copyToOriginalNode((DOMCachedNode)objectArray[i], bl);
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "notifyCopyMediator", "After making copies, this is how the tree of the copyMediator: \n " + copiedCacheMediator.copiedManager.getBuiltRootNode().toStringLazy(null, "", true));
        }
    }

    public InternalNodeDataFactory getUserDataFactory() {
        return CopiedDataFactory.INSTANCE;
    }

    protected class CopiedItemCopier
    extends NoMediator.GeneralItemCopier
    implements ItemCopier {
        ItemCopier originalItemCopier;

        CopiedItemCopier(ItemCopier itemCopier) {
            super(CopiedCacheMediator.this);
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "CopiedItemCopier", "made a new Copied Item Copier with originalItemCopier=" + itemCopier);
            }
            this.originalItemCopier = itemCopier;
        }

        public int copyNode(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
            Object object2;
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                object2 = null;
                if (cursor2.unwrap() instanceof DOMCachedNode) {
                    DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
                    object2 = dOMCachedNode.toStringLazy();
                }
                logger.logp(Level.FINER, logger.getName(), "copyNode", "source =" + (String)object2);
            }
            object2 = (CopiedCacheCursor)cursor2;
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "copyNode", "source manager =" + ((DOMCachedNode)((CacheCursor)object2).getDelegate()).getCache() + "\n copiedManager = " + CopiedCacheMediator.this.copiedManager);
            }
            return super.copyNode(cursor2, cursor3, area);
        }

        public Cursor.Profile sourceProfile() {
            return Copier.SOURCE_FEATURES;
        }

        public Cursor.Profile targetProfile(Cursor.Area area) {
            return Copier.TARGET_FEATURES;
        }
    }

    static class CursorWithOriginal {
        public CursorWithOriginal next;
        protected CopiedCacheCursor myCursor;

        CursorWithOriginal(CopiedCacheCursor copiedCacheCursor) {
            this.myCursor = copiedCacheCursor;
        }
    }
}

