/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom.mediator;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingCursorMediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingDataFactory;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import java.util.ArrayList;
import java.util.List;

public class NavigationCursorMediator
extends StreamingCursorMediator {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean lazySkip;
    private List<Cursor> lazyCursors;

    public NavigationCursorMediator(Cursor cursor2, Cursor.Profile profile, boolean bl) {
        super(cursor2, profile);
        this.lazySkip = bl;
        if (bl) {
            this.lazyCursors = new ArrayList<Cursor>();
        }
    }

    public NavigationCursorMediator(Cursor cursor2, Cursor.Profile profile) {
        this(cursor2, profile, true);
    }

    public boolean buildNext(DOMCachedNode dOMCachedNode) {
        int n2 = dOMCachedNode.getState();
        if (LazyLoadingHelper.isFirstChildBuilt(n2) || dOMCachedNode.itemKind() != 1 || !this.lazySkip) {
            this.visitSubtree(dOMCachedNode, n2, (n2 & 0x800) != 2048);
            return this.doBuildNext(dOMCachedNode);
        }
        if (LazyLoadingHelper.isFirstAttributeBuilt(n2)) {
            this.visitAttributes(dOMCachedNode, n2, true);
        }
        Cursor cursor2 = ((StreamingDataFactory.XCIData)((Object)dOMCachedNode.getInternalNodeData())).getXCI();
        Cursor cursor3 = cursor2.fork(true, Cursor.Profile.MINIMAL_NAVIGATION, Cursor.Profile.MINIMAL_NAVIGATION);
        this.lazyCursors.add(cursor3);
        cursor3.toSelf();
        return this.doBuildNext(dOMCachedNode, cursor3);
    }

    protected boolean doBuildNext(DOMCachedNode dOMCachedNode, Cursor cursor2) {
        Cursor cursor3 = ((StreamingDataFactory.XCIData)((Object)dOMCachedNode.getInternalNodeData())).getXCI();
        if (cursor3.toNext()) {
            ((StreamingDataFactory.XCIData)((Object)this.makeNode(cursor3, dOMCachedNode.getCache(), dOMCachedNode.getCachedParent(), dOMCachedNode).getInternalNodeData())).setXCI(cursor3);
            ((StreamingDataFactory.XCIData)((Object)dOMCachedNode.getInternalNodeData())).setXCI(cursor2);
            return true;
        }
        cursor3.release();
        ((StreamingDataFactory.XCIData)((Object)dOMCachedNode.getInternalNodeData())).setXCI(cursor2);
        if (cursor3 == this.source) {
            this.source = null;
        }
        this.lazyCursors.remove(cursor3);
        return false;
    }

    public boolean lazyMediator() {
        return this.lazySkip;
    }

    public void release() {
        super.release();
        if (this.lazyCursors != null) {
            for (int i = 0; i < this.lazyCursors.size(); ++i) {
                this.lazyCursors.get(i).release();
            }
        }
    }
}

