/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom.mediator;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.ras.xci.XCICustomLoggers;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedDocument;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.InternalNodeData;
import com.ibm.xml.xci.dp.cache.dom.InternalNodeDataFactory;
import com.ibm.xml.xci.dp.cache.dom.mediator.Mediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.NullDataFactory;
import com.ibm.xml.xci.dp.cache.helpers.BitMaskHelper;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.serialize.SerializedCData;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.dp.util.copy.NoItemCopier;
import com.ibm.xml.xci.dp.util.copy.SerializerCDataDelegate;
import com.ibm.xml.xci.serializer.AddContentInterface;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NoMediator
implements Mediator {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private CursorFactory factory;
    private static final Logger logger = LoggerUtil.getLogger(NoMediator.class);
    protected long documentID;

    public NoMediator(CursorFactory cursorFactory) {
        this.factory = cursorFactory;
        this.documentID = -1L;
    }

    public CursorFactory factory() {
        return this.factory;
    }

    public void setFactory(CursorFactory cursorFactory) {
        this.factory = cursorFactory;
    }

    public InternalNodeDataFactory getUserDataFactory() {
        return NullDataFactory.INSTANCE;
    }

    public void processParameters(Map map2) {
    }

    public DOMCachedNode buildFirstTopItem(CacheManager cacheManager, String string2, String string3) {
        this.documentID = cacheManager.documentIdentify();
        if (cacheManager.isXDMXStar()) {
            return cacheManager.makeCachedDocumenFragment();
        }
        return cacheManager.makeCachedDocument(string2, string3);
    }

    public boolean buildAttributes(DOMCachedElement dOMCachedElement, NodeTest nodeTest) {
        DOMCachedContainer dOMCachedContainer = dOMCachedElement.getCachedParent();
        if (dOMCachedContainer != null && dOMCachedElement.getCache().mediator(dOMCachedContainer) != this) {
            this.log("buildAttributes", dOMCachedElement);
        }
        return false;
    }

    public boolean buildNamespaceNodes(DOMCachedElement dOMCachedElement, NodeTest nodeTest) {
        DOMCachedContainer dOMCachedContainer = dOMCachedElement.getCachedParent();
        if (dOMCachedContainer != null && dOMCachedElement.getCache().mediator(dOMCachedContainer) != this) {
            this.log("buildNamespaceNodes", dOMCachedElement);
        }
        return false;
    }

    public boolean buildChildren(DOMCachedNode dOMCachedNode, NodeTest nodeTest) {
        DOMCachedContainer dOMCachedContainer = dOMCachedNode.getCachedParent();
        if (dOMCachedContainer != null && dOMCachedNode.getCache().mediator(dOMCachedContainer) != this) {
            this.log("buildChildren", dOMCachedNode);
        }
        return false;
    }

    public boolean buildNext(DOMCachedNode dOMCachedNode) {
        DOMCachedContainer dOMCachedContainer = dOMCachedNode.getCachedParent();
        if (dOMCachedContainer != null && dOMCachedNode.getCache().mediator(dOMCachedContainer) != this) {
            this.log("buildNext", dOMCachedNode);
        }
        return false;
    }

    public boolean buildPrevious(DOMCachedNode dOMCachedNode) {
        return false;
    }

    public boolean buildPosition(DOMCachedNode dOMCachedNode, long l) {
        return false;
    }

    public boolean buildParent(DOMCachedNode dOMCachedNode) {
        DOMCachedContainer dOMCachedContainer = dOMCachedNode.getCachedParent();
        if (dOMCachedContainer != null && dOMCachedNode.getCache().mediator(dOMCachedContainer) != this) {
            this.log("buildParent", dOMCachedNode);
        }
        return false;
    }

    public boolean buildId(DOMCachedDocument dOMCachedDocument, CData cData) {
        return false;
    }

    public VolatileCData serialize(Cursor cursor2, Map map2) {
        Cursor cursor3 = cursor2.fork(false, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION.union(Cursor.Profile.TO_NODE_TEST), Cursor.Profile.MINIMAL_STREAMING_NAVIGATION.union(Cursor.Profile.TO_NODE_TEST));
        if (this.fastSerializationCompatible(map2, cursor2)) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "serialize", "about to make a SerializerCDataDelegate with the general item copier!");
            }
            return new SerializerCDataDelegate(cursor3, map2, new GeneralItemCopier());
        }
        DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
        if (dOMCachedNode.getCache().getItemCopier() != null) {
            SerializerCDataDelegate serializerCDataDelegate = new SerializerCDataDelegate(cursor3, map2, dOMCachedNode.getCache().getItemCopier());
            dOMCachedNode.getCache().setItemCopier(null);
            return serializerCDataDelegate;
        }
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "serialize", "about to make a SerializedCData fallback.");
        }
        return new SerializedCData(cursor3, map2);
    }

    public ItemCopier getItemCopier(DOMCachedNode dOMCachedNode) {
        return NoItemCopier.SINGLETON;
    }

    public void release() {
    }

    public boolean lazyMediator() {
        return false;
    }

    public void reportMutation(DOMCachedNode dOMCachedNode, boolean bl) {
    }

    public long documentID() {
        return this.documentID;
    }

    protected boolean fastSerializationCompatible(Map map2, Cursor cursor2) {
        if (!(cursor2.unwrap() instanceof DOMCachedNode)) {
            return false;
        }
        boolean bl = ((DOMCachedNode)cursor2.unwrap()).getCache().getAttemptFastSerialization();
        if (bl && map2 != null && map2.size() > 0) {
            Object v = map2.get("{http://ibm.com/xml/xci/serializer}fast-ser");
            if (v != null) {
                return (Boolean)v != false;
            }
            int n2 = map2.size();
            if (n2 > 3) {
                return false;
            }
            for (String string2 : map2.keySet()) {
                Object object2;
                if ("omit-xml-declaration".equals(string2) || ("encoding".equals(string2) ? (object2 = (String)map2.get(string2)) != null && ((String)object2).equalsIgnoreCase("UTF-8") : "discard-default-attr".equals(string2) && (object2 = (Boolean)map2.get(string2)) != null && ((Boolean)object2).booleanValue())) continue;
                return false;
            }
            return true;
        }
        return bl;
    }

    public Cursor focus() {
        return null;
    }

    public boolean fastSerializationEnabled() {
        return false;
    }

    private void log(String string2, DOMCachedNode dOMCachedNode) {
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, logger.getName(), string2, "calling " + string2 + " for node: " + dOMCachedNode.toStringLazy() + "\nCache manager = " + dOMCachedNode.getCache() + " | Mediator (default) = " + dOMCachedNode.getCache().mediator() + " | Mediator (for node) = " + dOMCachedNode.getCache().mediator(dOMCachedNode) + " Stack trace = " + XCIErrorHelper.getStackTrace(20));
        }
    }

    public void treeOnlyMode(DOMCachedNode dOMCachedNode) {
        for (DOMCachedNamespace dOMCachedNamespace = dOMCachedNode.getCachedFirstNamespaceNode(); dOMCachedNamespace != null; dOMCachedNamespace = dOMCachedNamespace.getCachedFollowingNamespaceNode()) {
            if (dOMCachedNamespace.getMediatorData() == null) continue;
            dOMCachedNamespace.getMediatorData().treeOnlyMode(dOMCachedNamespace);
        }
        for (DOMCachedAttribute dOMCachedAttribute = dOMCachedNode.getCachedFirstAttribute(); dOMCachedAttribute != null; dOMCachedAttribute = dOMCachedAttribute.getCachedFollowingAttribute()) {
            if (dOMCachedAttribute.getMediatorData() == null) continue;
            dOMCachedAttribute.getMediatorData().treeOnlyMode(dOMCachedAttribute);
        }
        for (DOMCachedNode dOMCachedNode2 = dOMCachedNode.getCachedFirstChild(); dOMCachedNode2 != null; dOMCachedNode2 = dOMCachedNode2.getCachedFollowingSibling()) {
            if (dOMCachedNode2.getMediatorData() != null) {
                dOMCachedNode2.getMediatorData().treeOnlyMode(dOMCachedNode2);
                continue;
            }
            this.treeOnlyMode(dOMCachedNode2);
        }
        InternalNodeData internalNodeData = dOMCachedNode.getInternalNodeData();
        if (internalNodeData != null && internalNodeData.isDynamic()) {
            NullDataFactory.EmptyDataDynamic emptyDataDynamic = new NullDataFactory.EmptyDataDynamic();
            Object object2 = internalNodeData.getExtraField((byte)-1);
            ((InternalNodeData)emptyDataDynamic).setExtraField(object2, (byte)-1);
            dOMCachedNode.setInternalNodeData(emptyDataDynamic);
        } else {
            dOMCachedNode.setInternalNodeData(null);
        }
    }

    public Mediator getWrappedMediator() {
        return this;
    }

    protected class GeneralItemCopier
    implements ItemCopier {
        protected GeneralItemCopier() {
        }

        public int copyNode(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
            short s = cursor2.itemKind();
            if (s != 4 && s != 2) {
                InternalNodeData internalNodeData;
                Cursor cursor4;
                InternalNodeData internalNodeData2;
                boolean bl;
                Cursor cursor5 = cursor2.unwrap();
                if (!(cursor5 instanceof DOMCachedNode)) {
                    return 3;
                }
                DOMCachedNode dOMCachedNode = (DOMCachedNode)cursor2.unwrap();
                boolean bl2 = bl = LoggerUtil.isAnyTracingEnabled() && XCICustomLoggers.serializationLogger.isLoggable(Level.FINER);
                if (bl) {
                    XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "copyNode", "Entering copyNode for the node: " + dOMCachedNode.toStringLazy(null, "", true));
                }
                if ((internalNodeData2 = dOMCachedNode.getInternalNodeData()) == null) {
                    if (bl) {
                        XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "copyNode", "node did not have any data, fallback");
                    }
                    return 3;
                }
                if (dOMCachedNode.isDirty()) {
                    if (bl) {
                        XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "copyNode", "node was dirty, fallback");
                    }
                    return 3;
                }
                DOMCachedNode dOMCachedNode2 = dOMCachedNode.getCachedParent();
                if (dOMCachedNode2 != null && !dOMCachedNode2.isSubtreeDirty() && (cursor4 = cursor2.fork(false)).toParent() && !(dOMCachedNode2 = (DOMCachedNode)cursor4.unwrap()).isSubtreeDirty()) {
                    if (bl) {
                        XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "copyNode", "we have a parent with a clean subtree");
                    }
                    if ((internalNodeData = dOMCachedNode2.getInternalNodeData()) != null) {
                        DOMCachedNode dOMCachedNode3 = this.getCleanOriginal(dOMCachedNode2);
                        if (dOMCachedNode3 != null) {
                            dOMCachedNode2 = dOMCachedNode3;
                            internalNodeData = dOMCachedNode2.getInternalNodeData();
                        }
                        if (internalNodeData == null) {
                            if (bl) {
                                XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "copyNode", "parentData was null, keep trying..");
                            }
                        } else {
                            int n2 = internalNodeData.addSubtreeContent(dOMCachedNode2, area, (AddContentInterface)((Object)cursor3));
                            if (n2 != 3) {
                                if (bl) {
                                    XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "copyNode", "we finished serializing the subtree , fast serialized!");
                                }
                                return n2;
                            }
                        }
                    }
                }
                if ((cursor4 = this.getCleanOriginal(dOMCachedNode)) == null) {
                    if (bl) {
                        XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "copyNode", "trying to skip so we can ensure known end-offset");
                    }
                    if (!LazyLoadingHelper.isFirstChildBuilt(dOMCachedNode.getState())) {
                        dOMCachedNode.setState(BitMaskHelper.stateSet(dOMCachedNode.getState(), 16));
                        dOMCachedNode.getCachedFollowingSibling();
                    }
                    internalNodeData2 = dOMCachedNode.getInternalNodeData();
                    int n3 = internalNodeData2.addContent(area, (AddContentInterface)((Object)cursor3));
                    if (bl) {
                        if (n3 == 3) {
                            XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "copyNode", "could not fast serialize using addContent, fallback");
                        } else {
                            XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "copyNode", "successful in using addContent, fast serialized");
                        }
                    }
                    return n3;
                }
                internalNodeData = ((DOMCachedNode)cursor4).getInternalNodeData();
                if (internalNodeData == null) {
                    if (bl) {
                        XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "copyNode", "cannot fast serialize from original, fallback");
                    }
                    return 3;
                }
                if (!LazyLoadingHelper.isFirstChildBuilt(((DOMCachedNode)cursor4).getState()) && ((DOMCachedNode)cursor4).getBuiltParent() != null && !BitMaskHelper.stateContains(((DOMCachedNode)cursor4).getBuiltParent().getState(), 64)) {
                    ((DOMCachedNode)cursor4).setState(BitMaskHelper.stateSet(((DOMCachedNode)cursor4).getState(), 16));
                    ((DOMCachedNode)cursor4).getCachedFollowingSibling();
                }
                internalNodeData = ((DOMCachedNode)cursor4).getInternalNodeData();
                int n4 = internalNodeData.addContent(area, (AddContentInterface)((Object)cursor3));
                if (bl) {
                    if (n4 == 3) {
                        XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "copyNode", "[2]could not fast serialize using addContent, fallback");
                    } else {
                        XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "copyNode", "[2]successful in using addContent, fast serialized");
                    }
                }
                return n4;
            }
            return 3;
        }

        private DOMCachedNode getCleanOriginal(DOMCachedNode dOMCachedNode) {
            InternalNodeData internalNodeData = dOMCachedNode.getInternalNodeData();
            while (internalNodeData != null && dOMCachedNode.getOriginalNode() != null && !dOMCachedNode.getOriginalNode().isDirty()) {
                dOMCachedNode = dOMCachedNode.getOriginalNode();
                internalNodeData = dOMCachedNode.getInternalNodeData();
            }
            return dOMCachedNode;
        }

        public Cursor.Profile sourceProfile() {
            return Copier.SOURCE_FEATURES;
        }

        public Cursor.Profile targetProfile(Cursor.Area area) {
            return Copier.TARGET_FEATURES;
        }
    }
}

