/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.cache.dom.mediator;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractXAPICursor;
import com.ibm.xml.xci.dp.cache.dom.CacheManager;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedAttribute;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedContainer;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedDocument;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedElement;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNamespace;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedSimple;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedText;
import com.ibm.xml.xci.dp.cache.dom.InternalNodeDataFactory;
import com.ibm.xml.xci.dp.cache.dom.helpers.MiscHelpers;
import com.ibm.xml.xci.dp.cache.dom.mediator.NoMediator;
import com.ibm.xml.xci.dp.cache.dom.mediator.StreamingDataFactory;
import com.ibm.xml.xci.dp.cache.helpers.LazyLoadingHelper;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.errors.XCIUnsupportedOperationException;
import com.ibm.xml.xci.internal.values.InvalidEmptyCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.util.SimpleKindTest;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.ElementPSVI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamingCursorMediator
extends NoMediator {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2011. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Cursor source;
    private static final Logger logger = LoggerUtil.getLogger(StreamingCursorMediator.class);

    public StreamingCursorMediator(Cursor cursor2, Cursor.Profile profile) {
        super(cursor2.factory());
        Cursor.Profile profile2 = cursor2.profile();
        this.source = cursor2;
        if (!Cursor.Profile.MINIMAL_STREAMING_NAVIGATION.containedIn(profile2)) {
            throw new XCIUnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.MINIMAL_STREAMING_NAVIGATION"}));
        }
    }

    protected boolean doBuildNext(DOMCachedNode dOMCachedNode) {
        Cursor cursor2 = ((StreamingDataFactory.XCIData)((Object)dOMCachedNode.getInternalNodeData())).getXCI();
        if (cursor2.toNext()) {
            DOMCachedNode dOMCachedNode2 = this.makeNode(cursor2, dOMCachedNode.getCache(), dOMCachedNode.getCachedParent(), dOMCachedNode);
            StreamingDataFactory.XCIData xCIData = (StreamingDataFactory.XCIData)((Object)dOMCachedNode2.getInternalNodeData());
            xCIData.setXCI(cursor2);
            return true;
        }
        cursor2.release();
        if (cursor2 == this.source) {
            // empty if block
        }
        return false;
    }

    public InternalNodeDataFactory getUserDataFactory() {
        return StreamingDataFactory.INSTANCE;
    }

    public DOMCachedNode buildFirstTopItem(CacheManager cacheManager, String string2, String string3) {
        DOMCachedNode dOMCachedNode;
        this.documentID = cacheManager.documentIdentify();
        switch (this.source.itemKind()) {
            case 2: {
                dOMCachedNode = cacheManager.makeCachedAttribute(this.source.itemName(), this.source.itemTypedValue(), (AttributePSVI)this.source.itemXSPSVInfo(), this.source.itemXSAttributeDeclaration(), null);
                DOMCachedAttribute dOMCachedAttribute = (DOMCachedAttribute)dOMCachedNode;
                dOMCachedAttribute.itemValueOrigin = this.source.itemAttributeValueOrigin();
                dOMCachedAttribute.setState(6159);
                dOMCachedAttribute.setItemXSType(this.source.itemXSType());
                break;
            }
            case 4: {
                dOMCachedNode = cacheManager.makeCachedNamespaceNode(this.source.itemName(), this.source.itemTypedValue(), null);
                break;
            }
            case 1: {
                dOMCachedNode = cacheManager.makeCachedElement(this.source.itemName(), this.source.itemXSType(), (ElementPSVI)this.source.itemXSPSVInfo(), this.source.itemXSElementDeclaration(), this.source.itemNilled(), null, null);
                break;
            }
            case 3: {
                dOMCachedNode = cacheManager.makeCachedText(this.source.itemTypedValue(), false, this.source.itemIsAtomic(), null, null);
                break;
            }
            case 8: {
                dOMCachedNode = cacheManager.makeCachedComment(this.source.itemTypedValue(), null, null);
                break;
            }
            case 7: {
                dOMCachedNode = cacheManager.makeCachedPI(this.source.itemName(), this.source.itemTypedValue(), null, null);
                break;
            }
            case 9: {
                dOMCachedNode = cacheManager.makeCachedDocument(string2, string3);
                break;
            }
            default: {
                throw XCIErrorHelper.createBadContextItemException("buildFirstTopItem", this.source.itemKind());
            }
        }
        ((StreamingDataFactory.XCIData)((Object)dOMCachedNode.getInternalNodeData())).setXCI(this.source);
        if (cacheManager.isWrapper()) {
            return dOMCachedNode;
        }
        if (cacheManager.isValidateLoading()) {
            Boolean bl = (Boolean)cacheManager.factory().getSessionContext().getOption("http://www.ibm.com/xml/xci/bo/bo-bc-mode");
            if (bl != null && bl.booleanValue()) {
                DOMCachedNode dOMCachedNode2 = dOMCachedNode.getCachedFirstChild(SimpleKindTest.ELEMENT);
                if (dOMCachedNode2 == null) {
                    dOMCachedNode.validate(112);
                } else {
                    dOMCachedNode2.validate(112, null, dOMCachedNode2.itemXSType(), null);
                }
            } else {
                dOMCachedNode.validate(112);
            }
        } else if (cacheManager.isEagerLoading()) {
            this.visitSubtree(dOMCachedNode, dOMCachedNode.getState(), true);
        }
        return dOMCachedNode;
    }

    public DOMCachedNode buildNextTopItem(CacheManager cacheManager, String string2, String string3) {
        if (this.source == null || !this.source.toNext()) {
            this.source = null;
            return null;
        }
        return this.buildFirstTopItem(cacheManager, string2, string3);
    }

    public boolean buildNamespaceNodes(DOMCachedElement dOMCachedElement, NodeTest nodeTest) {
        assert (nodeTest == null) : "Only null build test supported!";
        if (!(dOMCachedElement.getInternalNodeData() instanceof StreamingDataFactory.XCIData)) {
            return false;
        }
        Cursor cursor2 = ((StreamingDataFactory.XCIData)((Object)dOMCachedElement.getInternalNodeData())).getXCI();
        Cursor cursor3 = cursor2.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION);
        if (cursor3.toNamespaceDecls()) {
            ((StreamingDataFactory.XCIData)((Object)this.makeNode(cursor3, dOMCachedElement.getCache(), dOMCachedElement, null).getInternalNodeData())).setXCI(cursor3);
            return true;
        }
        cursor3.release();
        return false;
    }

    public boolean buildAttributes(DOMCachedElement dOMCachedElement, NodeTest nodeTest) {
        assert (nodeTest == null) : "Only null build test supported!";
        int n2 = dOMCachedElement.getState();
        if ((n2 & 0x1800) != 6144) {
            this.visitNamespaceNodes(dOMCachedElement, n2, (n2 & 0x800) != 2048);
        }
        if (!(dOMCachedElement.getInternalNodeData() instanceof StreamingDataFactory.XCIData)) {
            return false;
        }
        Cursor cursor2 = ((StreamingDataFactory.XCIData)((Object)dOMCachedElement.getInternalNodeData())).getXCI();
        Cursor cursor3 = cursor2.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION);
        if (cursor3.toAttributes(null)) {
            ((StreamingDataFactory.XCIData)((Object)this.makeNode(cursor3, dOMCachedElement.getCache(), dOMCachedElement, null).getInternalNodeData())).setXCI(cursor3);
            return true;
        }
        cursor3.release();
        return false;
    }

    public boolean buildChildren(DOMCachedNode dOMCachedNode, NodeTest nodeTest) {
        assert (nodeTest == null) : "Only null build test supported!";
        int n2 = dOMCachedNode.getState();
        if ((n2 & 0x1800) != 6144) {
            this.visitNamespaceNodes(dOMCachedNode, n2, (n2 & 0x800) != 2048);
            n2 = dOMCachedNode.getState();
        }
        if ((n2 & 3) != 3) {
            this.visitAttributes(dOMCachedNode, n2, (n2 & 1) != 1);
        }
        if (!(dOMCachedNode.getInternalNodeData() instanceof StreamingDataFactory.XCIData)) {
            return false;
        }
        Cursor cursor2 = ((StreamingDataFactory.XCIData)((Object)dOMCachedNode.getInternalNodeData())).getXCI();
        Cursor cursor3 = cursor2.fork(true, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION);
        if (cursor3.toChildren(null)) {
            ((StreamingDataFactory.XCIData)((Object)this.makeNode(cursor3, dOMCachedNode.getCache(), dOMCachedNode, null).getInternalNodeData())).setXCI(cursor3);
            return true;
        }
        cursor3.release();
        return false;
    }

    public boolean buildNext(DOMCachedNode dOMCachedNode) {
        int n2 = dOMCachedNode.getState();
        if ((n2 & 0x180F) != 6159) {
            this.visitSubtree(dOMCachedNode, n2, (n2 & 0x800) != 2048);
        }
        return this.doBuildNext(dOMCachedNode);
    }

    public boolean buildPrevious(DOMCachedNode dOMCachedNode) {
        return false;
    }

    public boolean buildPosition(DOMCachedNode dOMCachedNode, long l) {
        assert (false);
        return false;
    }

    public boolean buildParent(DOMCachedNode dOMCachedNode) {
        return dOMCachedNode.getBuiltParent() != null;
    }

    public boolean buildIds(DOMCachedDocument dOMCachedDocument, CData cData) {
        return false;
    }

    public void release() {
        if (this.source != null) {
            this.source.release();
        }
    }

    protected DOMCachedNode makeNode(Cursor cursor2, CacheManager cacheManager, DOMCachedNode dOMCachedNode, DOMCachedNode dOMCachedNode2) {
        return MiscHelpers.makeNode(cursor2, cacheManager, dOMCachedNode, dOMCachedNode2);
    }

    protected void visitAttributes(DOMCachedNode dOMCachedNode, int n2, boolean bl) {
        if (dOMCachedNode.itemKind() == 1) {
            DOMCachedAttribute dOMCachedAttribute;
            DOMCachedElement dOMCachedElement = (DOMCachedElement)dOMCachedNode;
            DOMCachedAttribute dOMCachedAttribute2 = dOMCachedAttribute = bl ? null : dOMCachedElement.getBuiltFirstAttribute();
            if ((bl || dOMCachedAttribute == null && (n2 & 1) != 1) && this.buildAttributes(dOMCachedElement, null)) {
                dOMCachedAttribute = dOMCachedElement.getBuiltFirstAttribute();
                bl = true;
            }
            while (dOMCachedAttribute != null) {
                DOMCachedAttribute dOMCachedAttribute3;
                DOMCachedAttribute dOMCachedAttribute4 = dOMCachedAttribute3 = bl ? null : dOMCachedAttribute.getBuiltFollowingAttribute();
                if (dOMCachedAttribute3 == null) {
                    int n3 = dOMCachedAttribute.getState();
                    if (bl || (n3 & 0x200) != 512) {
                        if (this.buildNext(dOMCachedAttribute)) {
                            dOMCachedAttribute3 = dOMCachedAttribute.getBuiltFollowingAttribute();
                            bl = true;
                        } else {
                            dOMCachedAttribute3 = null;
                        }
                        dOMCachedAttribute.setState(n3 | 0x200);
                    }
                }
                dOMCachedAttribute = dOMCachedAttribute3;
            }
        }
        dOMCachedNode.setState(n2 | 3);
    }

    protected final void visitNamespaceNodes(DOMCachedNode dOMCachedNode, int n2, boolean bl) {
        if (dOMCachedNode instanceof DOMCachedElement) {
            DOMCachedNamespace dOMCachedNamespace;
            DOMCachedElement dOMCachedElement = (DOMCachedElement)dOMCachedNode;
            DOMCachedNamespace dOMCachedNamespace2 = dOMCachedNamespace = bl ? null : dOMCachedElement.getBuiltFirstNamespace();
            if ((bl || dOMCachedNamespace == null && (n2 & 0x800) != 2048) && this.buildNamespaceNodes(dOMCachedElement, null)) {
                dOMCachedNamespace = dOMCachedElement.getBuiltFirstNamespace();
                bl = true;
            }
            while (dOMCachedNamespace != null) {
                DOMCachedNamespace dOMCachedNamespace3;
                DOMCachedNamespace dOMCachedNamespace4 = dOMCachedNamespace3 = bl ? null : dOMCachedNamespace.getBuiltFollowingNamespaceNode();
                if (dOMCachedNamespace3 == null) {
                    int n3 = dOMCachedNamespace.getState();
                    if (bl || (n3 & 0x200) != 512) {
                        if (this.buildNext(dOMCachedNamespace)) {
                            dOMCachedNamespace3 = dOMCachedNamespace.getBuiltFollowingNamespaceNode();
                            bl = true;
                        } else {
                            dOMCachedNamespace3 = null;
                        }
                        dOMCachedNamespace.setState(n3 | 0x200);
                    }
                }
                dOMCachedNamespace = dOMCachedNamespace3;
            }
        }
        dOMCachedNode.setState(n2 | 0x1800);
    }

    public void visitSubtree(DOMCachedNode dOMCachedNode, int n2, boolean bl) {
        if (dOMCachedNode.getCache().getContainsMovedCopy()) {
            MiscHelpers.visitSubtree(dOMCachedNode);
        } else {
            this.internalVisitSubtree(dOMCachedNode, n2, bl);
        }
    }

    private void internalVisitSubtree(DOMCachedNode dOMCachedNode, int n2, boolean bl) {
        AbstractXAPICursor abstractXAPICursor;
        DOMCachedContainer dOMCachedContainer;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "visitSubtree", "Visiting subtree for node : " + dOMCachedNode.toStringLazy());
        }
        if (dOMCachedNode instanceof DOMCachedContainer && !(dOMCachedNode instanceof DOMCachedSimple)) {
            dOMCachedContainer = (DOMCachedContainer)dOMCachedNode;
            if (!(dOMCachedContainer.getInternalNodeData() instanceof StreamingDataFactory.XCIData)) {
                MiscHelpers.visitSubtree(dOMCachedContainer);
                return;
            }
            if (bl || (n2 & 0x1800) != 6144) {
                this.visitNamespaceNodes(dOMCachedContainer, n2, bl);
                n2 = dOMCachedContainer.getState();
            }
            if (bl || (n2 & 3) != 3) {
                this.visitAttributes(dOMCachedContainer, n2, bl);
                n2 = dOMCachedContainer.getState();
            }
            AbstractXAPICursor abstractXAPICursor2 = abstractXAPICursor = bl ? null : dOMCachedContainer.getBuiltFirstChild();
            if (bl || abstractXAPICursor == null && (n2 & 4) != 4) {
                if (this.buildChildren(dOMCachedContainer, null)) {
                    abstractXAPICursor = dOMCachedContainer.getBuiltFirstChild();
                    bl = true;
                }
                n2 |= 4;
            }
            while (abstractXAPICursor != null) {
                DOMCachedNode dOMCachedNode2;
                int n3 = ((DOMCachedNode)abstractXAPICursor).getState();
                if (bl || (n3 & 0x180F) != 6159) {
                    this.internalVisitSubtree((DOMCachedNode)abstractXAPICursor, n3, bl);
                    n3 = ((DOMCachedNode)abstractXAPICursor).getState();
                }
                if ((dOMCachedNode2 = ((DOMCachedNode)abstractXAPICursor).getBuiltFollowingSibling()) == null && (n3 & 0x200) != 512) {
                    if (this.buildNext((DOMCachedNode)abstractXAPICursor)) {
                        dOMCachedNode2 = ((DOMCachedNode)abstractXAPICursor).getBuiltFollowingSibling();
                        bl = true;
                    }
                    ((DOMCachedNode)abstractXAPICursor).setState(((DOMCachedNode)abstractXAPICursor).getState() | 0x200);
                }
                abstractXAPICursor = dOMCachedNode2;
            }
        }
        if (dOMCachedNode.itemKind() == 1 && dOMCachedNode.getCache().isEagerLoading() && ((DOMCachedElement)(dOMCachedContainer = (DOMCachedElement)dOMCachedNode)).getTextNodeChild() == null && !XCIErrorHelper.allowEmptyValue(dOMCachedNode.itemXSType())) {
            abstractXAPICursor = new InvalidEmptyCData(TypeHelper.getSimpleType(dOMCachedNode.itemXSType()));
            DOMCachedText dOMCachedText = dOMCachedNode.getCache().makeCachedText((VolatileCData)((Object)abstractXAPICursor), false, false, dOMCachedContainer, null);
            dOMCachedText.setState(LazyLoadingHelper.markAllResolved(dOMCachedText.getState()));
        }
        dOMCachedNode.setState(dOMCachedNode.getState() | 0x180F);
    }

    public Cursor focus() {
        return this.source;
    }
}

