/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.serialize;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.util.misc.IntStack;
import com.ibm.xml.xci.dp.util.misc.Stack;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.WhitespaceCharsConstant;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.serializer.AddContentInterface;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.namespace.QName;

public abstract class AbstractSerializeCursor
extends AbstractCursor
implements AddContentInterface {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile FEATURES_LIMIT = Cursor.Profile.MINIMAL_STREAMING_MUTATION;
    private static final int START_DOCUMENT = 0;
    protected static final int IN_START_TAG = 1;
    protected static final int CONTENT = 2;
    protected static final int TEXT_CONTENT = 3;
    protected static final int END_DOCUMENT = 4;
    public static final QName METHOD_HTML = new QName("html");
    public static final QName METHOD_XML = new QName("xml");
    protected boolean strict;
    protected int state;
    protected Stack<CData> openTags;
    protected QName method;
    protected boolean indenting;
    protected boolean avoidEmptyTags;
    protected String[] namespaces;
    protected int nsCount;
    protected IntStack nsCountPerFrame;
    protected boolean usePrefixHint;

    protected AbstractSerializeCursor(CursorFactory cursorFactory, Map map2) {
        super(cursorFactory);
        this.openTags = new Stack(20);
        this.namespaces = new String[128];
        this.nsCount = 0;
        this.nsCountPerFrame = new IntStack(256);
        this.method = METHOD_XML;
        if (map2 != null) {
            Object v;
            if (map2.get("strict") != null) {
                this.strict = (Boolean)map2.get("strict");
            }
            if (map2.get("indent") != null) {
                this.strict = (Boolean)map2.get("indent");
            }
            if (map2.get("method") != null && ((v = map2.get("method")).equals(METHOD_HTML) || "html".equals(v))) {
                this.avoidEmptyTags = true;
            }
            if (map2.get("usePrefixHints") != null) {
                this.usePrefixHint = (Boolean)map2.get("usePrefixHints");
            }
        }
    }

    public AbstractSerializeCursor(CursorFactory cursorFactory) {
        super(cursorFactory);
    }

    protected abstract void writeQName(VolatileCData var1) throws IOException;

    protected abstract void writeOpenTag(VolatileCData var1) throws IOException;

    protected abstract void writeBracketClosingTag(VolatileCData var1) throws IOException;

    protected abstract void writeSlashBracket() throws IOException;

    protected abstract void writeClosingBracket() throws IOException;

    protected abstract void writeClosingTag(VolatileCData var1) throws IOException;

    protected abstract void writeAttribute(boolean var1, VolatileCData var2, VolatileCData var3) throws IOException;

    protected abstract void writeAttribute(boolean var1, VolatileCData var2, Chars var3) throws IOException;

    protected abstract void writeAttrNSDecl(int var1) throws IOException;

    protected abstract void writeValue(VolatileCData var1) throws IOException;

    protected abstract void writeValue(Chars var1) throws IOException;

    protected abstract void writeComment(VolatileCData var1) throws IOException;

    protected abstract void writePI(VolatileCData var1, VolatileCData var2) throws IOException;

    protected abstract void declarePrefix(int var1, String var2, boolean var3);

    protected abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    protected static final boolean isQNameType(VolatileCData volatileCData) {
        XSSimpleTypeDefinition xSSimpleTypeDefinition = volatileCData.getXSTypeDefinition();
        return xSSimpleTypeDefinition != null && xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSQNAME, (short)0);
    }

    private final void finishTag() throws IOException {
        if (this.avoidEmptyTags) {
            this.writeBracketClosingTag(this.openTags.pop());
        } else {
            this.writeSlashBracket();
            this.openTags.pop();
        }
    }

    protected void ensureContentState(Cursor.Area area) throws IOException {
        if (this.state == 1) {
            if (area == Cursor.Area.FOLLOWING_SIBLING) {
                this.finishTag();
                this.popNamespaceContext();
            } else {
                this.writeClosingBracket();
            }
            this.state = 2;
        }
    }

    protected final boolean processNamespace(VolatileCData volatileCData) throws IOException {
        String string2 = volatileCData.getQNameNamespaceURI(1);
        if (string2 == null) {
            string2 = "";
        }
        if (this.toHandle(string2) == -1) {
            this.declareNS(string2, volatileCData.getQNamePrefix(1), true);
            return true;
        }
        return false;
    }

    private final boolean processAttrNamespace(VolatileCData volatileCData) throws IOException {
        String string2 = volatileCData.getQNameNamespaceURI(1);
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (this.toHandle(string2) == -1) {
            this.declareNS(string2, volatileCData.getQNamePrefix(1), true);
            return true;
        }
        return false;
    }

    public void pushNamespaceContext() {
        this.nsCountPerFrame.push(0);
    }

    public void popNamespaceContext() {
        this.nsCount -= this.nsCountPerFrame.pop();
    }

    public void addContent(Cursor.Area area, byte[] byArray, int n2, int n3) {
        try {
            this.ensureContentState(area);
            this.writeBytes(byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public void addContent(Cursor.Area area, char[] cArray, int n2, int n3) {
        try {
            this.ensureContentState(area);
            this.writeChars(cArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public boolean isOptimizedForDirectWrites(String string2) {
        return false;
    }

    public void addNewLine(Cursor.Area area) {
        try {
            this.ensureContentState(area);
            this.state = 3;
            this.writeValue(WhitespaceCharsConstant.newLineChar);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public void flushContent() {
    }

    public void writeChars(char[] cArray, int n2, int n3) throws IOException {
        throw new AssertionError();
    }

    public void toEndOfDocument() {
        this.state = 4;
        this.nsCount = 1;
        this.openTags.clear();
    }

    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    public Cursor.Profile futureProfile() {
        return FEATURES_LIMIT;
    }

    public boolean toChildren(NodeTest nodeTest) {
        return true;
    }

    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        assert (this.incrementForkReleaseCounter());
        return this;
    }

    public void release() {
        try {
            if (this.state == 1) {
                this.finishTag();
                this.popNamespaceContext();
            }
            if (this.openTags.isEmpty()) {
                switch (this.state) {
                    case 0: 
                    case 4: {
                        break;
                    }
                    default: {
                        this.state = 4;
                        break;
                    }
                }
            } else {
                VolatileCData volatileCData = this.openTags.pop();
                this.writeClosingTag(volatileCData);
                this.popNamespaceContext();
                this.state = 2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        assert (this.decrementForkReleaseCounter());
    }

    public boolean requiresRelease() {
        return true;
    }

    public boolean openMutation(Cursor.Area area) {
        this.state = 0;
        this.pushNamespaceContext();
        this.declareNS("", "", true);
        return true;
    }

    public void closeMutation() {
    }

    public void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2) {
        try {
            if (this.strict && this.state != 1) {
                if (this.openTags.isEmpty()) {
                    throw new XCIDynamicErrorException("ER_SER_ILLEGAL_ATTRIBUTE_POSITION2", new String[]{this.dbgGetRawName(volatileCData), this.dbgGetValue(volatileCData2)});
                }
                throw new XCIDynamicErrorException("ER_SER_ILLEGAL_ATTRIBUTE_POSITION3", new String[]{this.dbgGetRawName(volatileCData), this.dbgGetValue(volatileCData2), this.dbgGetRawName(this.openTags.peek())});
            }
            if (this.processAttrNamespace(volatileCData)) {
                this.writeAttrNSDecl(this.toHandle(volatileCData.getQNameNamespaceURI(1)));
            }
            if (AbstractSerializeCursor.isQNameType(volatileCData2) && this.processNamespace(volatileCData2)) {
                this.writeAttrNSDecl(this.toHandle(volatileCData2.getQNameNamespaceURI(1)));
            }
            this.writeAttribute(this.state == 1, volatileCData, volatileCData2);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public void addAttribute(VolatileCData volatileCData, Chars chars) {
        try {
            if (this.strict && this.state != 1) {
                if (this.openTags.isEmpty()) {
                    throw new XCIDynamicErrorException("ER_SER_ILLEGAL_ATTRIBUTE_POSITION2", new String[]{this.dbgGetRawName(volatileCData), this.dbgGetValue(chars)});
                }
                throw new XCIDynamicErrorException("ER_SER_ILLEGAL_ATTRIBUTE_POSITION3", new String[]{this.dbgGetRawName(volatileCData), this.dbgGetValue(chars), this.dbgGetRawName(this.openTags.peek())});
            }
            if (this.processAttrNamespace(volatileCData)) {
                this.writeAttrNSDecl(this.toHandle(volatileCData.getQNameNamespaceURI(1)));
            }
            this.writeAttribute(this.state == 1, volatileCData, chars);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public void addNamespaceNode(VolatileCData volatileCData, VolatileCData volatileCData2, boolean bl) {
        try {
            if (this.strict && this.state != 1) {
                if (this.openTags.isEmpty()) {
                    throw new XCIDynamicErrorException("ER_SER_ILLEGAL_NAMESPACE_POSITION2", new String[]{volatileCData.getString(1), this.dbgGetValue(volatileCData2)});
                }
                throw new XCIDynamicErrorException("ER_SER_ILLEGAL_NAMESPACE_POSITION3", new String[]{volatileCData.getString(1), this.dbgGetValue(volatileCData2), this.dbgGetRawName(this.openTags.peek())});
            }
            String string2 = volatileCData2.toString();
            int n2 = this.toHandle(string2);
            if (n2 == -1) {
                String string3 = volatileCData == null ? "" : volatileCData.toString();
                n2 = this.declareNS(string2, string3, false);
                this.writeAttrNSDecl(n2);
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public void addElement(Cursor.Area area, VolatileCData volatileCData, XSTypeDefinition xSTypeDefinition) {
        try {
            CData cData = volatileCData.constant(true);
            this.ensureContentState(area);
            this.pushNamespaceContext();
            boolean bl = this.processNamespace(cData);
            this.writeOpenTag(cData);
            this.openTags.add(cData);
            this.state = 1;
            if (bl) {
                this.writeAttrNSDecl(this.toHandle(cData.getQNameNamespaceURI(1)));
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public void setItemValue(VolatileCData volatileCData) {
        try {
            this.ensureContentState(Cursor.Area.FIRST_CHILD);
            this.writeValue(volatileCData);
            CData cData = this.openTags.pop();
            this.writeClosingTag(cData);
            this.popNamespaceContext();
            this.state = 2;
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public void addText(Cursor.Area area, VolatileCData volatileCData) {
        try {
            this.ensureContentState(area);
            this.state = 3;
            this.writeValue(volatileCData);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public void addComment(Cursor.Area area, VolatileCData volatileCData) {
        try {
            this.ensureContentState(area);
            this.writeComment(volatileCData);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public void addProcessingInstruction(Cursor.Area area, VolatileCData volatileCData, VolatileCData volatileCData2) {
        try {
            this.ensureContentState(area);
            this.writePI(volatileCData, volatileCData2);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public boolean toNext() {
        return true;
    }

    public boolean toFollowingSibling() {
        return true;
    }

    protected int toHandle(String string2) {
        for (int i = this.nsCount - 1; i >= 0; --i) {
            if (!this.namespaces[i].equals(string2)) continue;
            return i;
        }
        return -1;
    }

    protected int declareNS(String string2, String string3, boolean bl) {
        this.declarePrefix(this.nsCount, string3, bl);
        this.namespaces[this.nsCount++] = string2;
        this.nsCountPerFrame.push(this.nsCountPerFrame.pop() + 1);
        return this.nsCount - 1;
    }

    protected boolean initForkReleaseCounter() {
        return true;
    }

    protected boolean incrementForkReleaseCounter() {
        return true;
    }

    protected boolean decrementForkReleaseCounter() {
        return true;
    }

    private final String dbgGetValue(Chars chars) {
        StringWriter stringWriter = new StringWriter();
        try {
            chars.quote((short)141).writeTo(stringWriter, false);
        }
        catch (Exception exception) {
            return "";
        }
        return stringWriter.toString();
    }

    private final String dbgGetRawName(VolatileCData volatileCData) {
        String string2 = "";
        String string3 = volatileCData.getQNamePrefix(1);
        if (string3 != null && string3.length() > 0) {
            string2 = string3 + ':';
        }
        string2 = string2 + volatileCData.getQNameLocalPart(1);
        return string2;
    }

    public boolean outputParamNeedsFixing(String string2, Object object2) {
        return true;
    }
}

