/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.serialize;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.serialize.SequenceNormalizationCursor;
import com.ibm.xml.xci.dp.util.copy.Copier;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.dp.values.BaseCData;
import com.ibm.xml.xci.dp.values.TypedValueHelper;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.serializer.CopierExtended;
import com.ibm.xml.xci.serializer.SerializeParam;
import com.ibm.xml.xci.type.TypeRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.stream.StreamResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializedCData
extends BaseCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Cursor cursor;
    protected Map<String, Object> parameters;
    private final ItemCopier itemCopier;
    private boolean exprResult;
    public static final Cursor.Profile NEEDED_FEATURES = Cursor.Profile.MINIMAL_STREAMING_NAVIGATION;

    public SerializedCData(Cursor cursor2, Map<String, Object> map2) {
        this(cursor2, map2, null);
    }

    public SerializedCData(Cursor cursor2, Map<String, Object> map2, ItemCopier itemCopier) {
        super(TypeRegistry.XSSTRING);
        this.itemCopier = itemCopier;
        this.cursor = cursor2;
        Cursor.Profile profile = Copier.sourceProfile(this.itemCopier);
        if (!Copier.sourceProfile(this.itemCopier).containedIn(cursor2.profile())) {
            this.cursor = cursor2.factory().proxy(cursor2, profile, false, null, null);
        }
        if (map2 != null) {
            this.parameters = new HashMap<String, Object>(map2);
            Boolean bl = (Boolean)this.parameters.get("{http://ibm.com/xml/xci/serializer}expr-result");
            this.exprResult = bl == null ? false : bl;
            this.parameters.remove("{http://ibm.com/xml/xci/serializer}fast-ser");
            if (this.parameters.isEmpty()) {
                this.parameters = null;
            }
        } else {
            this.parameters = null;
        }
        if (!this.exprResult && this.itemCopier == null) {
            this.cursor = new SequenceNormalizationCursor(cursor2);
        }
    }

    @Override
    public void writeEncodedBytesTo(OutputStream outputStream, Charset charset, boolean bl) throws IOException {
        this.writeEncodedBytesTo(outputStream, charset.name(), (short)0, bl);
    }

    @Override
    public void writeEncodedBytesTo(OutputStream outputStream, String string2, short s, boolean bl) throws IOException {
        Cursor cursor2;
        if (this.exprResult) {
            this.exprWriteEncodedBytesTo(outputStream, string2, s, bl);
            return;
        }
        Cursor.Profile profile = Copier.sourceProfile(this.itemCopier);
        Cursor cursor3 = cursor2 = bl ? this.cursor : this.cursor.fork(false, profile, profile);
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        int n2 = 17;
        n2 = this.parameters.get("{http://ibm.com/xml/xci/serializer}data-format") == SerializeParam.DataFormatOptions.STANDARD ? (n2 |= 0x40) : (n2 |= 0x20);
        Boolean bl2 = (Boolean)this.parameters.get("discard-default-attr");
        if (bl2 != null && bl2 == Boolean.TRUE) {
            n2 |= 8;
        }
        if (string2 != null && this.parameters.get("encoding") == null) {
            this.parameters.put("encoding", string2);
        }
        CopierExtended.serialize(cursor2, new StreamResult(outputStream), this.parameters, Cursor.Area.FIRST_CHILD, n2, this.itemCopier);
    }

    @Override
    public int writeTo(Writer writer, boolean bl) throws IOException {
        return this.appendQuotedTo(writer, (short)0, bl);
    }

    @Override
    public CData constant(boolean bl) {
        try {
            StringWriter stringWriter = new StringWriter();
            this.appendQuotedTo(stringWriter, (short)0, bl);
            return new StringCData(stringWriter.toString(), this.xstype);
        }
        catch (IOException iOException) {
            throw new XCIDynamicErrorException(iOException);
        }
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.appendQuotedTo(stringWriter, (short)0, false);
        }
        catch (IOException iOException) {
            throw new XCIDynamicErrorException(iOException);
        }
        return stringWriter.toString();
    }

    @Override
    public String getString(int n2) {
        return this.toString();
    }

    private void exprWriteEncodedBytesTo(OutputStream outputStream, String string2, short s, boolean bl) throws IOException {
        int n2;
        VolatileCData volatileCData;
        Cursor cursor2;
        Cursor cursor3 = cursor2 = bl ? this.cursor : this.cursor.fork(false, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION);
        if (cursor2.itemIsAtomic()) {
            volatileCData = cursor2.itemTypedValue();
            TypedValueHelper.parseAtom(volatileCData.getString(1), TypeRegistry.XSSTRING, null, false).writeEncodedBytesTo(outputStream, string2, s, bl);
            for (n2 = 1; n2 < volatileCData.getSize(); ++n2) {
                this.writeEncodedSpace(outputStream, string2);
                TypedValueHelper.parseAtom(volatileCData.getString(n2 + 1), TypeRegistry.XSSTRING, null, false).writeEncodedBytesTo(outputStream, string2, s, bl);
            }
        } else {
            cursor2.itemStringValue().writeEncodedBytesTo(outputStream, string2, s, bl);
        }
        while (cursor2.toNext()) {
            this.writeEncodedSpace(outputStream, string2);
            if (cursor2.itemIsAtomic()) {
                volatileCData = cursor2.itemTypedValue();
                TypedValueHelper.parseAtom(volatileCData.getString(1), TypeRegistry.XSSTRING, null, false).writeEncodedBytesTo(outputStream, string2, s, bl);
                for (n2 = 1; n2 < volatileCData.getSize(); ++n2) {
                    this.writeEncodedSpace(outputStream, string2);
                    TypedValueHelper.parseAtom(volatileCData.getString(n2 + 1), TypeRegistry.XSSTRING, null, false).writeEncodedBytesTo(outputStream, string2, s, bl);
                }
                continue;
            }
            cursor2.itemStringValue().writeEncodedBytesTo(outputStream, string2, s, bl);
        }
        cursor2.release();
    }

    private void writeEncodedSpace(OutputStream outputStream, String string2) throws IOException {
        if (string2 == null) {
            outputStream.write(" ".getBytes());
        } else {
            outputStream.write(" ".getBytes(string2));
        }
    }

    @Override
    public int appendQuotedTo(Appendable appendable, short s, boolean bl) throws IOException {
        if (this.exprResult) {
            VolatileCData volatileCData;
            Cursor cursor2;
            Cursor cursor3 = cursor2 = bl ? this.cursor : this.cursor.fork(false, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION, Cursor.Profile.MINIMAL_STREAMING_NAVIGATION);
            if (cursor2.itemIsAtomic()) {
                volatileCData = cursor2.itemTypedValue();
                CData cData = TypedValueHelper.parseAtom(volatileCData.getString(1), TypeRegistry.XSSTRING, null, false);
                Chars chars = cData.quote(s);
                appendable.append(chars);
                for (int i = 1; i < volatileCData.getSize(); ++i) {
                    appendable.append(" ");
                    appendable.append(TypedValueHelper.parseAtom(volatileCData.getString(i + 1), TypeRegistry.XSSTRING, null, false).quote(s));
                }
            } else {
                appendable.append(cursor2.itemStringValue().quote(s));
            }
            while (cursor2.toNext()) {
                appendable.append(" ");
                if (cursor2.itemIsAtomic()) {
                    volatileCData = cursor2.itemTypedValue();
                    appendable.append(TypedValueHelper.parseAtom(volatileCData.getString(1), TypeRegistry.XSSTRING, null, false).quote(s));
                    for (int i = 1; i < volatileCData.getSize(); ++i) {
                        appendable.append(" ");
                        appendable.append(TypedValueHelper.parseAtom(volatileCData.getString(i + 1), TypeRegistry.XSSTRING, null, false).quote(s));
                    }
                    continue;
                }
                appendable.append(cursor2.itemStringValue().quote(s));
            }
            cursor2.release();
        } else {
            Cursor cursor4;
            Writer writer = appendable instanceof Writer ? (Writer)appendable : new AppendableWriter(appendable);
            Cursor.Profile profile = Copier.sourceProfile(this.itemCopier);
            Cursor cursor5 = cursor4 = bl ? this.cursor : this.cursor.fork(false, profile, profile);
            if (this.parameters == null) {
                this.parameters = new HashMap<String, Object>();
            }
            CopierExtended.serialize(cursor4, new StreamResult(writer), this.parameters, Cursor.Area.FIRST_CHILD, 49, this.itemCopier);
        }
        return appendable.toString().length();
    }

    static final class MutableCharSequence
    implements CharSequence {
        private char[] cbuf;
        private int off;
        private int len;

        public MutableCharSequence(char[] cArray, int n2, int n3) {
            this.setValue(cArray, n2, n3);
        }

        public void setValue(char[] cArray, int n2, int n3) {
            this.cbuf = cArray;
            this.off = n2;
            this.len = n3;
        }

        public char charAt(int n2) {
            return this.cbuf[this.off + n2];
        }

        public int length() {
            return this.len;
        }

        public CharSequence subSequence(int n2, int n3) {
            return new MutableCharSequence(this.cbuf, this.off + n2, n3 - n2);
        }

        public String toString() {
            return new String(this.cbuf, this.off, this.len);
        }
    }

    static final class AppendableWriter
    extends Writer {
        private final Appendable appender;
        private MutableCharSequence sequence;

        public AppendableWriter(Appendable appendable) {
            this.appender = appendable;
        }

        public void write(int n2) throws IOException {
            this.appender.append((char)n2);
        }

        public void write(char[] cArray, int n2, int n3) throws IOException {
            if (this.sequence == null) {
                this.sequence = new MutableCharSequence(cArray, n2, n3);
            } else {
                this.sequence.setValue(cArray, n2, n3);
            }
            this.appender.append(this.sequence);
        }

        public void write(String string2) throws IOException {
            this.appender.append(string2);
        }

        public void write(String string2, int n2, int n3) throws IOException {
            this.appender.append(string2, n2, n3);
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }
    }
}

