/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.serialize;

import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.serialize.AbstractSerializeCursor;
import com.ibm.xml.xci.dp.values.chars.Chars;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utf8OutputStreamCursor
extends AbstractSerializeCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final byte OPEN = 60;
    private static final byte CLOSE = 62;
    private static final byte P = 112;
    private static final byte SPACE = 32;
    private static final byte QUOTE = 34;
    private static final byte COLON = 58;
    private static final byte[] XMLNS;
    private static final byte[] XMLNS_EQUAL_QUOTE;
    private static final byte[] EQUAL_QUOTE;
    private static final byte[] CLOSE_OPEN;
    private static final byte[] SLASH_BRACKET;
    private static final byte[] OPEN_EMPTY;
    static final byte[][] PREFIXES;
    protected final OutputStream output;
    protected final Map<String, byte[]> string2bytes = new HashMap<String, byte[]>();
    protected byte[][] prefixes;

    public Utf8OutputStreamCursor(CursorFactory cursorFactory, OutputStream outputStream, Map<String, Object> map2) {
        super(cursorFactory, map2);
        this.output = outputStream;
        this.prefixes = new byte[128][];
    }

    private final void writeWithCaching(String string2) throws IOException {
        byte[] byArray = this.string2bytes.get(string2);
        if (byArray == null) {
            byArray = string2.getBytes(Chars.UTF8.name());
            this.string2bytes.put(string2, byArray);
        }
        this.output.write(byArray);
    }

    @Override
    protected void declarePrefix(int n2, String string2, boolean bl) {
        if (string2 == null || "".equals(string2)) {
            if (this.nsCount > PREFIXES.length) {
                char[] cArray = Integer.toString(this.nsCount).toCharArray();
                this.prefixes[this.nsCount] = new byte[1 + cArray.length];
                this.prefixes[this.nsCount][0] = 112;
                System.arraycopy(cArray, 0, this.prefixes[this.nsCount], 1, cArray.length);
            } else {
                this.prefixes[this.nsCount] = PREFIXES[this.nsCount];
            }
        } else {
            try {
                this.prefixes[this.nsCount] = string2.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
    }

    @Override
    protected void writeAttribute(boolean bl, VolatileCData volatileCData, VolatileCData volatileCData2) throws IOException {
        if (bl) {
            this.output.write(32);
        }
        this.writeQName(volatileCData);
        this.output.write(EQUAL_QUOTE);
        if (Utf8OutputStreamCursor.isQNameType(volatileCData2)) {
            this.writeQName(volatileCData2);
        } else {
            volatileCData2.constant(true).quote((short)141).writeEncodedBytesTo(this.output, Chars.UTF8, false);
        }
        this.output.write(34);
    }

    @Override
    protected void writeAttribute(boolean bl, VolatileCData volatileCData, Chars chars) throws IOException {
        if (bl) {
            this.output.write(32);
        }
        this.writeQName(volatileCData);
        this.output.write(EQUAL_QUOTE);
        chars.constant(true).quote((short)141).writeEncodedBytesTo(this.output, Chars.UTF8, false);
        this.output.write(34);
    }

    @Override
    protected void writeAttrNSDecl(int n2) throws IOException {
        this.output.write(XMLNS);
        this.output.write(this.prefixes[n2]);
        this.output.write(EQUAL_QUOTE);
        this.writeWithCaching(this.namespaces[n2]);
        this.output.write(34);
    }

    @Override
    protected void writeBracketClosingTag(VolatileCData volatileCData) throws IOException {
        this.output.write(CLOSE_OPEN);
        this.writeQName(volatileCData);
        this.output.write(62);
    }

    @Override
    protected void writeClosingBracket() throws IOException {
        this.output.write(62);
    }

    @Override
    protected void writeClosingTag(VolatileCData volatileCData) throws IOException {
        this.output.write(OPEN_EMPTY);
        this.writeQName(volatileCData);
        this.output.write(62);
    }

    @Override
    protected void writeComment(VolatileCData volatileCData) throws IOException {
        this.writeWithCaching("<!--");
        volatileCData.quote((short)0).writeEncodedBytesTo(this.output, Chars.UTF8, false);
        this.writeWithCaching("-->");
    }

    @Override
    protected void writeOpenTag(VolatileCData volatileCData) throws IOException {
        this.output.write(60);
        this.writeQName(volatileCData);
    }

    @Override
    protected void writePI(VolatileCData volatileCData, VolatileCData volatileCData2) throws IOException {
        this.writeWithCaching("<?");
        this.writeQName(volatileCData);
        this.writeWithCaching(" ");
        volatileCData2.quote((short)0).writeEncodedBytesTo(this.output, Chars.UTF8, false);
        this.writeWithCaching("?>");
    }

    @Override
    protected void writeQName(VolatileCData volatileCData) throws IOException {
        int n2 = this.toHandle(volatileCData.getQNameNamespaceURI(1));
        if (n2 != 0) {
            this.output.write(this.prefixes[n2]);
            this.output.write(58);
        }
        this.writeWithCaching(volatileCData.getQNameLocalPart(1));
    }

    @Override
    protected void writeSlashBracket() throws IOException {
        this.output.write(SLASH_BRACKET);
    }

    @Override
    protected void writeValue(VolatileCData volatileCData) throws IOException {
        volatileCData.quote((short)33).writeEncodedBytesTo(this.output, Chars.UTF8, false);
    }

    @Override
    protected void writeValue(Chars chars) throws IOException {
        chars.quote((short)33).writeEncodedBytesTo(this.output, Chars.UTF8, false);
    }

    @Override
    protected void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.output.write(byArray, n2, n3);
    }

    @Override
    public void closeMutation() {
        try {
            this.output.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public VolatileCData itemValue() {
        return null;
    }

    static {
        byte[] byArray;
        int n2;
        XMLNS = new byte[]{32, 120, 109, 108, 110, 115, 58};
        XMLNS_EQUAL_QUOTE = new byte[]{32, 120, 109, 108, 110, 115, 61, 34};
        EQUAL_QUOTE = new byte[]{61, 34};
        CLOSE_OPEN = new byte[]{62, 60, 47};
        SLASH_BRACKET = new byte[]{47, 62};
        OPEN_EMPTY = new byte[]{60, 47};
        PREFIXES = new byte[99][3];
        for (n2 = 0; n2 < 9; ++n2) {
            byArray = new byte[]{112, 48, (byte)(n2 + 49)};
            Utf8OutputStreamCursor.PREFIXES[n2] = byArray;
        }
        for (n2 = 10; n2 < 99; ++n2) {
            byArray = new byte[]{112, (byte)((n2 >> 8) + 49), (byte)(n2 + 49)};
            Utf8OutputStreamCursor.PREFIXES[n2] = byArray;
        }
    }
}

