/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.serialize;

import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.serialize.AbstractSerializeCursor;
import com.ibm.xml.xci.dp.values.chars.Chars;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class WriterCursor
extends AbstractSerializeCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final char[] XMLNS_PREFIX;
    protected static final char[] XMLNS;
    protected static final char[] CLOSE_OPEN;
    protected static final char[] SLASH_BRACKET;
    static final char[][] PREFIXES;
    protected final Writer writer;
    protected char[][] prefixes;

    public WriterCursor(CursorFactory cursorFactory, Writer writer, Map map2) {
        super(cursorFactory, map2);
        this.writer = writer;
        this.prefixes = new char[128][];
    }

    protected final void writeQName(VolatileCData volatileCData) throws IOException {
        int n2 = this.toHandle(volatileCData.getQNameNamespaceURI(1));
        if (n2 != 0 && XMLNS_PREFIX != this.prefixes[n2]) {
            this.writer.write(this.prefixes[n2]);
            this.writer.write(58);
        }
        this.writer.write(volatileCData.getQNameLocalPart(1));
    }

    protected final void writeAttrNSDecl(int n2) throws IOException {
        this.writer.write(XMLNS);
        if (XMLNS_PREFIX != this.prefixes[n2]) {
            this.writer.write(58);
            this.writer.write(this.prefixes[n2]);
        }
        this.writer.write(61);
        this.writer.write(34);
        this.writer.write(this.namespaces[n2]);
        this.writer.write(34);
    }

    protected void declarePrefix(int n2, String string2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = string2 == null || string2.length() == 0;
        if (bl && bl2) {
            if (this.nsCount > PREFIXES.length) {
                char[] cArray = Integer.toString(this.nsCount).toCharArray();
                this.prefixes[this.nsCount] = new char[1 + cArray.length];
                this.prefixes[this.nsCount][0] = 112;
                System.arraycopy(cArray, 0, this.prefixes[this.nsCount], 1, cArray.length);
            } else {
                this.prefixes[this.nsCount] = PREFIXES[this.nsCount];
            }
        } else {
            this.prefixes[this.nsCount] = bl2 ? XMLNS_PREFIX : string2.toCharArray();
        }
    }

    protected void writeAttribute(boolean bl, VolatileCData volatileCData, VolatileCData volatileCData2) throws IOException {
        if (bl) {
            this.writer.write(32);
        }
        this.writeQName(volatileCData);
        this.writer.write(61);
        this.writer.write(34);
        if (WriterCursor.isQNameType(volatileCData2)) {
            this.writeQName(volatileCData2);
        } else {
            volatileCData2.quote((short)141).writeTo(this.writer, false);
        }
        this.writer.write(34);
    }

    protected void writeAttribute(boolean bl, VolatileCData volatileCData, Chars chars) throws IOException {
        if (bl) {
            this.writer.write(32);
        }
        this.writeQName(volatileCData);
        this.writer.write(61);
        this.writer.write(34);
        chars.quote((short)141).writeTo(this.writer, false);
        this.writer.write(34);
    }

    protected void writeBracketClosingTag(VolatileCData volatileCData) throws IOException {
        this.writer.write(CLOSE_OPEN);
        this.writeQName(volatileCData);
        this.writer.write(62);
    }

    protected void writeClosingBracket() throws IOException {
        this.writer.write(62);
    }

    protected void writeClosingTag(VolatileCData volatileCData) throws IOException {
        this.writer.write("</");
        this.writeQName(volatileCData);
        this.writer.write(62);
    }

    protected void writeComment(VolatileCData volatileCData) throws IOException {
        this.writer.write("<!--");
        volatileCData.quote((short)0).writeTo(this.writer, false);
        this.writer.write("-->");
    }

    protected void writeOpenTag(VolatileCData volatileCData) throws IOException {
        this.writer.write(60);
        this.writeQName(volatileCData);
    }

    protected void writePI(VolatileCData volatileCData, VolatileCData volatileCData2) throws IOException {
        this.writer.write("<?");
        this.writeQName(volatileCData);
        this.writer.write(" ");
        volatileCData2.quote((short)0).writeTo(this.writer, false);
        this.writer.write("?>");
    }

    protected void writeSlashBracket() throws IOException {
        this.writer.write(SLASH_BRACKET);
    }

    protected void writeValue(VolatileCData volatileCData) throws IOException {
        volatileCData.quote((short)33).writeTo(this.writer, false);
    }

    protected void writeValue(Chars chars) throws IOException {
        chars.quote((short)33).writeTo(this.writer, false);
    }

    protected void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.writer.write(new String(byArray, n2, n3));
    }

    public void closeMutation() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public VolatileCData itemValue() {
        return null;
    }

    static {
        char[] cArray;
        int n2;
        XMLNS_PREFIX = "".toCharArray();
        XMLNS = " xmlns".toCharArray();
        CLOSE_OPEN = "></".toCharArray();
        SLASH_BRACKET = "/>".toCharArray();
        PREFIXES = new char[99][3];
        for (n2 = 0; n2 < 9; ++n2) {
            cArray = new char[]{'p', '0', (char)(n2 + 49)};
            WriterCursor.PREFIXES[n2] = cArray;
        }
        for (n2 = 10; n2 < 99; ++n2) {
            cArray = new char[]{'p', (char)((n2 >> 8) + 49), (char)(n2 + 49)};
            WriterCursor.PREFIXES[n2] = cArray;
        }
    }
}

