/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.type;

import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.cast.CastJV2Double;
import com.ibm.xml.xci.internal.cast.CastJV2Float;
import com.ibm.xml.xci.internal.cast.CastJV2String;
import com.ibm.xml.xci.internal.cast.CastUtilities;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSModelGroup;
import com.ibm.xml.xml4j.api.s1.xs.XSObjectList;
import com.ibm.xml.xml4j.api.s1.xs.XSParticle;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import com.ibm.xml.xml4j.internal.s1.impl.dv.util.Base64;
import com.ibm.xml.xml4j.internal.s1.impl.dv.util.HexBin;
import com.ibm.xml.xml4j.internal.s1.impl.xs.XSComplexTypeDecl;
import com.ibm.xml.xml4j.internal.s1.util.XMLChar;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.w3c.dom.TypeInfo;

public class TypeHelper {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean isOpen(XSComplexTypeDefinition xSComplexTypeDefinition) {
        XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSComplexTypeDefinition;
        if (xSComplexTypeDecl.getAttrGrp() != null && xSComplexTypeDecl.getAttributeWildcard() != null) {
            return true;
        }
        switch (xSComplexTypeDefinition.getContentType()) {
            case 2: 
            case 3: {
                return TypeHelper.isOpen(xSComplexTypeDefinition.getParticle());
            }
        }
        return false;
    }

    private static boolean isOpen(XSParticle xSParticle) {
        switch (xSParticle.getTerm().getType()) {
            case 2: {
                return false;
            }
            case 7: {
                XSModelGroup xSModelGroup = (XSModelGroup)xSParticle.getTerm();
                XSObjectList xSObjectList = xSModelGroup.getParticles();
                for (int i = 0; i < xSObjectList.getLength(); ++i) {
                    if (!TypeHelper.isOpen((XSParticle)xSObjectList.item(i))) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean isAtomic(XSTypeDefinition xSTypeDefinition) {
        return xSTypeDefinition.getTypeCategory() == 16 && ((XSSimpleTypeDefinition)xSTypeDefinition).getVariety() == 1;
    }

    public static boolean isAtomic(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return xSSimpleTypeDefinition.getVariety() == 1;
    }

    public static boolean isList(XSTypeDefinition xSTypeDefinition) {
        XSSimpleTypeDefinition xSSimpleTypeDefinition = TypeHelper.getSimpleType(xSTypeDefinition);
        return xSSimpleTypeDefinition == null ? false : TypeHelper.isList(xSSimpleTypeDefinition);
    }

    public static boolean isList(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return xSSimpleTypeDefinition.getVariety() == 2;
    }

    public static boolean isSimple(XSTypeDefinition xSTypeDefinition) {
        if (xSTypeDefinition == null) {
            return false;
        }
        if (xSTypeDefinition.getTypeCategory() == 16) {
            return true;
        }
        return ((XSComplexTypeDefinition)xSTypeDefinition).getContentType() == 1;
    }

    public static XSSimpleTypeDefinition getSimpleType(XSTypeDefinition xSTypeDefinition) {
        if (xSTypeDefinition == null) {
            return null;
        }
        if (xSTypeDefinition.getTypeCategory() == 16) {
            return (XSSimpleTypeDefinition)xSTypeDefinition;
        }
        if (xSTypeDefinition.getTypeCategory() == 15 && ((XSComplexTypeDefinition)xSTypeDefinition).getContentType() == 1) {
            return ((XSComplexTypeDefinition)xSTypeDefinition).getSimpleType();
        }
        return null;
    }

    public static boolean isSimple(XSComplexTypeDefinition xSComplexTypeDefinition) {
        return xSComplexTypeDefinition.getContentType() == 1;
    }

    public static boolean isMixed(XSTypeDefinition xSTypeDefinition) {
        if (xSTypeDefinition.getTypeCategory() == 16) {
            return false;
        }
        return ((XSComplexTypeDefinition)xSTypeDefinition).getContentType() == 3;
    }

    public static boolean isEqual(XSSimpleTypeDefinition xSSimpleTypeDefinition, XSSimpleTypeDefinition xSSimpleTypeDefinition2) {
        if (xSSimpleTypeDefinition == null || xSSimpleTypeDefinition2 == null) {
            return false;
        }
        boolean bl = xSSimpleTypeDefinition2.getAnonymous();
        if (!xSSimpleTypeDefinition.getAnonymous()) {
            return !bl && xSSimpleTypeDefinition.getName() == xSSimpleTypeDefinition2.getName() && xSSimpleTypeDefinition.getNamespace() == xSSimpleTypeDefinition2.getNamespace();
        }
        if (bl) {
            TypeInfo typeInfo = (TypeInfo)((Object)xSSimpleTypeDefinition);
            TypeInfo typeInfo2 = (TypeInfo)((Object)xSSimpleTypeDefinition2);
            if (typeInfo.getTypeName().equals(typeInfo2.getTypeName())) {
                String string2 = typeInfo.getTypeNamespace();
                String string3 = typeInfo2.getTypeNamespace();
                if (string2 != null) {
                    return string3 != null && string2.equals(string3);
                }
                return string3 == null;
            }
        }
        return false;
    }

    public static boolean isEqualToBuiltInType(XSSimpleTypeDefinition xSSimpleTypeDefinition, XSSimpleTypeDefinition xSSimpleTypeDefinition2) {
        assert (xSSimpleTypeDefinition2 != null);
        if (xSSimpleTypeDefinition == xSSimpleTypeDefinition2) {
            return true;
        }
        if (xSSimpleTypeDefinition == null) {
            return false;
        }
        if (xSSimpleTypeDefinition.getAnonymous()) {
            return false;
        }
        return xSSimpleTypeDefinition.getName() == xSSimpleTypeDefinition2.getName() && xSSimpleTypeDefinition.getNamespace() == xSSimpleTypeDefinition2.getNamespace();
    }

    public static String prettyPrint(XSTypeDefinition xSTypeDefinition) {
        assert (xSTypeDefinition != null);
        boolean bl = xSTypeDefinition.getAnonymous();
        String string2 = !bl ? xSTypeDefinition.getName() : ((TypeInfo)((Object)xSTypeDefinition)).getTypeName();
        String string3 = !bl ? xSTypeDefinition.getNamespace() : ((TypeInfo)((Object)xSTypeDefinition)).getTypeNamespace();
        return (string3 != null ? "{" + string3 + "}" : "") + (string2 != null ? string2 : "");
    }

    public static String castToString(BigDecimal bigDecimal) {
        try {
            return CastJV2String.jVToString(bigDecimal, TypeRegistry.XSSTRING, true);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static String castToString(BigInteger bigInteger) {
        try {
            return CastJV2String.jVToString(bigInteger, TypeRegistry.XSSTRING, true);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static String castToString(Boolean bl) {
        try {
            return CastJV2String.jVToString(bl, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static String castToString(Byte by2) {
        try {
            return CastJV2String.jVToString(by2, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static String castToString(Double d) {
        try {
            return CastJV2String.jVToString(d, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static String castToString(Float f2) {
        try {
            return CastJV2String.jVToString(f2.floatValue(), TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static String castToString(Integer n2) {
        try {
            return CastJV2String.jVToString(n2, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static String castToString(Long l) {
        try {
            return CastJV2String.jVToString(l, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static String castToString(QName qName) {
        try {
            return CastJV2String.jVToString(qName, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static String castToString(Duration duration2) {
        try {
            return CastJV2String.jVToString(duration2, TypeRegistry.XSSTRING, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static byte castToByte(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw XCIErrorHelper.createCastValueNotAllowedException();
        }
        if (d >= 128.0 || d <= -129.0) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(d), TypeRegistry.XSBYTE.toString(), null);
        }
        return (byte)d;
    }

    public static byte castToByte(float f2) {
        if (Float.isInfinite(f2) || Float.isNaN(f2)) {
            throw XCIErrorHelper.createCastValueNotAllowedException();
        }
        if (f2 >= 128.0f || f2 <= -129.0f) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(f2), TypeRegistry.XSBYTE.toString(), null);
        }
        return (byte)f2;
    }

    public static double castToDouble(BigDecimal bigDecimal) {
        try {
            return CastJV2Double.jVToDouble(bigDecimal, TypeRegistry.XSDOUBLE, true);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static double castToDouble(BigInteger bigInteger) {
        try {
            return CastJV2Double.jVToDouble(bigInteger, TypeRegistry.XSDOUBLE, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static double castToDouble(byte by2) {
        try {
            return CastJV2Double.jVToDouble(by2, TypeRegistry.XSDOUBLE, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static double castToDouble(int n2) {
        try {
            return CastJV2Double.jVToDouble(n2, TypeRegistry.XSDOUBLE, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static double castToDouble(long l) {
        try {
            return CastJV2Double.jVToDouble(l, TypeRegistry.XSDOUBLE, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static float castToFloat(BigDecimal bigDecimal) {
        try {
            return CastJV2Float.jVToFloat(bigDecimal, TypeRegistry.XSFLOAT, true);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static float castToFloat(BigInteger bigInteger) {
        try {
            return CastJV2Float.jVToFloat(bigInteger, TypeRegistry.XSFLOAT, true);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static float castToFloat(byte by2) {
        try {
            return CastJV2Float.jVToFloat(by2, TypeRegistry.XSFLOAT, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static float castToFloat(int n2) {
        try {
            return CastJV2Float.jVToFloat(n2, TypeRegistry.XSFLOAT, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static float castToFloat(long l) {
        try {
            return CastJV2Float.jVToFloat(l, TypeRegistry.XSFLOAT, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new XCIDynamicErrorException(invalidDatatypeValueException);
        }
    }

    public static int castToInt(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw XCIErrorHelper.createCastValueNotAllowedException();
        }
        if (d >= 2.147483648E9 || d <= -2.147483649E9) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(d), TypeRegistry.XSINT.toString(), null);
        }
        return (int)d;
    }

    public static int castToInt(float f2) {
        if (Float.isInfinite(f2) || Float.isNaN(f2)) {
            throw XCIErrorHelper.createCastValueNotAllowedException();
        }
        if (f2 >= 2.1474836E9f || f2 <= -2.1474836E9f) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(f2), TypeRegistry.XSINT.toString(), null);
        }
        return (int)f2;
    }

    public static long castToLong(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw XCIErrorHelper.createCastValueNotAllowedException();
        }
        if (d >= 9.223372036854776E18 || d <= -9.223372036854776E18) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(d), TypeRegistry.XSLONG.toString(), null);
        }
        return (long)d;
    }

    public static long castToLong(float f2) {
        if (Float.isInfinite(f2) || Float.isNaN(f2)) {
            throw XCIErrorHelper.createCastValueNotAllowedException();
        }
        if (f2 >= 9.223372E18f || f2 <= -9.223372E18f) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(f2), TypeRegistry.XSLONG.toString(), null);
        }
        return (long)f2;
    }

    public static short castToShort(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw XCIErrorHelper.createCastValueNotAllowedException();
        }
        if (d >= 32768.0 || d <= -32769.0) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(d), TypeRegistry.XSSHORT.toString(), null);
        }
        return (short)d;
    }

    public static short castToShort(float f2) {
        if (Float.isInfinite(f2) || Float.isNaN(f2)) {
            throw XCIErrorHelper.createCastValueNotAllowedException();
        }
        if (f2 >= 32768.0f || f2 <= -32769.0f) {
            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(f2), TypeRegistry.XSSHORT.toString(), null);
        }
        return (short)f2;
    }

    public static String validateLanguage(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        try {
            return (String)CastUtilities.validate(string2, TypeRegistry.XSLANGUAGE);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw XCIErrorHelper.createBadTypeValueException(string2, TypeHelper.prettyPrint(xSSimpleTypeDefinition), invalidDatatypeValueException);
        }
    }

    public static String convertToBase64BinaryString(byte[] byArray) {
        return Base64.encode(byArray);
    }

    public static String convertToHexBinaryString(byte[] byArray) {
        return HexBin.encode(byArray);
    }

    public static boolean isValidNmtoken(String string2) {
        return XMLChar.isValidNmtoken(string2);
    }

    public static boolean isValidName(String string2) {
        return XMLChar.isValidName(string2);
    }

    public static boolean isValidNCName(String string2) {
        return XMLChar.isValidNCName(string2);
    }
}

