/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.util.misc.Stack;

public abstract class AbstractStreamingTraversal {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public void traverse(Cursor cursor2) {
        Stack<Cursor> stack = new Stack<Cursor>(500);
        stack.push(cursor2);
        boolean bl = true;
        do {
            cursor2 = (Cursor)stack.peek();
            switch (cursor2.itemKind()) {
                case 1: {
                    this.startElement(cursor2.itemName(), cursor2);
                    Cursor cursor3 = cursor2.fork(true);
                    if (cursor3.toAttributes(null)) {
                        do {
                            this.receiveAttribute(cursor3);
                        } while (cursor3.toNext());
                    }
                    cursor3.release();
                    cursor3 = null;
                    Cursor cursor4 = cursor2.fork(true);
                    if (cursor4.toChildren(null)) {
                        stack.push(cursor4);
                        bl = false;
                        break;
                    }
                    cursor4.release();
                    cursor4 = null;
                    bl = true;
                    break;
                }
                case 9: {
                    this.startDocument();
                    Cursor cursor3 = cursor2.fork(true);
                    if (cursor3.toChildren(null)) {
                        stack.push(cursor3);
                        bl = false;
                        break;
                    }
                    cursor3.release();
                    cursor3 = null;
                    bl = true;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.receiveText(cursor2.itemTypedValue(), cursor2);
                    bl = true;
                    break;
                }
                case 8: {
                    this.receiveComment(cursor2.itemTypedValue(), cursor2);
                    cursor2.itemTypedValue();
                    bl = true;
                    break;
                }
                case 7: {
                    this.receivePI(cursor2.itemName(), cursor2.itemTypedValue(), cursor2);
                    bl = true;
                }
            }
            if (!bl) continue;
            while (!cursor2.toNext()) {
                cursor2.release();
                stack.pop();
                Cursor cursor5 = cursor2 = stack.isEmpty() ? null : (Cursor)stack.peek();
                if (cursor2 != null) {
                    this.endElement();
                }
                if (cursor2 != null) continue;
            }
        } while (!stack.isEmpty());
    }

    protected abstract void startDocument();

    protected abstract void startElement(VolatileCData var1, Cursor var2);

    protected abstract void endElement();

    protected abstract void receiveAttribute(Cursor var1);

    protected abstract void receiveComment(VolatileCData var1, Cursor var2);

    protected abstract void receiveText(VolatileCData var1, Cursor var2);

    protected abstract void receivePI(VolatileCData var1, VolatileCData var2, Cursor var3);
}

