/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.serialize.SerializedCData;
import com.ibm.xml.xci.dp.util.CDataSequence;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDataCursor
extends AbstractCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private CData cdata;
    private int position;

    public CDataCursor(CursorFactory cursorFactory, CData cData) {
        super(cursorFactory);
        assert (cursorFactory != null);
        this.cdata = cData;
        this.position = 1;
    }

    @Override
    public Cursor.Profile profile() {
        return Cursor.Profile.RANDOM_ACCESS;
    }

    @Override
    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public Cursor.Profile futureProfile() {
        return Cursor.Profile.RANDOM_ACCESS;
    }

    @Override
    public VolatileCData itemValue() {
        return this.cdata.itemAt(this.position);
    }

    @Override
    public XSTypeDefinition itemXSType() {
        return this.cdata.itemAt(this.position).getXSTypeDefinition();
    }

    @Override
    public short itemKind() {
        return 3;
    }

    @Override
    public boolean itemIsAtomic() {
        return true;
    }

    @Override
    public long contextPosition() {
        return this.position;
    }

    @Override
    public long contextSize() {
        return this.cdata.getSize();
    }

    @Override
    public boolean contextIsSingleton() {
        return this.contextSize() == 1L;
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        if (bl) {
            return new CDataCursor(this.factory, this.itemTypedValue().constant(false));
        }
        CDataCursor cDataCursor = new CDataCursor(this.factory, this.cdata);
        cDataCursor.position = this.position;
        return cDataCursor;
    }

    @Override
    public boolean toNext() {
        return this.toPosition(this.position + 1);
    }

    @Override
    public boolean toPrevious() {
        return this.toPosition(this.position - 1);
    }

    @Override
    public boolean toPosition(long l) {
        assert (l <= Integer.MAX_VALUE);
        if (1L <= l && l <= (long)this.cdata.getSize()) {
            this.position = (int)l;
            return true;
        }
        return false;
    }

    @Override
    public boolean toSelf() {
        if (this.cdata.getSize() > 1) {
            this.cdata = this.cdata.itemAt(this.position);
            this.position = 1;
        }
        return true;
    }

    @Override
    public boolean toAttributes(NodeTest nodeTest) {
        return false;
    }

    @Override
    public boolean toChildren(NodeTest nodeTest) {
        return false;
    }

    @Override
    public boolean toParent() {
        return false;
    }

    @Override
    public boolean toRoot() {
        return false;
    }

    @Override
    public boolean itemIsSameNode(Cursor cursor2) {
        return false;
    }

    @Override
    public boolean itemIsBeforeNode(Cursor cursor2) {
        return false;
    }

    public String toString() {
        return this.cdata.toString();
    }

    @Override
    public VolatileCData serialize(Map<String, Object> map2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (map2 != null) {
            hashMap.putAll(map2);
        }
        hashMap.put("{http://ibm.com/xml/xci/serializer}expr-result", Boolean.TRUE);
        return new SerializedCData(this, hashMap);
    }

    @Override
    public Cursor sequenceConcat(Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        CDataSequence cDataSequence = bl ? new CDataSequence(this.factory, this.itemValue().constant(false)) : new CDataSequence(this.factory, this.cdata);
        Cursor cursor3 = cDataSequence.sequenceConcat(cursor2, profile, profile2, bl, bl2, bl3, bl4);
        if (bl3) {
            this.release();
        }
        return cursor3;
    }

    @Override
    public boolean contextIsAtomsOnly() {
        return true;
    }

    @Override
    public boolean contextIsNodesOnly() {
        return false;
    }

    @Override
    public void release() {
        assert (this.makeInvalid());
        super.release();
    }

    private boolean makeInvalid() {
        this.position = -1;
        this.cdata = null;
        return true;
    }

    @Override
    protected Chars itemSValue() {
        return new StringChars(this.cdata.getString(this.position));
    }

    @Override
    public VolatileCData itemName() {
        return this.factory.data(TypeRegistry.XSQNAME);
    }
}

