/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.serialize.SerializedCData;
import com.ibm.xml.xci.dp.util.CDataCursor;
import com.ibm.xml.xci.dp.values.AbstractCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.internal.values.CDataList;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDataSequence
extends AbstractCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private CDataList list;
    private int position;
    boolean isSharedFork;

    public CDataSequence(CursorFactory cursorFactory, CData cData) {
        super(cursorFactory);
        this.list = new CDataList(cData);
        this.isSharedFork = false;
        this.position = 1;
    }

    public CDataSequence(CDataSequence cDataSequence) {
        super(cDataSequence.factory);
        this.list = cDataSequence.list;
        this.position = cDataSequence.position;
        this.isSharedFork = true;
    }

    @Override
    public Cursor.Profile profile() {
        return Cursor.Profile.RANDOM_ACCESS;
    }

    @Override
    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public Cursor.Profile futureProfile() {
        return Cursor.Profile.RANDOM_ACCESS;
    }

    @Override
    public VolatileCData itemValue() {
        return this.list.itemAt(this.position);
    }

    @Override
    public XSTypeDefinition itemXSType() {
        return this.list.itemAt(this.position).getXSTypeDefinition();
    }

    @Override
    public short itemKind() {
        return 3;
    }

    @Override
    public boolean itemIsAtomic() {
        return true;
    }

    @Override
    public long contextPosition() {
        return this.position;
    }

    @Override
    public long contextSize() {
        return this.list.getSize();
    }

    @Override
    public boolean contextIsSingleton() {
        return this.contextSize() == 1L;
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        if (bl) {
            return this.itemTypedValue().constant(false).toCursor();
        }
        CDataSequence cDataSequence = new CDataSequence(this);
        return cDataSequence;
    }

    @Override
    public void release() {
    }

    private final boolean trashStuff() {
        this.list = null;
        return true;
    }

    @Override
    public boolean toNext() {
        return this.toPosition(this.position + 1);
    }

    @Override
    public boolean toPrevious() {
        return this.toPosition(this.position - 1);
    }

    @Override
    public boolean toPosition(long l) {
        assert (l <= Integer.MAX_VALUE);
        if (1L <= l && l <= (long)this.list.getSize()) {
            this.position = (int)l;
            return true;
        }
        return false;
    }

    @Override
    public boolean toSelf() {
        if (this.list.getSize() > 1) {
            CData cData = this.list.itemAt(this.position);
            this.list = new CDataList(cData, cData.getXSTypeDefinition());
            this.position = 1;
        }
        return true;
    }

    @Override
    public boolean toAttributes(NodeTest nodeTest) {
        return false;
    }

    @Override
    public boolean toChildren(NodeTest nodeTest) {
        return false;
    }

    @Override
    public boolean toParent() {
        return false;
    }

    @Override
    public boolean toRoot() {
        return false;
    }

    @Override
    public boolean itemIsSameNode(Cursor cursor2) {
        return false;
    }

    @Override
    public boolean itemIsBeforeNode(Cursor cursor2) {
        return false;
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public VolatileCData serialize(Map<String, Object> map2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (map2 != null) {
            hashMap.putAll(map2);
        }
        hashMap.put("{http://ibm.com/xml/xci/serializer}expr-result", Boolean.TRUE);
        return new SerializedCData(this, map2);
    }

    @Override
    public Cursor sequenceConcat(Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5;
        if (cursor2 == null) {
            return CDataSequence.ownTheCursor(this, bl, bl3);
        }
        Cursor cursor3 = cursor2.unwrap();
        boolean bl6 = cursor2 instanceof CDataSequence;
        boolean bl7 = bl5 = cursor3 instanceof CDataCursor || cursor3 instanceof CDataSequence || cursor3 instanceof AbstractCData && cursor3.contextIsSingleton();
        if (bl6) {
            CDataSequence cDataSequence = (CDataSequence)CDataSequence.ownTheCursor(this, bl, bl3);
            cDataSequence.ensureNotShared(bl3);
            CDataSequence cDataSequence2 = (CDataSequence)cursor2;
            if (bl2) {
                cDataSequence.list.add(cDataSequence2.list.get(cDataSequence2.position - 1));
            } else {
                cDataSequence.list.addAll(cDataSequence2.list);
            }
            if (bl4) {
                cursor2.release();
            }
            return cDataSequence;
        }
        if (bl5) {
            CDataSequence cDataSequence = (CDataSequence)CDataSequence.ownTheCursor(this, bl, bl3);
            cDataSequence.ensureNotShared(bl3);
            Cursor cursor4 = CDataSequence.ownTheCursorIfMightMove(cursor2, bl2, bl4);
            if (bl2) {
                cDataSequence.list.add(cursor4.itemTypedValue());
            } else {
                do {
                    cDataSequence.list.add(cursor4.itemTypedValue());
                } while (cursor4.toNext());
            }
            CDataSequence.ownedCleanupIfMightMove(cursor4, bl2, true);
            return cDataSequence;
        }
        Cursor cursor5 = AbstractCursor.defaultSequenceConcatSingletonList(this, cursor2, profile, profile2, bl, bl2, bl3, bl4);
        return cursor5;
    }

    private void ensureNotShared(boolean bl) {
        if (bl && this.isSharedFork) {
            this.list = new CDataList(this.list, true);
            this.isSharedFork = false;
        }
    }

    @Override
    public boolean contextIsAtomsOnly() {
        return true;
    }

    @Override
    public boolean contextIsNodesOnly() {
        return false;
    }

    @Override
    protected Chars itemSValue() {
        return new StringChars(this.list.getString(this.position));
    }

    @Override
    public boolean itemIsSameDocument(Cursor cursor2) {
        return false;
    }
}

