/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;
import com.ibm.xml.xci.dp.serialize.SerializedCData;
import com.ibm.xml.xci.internal.util.SortHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Concatenate2Cursor
extends AbstractDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Cursor left;
    protected Cursor right;
    boolean inLeft = true;
    private boolean tempOverrideContextSize = false;
    Cursor.Profile features;
    static final Cursor.Profile CONCATENATED2SEQUENCEFEATURES = Cursor.Profile.SEQUENCE;
    static final Cursor.Profile TOPOSITIONSIZEFEATURES = Cursor.Profile.POSITION.union(Cursor.Profile.SIZE);

    @Override
    public VolatileCData serialize(Map<String, Object> map2) {
        return new SerializedCData(this, map2);
    }

    public Concatenate2Cursor(Cursor cursor2, Cursor cursor3) {
        this(cursor2, cursor3, true, cursor2.profile().intersect(cursor3.profile()).union(CONCATENATED2SEQUENCEFEATURES));
    }

    public Concatenate2Cursor(Cursor cursor2, Cursor cursor3, boolean bl, Cursor.Profile profile) {
        this.left = cursor2;
        this.right = cursor3;
        this.inLeft = bl;
        this.features = profile.union(CONCATENATED2SEQUENCEFEATURES);
    }

    @Override
    public Cursor getDelegate() {
        return this.inLeft ? this.left : this.right;
    }

    private final void forget() {
        if (this.getDelegate() != this.left) {
            if (this.left != null) {
                this.left.release();
            }
            this.left = null;
        }
        if (this.getDelegate() != this.right) {
            if (this.right != null) {
                this.right.release();
            }
            this.right = null;
        }
    }

    @Override
    public Cursor.Profile profile() {
        return this.features;
    }

    @Override
    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public Cursor.Profile futureProfile() {
        if (this.left == null || this.right == null) {
            return super.futureProfile();
        }
        return this.left.futureProfile().intersect(this.right.futureProfile());
    }

    @Override
    public void release() {
        if (this.left != null) {
            this.left.release();
            this.left = null;
        }
        if (this.right != null) {
            this.right.release();
            this.right = null;
        }
        super.release();
    }

    @Override
    public boolean toSelf() {
        super.toSelf();
        this.forget();
        return true;
    }

    @Override
    public boolean toAttributes(NodeTest nodeTest) {
        boolean bl = super.toAttributes(nodeTest);
        if (bl) {
            this.forget();
        }
        return bl;
    }

    @Override
    public boolean toChildren(NodeTest nodeTest) {
        boolean bl = super.toChildren(nodeTest);
        if (bl) {
            this.forget();
        }
        return bl;
    }

    @Override
    public boolean toParent() {
        boolean bl = super.toParent();
        if (bl) {
            this.forget();
        }
        return bl;
    }

    @Override
    public boolean toRoot() {
        boolean bl = super.toRoot();
        if (bl) {
            this.forget();
        }
        return bl;
    }

    @Override
    public boolean toIds(VolatileCData volatileCData) {
        boolean bl = super.toIds(volatileCData);
        if (bl) {
            this.forget();
        }
        return bl;
    }

    @Override
    public long contextPosition() {
        if (this.left == null || this.right == null) {
            return super.contextPosition();
        }
        assert (Cursor.Profile.POSITION.containedIn(this.left.profile())) : "Left cursor needs to override contextPosition()!";
        assert (Cursor.Profile.SIZE.containedIn(this.left.profile())) : "Left cursor needs to override contextSize()!";
        assert (Cursor.Profile.SIZE.containedIn(this.right.profile())) : "Right cursor needs to override contextPosition()!";
        return this.inLeft ? this.left.contextPosition() : this.left.contextSize() + this.right.contextPosition();
    }

    @Override
    public long contextSize() {
        if (this.tempOverrideContextSize) {
            return 0L;
        }
        if (this.left == null || this.right == null) {
            return super.contextSize();
        }
        return this.left.contextSize() + this.right.contextSize();
    }

    public int size() {
        return (int)this.contextSize();
    }

    @Override
    public boolean contextIsSingleton() {
        if (this.left == null || this.right == null) {
            return super.contextIsSingleton();
        }
        return false;
    }

    @Override
    public boolean contextIsLive() {
        if (this.left == null || this.right == null) {
            return super.contextIsLive();
        }
        return this.left.contextIsLive() && this.right.contextIsLive();
    }

    @Override
    public boolean toNext() {
        if (super.toNext()) {
            return true;
        }
        if (this.inLeft && this.right != null) {
            this.inLeft = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean toPrevious() {
        if (super.toPrevious()) {
            return true;
        }
        if (!this.inLeft && this.left != null) {
            this.inLeft = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean toPosition(long l) {
        assert (l > 0L);
        if (l <= 0L) {
            return false;
        }
        this.tempOverrideContextSize = true;
        long l2 = this.left.contextSize();
        this.tempOverrideContextSize = false;
        if (l <= l2) {
            boolean bl = this.left.toPosition(l);
            assert (bl);
            if (bl && !this.inLeft) {
                this.inLeft = true;
                if (null != this.right) {
                    assert (Cursor.Profile.TO_POSITION.containedIn(this.right.profile()));
                    this.right.toPosition(1L);
                }
            }
            return bl;
        }
        boolean bl = this.right.toPosition(l - l2);
        if (bl && this.inLeft) {
            this.inLeft = false;
        }
        return bl;
    }

    @Override
    public boolean contextIsOrdered(boolean bl) {
        boolean bl2;
        if (this.left == null || this.right == null) {
            bl2 = super.contextIsOrdered(bl);
        } else if (this.left.contextIsOrdered(bl) && this.right.contextIsOrdered(bl)) {
            Cursor cursor2 = this.left.fork(false);
            Cursor cursor3 = this.right.fork(false);
            if (TOPOSITIONSIZEFEATURES.containedIn(this.left.profile())) {
                cursor2.toPosition(cursor2.contextSize());
            } else if (cursor2 != null) {
                while (cursor2.toNext()) {
                }
            }
            Cursor.Profile profile = cursor3.profile();
            if (TOPOSITIONSIZEFEATURES.containedIn(profile)) {
                cursor3.toPosition(1L);
            } else if (Cursor.Profile.TO_PREVIOUS.containedIn(profile)) {
                if (cursor3 != null) {
                    while (cursor3.toPrevious()) {
                    }
                }
            } else assert (false) : "Right Cursor did not support TO_POSITION|SIZE nor TO_PREVIOUS";
            bl2 = cursor2.itemIsBeforeNode(cursor3) || !bl && cursor2.itemIsSameNode(cursor3);
            cursor2.release();
        } else {
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        if (this.left == null || this.right == null || bl) {
            return super.fork(bl, profile, profile2);
        }
        return new Concatenate2Cursor(this.left.fork(false, profile, profile2), this.right.fork(false, profile, profile2), this.inLeft, this.features);
    }

    @Override
    public Cursor sequenceConcat(Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Concatenate2Cursor concatenate2Cursor = (Concatenate2Cursor)AbstractCursor.ownTheCursor(this, bl, bl3);
        concatenate2Cursor.right = null != concatenate2Cursor.right ? concatenate2Cursor.right.sequenceConcat(cursor2, profile, profile2, bl, false, bl3, bl4) : AbstractCursor.ownTheCursor(cursor2, bl2, bl4);
        return concatenate2Cursor;
    }

    @Override
    public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
        Cursor cursor2 = SortHelper.documentOrderSortToSequence(this, true, profile, profile2, bl);
        return cursor2;
    }
}

