/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;
import com.ibm.xml.xci.dp.serialize.SerializedCData;
import com.ibm.xml.xci.dp.util.SingletonListCursor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDocSequenceCursor
extends AbstractDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected List<Cursor> list;
    int cursorListPosition;
    long position;
    int size = -1;
    static final Cursor.Profile MUTABLESEQUENCEFEATURES = Cursor.Profile.SEQUENCE;
    State state;
    boolean contextIsOrdered;
    static boolean forceToSelf = false;
    private static final Cursor.Profile SINGLETONPROFILE = Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_SELF);

    protected MultiDocSequenceCursor() {
    }

    public MultiDocSequenceCursor(Cursor cursor2, boolean bl, boolean bl2) {
        this.list = new Vector<Cursor>();
        if (bl) {
            Cursor cursor3 = MultiDocSequenceCursor.makeSingle(cursor2);
            this.list.add(cursor3);
            this.contextIsOrdered = true;
        } else {
            if (bl2) {
                cursor2 = cursor2.fork(false);
            }
            this.list.add(cursor2);
            this.contextIsOrdered = cursor2.contextIsOrdered(true);
        }
        this.state = State.sequence;
        this.cursorListPosition = 1;
        this.position = Cursor.Profile.POSITION.containedIn(cursor2.profile()) ? cursor2.contextPosition() : 1L;
        assert (this.isValidCursor());
    }

    public MultiDocSequenceCursor(Cursor cursor2, boolean bl) {
        this(cursor2, false, bl);
    }

    @Override
    protected final Cursor getDelegate() {
        return this.list.get(this.cursorListPosition - 1);
    }

    protected final Cursor getDelegateInfo() {
        return this.list.get(this.cursorListPosition - 1);
    }

    @Override
    protected void navigate() {
        assert (this.list != null) : "SingletonListCursor management problem: double-release!";
        if (this.state == State.sequence) {
            this.state = State.other;
            Cursor cursor2 = this.list.get(this.cursorListPosition - 1);
            for (Cursor cursor3 : this.list) {
                if (cursor3 == cursor2) continue;
                cursor3.release();
            }
            this.list.clear();
            this.list.add(0, cursor2);
            this.cursorListPosition = 1;
            this.position = 1L;
        }
    }

    @Override
    public final Cursor.Profile profile() {
        return this.getDelegate().profile().union(MUTABLESEQUENCEFEATURES);
    }

    @Override
    public final Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public final Cursor.Profile futureProfile() {
        return this.getDelegate().futureProfile().union(MUTABLESEQUENCEFEATURES);
    }

    @Override
    public void release() {
        for (Cursor cursor2 : this.list) {
            cursor2.release();
        }
        this.list = null;
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        Cursor cursor2;
        Iterator<Cursor> iterator;
        assert (this.isValidCursor());
        assert (this.list != null) : "SingletonList can not be fork()ed after it has been release()d";
        if (bl && profile2.containedIn((Cursor.Profile)((Object)(iterator = (cursor2 = this.getDelegate()).futureProfile())))) {
            Cursor cursor3 = this.getDelegate().fork(bl, profile, profile2);
            if (forceToSelf) {
                cursor3.toSelf();
            }
            return cursor3;
        }
        cursor2 = new MultiDocSequenceCursor();
        if (bl) {
            iterator = new ArrayList(1);
            iterator.add(this.list.get(this.cursorListPosition - 1).fork(true));
            ((MultiDocSequenceCursor)cursor2).list = iterator;
            ((MultiDocSequenceCursor)cursor2).position = 1L;
            ((MultiDocSequenceCursor)cursor2).size = -1;
            ((MultiDocSequenceCursor)cursor2).cursorListPosition = 1;
        } else {
            ((MultiDocSequenceCursor)cursor2).list = new Vector<Cursor>();
            for (Cursor cursor4 : this.list) {
                ((MultiDocSequenceCursor)cursor2).list.add(cursor4.fork(bl));
            }
            ((MultiDocSequenceCursor)cursor2).position = this.position;
            ((MultiDocSequenceCursor)cursor2).size = this.size;
            ((MultiDocSequenceCursor)cursor2).cursorListPosition = this.cursorListPosition;
        }
        ((MultiDocSequenceCursor)cursor2).state = this.state;
        ((MultiDocSequenceCursor)cursor2).contextIsOrdered = this.contextIsOrdered;
        assert (this.isValidCursor());
        assert (super.isValidCursor());
        return cursor2;
    }

    private boolean isValidCursor() {
        if (this.list == null) {
            return false;
        }
        if (this.cursorListPosition - 1 >= this.list.size()) {
            return false;
        }
        Iterator<Cursor> iterator = this.list.iterator();
        if (iterator.hasNext()) {
            Cursor cursor2 = iterator.next();
            return MultiDocSequenceCursor.isValid(cursor2);
        }
        return true;
    }

    private static boolean isValid(Cursor cursor2) {
        try {
            boolean bl;
            Class<?> clazz = Class.forName("com.ibm.xltxe.rnm1.xtq.xci.dtm.ref.DTMCursor$InnerDTMCursor");
            if (clazz.isInstance(cursor2)) {
                Method method = clazz.getMethod("isValidCursor", new Class[0]);
                Boolean bl2 = (Boolean)method.invoke((Object)cursor2, (Object[])null);
                if (!bl2.booleanValue()) {
                    return bl2;
                }
            } else if (cursor2 instanceof MultiDocSequenceCursor && !(bl = ((MultiDocSequenceCursor)cursor2).isValidCursor())) {
                return bl;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return true;
    }

    protected long getSequenceContextPosition() {
        return this.position;
    }

    @Override
    public long contextPosition() {
        if (this.state == State.sequence) {
            return this.getSequenceContextPosition();
        }
        return super.contextPosition();
    }

    @Override
    public long contextSize() {
        if (this.state == State.sequence) {
            if (this.size == -1) {
                this.size = 0;
                for (Cursor cursor2 : this.list) {
                    this.size = (int)((long)this.size + cursor2.contextSize());
                }
            }
            return this.size;
        }
        return super.contextSize();
    }

    @Override
    public boolean contextIsSingleton() {
        if (this.state == State.sequence) {
            return this.list.size() == 1 && this.getDelegate().contextIsSingleton();
        }
        return super.contextIsSingleton();
    }

    @Override
    public boolean contextIsOrdered(boolean bl) {
        if (this.state == State.sequence) {
            return this.contextIsOrdered;
        }
        return super.contextIsOrdered(bl);
    }

    @Override
    public boolean contextIsNodesOnly() {
        for (Cursor cursor2 : this.list) {
            if (cursor2.contextIsNodesOnly()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contextIsSingleDoc() {
        return this.list.size() == 1 && this.list.get(0).contextIsSingleDoc();
    }

    @Override
    public boolean contextIsLive() {
        if (this.state == State.sequence) {
            return false;
        }
        return super.contextIsLive();
    }

    @Override
    public boolean toNext() {
        if (this.state == State.other) {
            return super.toNext();
        }
        int n2 = this.cursorListPosition;
        Cursor cursor2 = this.list.get(n2 - 1);
        boolean bl = cursor2.toNext();
        if (bl) {
            ++this.position;
        } else if (++n2 <= this.list.size()) {
            cursor2 = this.list.get(n2 - 1);
            ++this.position;
            this.cursorListPosition = n2;
            bl = true;
        }
        assert (this.isValidCursor());
        return bl;
    }

    @Override
    public boolean toPrevious() {
        if (this.state == State.other) {
            return super.toPrevious();
        }
        int n2 = this.cursorListPosition;
        Cursor cursor2 = this.list.get(n2 - 1);
        boolean bl = cursor2.toPrevious();
        if (bl) {
            --this.position;
            assert (this.position >= 1L);
        } else if (--n2 >= 1) {
            cursor2 = this.list.get(n2 - 1);
            --this.position;
            this.cursorListPosition = n2;
            bl = true;
        }
        assert (this.isValidCursor());
        return bl;
    }

    @Override
    public boolean toPosition(long l) {
        int n2;
        if (this.state == State.other) {
            return super.toPosition(l);
        }
        if (l == this.position) {
            return true;
        }
        long l2 = this.position;
        int n3 = this.cursorListPosition;
        boolean bl = l > this.position;
        int n4 = Math.abs((int)(l - this.position));
        int n5 = -1;
        Cursor cursor2 = null;
        Cursor cursor3 = null;
        Cursor[] cursorArray = null;
        boolean bl2 = true;
        for (n2 = 0; n2 < n4 && bl2; ++n2) {
            if (n5 != this.cursorListPosition) {
                if (cursor2 != null) {
                    if (cursorArray == null) {
                        cursorArray = new Cursor[this.list.size()];
                    }
                    assert (cursor3 != null);
                    assert (MultiDocSequenceCursor.isValid(cursor3));
                    cursorArray[n5 - 1] = cursor3;
                }
                cursor3 = this.getDelegateInfo();
                cursor2 = cursor3.fork(false);
                this.list.set(this.cursorListPosition - 1, cursor2);
                n5 = this.cursorListPosition;
            }
            bl2 = bl ? this.toNext() : this.toPrevious();
        }
        if (!bl2) {
            this.position = l2;
            this.cursorListPosition = n3;
            cursor2.release();
            this.list.set(n5 - 1, cursor3);
            if (cursorArray != null) {
                assert (cursorArray != null);
                n2 = n5 < n3 ? n5 : n3;
                int n6 = n5 > n3 ? n5 : n3;
                for (int i = n2; i < n6; ++i) {
                    Cursor cursor4 = this.list.get(i - 1);
                    cursor4.release();
                    Cursor cursor5 = cursorArray[i - 1];
                    this.list.set(i - 1, cursor5);
                }
            }
        } else {
            cursor3.release();
            if (cursorArray != null) {
                assert (cursorArray != null);
                n2 = n5 < n3 ? n5 : n3;
                int n7 = n5 > n3 ? n5 : n3;
                for (int i = n2; i < n7; ++i) {
                    Cursor cursor6 = cursorArray[i - 1];
                    cursor6.release();
                }
            }
        }
        assert (this.isValidCursor());
        return bl2;
    }

    @Override
    public boolean isWrapped() {
        return true;
    }

    @Override
    public Cursor unwrap() {
        return this.getDelegate().unwrap();
    }

    private static Cursor makeSingle(Cursor cursor2) {
        Cursor cursor3 = cursor2.fork(true, SINGLETONPROFILE, cursor2.futureProfile());
        cursor3.toSelf();
        return cursor3;
    }

    @Override
    public Cursor sequenceConcat(Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.sequenceConcatx(cursor2, profile, profile2, bl, bl2, bl3, bl4, true);
    }

    public Cursor sequenceConcatx(Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (cursor2 == null) {
            Cursor cursor3 = AbstractCursor.ownTheCursor(this, bl, bl3);
            return cursor3;
        }
        Cursor cursor4 = AbstractCursor.ownTheCursor(this, bl, bl3);
        if (cursor4 instanceof MultiDocSequenceCursor) {
            MultiDocSequenceCursor multiDocSequenceCursor = (MultiDocSequenceCursor)cursor4;
            Cursor cursor5 = AbstractCursor.ownTheCursor(cursor2, bl2, bl4);
            if (cursor5 instanceof MultiDocSequenceCursor) {
                this.decomposAdd(multiDocSequenceCursor, (MultiDocSequenceCursor)cursor5, profile, profile2, bl2);
            } else {
                int n2 = multiDocSequenceCursor.list.size() - 1;
                Cursor cursor6 = multiDocSequenceCursor.list.get(n2);
                if (bl5 && Cursor.Profile.IS_SAME_DOCUMENT.containedIn(cursor6.profile()) && cursor6.itemIsSameDocument(cursor5)) {
                    cursor6 = cursor6.sequenceConcat(cursor5, profile, profile2, false, bl2, true, true);
                    multiDocSequenceCursor.list.set(n2, cursor6);
                } else {
                    if (bl2) {
                        cursor5.toSelf();
                    } else if (!Cursor.Profile.POSITION.containedIn(cursor4.profile()) || cursor5.contextPosition() != 1L) {
                        Cursor cursor7 = cursor5.fork(true);
                        cursor7.toSelf();
                        if (cursor5.toNext()) {
                            cursor5 = cursor7.sequenceConcat(cursor5, profile, profile2, true, true);
                        } else {
                            cursor5.release();
                            cursor5 = cursor7;
                        }
                    }
                    multiDocSequenceCursor.list.add(cursor5);
                }
            }
            if (multiDocSequenceCursor.size != -1) {
                multiDocSequenceCursor.size = (int)((long)multiDocSequenceCursor.size + (bl2 ? 1L : cursor5.contextSize()));
            }
            multiDocSequenceCursor.state = State.sequence;
            multiDocSequenceCursor.contextIsOrdered = false;
            assert (multiDocSequenceCursor.isValidCursor());
            return multiDocSequenceCursor;
        }
        SingletonListCursor singletonListCursor = new SingletonListCursor(cursor4, bl, !bl3);
        AbstractCursor.ownedCleanupIfMightMove(cursor4, bl, bl3);
        Cursor cursor8 = singletonListCursor.sequenceConcat(cursor2, profile, profile2, bl, bl2, true, bl4);
        return cursor8;
    }

    private void decomposAdd(MultiDocSequenceCursor multiDocSequenceCursor, MultiDocSequenceCursor multiDocSequenceCursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
        for (Cursor cursor2 : multiDocSequenceCursor2.list) {
            int n2 = multiDocSequenceCursor.list.size() - 1;
            Cursor cursor3 = multiDocSequenceCursor.list.get(n2);
            if (Cursor.Profile.IS_SAME_DOCUMENT.containedIn(cursor3.profile()) && cursor3.itemIsSameDocument(cursor2)) {
                cursor3 = cursor3.sequenceConcat(cursor2, profile, profile2, false, bl, true, true);
                multiDocSequenceCursor.list.set(n2, cursor3);
                continue;
            }
            if (bl) {
                cursor2.toSelf();
            }
            multiDocSequenceCursor.list.add(cursor2);
            if (!bl) continue;
            break;
        }
    }

    @Override
    public boolean toAttributes(final NodeTest nodeTest) {
        if (this.state != State.sequence) {
            return super.toAttributes(nodeTest);
        }
        return new Navigator(){

            boolean call() {
                return MultiDocSequenceCursor.super.toAttributes(nodeTest);
            }
        }.to();
    }

    @Override
    public boolean toChildren(final NodeTest nodeTest) {
        if (this.state != State.sequence) {
            return super.toChildren(nodeTest);
        }
        return new Navigator(){

            boolean call() {
                return MultiDocSequenceCursor.super.toChildren(nodeTest);
            }
        }.to();
    }

    @Override
    public boolean toFollowingSiblings(final NodeTest nodeTest) {
        if (this.state != State.sequence) {
            return super.toFollowingSiblings(nodeTest);
        }
        return new Navigator(){

            boolean call() {
                return MultiDocSequenceCursor.super.toFollowingSiblings(nodeTest);
            }
        }.to();
    }

    @Override
    public boolean toIdrefs(final VolatileCData volatileCData) {
        if (this.state != State.sequence) {
            return super.toIdrefs(volatileCData);
        }
        return new Navigator(){

            boolean call() {
                return MultiDocSequenceCursor.super.toIdrefs(volatileCData);
            }
        }.to();
    }

    @Override
    public boolean toIds(final VolatileCData volatileCData) {
        if (this.state != State.sequence) {
            return super.toIds(volatileCData);
        }
        return new Navigator(){

            boolean call() {
                return MultiDocSequenceCursor.super.toIds(volatileCData);
            }
        }.to();
    }

    @Override
    public boolean toNamespaceDecls() {
        if (this.state != State.sequence) {
            return super.toNamespaceDecls();
        }
        return new Navigator(){

            boolean call() {
                return MultiDocSequenceCursor.super.toNamespaceDecls();
            }
        }.to();
    }

    @Override
    public boolean toParent() {
        if (this.state != State.sequence) {
            return super.toParent();
        }
        return new Navigator(){

            boolean call() {
                return MultiDocSequenceCursor.super.toParent();
            }
        }.to();
    }

    @Override
    public boolean toPrecedingSiblings(final NodeTest nodeTest) {
        if (this.state != State.sequence) {
            return super.toPrecedingSiblings(nodeTest);
        }
        return new Navigator(){

            boolean call() {
                return MultiDocSequenceCursor.super.toPrecedingSiblings(nodeTest);
            }
        }.to();
    }

    @Override
    public boolean toRoot() {
        if (this.state != State.sequence) {
            return super.toRoot();
        }
        return new Navigator(){

            boolean call() {
                return MultiDocSequenceCursor.super.toRoot();
            }
        }.to();
    }

    @Override
    public boolean toSelf() {
        if (this.state != State.sequence) {
            return super.toSelf();
        }
        return new Navigator(){

            boolean call() {
                return MultiDocSequenceCursor.super.toSelf();
            }
        }.to();
    }

    public void setContextIsOrdered(boolean bl) {
        this.contextIsOrdered = bl;
    }

    @Override
    public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
        MultiDocSequenceCursor multiDocSequenceCursor;
        MultiDocSequenceCursor multiDocSequenceCursor2 = multiDocSequenceCursor = bl ? this : (MultiDocSequenceCursor)this.fork(false, profile, profile2);
        if (this.contextIsOrdered) {
            return multiDocSequenceCursor;
        }
        if (multiDocSequenceCursor.list.size() == 1) {
            return multiDocSequenceCursor.list.get(0).documentOrder(profile, profile2, true);
        }
        List<Cursor> list = this.coalesceLikeItems(multiDocSequenceCursor, profile, profile2);
        this.docOrderEachSequence(list, profile, profile2);
        this.sortToStableDocOrder(list);
        multiDocSequenceCursor.list = list;
        multiDocSequenceCursor.cursorListPosition = 1;
        if (!bl) assert (this.isValidCursor());
        assert (multiDocSequenceCursor.isValidCursor());
        multiDocSequenceCursor.contextIsOrdered = true;
        return multiDocSequenceCursor;
    }

    private void sortToStableDocOrder(List<Cursor> list) {
        Collections.sort(list, new Comparator<Cursor>(){

            @Override
            public int compare(Cursor cursor2, Cursor cursor3) {
                return cursor2.factory().getSessionContext().documentIsBefore(cursor2.itemDocumentIdentity(), cursor3.itemDocumentIdentity()) ? -1 : 1;
            }
        });
    }

    private void docOrderEachSequence(List<Cursor> list, Cursor.Profile profile, Cursor.Profile profile2) {
        for (int i = 0; i < list.size(); ++i) {
            Cursor cursor2 = list.get(i);
            Cursor cursor3 = cursor2.documentOrder(profile, profile2, true);
            assert (MultiDocSequenceCursor.isValid(cursor3));
            list.set(i, cursor3);
        }
    }

    private List<Cursor> coalesceLikeItems(MultiDocSequenceCursor multiDocSequenceCursor, Cursor.Profile profile, Cursor.Profile profile2) {
        Vector<Cursor> vector = new Vector<Cursor>();
        for (int i = 0; i < multiDocSequenceCursor.list.size(); ++i) {
            Cursor cursor2 = multiDocSequenceCursor.list.get(i);
            if (!cursor2.contextIsSingleDoc() || !cursor2.contextIsNodesOnly()) {
                do {
                    if (cursor2.itemIsAtomic()) {
                        Cursor cursor3 = cursor2.fork(true);
                        vector.add(cursor3);
                        continue;
                    }
                    this.addSequenceToSameDocOrAppend(vector, cursor2, true, profile, profile2, false);
                } while (cursor2.toNext());
                cursor2.release();
                continue;
            }
            this.addSequenceToSameDocOrAppend(vector, cursor2, false, profile, profile2, true);
        }
        return vector;
    }

    private void addSequenceToSameDocOrAppend(List<Cursor> list, Cursor cursor2, boolean bl, Cursor.Profile profile, Cursor.Profile profile2, boolean bl2) {
        boolean bl3 = false;
        for (int i = 0; i < list.size(); ++i) {
            Cursor cursor3 = list.get(i);
            if (cursor2 == cursor3 || !Cursor.Profile.IS_SAME_DOCUMENT.containedIn(cursor2.profile()) || !cursor2.itemIsSameDocument(cursor3)) continue;
            Cursor cursor4 = cursor2.sequenceConcat(cursor3, profile, profile2, bl, false, bl2, true);
            bl3 = true;
            assert (MultiDocSequenceCursor.isValid(cursor4));
            list.set(i, cursor4);
            break;
        }
        if (!bl3) {
            if (bl) {
                cursor2 = cursor2.fork(true, profile, profile2);
                cursor2.toSelf();
            }
            assert (MultiDocSequenceCursor.isValid(cursor2));
            list.add(cursor2);
        }
    }

    @Override
    public VolatileCData serialize(Map<String, Object> map2) {
        return new SerializedCData(this, map2);
    }

    @Override
    public Object exportAs(String string2, boolean bl) {
        if ("domNodeList2".equals(string2)) {
            throw new ClassCastException();
        }
        return super.exportAs(string2, bl);
    }

    @Override
    public boolean itemIsSameNode(Cursor cursor2) {
        return super.itemIsSameNode(cursor2);
    }

    abstract class Navigator {
        Navigator() {
        }

        abstract boolean call();

        public boolean to() {
            Cursor cursor2 = MultiDocSequenceCursor.this.getDelegate();
            Cursor cursor3 = cursor2.fork(true);
            MultiDocSequenceCursor.this.list.set(MultiDocSequenceCursor.this.cursorListPosition - 1, cursor3);
            if (this.call()) {
                assert (MultiDocSequenceCursor.this.isValidCursor());
                return true;
            }
            cursor3.release();
            MultiDocSequenceCursor.this.list.set(MultiDocSequenceCursor.this.cursorListPosition - 1, cursor2);
            assert (MultiDocSequenceCursor.this.isValidCursor());
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        sequence,
        other;

    }
}

