/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;
import java.util.ArrayList;
import java.util.List;

public class SharedSequenceCursor
extends AbstractDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private SequenceCache cache;
    private int position;

    public SharedSequenceCursor(Cursor cursor2, Cursor.Profile profile) {
        Cursor.Profile profile2 = profile.union(Cursor.Profile.MINIMAL_NAVIGATION);
        Cursor cursor3 = cursor2.factory().proxy(cursor2, profile2, false, null, null);
        this.cache = new SequenceCache(this, profile, cursor3);
    }

    protected SharedSequenceCursor(SharedSequenceCursor sharedSequenceCursor, Cursor.Profile profile, boolean bl, Cursor.Profile profile2) {
        this.cache = sharedSequenceCursor.cache;
        this.cache.addFork(this);
    }

    protected Cursor getDelegate() {
        return this.cache.item(this.position);
    }

    public Cursor.Profile profile() {
        return this.cache.maximalFeatures;
    }

    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    public Cursor.Profile futureProfile() {
        return this.cache.maximalFeatures;
    }

    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        return new SharedSequenceCursor(this, profile, bl, profile2);
    }

    public void release() {
        this.cache.removeFork(this);
        super.release();
    }

    static class SequenceCache {
        private final List<SharedSequenceCursor> forks = new ArrayList<SharedSequenceCursor>();
        private final Cursor.Profile maximalFeatures;
        private Cursor source;
        private final List<Cursor> items = new ArrayList<Cursor>();

        SequenceCache(SharedSequenceCursor sharedSequenceCursor, Cursor.Profile profile, Cursor cursor2) {
            this.addFork(sharedSequenceCursor);
            this.maximalFeatures = profile;
            this.source = cursor2;
        }

        void addFork(SharedSequenceCursor sharedSequenceCursor) {
            this.forks.add(sharedSequenceCursor);
        }

        void removeFork(SharedSequenceCursor sharedSequenceCursor) {
            this.forks.remove(sharedSequenceCursor);
        }

        Cursor advance() {
            if (this.source == null) {
                return null;
            }
            Cursor cursor2 = this.source.fork(true, this.maximalFeatures, this.maximalFeatures);
            cursor2.toSelf();
            this.items.add(cursor2);
            if (!this.source.toNext()) {
                this.source = null;
            }
            return cursor2;
        }

        int size() {
            while (this.advance() != null) {
            }
            return this.items.size();
        }

        Cursor item(int n2) {
            Cursor cursor2;
            if (n2 <= this.items.size()) {
                return this.items.get(n2 - 1);
            }
            while ((cursor2 = this.advance()) != null && this.items.size() < n2) {
            }
            assert (cursor2 == null || this.items.size() == n2);
            return cursor2;
        }
    }
}

