/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;
import com.ibm.xml.xci.dp.serialize.SerializedCData;
import com.ibm.xml.xci.internal.util.SortHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonListCursor
extends AbstractDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected List<Cursor> list;
    protected List<Cursor> releaseList;
    private CountHolder holderCountOnReleaseList;
    int position;
    static final Cursor.Profile MUTABLESEQUENCEFEATURES = Cursor.Profile.SEQUENCE;
    State state;
    boolean contextIsOrdered;
    static boolean forceToSelf = false;
    private static final Cursor.Profile SINGLETONPROFILE = Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_SELF);

    @Override
    public boolean itemIsSameNode(Cursor cursor2) {
        return super.itemIsSameNode(cursor2);
    }

    protected SingletonListCursor(List<Cursor> list) {
        assert (list.size() > 0) : "SingletonList must have at least one member.";
        this.list = list;
        this.position = 1;
    }

    public void reverseList() {
        int n2 = this.list.size();
        int n3 = this.list.size() / 2;
        for (int i = 0; i < n3; ++i) {
            int n4 = n2 - i - 1;
            Cursor cursor2 = this.list.get(n4);
            this.list.set(n4, this.list.get(i));
            this.list.set(i, cursor2);
        }
    }

    public SingletonListCursor(Cursor cursor2, boolean bl, boolean bl2) {
        this.list = new Vector<Cursor>();
        this.holderCountOnReleaseList = new CountHolder();
        if (bl) {
            Cursor cursor3 = SingletonListCursor.makeSingle(cursor2);
            this.list.add(cursor3);
            this.contextIsOrdered = true;
        } else {
            if (bl2) {
                cursor2 = cursor2.fork(false);
            }
            do {
                Cursor cursor4 = SingletonListCursor.makeSingle(cursor2);
                this.list.add(cursor4);
                SingletonListCursor.addToReleaseList(cursor4, this);
            } while (cursor2.toNext());
            this.contextIsOrdered = cursor2.contextIsOrdered(true);
            if (bl2 && !bl) {
                cursor2.release();
            }
        }
        this.state = State.sequence;
        this.position = 1;
        assert (this.ensureSingletons());
    }

    public SingletonListCursor(Cursor cursor2, boolean bl) {
        this(cursor2, false, bl);
    }

    @Override
    protected final Cursor getDelegate() {
        return this.list.get(this.position - 1);
    }

    @Override
    protected void navigate() {
        assert (this.list != null) : "SingletonListCursor management problem: double-release!";
        if (this.state == State.sequence) {
            this.state = State.other;
            Cursor cursor2 = this.getDelegate();
            if (this.releaseList != null && this.holderCountOnReleaseList.count == 1) {
                for (Cursor cursor3 : this.releaseList) {
                    if (cursor3 == cursor2) continue;
                    cursor3.release();
                }
                this.releaseList = null;
            }
            if (this.releaseList == null) {
                this.releaseList = new ArrayList<Cursor>();
            }
            this.releaseList.add(cursor2);
            this.list.clear();
            this.list.add(0, cursor2);
            this.position = 1;
        }
    }

    @Override
    public final Cursor.Profile profile() {
        return this.getDelegate().profile().union(MUTABLESEQUENCEFEATURES);
    }

    @Override
    public final Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public final Cursor.Profile futureProfile() {
        return this.getDelegate().futureProfile().union(MUTABLESEQUENCEFEATURES);
    }

    @Override
    public void release() {
        --this.holderCountOnReleaseList.count;
        if (this.releaseList != null) {
            if (this.holderCountOnReleaseList.count == 0) {
                for (Cursor cursor2 : this.releaseList) {
                    cursor2.release();
                }
            }
            this.releaseList = null;
        }
        this.list = null;
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        ArrayList<Cursor> arrayList;
        Object object2;
        assert (this.list != null) : "SingletonList can not be fork()ed after it has been release()d";
        if (bl && profile2.containedIn((Cursor.Profile)(object2 = (arrayList = this.getDelegate()).futureProfile()))) {
            Cursor cursor2 = this.getDelegate().fork(bl, profile, profile2);
            if (forceToSelf) {
                cursor2.toSelf();
            }
            return cursor2;
        }
        if (bl) {
            arrayList = new ArrayList(1);
            object2 = this.getDelegate();
            if (this.state == State.other) {
                object2 = object2.fork(false);
                SingletonListCursor.addToReleaseList((Cursor)object2, this);
            }
            arrayList.add((Cursor)object2);
        } else {
            arrayList = new ArrayList<Cursor>(this.list.size());
            for (Cursor cursor3 : this.list) {
                if (this.state == State.sequence) {
                    assert (cursor3.contextIsSingleton()) : "SingletonList can only contain singletons.";
                } else if (this.state == State.other) {
                    cursor3 = cursor3.fork(false);
                    SingletonListCursor.addToReleaseList(cursor3, this);
                }
                arrayList.add(cursor3);
            }
        }
        object2 = this.dupThis(arrayList);
        ((SingletonListCursor)object2).releaseList = this.releaseList;
        ++this.holderCountOnReleaseList.count;
        ((SingletonListCursor)object2).holderCountOnReleaseList = this.holderCountOnReleaseList;
        ((SingletonListCursor)object2).state = this.state;
        ((SingletonListCursor)object2).contextIsOrdered = this.contextIsOrdered;
        int n2 = ((SingletonListCursor)object2).position = bl ? 1 : this.position;
        assert (super.ensureSingletons());
        return object2;
    }

    protected SingletonListCursor dupThis(List<Cursor> list) {
        return new SingletonListCursor(list);
    }

    protected int getSequenceContextPosition() {
        return this.position;
    }

    @Override
    public long contextPosition() {
        if (this.state == State.sequence) {
            return this.getSequenceContextPosition();
        }
        return super.contextPosition();
    }

    @Override
    public long contextSize() {
        if (this.state == State.sequence) {
            return this.list.size();
        }
        return super.contextSize();
    }

    @Override
    public boolean contextIsSingleton() {
        if (this.state == State.sequence) {
            return this.list.size() == 1;
        }
        return super.contextIsSingleton();
    }

    @Override
    public boolean contextIsOrdered(boolean bl) {
        if (this.state == State.sequence) {
            return this.contextIsOrdered;
        }
        return super.contextIsOrdered(bl);
    }

    @Override
    public boolean contextIsLive() {
        if (this.state == State.sequence) {
            return false;
        }
        return super.contextIsLive();
    }

    @Override
    public boolean toNext() {
        if (this.state == State.other) {
            return super.toNext();
        }
        return this.toPosition(this.position + 1);
    }

    @Override
    public boolean toPrevious() {
        if (this.state == State.other) {
            return super.toPrevious();
        }
        return this.toPosition(this.position - 1);
    }

    @Override
    public boolean toPosition(long l) {
        if (this.state == State.other) {
            return super.toPosition(l);
        }
        assert ((long)this.position < Integer.MAX_VALUE) : "Cannot handle positions beyond int range.";
        if (1L <= l && l <= (long)this.list.size()) {
            this.position = (int)l;
            assert (this.getDelegate().contextIsSingleton()) : "toPosition: SingletonList can only contain singletons.";
            return true;
        }
        return false;
    }

    @Override
    public boolean isWrapped() {
        return true;
    }

    @Override
    public Cursor unwrap() {
        return this.getDelegate().unwrap();
    }

    private final boolean ensureSingletons() {
        assert (this.state != null) : "state can not be null at this time!";
        if (this.state == State.sequence) {
            for (Cursor cursor2 : this.list) {
                assert (cursor2.contextIsSingleton()) : "ensureSingletons: SingletonList can only contain singletons.";
            }
        }
        return true;
    }

    private static Cursor makeSingle(Cursor cursor2) {
        Cursor cursor3 = cursor2.fork(true, SINGLETONPROFILE, cursor2.futureProfile());
        cursor3.toSelf();
        return cursor3;
    }

    private static void addToReleaseList(Cursor cursor2, SingletonListCursor singletonListCursor) {
        if (null == singletonListCursor.releaseList) {
            singletonListCursor.releaseList = new Vector<Cursor>();
        }
        if (!singletonListCursor.releaseList.contains(cursor2)) {
            singletonListCursor.releaseList.add(cursor2);
        }
    }

    @Override
    public Cursor sequenceConcat(Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (cursor2 == null) {
            Cursor cursor3 = AbstractCursor.ownTheCursor(this, bl, bl3);
            return cursor3;
        }
        Cursor cursor4 = AbstractCursor.ownTheCursor(this, bl, bl3);
        if (cursor4 instanceof SingletonListCursor) {
            SingletonListCursor singletonListCursor = (SingletonListCursor)cursor4;
            Cursor cursor5 = AbstractCursor.ownTheCursor(cursor2, bl2, bl4);
            if (bl2) {
                cursor5.toSelf();
                singletonListCursor.list.add(cursor5);
                SingletonListCursor.addToReleaseList(cursor5, singletonListCursor);
            } else {
                do {
                    Cursor cursor6 = SingletonListCursor.makeSingle(cursor5);
                    singletonListCursor.list.add(cursor6);
                    SingletonListCursor.addToReleaseList(cursor6, singletonListCursor);
                } while (cursor5.toNext());
                AbstractCursor.ownedCleanup(cursor5, true);
            }
            singletonListCursor.state = State.sequence;
            this.contextIsOrdered = false;
            assert (singletonListCursor.ensureSingletons());
            return singletonListCursor;
        }
        return super.sequenceConcat(cursor2, profile, profile2, bl, bl2, true, bl4);
    }

    @Override
    public boolean toAttributes(final NodeTest nodeTest) {
        if (this.state != State.sequence || this.holderCountOnReleaseList.count <= 1) {
            return super.toAttributes(nodeTest);
        }
        return new Navigator(){

            boolean call() {
                return SingletonListCursor.super.toAttributes(nodeTest);
            }
        }.to();
    }

    @Override
    public boolean toChildren(final NodeTest nodeTest) {
        if (this.state != State.sequence || this.holderCountOnReleaseList.count <= 1) {
            return super.toChildren(nodeTest);
        }
        return new Navigator(){

            boolean call() {
                return SingletonListCursor.super.toChildren(nodeTest);
            }
        }.to();
    }

    @Override
    public boolean toFollowingSiblings(final NodeTest nodeTest) {
        if (this.state != State.sequence || this.holderCountOnReleaseList.count <= 1) {
            return super.toFollowingSiblings(nodeTest);
        }
        return new Navigator(){

            boolean call() {
                return SingletonListCursor.super.toFollowingSiblings(nodeTest);
            }
        }.to();
    }

    @Override
    public boolean toIdrefs(final VolatileCData volatileCData) {
        if (this.state != State.sequence || this.holderCountOnReleaseList.count <= 1) {
            return super.toIdrefs(volatileCData);
        }
        return new Navigator(){

            boolean call() {
                return SingletonListCursor.super.toIdrefs(volatileCData);
            }
        }.to();
    }

    @Override
    public boolean toIds(final VolatileCData volatileCData) {
        if (this.state != State.sequence || this.holderCountOnReleaseList.count <= 1) {
            return super.toIds(volatileCData);
        }
        return new Navigator(){

            boolean call() {
                return SingletonListCursor.super.toIds(volatileCData);
            }
        }.to();
    }

    @Override
    public boolean toNamespaceDecls() {
        if (this.state != State.sequence || this.holderCountOnReleaseList.count <= 1) {
            return super.toNamespaceDecls();
        }
        return new Navigator(){

            boolean call() {
                return SingletonListCursor.super.toNamespaceDecls();
            }
        }.to();
    }

    @Override
    public boolean toParent() {
        if (this.state != State.sequence || this.holderCountOnReleaseList.count <= 1) {
            return super.toParent();
        }
        return new Navigator(){

            boolean call() {
                return SingletonListCursor.super.toParent();
            }
        }.to();
    }

    @Override
    public boolean toPrecedingSiblings(final NodeTest nodeTest) {
        if (this.state != State.sequence || this.holderCountOnReleaseList.count <= 1) {
            return super.toPrecedingSiblings(nodeTest);
        }
        return new Navigator(){

            boolean call() {
                return SingletonListCursor.super.toPrecedingSiblings(nodeTest);
            }
        }.to();
    }

    @Override
    public boolean toRoot() {
        if (this.state != State.sequence || this.holderCountOnReleaseList.count <= 1) {
            return super.toRoot();
        }
        return new Navigator(){

            boolean call() {
                return SingletonListCursor.super.toRoot();
            }
        }.to();
    }

    @Override
    public boolean toSelf() {
        if (this.state != State.sequence || this.holderCountOnReleaseList.count <= 1) {
            return super.toSelf();
        }
        return new Navigator(){

            boolean call() {
                return SingletonListCursor.super.toSelf();
            }
        }.to();
    }

    public void setContextIsOrdered(boolean bl) {
        this.contextIsOrdered = bl;
    }

    @Override
    public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
        Cursor cursor2 = SortHelper.documentOrderSortToSequence(this, true, profile, profile2, bl);
        return cursor2;
    }

    @Override
    public VolatileCData serialize(Map<String, Object> map2) {
        return new SerializedCData(this, map2);
    }

    @Override
    public Object exportAs(String string2, boolean bl) {
        if ("domNodeList2".equals(string2)) {
            throw new ClassCastException();
        }
        return super.exportAs(string2, bl);
    }

    abstract class Navigator {
        Navigator() {
        }

        abstract boolean call();

        public boolean to() {
            Cursor cursor2 = SingletonListCursor.this.getDelegate();
            Cursor cursor3 = cursor2.fork(true);
            SingletonListCursor.this.list.set(SingletonListCursor.this.position - 1, cursor3);
            if (this.call()) {
                return true;
            }
            cursor3.release();
            SingletonListCursor.this.list.set(SingletonListCursor.this.position - 1, cursor2);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        sequence,
        other;

    }

    class CountHolder {
        int count = 1;

        CountHolder() {
        }
    }
}

