/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.dp.values.BaseCData;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class StringCDataBuilder {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private XSSimpleTypeDefinition type;
    protected Link first;
    protected Link last;
    protected int length;
    protected String string;
    protected char[] chars;
    protected Bytes utf8;
    protected boolean done;

    public StringCDataBuilder(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        this.type = xSSimpleTypeDefinition;
        this.last = null;
        this.first = null;
        this.length = 0;
        this.string = "";
        this.chars = null;
        this.utf8 = null;
    }

    public void append(CData cData) {
        assert (!this.done) : "Cannot append() after done().";
        if (cData != null) {
            if (this.first == null) {
                this.first = this.last = new Link(cData);
            } else {
                this.last = this.last.next = new Link(cData);
            }
            this.length = -1;
            this.string = null;
            this.chars = null;
            this.utf8 = null;
        }
    }

    public CData toCData() {
        assert (!this.done) : "Cannot extract CData more than once!";
        this.done = true;
        if (this.first != null && this.first == this.last) {
            return this.first.text;
        }
        return new ToCData(this.type);
    }

    protected static class Link {
        public CData text;
        public Link next;

        Link(CData cData) {
            this.text = cData;
        }
    }

    private class ToCData
    extends BaseCData
    implements CData {
        ToCData(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
            super(xSSimpleTypeDefinition);
        }

        public int length() {
            if (StringCDataBuilder.this.length < 0) {
                StringCDataBuilder.this.length = 0;
                Link link = StringCDataBuilder.this.first;
                while (link != null) {
                    StringCDataBuilder.this.length += link.text.length();
                    link = link.next;
                }
            }
            return StringCDataBuilder.this.length;
        }

        public boolean hasCharAt(int n2) {
            int n3 = 0;
            Link link = StringCDataBuilder.this.first;
            while (link != null) {
                int n4 = n3 + link.text.length();
                if (n2 < n4) {
                    return true;
                }
                n3 = n4;
                link = link.next;
            }
            return false;
        }

        public char charAt(int n2) {
            int n3 = 0;
            Link link = StringCDataBuilder.this.first;
            while (link != null) {
                int n4 = n3 + link.text.length();
                if (n2 < n4) {
                    return link.text.charAt(n2 - n3);
                }
                n3 = n4;
                link = link.next;
            }
            throw new IndexOutOfBoundsException();
        }

        public CharSequence subSequence(int n2, int n3) {
            if (n2 < 0 || n3 < n2) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == n3) {
                return "";
            }
            if (n2 == 0 && n3 == this.length() && StringCDataBuilder.this.done) {
                return this;
            }
            int n4 = 0;
            Link link = StringCDataBuilder.this.first;
            while (link != null) {
                int n5 = n4 + link.text.length();
                if (n2 <= n5) {
                    if (n3 <= n5) {
                        return link.text.subSequence(n2 - n4, n3 - n4);
                    }
                    return this.toString().subSequence(n2, n3);
                }
                n4 = n5;
                link = link.next;
            }
            throw new IndexOutOfBoundsException();
        }

        public CharSequence subSequence(int n2) {
            return this.toString().substring(n2);
        }

        public String toString() {
            if (StringCDataBuilder.this.string == null) {
                if (StringCDataBuilder.this.chars != null) {
                    StringCDataBuilder.this.string = StringCDataBuilder.this.chars.toString();
                } else {
                    StringWriter stringWriter = new StringWriter();
                    Link link = StringCDataBuilder.this.first;
                    while (link != null) {
                        try {
                            link.text.writeTo(stringWriter, false);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        link = link.next;
                    }
                    StringCDataBuilder.this.string = stringWriter.toString();
                }
            }
            return StringCDataBuilder.this.string;
        }

        public char[] toCharArray() {
            if (StringCDataBuilder.this.chars == null) {
                if (StringCDataBuilder.this.string != null) {
                    StringCDataBuilder.this.chars = StringCDataBuilder.this.string.toCharArray();
                } else {
                    CharArrayWriter charArrayWriter = new CharArrayWriter(this.length());
                    Link link = StringCDataBuilder.this.first;
                    while (link != null) {
                        try {
                            link.text.writeTo(charArrayWriter, false);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        link = link.next;
                    }
                    StringCDataBuilder.this.chars = charArrayWriter.toCharArray();
                }
            }
            return StringCDataBuilder.this.chars;
        }

        public int writeTo(Writer writer, boolean bl) throws IOException {
            if (StringCDataBuilder.this.chars != null) {
                writer.write(StringCDataBuilder.this.chars);
                return StringCDataBuilder.this.chars.length;
            }
            if (StringCDataBuilder.this.string != null) {
                writer.write(StringCDataBuilder.this.string);
                return StringCDataBuilder.this.string.length();
            }
            int n2 = 0;
            Link link = StringCDataBuilder.this.first;
            while (link != null) {
                n2 += link.text.writeTo(writer, false);
                link = link.next;
            }
            return n2;
        }

        public String getString(int n2) {
            return this.toString();
        }
    }
}

