/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.exec.Axis;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xci.util.SimpleNameTest;
import com.ibm.xml.xml4j.api.s1.xs.XSComplexTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSModelGroup;
import com.ibm.xml.xml4j.api.s1.xs.XSObjectList;
import com.ibm.xml.xml4j.api.s1.xs.XSParticle;
import com.ibm.xml.xml4j.api.s1.xs.XSTerm;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;

public class XCIXpathGenerator {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2011. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static Cursor.Profile myProfile = Cursor.Profile.RANDOM_ACCESS.union(Cursor.Profile.RANDOM_ACCESS).union(Cursor.Profile.TO_NODE_TEST);

    public static void main(String[] stringArray) throws FileNotFoundException {
        SessionContext sessionContext = new SessionContext();
        FileInputStream fileInputStream = new FileInputStream("../xci-test/resources/input/catalog1.xml");
        Cursor cursor2 = sessionContext.document(new StreamSource(fileInputStream), new RequestInfo(myProfile));
        if (cursor2.toChildren(SimpleNameTest.element(cursor2.factory().data(new QName("catalog"), TypeRegistry.XSQNAME, false))) && cursor2.toChildren(SimpleNameTest.element(cursor2.factory().data(new QName("Item"), TypeRegistry.XSQNAME, false)))) {
            do {
                Cursor cursor3 = cursor2.fork(false, myProfile, myProfile);
                cursor3.toChildren(SimpleNameTest.element(cursor2.factory().data(new QName("name"), TypeRegistry.XSQNAME, false)));
                cursor3.toChildren(null);
                Cursor cursor4 = cursor2.fork(false, myProfile, myProfile);
                cursor4.toChildren(SimpleNameTest.element(cursor2.factory().data(new QName("productNumber"), TypeRegistry.XSQNAME, false)));
                cursor4.toChildren(null);
                Cursor cursor5 = cursor2.fork(false, myProfile, myProfile);
                cursor5.toChildren(SimpleNameTest.element(cursor2.factory().data(new QName("price"), TypeRegistry.XSQNAME, false)));
                cursor5.toChildren(null);
                System.out.println(XCIXpathGenerator.nodeToXPath(cursor3) + " has value " + cursor3.itemTypedValue().getString(1) + "\n" + XCIXpathGenerator.nodeToXPath(cursor4) + " has value " + cursor4.itemTypedValue().getString(1) + "\n" + XCIXpathGenerator.nodeToXPath(cursor5) + " has value " + cursor5.itemTypedValue().getString(1));
                cursor3.release();
                cursor4.release();
                cursor5.release();
            } while (cursor2.toNext());
        }
        cursor2.release();
    }

    public static String nodeToXPath(Cursor cursor2) {
        return XCIXpathGenerator.nodeToXPath(cursor2, false, false);
    }

    public static String nodeToXPath(Cursor cursor2, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = XCIXpathGenerator.nodeToXpath(cursor2, new StringBuilder(), bl, bl2);
        if (stringBuilder.length() == 0) {
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    private static StringBuilder nodeToXpath(Cursor cursor2, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        Cursor cursor3;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        if ((cursor3 = XCIXpathGenerator.getAxisCursor(cursor2, Axis.PARENT)) != null) {
            XCIXpathGenerator.nodeToXpath(cursor3, stringBuilder, bl, bl2);
        } else if (cursor2.itemKind() != 9 && stringBuilder.length() != 0 && stringBuilder.charAt(0) == '/') {
            stringBuilder.deleteCharAt(0);
        }
        switch (cursor2.itemKind()) {
            case 0: {
                throw new IllegalArgumentException(XCIMessages.createXCIMessage("ER_XPATH_FOR_NON_NODE", new String[]{cursor2.toString(), cursor2.itemXSType().getName()}));
            }
            case 9: {
                break;
            }
            case 3: {
                stringBuilder.append("/text()[");
                stringBuilder.append(XCIXpathGenerator.sibindex(cursor2, null, false));
                stringBuilder.append("]");
                break;
            }
            case 8: {
                stringBuilder.append("/comment()[");
                stringBuilder.append(XCIXpathGenerator.sibindex(cursor2, null, false));
                stringBuilder.append("]");
                break;
            }
            case 1: {
                QName qName = cursor2.itemName().getQName(1, null);
                if (bl2 || "".equals(qName.getNamespaceURI())) {
                    stringBuilder.append("/").append(qName.getLocalPart());
                } else {
                    stringBuilder.append("/*[local-name()='");
                    stringBuilder.append(qName.getLocalPart());
                    stringBuilder.append("' and namespace-uri()='");
                    stringBuilder.append(qName.getNamespaceURI());
                    stringBuilder.append("']");
                }
                int n2 = XCIXpathGenerator.sibindex(cursor2, cursor3, bl);
                if (n2 <= 0) break;
                stringBuilder.append('[');
                stringBuilder.append(n2);
                stringBuilder.append(']');
                break;
            }
            case 2: {
                QName qName = cursor2.itemName().getQName(1, null);
                if (bl2 || "".equals(qName.getNamespaceURI())) {
                    stringBuilder.append("/@").append(qName.getLocalPart());
                    break;
                }
                stringBuilder.append("/@*[local-name()='");
                stringBuilder.append(qName.getLocalPart());
                stringBuilder.append("' and namespace-uri()='");
                stringBuilder.append(qName.getNamespaceURI());
                stringBuilder.append("']");
                break;
            }
            case 4: {
                QName qName = cursor2.itemName().getQName(1, null);
                stringBuilder.append("/namespace::");
                stringBuilder.append(qName.getPrefix());
                break;
            }
            case 7: {
                QName qName = cursor2.itemName().getQName(1, null);
                stringBuilder.append("processing-instruction(");
                String string2 = qName.getPrefix();
                if (string2 != null && string2.length() > 0) {
                    stringBuilder.append(string2).append(':');
                }
                stringBuilder.append(qName.getLocalPart());
                stringBuilder.append(")[");
                stringBuilder.append(XCIXpathGenerator.sibindex(cursor2, null, false));
                stringBuilder.append("]");
            }
        }
        if (cursor3 != null) {
            cursor3.release();
        }
        return stringBuilder;
    }

    private static int sibindex(Cursor cursor2, Cursor cursor3, boolean bl) {
        Object object2;
        VolatileCData volatileCData = cursor2.itemName();
        QName qName = volatileCData != null && !volatileCData.isEmptySequence() ? volatileCData.getQName(1, null) : null;
        int n2 = 1;
        short s = cursor2.itemKind();
        Cursor cursor4 = XCIXpathGenerator.getAxisCursor(cursor2, Axis.PRECEDINGSIBLING);
        if (cursor4 != null) {
            do {
                QName qName2;
                QName qName3 = qName2 = (object2 = cursor4.itemName()) == null || object2.isEmptySequence() ? null : object2.getQName(1, null);
                if (cursor4.itemKind() != s || (qName2 != null || qName != null) && (qName2 == null || !qName2.equals(qName))) continue;
                ++n2;
            } while (cursor4.toNext());
            cursor4.release();
        }
        if (n2 > 1 || !bl) {
            return n2;
        }
        if (cursor3 == null || cursor3.itemKind() != 1) {
            return 0;
        }
        object2 = cursor3.itemXSType();
        return XCIXpathGenerator.hasSingle((XSTypeDefinition)object2, qName) ? 0 : 1;
    }

    private static boolean hasSingle(XSTypeDefinition xSTypeDefinition, QName qName) {
        if (xSTypeDefinition == null || xSTypeDefinition.getTypeCategory() == 16) {
            return false;
        }
        XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition;
        if (xSComplexTypeDefinition.getContentType() == 0 || xSComplexTypeDefinition.getContentType() == 1) {
            return false;
        }
        XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
        return XCIXpathGenerator.count(xSParticle, qName) == 1;
    }

    private static int count(XSParticle xSParticle, QName qName) {
        XSTerm xSTerm = xSParticle.getTerm();
        switch (xSTerm.getType()) {
            case 2: {
                XSElementDeclaration xSElementDeclaration = (XSElementDeclaration)xSTerm;
                if (XCIXpathGenerator.equals(qName.getNamespaceURI(), xSElementDeclaration.getNamespace()) && XCIXpathGenerator.equals(qName.getLocalPart(), xSElementDeclaration.getName())) {
                    return xSParticle.getMaxOccursUnbounded() ? 2 : xSParticle.getMaxOccurs();
                }
                return 0;
            }
            case 9: {
                return 0;
            }
        }
        int n2 = XCIXpathGenerator.count((XSModelGroup)xSTerm, qName);
        int n3 = xSParticle.getMaxOccursUnbounded() ? 2 : xSParticle.getMaxOccurs();
        return n3 * n2;
    }

    private static int count(XSModelGroup xSModelGroup, QName qName) {
        boolean bl = xSModelGroup.getCompositor() == 2;
        int n2 = 0;
        XSObjectList xSObjectList = xSModelGroup.getParticles();
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            int n3 = XCIXpathGenerator.count((XSParticle)xSObjectList.item(i), qName);
            if (bl) {
                n2 = Math.max(n2, n3);
                continue;
            }
            n2 += n3;
        }
        return n2;
    }

    private static boolean equals(String string2, String string3) {
        return string2 == null || string2.length() == 0 ? string3 == null || string3.length() == 0 : string2.equals(string3);
    }

    private static Cursor getAxisCursor(Cursor cursor2, Axis axis) {
        SessionContext sessionContext = cursor2.factory().getSessionContext();
        Executable executable = sessionContext.getPreparer().prepare(axis, null, null, -1);
        Cursor cursor3 = executable.execute(cursor2, null, Cursor.Profile.SEQUENCE, null);
        return cursor3;
    }
}

