/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.copy;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.copyright.Copyright;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.dp.cache.dom.CacheCursor;
import com.ibm.xml.xci.dp.cache.dom.DOMCachedNode;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.NamespaceContextHelper;
import com.ibm.xml.xci.dp.util.SinkCursor;
import com.ibm.xml.xci.dp.util.XCIXpathGenerator;
import com.ibm.xml.xci.dp.util.copy.CopierDelegate;
import com.ibm.xml.xci.dp.util.copy.ItemCopier;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.internal.values.Base64BinaryCData;
import com.ibm.xml.xci.internal.values.MTOMCData;
import com.ibm.xml.xci.internal.values.QNameCData;
import com.ibm.xml.xci.internal.values.StoredCharsCData;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.spi.config.AttachmentContent;
import com.ibm.xml.xci.spi.config.PathComputer;
import com.ibm.xml.xci.spi.config.XMLAttachmentMarshaller;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSElementDeclaration;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class Copier {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2011. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile SOURCE_FEATURES = Cursor.Profile.MINIMAL_STREAMING_NAVIGATION;
    public static final Cursor.Profile TARGET_FEATURES = Cursor.Profile.MINIMAL_STREAMING_MUTATION;
    public static final int NODE_COPIED = 0;
    public static final int SUBTREE_COPIED = 1;
    public static final int FOLLOWING_COPIED = 2;
    public static final int SEQUENCE_COPIED = 4;
    public static final int OPTION_RELEASE_SOURCE = 1;
    public static final int OPTION_PRESERVE_PSVI = 2;
    public static final int OPTION_DISCARD_NS_DECLS = 4;
    public static final int OPTION_DISCARD_DEFAULT_ATTRIBUTE = 8;
    public static final int OPTION_RELEASE_TARGET = 16;
    public static final int OPTION_STRING_VALUE = 32;
    public static final int OPTION_TYPED_VALUE = 64;
    public static final int OPTION_PRESERVE_XS_DECLS = 128;
    private static final VolatileCData XOP_INCLUDE = new QNameCData(new QName("http://www.w3.org/2004/08/xop/include", "Include"), TypeRegistry.XSQNAME);
    private static final VolatileCData HREF = new QNameCData(new QName("", "href"), TypeRegistry.XSQNAME);
    private static final Logger logger = LoggerUtil.getLogger(Copier.class);
    private final boolean preservePSVI;
    private final boolean preserveXSDecls;
    private final boolean preserveDefaultAttribute;
    private final Cursor.CopyDataOptions dataCopy;
    protected final boolean discardNSDecls;
    private final XMLAttachmentMarshaller xmlAM;

    public static void materialize(Cursor cursor2) {
        if (cursor2 != null) {
            Copier.copy(cursor2, new SinkCursor(cursor2.factory()), Cursor.Area.FIRST_CHILD);
        }
    }

    public static void copy(Cursor cursor2, Cursor cursor3) {
        Copier.copy(cursor2, cursor3, Cursor.Area.FIRST_CHILD);
    }

    public static void copy(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
        Copier.copy(cursor2, cursor3, area, 17);
    }

    public static void copy(Cursor cursor2, Cursor cursor3, Cursor.Area area, int n2) {
        Copier.copy(cursor2, cursor3, area, n2, null);
    }

    public static void copy(Cursor cursor2, Cursor cursor3, Cursor.Area area, int n2, ItemCopier itemCopier) {
        if (cursor2 != null) {
            assert (SOURCE_FEATURES.containedIn(cursor2.profile())) : "Insufficient source features for copy!";
            assert (cursor3 != null) : "Cannot copy into empty target sequence, only document and element parents!";
            assert (TARGET_FEATURES.containedIn(cursor3.profile())) : "Insufficient target features for copy!";
            if (cursor2.itemKind() == 9 && !cursor2.toChildren(null)) {
                return;
            }
            boolean bl = cursor3.openMutation(Cursor.Area.SUBTREE);
            Copier copier = itemCopier == null ? new Copier(n2) : new CopierDelegate(n2, itemCopier);
            copier.copySequence2Content(cursor2, cursor3, area);
            if (bl) {
                cursor3.closeMutation();
            }
            if ((n2 & 1) != 0) {
                cursor2.release();
            }
            if ((n2 & 0x10) != 0) {
                cursor3.release();
            }
        }
    }

    public static Cursor.Profile sourceProfile(ItemCopier itemCopier) {
        if (itemCopier != null) {
            return itemCopier.sourceProfile();
        }
        return SOURCE_FEATURES;
    }

    public static Cursor.Profile targetProfile(Cursor.Area area, ItemCopier itemCopier) {
        if (itemCopier != null) {
            return itemCopier.targetProfile(area);
        }
        return TARGET_FEATURES;
    }

    protected Copier(int n2) {
        this(n2, null, null);
    }

    protected Copier(int n2, Cursor cursor2, XMLAttachmentMarshaller xMLAttachmentMarshaller) {
        this.preservePSVI = (n2 & 2) != 0;
        this.preserveXSDecls = (n2 & 0x80) != 0;
        this.preserveDefaultAttribute = (n2 & 8) == 0;
        boolean bl = this.discardNSDecls = (n2 & 4) != 0;
        this.dataCopy = (n2 & 0x20) != 0 && (n2 & 0x40) != 0 ? Cursor.CopyDataOptions.ALL : ((n2 & 0x20) != 0 ? Cursor.CopyDataOptions.LEXICAL : ((n2 & 0x40) != 0 ? Cursor.CopyDataOptions.TYPE : Cursor.CopyDataOptions.ALL));
        if (cursor2 != null && Cursor.Profile.RANDOM_ACCESS.containedIn(cursor2.profile())) {
            assert (xMLAttachmentMarshaller == null || this.dataCopy != Cursor.CopyDataOptions.TYPE);
            this.xmlAM = xMLAttachmentMarshaller;
        } else {
            this.xmlAM = null;
        }
    }

    protected int copySequence2Content(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
        int n2 = this.copyNode(cursor2, cursor3, area);
        if (n2 == 2) {
            return 2;
        }
        switch (area.immediateArea()) {
            case FIRST_CHILD: {
                cursor3 = cursor3.fork(true, cursor3.profile(), cursor3.futureProfile());
                cursor3.toChildren(null);
                break;
            }
            case IMMEDIATE_FOLLOWING: {
                cursor3 = cursor3.fork(false, cursor3.profile(), cursor3.futureProfile());
                cursor3.toNext();
                break;
            }
            case LAST_CHILD: {
                cursor3 = cursor3.fork(true, cursor3.profile(), cursor3.futureProfile());
                cursor3.toChildren(null);
                while (cursor3.toNext()) {
                }
                break;
            }
            case ATTRIBUTE: {
                cursor3 = cursor3.fork(false, cursor3.profile(), cursor3.futureProfile());
                break;
            }
            case NAMESPACE_DECLS: {
                cursor3 = cursor3.fork(false, cursor3.profile(), cursor3.futureProfile());
                break;
            }
            default: {
                assert (false) : "Impossible WHERE parameter to copySequence2Content: " + area.toString();
                break;
            }
        }
        if (this.preservePSVI && cursor2.itemKind() == 1 && cursor2.itemXSPSVInfo() != null) {
            cursor3.setItemPSVI(cursor2.itemXSPSVInfo());
        }
        if (this.preserveXSDecls && cursor2.itemKind() == 1) {
            cursor3.setItemXSElementDeclaration(cursor2.itemXSElementDeclaration());
        }
        if (n2 == 0 && cursor2.itemKind() == 1) {
            n2 = this.copyContents(cursor2, cursor3);
        }
        if (n2 == 2) {
            return 2;
        }
        if (n2 != 4) {
            while (cursor2.toNext()) {
                n2 = this.copyNode(cursor2, cursor3, Cursor.Area.FOLLOWING_SIBLING);
                cursor3.toNext();
                if (cursor2.itemKind() == 1) {
                    if (this.preservePSVI && cursor2.itemXSPSVInfo() != null) {
                        cursor3.setItemPSVI(cursor2.itemXSPSVInfo());
                    }
                    if (this.preserveXSDecls) {
                        cursor3.setItemXSElementDeclaration(cursor2.itemXSElementDeclaration());
                    }
                }
                if (n2 == 0 && cursor2.itemKind() == 1) {
                    n2 = this.copyContents(cursor2, cursor3);
                }
                if (n2 != 2) continue;
                return 2;
            }
        }
        cursor3.release();
        return 1;
    }

    protected int copyNode(Cursor cursor2, Cursor cursor3, Cursor.Area area) {
        switch (cursor2.itemKind()) {
            case 2: {
                Cursor.ItemValueOrigin itemValueOrigin = cursor2.itemAttributeValueOrigin();
                if (!this.preserveDefaultAttribute && itemValueOrigin != Cursor.ItemValueOrigin.UNKNOWN && itemValueOrigin != Cursor.ItemValueOrigin.SPECIFIED) break;
                if (this.dataCopy == Cursor.CopyDataOptions.LEXICAL) {
                    XSTypeDefinition xSTypeDefinition = cursor2.itemXSType();
                    if (xSTypeDefinition instanceof XSSimpleTypeDefinition && ((XSSimpleTypeDefinition)xSTypeDefinition).getBuiltInKind() == 19) {
                        Copier.addAttribute(cursor2.itemName(), cursor2.itemTypedValue(), xSTypeDefinition, this.preservePSVI, this.preserveXSDecls, cursor2, cursor3);
                        break;
                    }
                    Copier.addAttribute(cursor2.itemName(), cursor2.itemStringValueAsChars(), xSTypeDefinition, this.preservePSVI, this.preserveXSDecls, cursor2, cursor3);
                    break;
                }
                if (this.dataCopy == Cursor.CopyDataOptions.TYPE) {
                    Copier.addAttribute(cursor2.itemName(), cursor2.itemTypedValue().stripOriginalLexicalValue(false), cursor2.itemXSType(), this.preservePSVI, this.preserveXSDecls, cursor2, cursor3);
                    break;
                }
                CData cData = cursor2.itemTypedValue().constant(false);
                Copier.addAttribute(cursor2.itemName(), cData, cursor2.itemXSType(), this.preservePSVI, this.preserveXSDecls, cursor2, cursor3);
                break;
            }
            case 1: {
                cursor3.addElement(area, cursor2.itemName(), cursor2.itemXSType());
                break;
            }
            case 3: {
                cursor3.addText(area, cursor2.itemStringValueAsChars());
                break;
            }
            case 8: {
                cursor3.addComment(area, cursor2.itemStringValueAsChars());
                break;
            }
            case 7: {
                cursor3.addProcessingInstruction(area, cursor2.itemName(), cursor2.itemStringValueAsChars());
                break;
            }
            case 4: {
                VolatileCData volatileCData = cursor2.itemName();
                String string2 = !volatileCData.isEmptySequence() ? volatileCData.getQNameLocalPart(1) : null;
                CData cData = cursor2.factory().data((CharSequence)(string2 != null ? string2 : ""), null, false);
                cursor3.addNamespaceNode(cData, cursor2.itemStringValue(), true);
                break;
            }
            case 9: {
                break;
            }
            default: {
                assert (false) : "Invalid focus kind:" + cursor2.itemKind();
                break;
            }
        }
        return 0;
    }

    protected int copyContents(Cursor cursor2, Cursor cursor3) {
        int n2;
        Cursor cursor4;
        Cursor cursor5;
        if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            if (cursor2.unwrap() instanceof DOMCachedNode) {
                logger.logp(Level.FINEST, logger.getName(), "copyContents", "About to copy the contents from source node= " + ((DOMCachedNode)cursor2.unwrap()).toStringLazy());
            } else {
                logger.logp(Level.FINEST, logger.getName(), "copyContents", "About to copy the contents from source node");
            }
        }
        if ((cursor5 = cursor2.fork(true)).toNamespaceDecls() && !this.discardNSDecls) {
            do {
                this.copyNode(cursor5, cursor3, Cursor.Area.FOLLOWING_SIBLING);
            } while (cursor5.toNext());
        }
        cursor5.release();
        if (this.discardNSDecls) {
            Copier.fixupNamespace(cursor2, cursor3);
        }
        if ((cursor4 = cursor2.fork(true)).toAttributes(null)) {
            do {
                this.copyNode(cursor4, cursor3, Cursor.Area.FOLLOWING_SIBLING);
                if (!this.discardNSDecls) continue;
                Copier.fixupNamespace(cursor4, cursor3);
            } while (cursor4.toNext());
        }
        cursor4.release();
        if ((this.xmlAM != null || this.dataCopy == Cursor.CopyDataOptions.TYPE || this.dataCopy == Cursor.CopyDataOptions.ALL) && this.isOptimalSimpleTyped(cursor2)) {
            VolatileCData volatileCData = cursor2.itemTypedValue();
            if (!volatileCData.isEmptySequence()) {
                VolatileCData volatileCData2;
                cursor3 = cursor3.fork(true, cursor3.profile(), cursor3.futureProfile());
                cursor3.toChildren(null);
                VolatileCData volatileCData3 = volatileCData2 = this.dataCopy == Cursor.CopyDataOptions.TYPE ? volatileCData.stripOriginalLexicalValue(false) : volatileCData;
                if (this.xmlAM != null) {
                    this.addTextAsFirstChild(cursor2, cursor3, volatileCData2);
                } else {
                    cursor3.addText(Cursor.Area.FIRST_CHILD, (Chars)volatileCData2);
                }
                cursor3.release();
            }
            n2 = 1;
        } else {
            Cursor cursor6 = cursor2.fork(true);
            n2 = cursor6.toChildren(null) ? this.copySequence2Content(cursor6, cursor3, Cursor.Area.FIRST_CHILD) : 1;
            cursor6.release();
        }
        return n2;
    }

    private void addTextAsFirstChild(Cursor cursor2, Cursor cursor3, VolatileCData volatileCData) {
        XSSimpleTypeDefinition xSSimpleTypeDefinition = volatileCData.getXSTypeDefinition();
        if (xSSimpleTypeDefinition != null && xSSimpleTypeDefinition.getBuiltInKind() == 17) {
            String string2 = null;
            if (volatileCData instanceof MTOMCData) {
                PathComputerImpl pathComputerImpl = new PathComputerImpl(cursor2);
                XSElementDeclaration xSElementDeclaration = cursor2.itemXSElementDeclaration();
                AttachmentContent attachmentContent = ((MTOMCData)volatileCData).getMTOM();
                string2 = this.xmlAM.addAttachment(attachmentContent, -1, xSElementDeclaration, pathComputerImpl);
            } else if (volatileCData instanceof Base64BinaryCData) {
                PathComputerImpl pathComputerImpl = new PathComputerImpl(cursor2);
                XSElementDeclaration xSElementDeclaration = cursor2.itemXSElementDeclaration();
                Bytes bytes2 = volatileCData.getBase64Binary(1);
                string2 = this.xmlAM.addAttachment(bytes2.toByteArray(false), xSElementDeclaration, pathComputerImpl);
            } else {
                Bytes bytes3 = volatileCData.getBase64Binary(1);
                if ((bytes3.byteLength() + 2L) / 3L * 4L == (long)volatileCData.length()) {
                    PathComputerImpl pathComputerImpl = new PathComputerImpl(cursor2);
                    XSElementDeclaration xSElementDeclaration = cursor2.itemXSElementDeclaration();
                    string2 = this.xmlAM.addAttachment(bytes3.toByteArray(false), xSElementDeclaration, pathComputerImpl);
                }
            }
            if (string2 != null) {
                cursor3.addElement(Cursor.Area.FIRST_CHILD, XOP_INCLUDE, null);
                cursor3.addAttribute(HREF, new StringCData(string2, TypeRegistry.XSSTRING));
                return;
            }
        }
        cursor3.addText(Cursor.Area.FIRST_CHILD, (Chars)volatileCData);
    }

    private boolean isOptimalSimpleTyped(Cursor cursor2) {
        if (!TypeHelper.isSimple(cursor2.itemXSType())) {
            return false;
        }
        if (Cursor.Profile.MINIMAL_NAVIGATION.containedIn(cursor2.futureProfile())) {
            Cursor cursor3 = cursor2.fork(true, Cursor.Profile.MINIMAL_NAVIGATION, Cursor.Profile.MINIMAL_NAVIGATION);
            if (cursor3.toChildren(null) && !cursor3.toNext() && cursor3.itemKind() == 3) {
                cursor3.release();
                return true;
            }
            cursor3.release();
        }
        return false;
    }

    public static void fixupNamespace(Cursor cursor2, Cursor cursor3) {
        VolatileCData volatileCData = cursor2.itemName();
        String string2 = volatileCData.getQNamePrefix(1);
        if (string2 != null && string2.length() > 0) {
            CharSequence charSequence;
            Cursor cursor4 = cursor3.fork(true);
            boolean bl = false;
            while (cursor4.toParent()) {
                if (cursor4.itemKind() != 1 || (charSequence = cursor4.itemName().getQNamePrefix(1)) == null || !((String)charSequence).equals(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                charSequence = new StringCData(string2, TypeRegistry.XSSTRING);
                StringCData stringCData = new StringCData(NamespaceContextHelper.getNamespaceURI(cursor2, string2), TypeRegistry.XSSTRING);
                cursor3.addNamespaceNode((VolatileCData)charSequence, stringCData, false);
            }
        }
    }

    private static void addAttribute(VolatileCData volatileCData, VolatileCData volatileCData2, XSTypeDefinition xSTypeDefinition, boolean bl, boolean bl2, Cursor cursor2, Cursor cursor3) {
        if ((bl || bl2) && cursor3 instanceof CacheCursor) {
            ((CacheCursor)cursor3).addAttributeWithTypeInfo(volatileCData, volatileCData2, xSTypeDefinition, bl2 ? cursor2.itemXSAttributeDeclaration() : null, bl ? (AttributePSVI)cursor2.itemXSPSVInfo() : null);
        } else {
            cursor3.addAttribute(volatileCData, volatileCData2);
        }
    }

    private static void addAttribute(VolatileCData volatileCData, Chars chars, XSTypeDefinition xSTypeDefinition, boolean bl, boolean bl2, Cursor cursor2, Cursor cursor3) {
        if ((bl || bl2) && cursor3 instanceof CacheCursor) {
            ((CacheCursor)cursor3).addAttributeWithTypeInfo(volatileCData, new StoredCharsCData(chars, TypeRegistry.XSUNTYPEDATOMIC), xSTypeDefinition, bl2 ? cursor2.itemXSAttributeDeclaration() : null, bl ? (AttributePSVI)cursor2.itemXSPSVInfo() : null);
        } else {
            cursor3.addAttribute(volatileCData, chars);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2011. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class PathComputerImpl
    implements PathComputer {
        private final Cursor node;

        public PathComputerImpl(Cursor cursor2) {
            this.node = cursor2;
        }

        public String computePath() {
            return XCIXpathGenerator.nodeToXPath(this.node, true, true);
        }
    }
}

