/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.copy;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.ras.xci.XCICustomLoggers;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.values.BaseCData;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Level;

public class SerializerCDataLogger
extends BaseCData
implements VolatileCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private StringBuilder sb;
    private ByteArrayOutputStream baos;
    private VolatileCData serializerDelegate;

    public SerializerCDataLogger(XSSimpleTypeDefinition xSSimpleTypeDefinition, VolatileCData volatileCData) {
        super(xSSimpleTypeDefinition);
        this.serializerDelegate = volatileCData;
    }

    public int writeTo(Writer writer, boolean bl) throws IOException {
        int n2 = this.serializerDelegate.writeTo(new MyWriter(writer), bl);
        this.logOutput(this.sb.toString());
        return n2;
    }

    public int appendQuotedTo(Appendable appendable, short s, boolean bl) throws IOException {
        int n2 = this.serializerDelegate.appendQuotedTo(new MyAppendable(appendable), s, bl);
        this.logOutput(this.sb.toString());
        return n2;
    }

    public void writeEncodedBytesTo(OutputStream outputStream, Charset charset, boolean bl) throws IOException {
        this.serializerDelegate.writeEncodedBytesTo(new MyOutputStream(outputStream), charset, bl);
        this.logOutput(this.baos.toString());
    }

    public void writeEncodedBytesTo(OutputStream outputStream, String string2, short s, boolean bl) throws IOException {
        this.serializerDelegate.writeEncodedBytesTo(new MyOutputStream(outputStream), string2, s, bl);
        this.logOutput(this.baos.toString());
    }

    public CData constant(boolean bl) {
        return this.serializerDelegate.constant(bl);
    }

    public String toString() {
        return this.serializerDelegate.toString();
    }

    public String getString(int n2) {
        return this.serializerDelegate.getString(n2);
    }

    private void logOutput(String string2) {
        XCICustomLoggers.serializationLogger.logp(Level.FINER, XCICustomLoggers.serializationLogger.getName(), "logOutput", string2);
    }

    private class MyOutputStream
    extends OutputStream {
        private OutputStream outputStreamDelegate;

        public MyOutputStream(OutputStream outputStream) {
            this.outputStreamDelegate = outputStream;
            SerializerCDataLogger.this.baos = new ByteArrayOutputStream();
        }

        public void close() throws IOException {
            this.outputStreamDelegate.close();
        }

        public void flush() throws IOException {
            this.outputStreamDelegate.flush();
        }

        public void write(byte[] byArray) throws IOException {
            if (LoggerUtil.isAnyTracingEnabled() && XCICustomLoggers.serializationLogger.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\nSerializing[");
                stringBuilder.append(new String(byArray));
                stringBuilder.append("]\n");
                stringBuilder.append(XCIErrorHelper.getStackTrace(15));
                XCICustomLoggers.serializationLogger.logp(Level.FINEST, XCICustomLoggers.serializationLogger.getName(), "write", stringBuilder.toString());
            }
            SerializerCDataLogger.this.baos.write(byArray);
            this.outputStreamDelegate.write(byArray);
        }

        public void write(byte[] byArray, int n2, int n3) throws IOException {
            if (LoggerUtil.isAnyTracingEnabled() && XCICustomLoggers.serializationLogger.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\nSerializing[");
                stringBuilder.append(new String(byArray, n2, n3));
                stringBuilder.append("]\n");
                stringBuilder.append(XCIErrorHelper.getStackTrace(15));
                XCICustomLoggers.serializationLogger.logp(Level.FINEST, XCICustomLoggers.serializationLogger.getName(), "write", stringBuilder.toString());
            }
            SerializerCDataLogger.this.baos.write(byArray, n2, n3);
            this.outputStreamDelegate.write(byArray, n2, n3);
        }

        public void write(int n2) throws IOException {
            SerializerCDataLogger.this.baos.write(n2);
            this.outputStreamDelegate.write(n2);
        }
    }

    public class MyWriter
    extends Writer {
        private Writer writerDelegate;

        public MyWriter(Writer writer) {
            this.writerDelegate = writer;
            SerializerCDataLogger.this.sb = new StringBuilder();
        }

        public void write(char[] cArray) throws IOException {
            if (LoggerUtil.isAnyTracingEnabled() && XCICustomLoggers.serializationLogger.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\nSerializing[");
                stringBuilder.append(cArray);
                stringBuilder.append("]\n");
                stringBuilder.append(XCIErrorHelper.getStackTrace(15));
                XCICustomLoggers.serializationLogger.logp(Level.FINEST, XCICustomLoggers.serializationLogger.getName(), "write", stringBuilder.toString());
            }
            SerializerCDataLogger.this.sb.append(cArray);
            this.writerDelegate.write(cArray);
        }

        public void write(int n2) throws IOException {
            SerializerCDataLogger.this.sb.append(n2);
            this.writerDelegate.write(n2);
        }

        public void write(String string2, int n2, int n3) throws IOException {
            if (LoggerUtil.isAnyTracingEnabled() && XCICustomLoggers.serializationLogger.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\nSerializing[");
                stringBuilder.append(string2, n2, n3);
                stringBuilder.append("]\n");
                stringBuilder.append(XCIErrorHelper.getStackTrace(15));
                XCICustomLoggers.serializationLogger.logp(Level.FINEST, XCICustomLoggers.serializationLogger.getName(), "write", stringBuilder.toString());
            }
            SerializerCDataLogger.this.sb.append(string2, n2, n3);
            this.writerDelegate.write(string2, n2, n3);
        }

        public void write(String string2) throws IOException {
            SerializerCDataLogger.this.sb.append(string2);
            this.writerDelegate.write(string2);
        }

        public void close() throws IOException {
            this.writerDelegate.close();
        }

        public void flush() throws IOException {
            this.writerDelegate.flush();
        }

        public void write(char[] cArray, int n2, int n3) throws IOException {
            SerializerCDataLogger.this.sb.append(cArray, n2, n3);
            this.writerDelegate.write(cArray, n2, n3);
        }
    }

    private class MyAppendable
    implements Appendable {
        private Appendable appenderDelegate;

        public MyAppendable(Appendable appendable) {
            this.appenderDelegate = appendable;
            SerializerCDataLogger.this.sb = new StringBuilder();
        }

        public Appendable append(CharSequence charSequence) throws IOException {
            if (LoggerUtil.isAnyTracingEnabled() && XCICustomLoggers.serializationLogger.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\nSerializing[");
                stringBuilder.append(charSequence);
                stringBuilder.append("]\n");
                stringBuilder.append(XCIErrorHelper.getStackTrace(15));
                XCICustomLoggers.serializationLogger.logp(Level.FINEST, XCICustomLoggers.serializationLogger.getName(), "write", stringBuilder.toString());
            }
            SerializerCDataLogger.this.sb.append(charSequence);
            this.appenderDelegate.append(charSequence);
            return this;
        }

        public Appendable append(char c) throws IOException {
            SerializerCDataLogger.this.sb.append(c);
            this.appenderDelegate.append(c);
            return this;
        }

        public Appendable append(CharSequence charSequence, int n2, int n3) throws IOException {
            if (LoggerUtil.isAnyTracingEnabled() && XCICustomLoggers.serializationLogger.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\nSerializing[");
                stringBuilder.append(charSequence, n2, n3);
                stringBuilder.append("]\n");
                stringBuilder.append(XCIErrorHelper.getStackTrace(15));
                XCICustomLoggers.serializationLogger.logp(Level.FINEST, XCICustomLoggers.serializationLogger.getName(), "write", stringBuilder.toString());
            }
            SerializerCDataLogger.this.sb.append(charSequence, n2, n3);
            this.appenderDelegate.append(charSequence, n2, n3);
            return this;
        }
    }
}

