/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.fixers;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractDelegatingCursor;
import com.ibm.xml.xci.internal.util.CopyToResultHelper;
import com.ibm.xml.xci.res.XCIMessages;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveSubtreeFixer
extends AbstractDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile FIXED_FEATURES = Cursor.Profile.REMOVE_SUBTREE;
    public static final Cursor.Profile UNFIXED_FEATURES = Cursor.Profile.SIZE.union(Cursor.Profile.POSITION).union(Cursor.Profile.TO_POSITION).union(Cursor.Profile.TO_FOLLOWING_SIBLINGS).union(Cursor.Profile.TO_PRECEDING_SIBLINGS).union(Cursor.Profile.TO_IDREFS).union(Cursor.Profile.TO_IDS);
    public static final Cursor.Profile NEEDED_FEATURES = Cursor.Profile.NODE_IDENTITY.union(Cursor.Profile.MINIMAL_NAVIGATION).union(Cursor.Profile.TO_FOLLOWING_SIBLINGS);
    private static final Cursor.Profile REMOVE_CHILD_FEATURES = Cursor.Profile.MINIMAL_STREAMING_MUTATION.union(Cursor.Profile.NODE_IDENTITY);
    private static final Cursor.Profile REMOVE_FOLLOWING_SIBLING_FEATURES = Cursor.Profile.TO_FOLLOWING_SIBLINGS.union(Cursor.Profile.NODE_IDENTITY);
    protected Cursor cursor;
    protected Set<Long> removedNodes;

    public RemoveSubtreeFixer(Cursor cursor2) {
        this.cursor = cursor2;
        this.removedNodes = new HashSet<Long>();
    }

    protected RemoveSubtreeFixer(Cursor cursor2, Set<Long> set2) {
        this.cursor = cursor2;
        this.removedNodes = set2;
    }

    protected boolean removeNode(long l) {
        return this.removedNodes.add(l);
    }

    protected boolean hasBeenRemoved(long l) {
        return this.removedNodes.contains(l);
    }

    @Override
    protected Cursor getDelegate() {
        return this.cursor;
    }

    @Override
    public Cursor.Profile profile() {
        return super.profile().union(FIXED_FEATURES).difference(UNFIXED_FEATURES);
    }

    @Override
    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    @Override
    public Cursor.Profile futureProfile() {
        return super.futureProfile().union(FIXED_FEATURES).difference(UNFIXED_FEATURES);
    }

    @Override
    public boolean removeSubtree(Cursor.Area area) {
        switch (area.immediateArea()) {
            case SELF: {
                return this.removeNode(this.cursor.itemNodeIdentity());
            }
            case FIRST_CHILD: {
                Cursor cursor2 = this.fork(true, REMOVE_CHILD_FEATURES, REMOVE_CHILD_FEATURES);
                boolean bl = cursor2.toChildren(null) ? this.removeNode(cursor2.itemNodeIdentity()) : false;
                cursor2.release();
                return bl;
            }
            case IMMEDIATE_FOLLOWING: {
                Cursor cursor3 = this.cursor.fork(true, REMOVE_FOLLOWING_SIBLING_FEATURES, REMOVE_FOLLOWING_SIBLING_FEATURES);
                boolean bl = false;
                do {
                    if (!cursor3.toFollowingSiblings(null) || this.hasBeenRemoved(cursor3.itemNodeIdentity())) continue;
                    bl = this.removeNode(cursor3.itemNodeIdentity());
                    break;
                } while (cursor3.toNext());
                cursor3.release();
                return bl;
            }
            case LAST_CHILD: {
                boolean bl;
                Cursor cursor4 = this.fork(true, REMOVE_CHILD_FEATURES, REMOVE_CHILD_FEATURES);
                if (cursor4.toChildren(null)) {
                    while (cursor4.toNext()) {
                    }
                    bl = this.removeNode(cursor4.itemNodeIdentity());
                } else {
                    bl = false;
                }
                cursor4.release();
                return bl;
            }
        }
        throw new IllegalArgumentException(XCIMessages.createXCIMessage("ER_ILLEGAL_ARGS", new String[]{"where", area.toString()}));
    }

    @Override
    public boolean contextIsSingleton() {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.SIZE"}));
    }

    @Override
    public long contextPosition() {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.POSITION"}));
    }

    @Override
    public long contextSize() {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.SIZE"}));
    }

    public boolean copyToResult(Result result2, Map map2, boolean bl, boolean bl2) {
        return CopyToResultHelper.copyToResult(this, result2, map2, bl, bl2);
    }

    @Override
    public Object exportAs(String string2, boolean bl) {
        throw new ClassCastException();
    }

    @Override
    public Class<?> exportAsClass(String string2) {
        return null;
    }

    @Override
    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        return new RemoveSubtreeFixer(this.cursor, this.removedNodes);
    }

    @Override
    public boolean openMutation(Cursor.Area area) {
        return this.cursor.openMutation(area);
    }

    @Override
    public boolean toChildren(NodeTest nodeTest) {
        Cursor cursor2 = this.cursor.fork(false);
        if (this.cursor.toChildren(nodeTest)) {
            while (this.hasBeenRemoved(this.cursor.itemNodeIdentity())) {
                if (this.cursor.toNext()) continue;
                this.cursor.release();
                this.cursor = cursor2;
                return false;
            }
            cursor2.release();
            return true;
        }
        cursor2.release();
        return false;
    }

    @Override
    public boolean toFollowingSiblings(NodeTest nodeTest) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_FOLLOWING_SIBLINGS"}));
    }

    @Override
    public boolean toIdrefs(VolatileCData volatileCData) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_IDREFS"}));
    }

    @Override
    public boolean toIds(VolatileCData volatileCData) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_IDS"}));
    }

    @Override
    public boolean toNext() {
        Cursor cursor2 = this.cursor.fork(false);
        if (this.cursor.toNext()) {
            while (this.hasBeenRemoved(this.cursor.itemNodeIdentity())) {
                if (this.cursor.toNext()) continue;
                this.cursor.release();
                this.cursor = cursor2;
                return false;
            }
            cursor2.release();
            return true;
        }
        cursor2.release();
        return false;
    }

    @Override
    public boolean toPosition(long l) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_POSITION"}));
    }

    @Override
    public boolean toPrecedingSiblings(NodeTest nodeTest) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_PRECEDING_SIBLINGS"}));
    }

    @Override
    public boolean toPrevious() {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_PREVIOUS"}));
    }

    @Override
    public VolatileCData serialize(Map<String, Object> map2) {
        throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.SERIALIZE"}));
    }
}

