/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.fixers;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractSimpleDelegatingCursor;

public class SelfFixer
extends AbstractSimpleDelegatingCursor {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Cursor.Profile FIXED_FEATURES = Cursor.Profile.TO_SELF;
    public static final Cursor.Profile NEEDED_FEATURES = Cursor.Profile.NONE;
    boolean singleton;

    public SelfFixer(Cursor cursor2) {
        super(cursor2);
    }

    public boolean toSelf() {
        this.singleton = true;
        return true;
    }

    public boolean toParent() {
        this.singleton = true;
        return super.toParent();
    }

    public boolean toRoot() {
        this.singleton = true;
        return super.toRoot();
    }

    public boolean toIds(VolatileCData volatileCData) {
        this.singleton = false;
        return super.toIds(volatileCData);
    }

    public boolean toIdrefs(VolatileCData volatileCData) {
        this.singleton = false;
        return super.toIdrefs(volatileCData);
    }

    public boolean toFollowingSiblings(NodeTest nodeTest) {
        this.singleton = false;
        return super.toFollowingSiblings(nodeTest);
    }

    public boolean toPrecedingSiblings(NodeTest nodeTest) {
        this.singleton = false;
        return super.toPrecedingSiblings(nodeTest);
    }

    public boolean toChildren(NodeTest nodeTest) {
        this.singleton = false;
        return super.toChildren(nodeTest);
    }

    public boolean toNamespaceDecls() {
        this.singleton = false;
        return super.toNamespaceDecls();
    }

    public boolean toAttributes(NodeTest nodeTest) {
        this.singleton = false;
        return super.toAttributes(nodeTest);
    }

    public Cursor.Profile profile() {
        return super.profile().union(FIXED_FEATURES);
    }

    public Cursor.Profile profileLimit() {
        return this.futureProfile();
    }

    public Cursor.Profile futureProfile() {
        return super.futureProfile().union(FIXED_FEATURES);
    }

    public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
        if (this.singleton || FIXED_FEATURES.disjoint(profile.union(profile2))) {
            return super.fork(bl, profile, profile2);
        }
        return new SelfFixer(super.fork(bl, profile.difference(FIXED_FEATURES), profile2.difference(FIXED_FEATURES)));
    }

    public boolean contextIsSingleton() {
        return this.singleton ? true : super.contextIsSingleton();
    }

    public boolean contextIsOrdered(boolean bl) {
        return this.singleton ? true : super.contextIsOrdered(bl);
    }

    public long contextPosition() {
        return this.singleton ? 1L : super.contextPosition();
    }

    public long contextSize() {
        return this.singleton ? 1L : super.contextSize();
    }

    public boolean toNext() {
        return this.singleton ? false : super.toNext();
    }

    public boolean toPrevious() {
        return this.singleton ? false : super.toPrevious();
    }

    public boolean toPosition(long l) {
        return this.singleton ? l == 1L : super.toPosition(l);
    }
}

