/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.misc;

public class IntArrayList
implements Cloneable {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int[] array;
    protected int firstFree;

    public IntArrayList() {
        this.array = new int[32];
    }

    public IntArrayList(int n2) {
        this.array = new int[n2];
    }

    protected void ensureCapacity(int n2) {
        if (this.array.length < n2) {
            int n3 = this.array.length * 2;
            int[] nArray = new int[n3];
            System.arraycopy(this.array, 0, nArray, 0, this.firstFree);
            this.array = nArray;
        }
    }

    public final int size() {
        return this.firstFree;
    }

    public final void add(int n2) {
        this.ensureCapacity(this.firstFree + 1);
        this.array[this.firstFree] = n2;
        ++this.firstFree;
    }

    public final void set(int n2, int n3) {
        assert (this.firstFree > n2);
        this.array[n2] = n3;
    }

    public final void clear() {
        this.firstFree = 0;
    }

    public final int get(int n2) {
        return this.array[n2];
    }

    public final boolean contains(int n2) {
        for (int i = 0; i < this.firstFree; ++i) {
            if (this.array[i] != n2) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        try {
            IntArrayList intArrayList = (IntArrayList)super.clone();
            intArrayList.array = (int[])this.array.clone();
            return intArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }
}

