/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.mutate;

import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.errors.XCIIllegalStateException;
import com.ibm.xml.xci.res.XCIMessages;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrdinalDecimal
implements Comparable<OrdinalDecimal>,
Serializable {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = -3803058552556528432L;
    private short[] value;

    private OrdinalDecimal(short[] sArray) {
        this.value = sArray;
    }

    public OrdinalDecimal() {
        this.value = new short[1];
        this.value[0] = 1;
    }

    public OrdinalDecimal(OrdinalDecimal ordinalDecimal) {
        int n2 = ordinalDecimal.value.length;
        this.value = new short[n2];
        System.arraycopy(ordinalDecimal.value, 0, this.value, 0, n2);
    }

    public OrdinalDecimal before() {
        int n2 = this.value.length;
        short[] sArray = new short[n2 + 1];
        System.arraycopy(this.value, 0, sArray, 0, n2);
        int n3 = n2 - 1;
        sArray[n3] = (short)(sArray[n3] - 1);
        sArray[n2] = 1;
        return new OrdinalDecimal(sArray);
    }

    public OrdinalDecimal before(OrdinalDecimal ordinalDecimal) {
        return ordinalDecimal.after(this);
    }

    public OrdinalDecimal after() {
        int n2 = this.value.length;
        short[] sArray = new short[n2];
        System.arraycopy(this.value, 0, sArray, 0, n2);
        sArray = this.increment(sArray, n2 - 1);
        return new OrdinalDecimal(sArray);
    }

    private short[] matchLength(short[] sArray, int n2) {
        short[] sArray2 = sArray;
        if (sArray2.length != n2) {
            int n3 = sArray2.length < n2 ? sArray2.length : n2;
            sArray2 = new short[n2];
            System.arraycopy(sArray, 0, sArray2, 0, n3);
        }
        return sArray2;
    }

    private short[] extend(short[] sArray, int n2) {
        short[] sArray2 = this.matchLength(sArray, n2 + 1);
        sArray2[n2] = 1;
        return sArray2;
    }

    private short[] increment(short[] sArray, int n2) {
        short[] sArray2 = this.matchLength(sArray, n2 + 1);
        if (sArray2[n2] < Short.MAX_VALUE) {
            int n3 = n2;
            sArray2[n3] = (short)(sArray2[n3] + 1);
        } else {
            sArray2 = this.extend(sArray2, n2 + 1);
        }
        return sArray2;
    }

    private short[] zeroOne(short[] sArray, int n2) {
        sArray = this.matchLength(sArray, n2 + 2);
        sArray[n2] = 0;
        sArray[n2 + 1] = 1;
        return sArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OrdinalDecimal after(OrdinalDecimal ordinalDecimal) {
        int n2;
        int n3 = 0;
        int n4 = ordinalDecimal.value.length;
        int n5 = this.value.length < n4 ? this.value.length : n4;
        short[] sArray = new short[n5];
        for (n2 = 0; n3 == 0 && n2 < n5; ++n2) {
            sArray[n2] = this.value[n2];
            n3 = this.value[n2] - ordinalDecimal.value[n2];
        }
        if (n3 != 0) {
            if (n3 == -1) {
                int n6 = this.value.length;
                sArray = this.matchLength(sArray, n6 + 1);
                while (n2 < n6) {
                    sArray[n2] = this.value[n2];
                    ++n2;
                }
                sArray[n2] = 1;
                return new OrdinalDecimal(sArray);
            } else {
                if (n3 >= 0) throw new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_ORD_DEC_AFTER_ARG_SMALL", null));
                sArray = this.increment(sArray, n2 - 1);
            }
            return new OrdinalDecimal(sArray);
        } else if (this.value.length < n4) {
            short s;
            sArray = this.matchLength(sArray, n4);
            do {
                s = ordinalDecimal.value[n2];
                sArray[n2] = 0;
            } while (s == 0 && ++n2 < n4);
            if (s == 0) {
                throw new XCIIllegalStateException(XCIMessages.createXCIMessage("ER_ORD_DEC_AFTER", null));
            }
            if (s == 1) {
                sArray = this.zeroOne(sArray, n2 - 1);
                return new OrdinalDecimal(sArray);
            } else {
                sArray = this.extend(sArray, n2);
                sArray[n2] = 1;
            }
            return new OrdinalDecimal(sArray);
        } else {
            if (ordinalDecimal.value.length >= this.value.length) throw new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_ORD_DEC_AFTER_ARG_SAME", null));
            sArray = this.increment(sArray, n2 - 1);
        }
        return new OrdinalDecimal(sArray);
    }

    @Override
    public int compareTo(OrdinalDecimal ordinalDecimal) {
        int n2 = 0;
        int n3 = this.value.length < ordinalDecimal.value.length ? this.value.length : ordinalDecimal.value.length;
        for (int i = 0; n2 == 0 && i < n3; ++i) {
            n2 = this.value[i] - ordinalDecimal.value[i];
        }
        if (n2 == 0) {
            n2 = this.value.length - ordinalDecimal.value.length;
        }
        return n2;
    }

    public boolean equals(Object object2) {
        boolean bl;
        boolean bl2 = bl = object2 == this;
        if (!bl && object2 instanceof OrdinalDecimal) {
            OrdinalDecimal ordinalDecimal = (OrdinalDecimal)object2;
            bl = this.compareTo(ordinalDecimal) == 0;
        }
        return bl;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i = 0; i < this.value.length; ++i) {
            n2 += this.value[i];
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Short.toString(this.value[0]));
        for (int i = 1; i < this.value.length; ++i) {
            stringBuilder.append("." + Short.toString(this.value[i]));
        }
        return stringBuilder.toString();
    }
}

