/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.util.mutate.change;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.DocumentInfo;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.util.mutate.Item;
import com.ibm.xml.xci.dp.util.mutate.change.AttributeChange;
import com.ibm.xml.xci.dp.util.mutate.change.ItemChange;
import com.ibm.xml.xci.errors.XCIUnsupportedOperationException;
import com.ibm.xml.xci.res.XCIMessages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeRecord {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Cursor docRep;
    private List<AttributeChange> attributeChain = new ArrayList<AttributeChange>();
    private List<ItemChange> itemChain = new ArrayList<ItemChange>();

    public ChangeRecord(Cursor cursor2) {
        this.docRep = cursor2.fork(true, Cursor.Profile.TO_SELF, Cursor.Profile.TO_SELF);
        this.docRep.toSelf();
    }

    public boolean isSameDocument(Cursor cursor2) {
        boolean bl = false;
        if (cursor2 != null && cursor2.getClass() == this.docRep.getClass()) {
            bl = cursor2.itemIsSameDocument(this.docRep);
        }
        return bl;
    }

    public boolean equals(Object object2) {
        boolean bl;
        boolean bl2 = bl = object2 == this;
        if (!bl && (bl = object2 instanceof ChangeRecord)) {
            ChangeRecord changeRecord = (ChangeRecord)object2;
            bl = this.docRep.itemIsSameDocument(changeRecord.docRep);
        }
        return bl;
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        DocumentInfo documentInfo = this.docRep.itemDocumentInfo();
        return "Change record for document " + documentInfo.toString();
    }

    public synchronized void addAttribute(Item item2, VolatileCData volatileCData, VolatileCData volatileCData2) {
        if (item2.itemKind() == 1) {
            int n2 = this.findAttributeChange(item2, volatileCData);
            if (0 <= n2) {
                AttributeChange attributeChange = this.attributeChain.get(n2);
                attributeChange.setAdded(volatileCData2);
            } else {
                AttributeChange attributeChange = new AttributeChange(item2, volatileCData, volatileCData2);
                this.attributeChain.add(attributeChange);
            }
        } else {
            throw new XCIUnsupportedOperationException(XCIMessages.createXCIMessage("ER_PARENT_NOT_AN_ELEMENT", null));
        }
    }

    public synchronized boolean removeAttribute(Item item2, VolatileCData volatileCData, boolean bl) {
        if (item2.itemKind() == 1) {
            int n2 = this.findAttributeChange(item2, volatileCData);
            if (0 <= n2) {
                AttributeChange attributeChange = this.attributeChain.get(n2);
                if (attributeChange.isAdded()) {
                    if (bl) {
                        attributeChange.setRemoved();
                    } else {
                        this.attributeChain.remove(attributeChange);
                    }
                }
            } else if (bl) {
                AttributeChange attributeChange = new AttributeChange(item2, volatileCData);
                this.attributeChain.add(attributeChange);
            }
        }
        return true;
    }

    public synchronized boolean isRemovedAttribute(Item item2, VolatileCData volatileCData) {
        boolean bl = false;
        int n2 = this.findAttributeChange(item2, volatileCData);
        if (0 <= n2) {
            AttributeChange attributeChange = this.attributeChain.get(n2);
            bl = attributeChange.isRemoved();
        }
        return bl;
    }

    public synchronized List<AttributeChange> getAddedAttributes(Item item2) {
        ArrayList<AttributeChange> arrayList = null;
        for (AttributeChange attributeChange : this.attributeChain) {
            if (!attributeChange.isChange(item2) || !attributeChange.isAdded()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<AttributeChange>();
            }
            arrayList.add(attributeChange);
        }
        return arrayList;
    }

    private int findAttributeChange(Item item2, VolatileCData volatileCData) {
        int n2 = 0;
        int n3 = -1;
        Iterator<AttributeChange> iterator = this.attributeChain.iterator();
        while (n3 < 0 && iterator.hasNext()) {
            if (iterator.next().isChange(item2, volatileCData)) {
                n3 = n2;
            }
            ++n2;
        }
        return n3;
    }

    public synchronized List<ItemChange> getAddedItems(Item item2) {
        ArrayList<ItemChange> arrayList = null;
        for (ItemChange itemChange : this.itemChain) {
            if (!itemChange.hasParent(item2) || !itemChange.isAdded()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<ItemChange>();
            }
            arrayList.add(itemChange);
        }
        return arrayList;
    }

    private int findItemChange(Item item2) {
        int n2 = 0;
        int n3 = -1;
        Iterator<ItemChange> iterator = this.itemChain.iterator();
        while (n3 < 0 && iterator.hasNext()) {
            if (iterator.next().isChange(item2)) {
                n3 = n2;
            }
            ++n2;
        }
        return n3;
    }

    public void addItem(Item item2, Item item3) {
        if (item2.itemKind() == 1) {
            int n2 = this.findItemChange(item3);
            if (0 <= n2) {
                this.itemChain.remove(n2);
            }
        } else {
            throw new XCIUnsupportedOperationException(XCIMessages.createXCIMessage("ER_PARENT_NOT_AN_ELEMENT", null));
        }
        ItemChange itemChange = new ItemChange(item2, item3, true);
        this.itemChain.add(itemChange);
    }

    public void removeChild(Item item2, Item item3) {
        int n2 = this.findItemChange(item3);
        if (0 <= n2) {
            ItemChange itemChange = this.itemChain.get(n2);
            if (itemChange.isAdded()) {
                if (itemChange.hasDelegate()) {
                    itemChange.setRemoved();
                } else {
                    this.itemChain.remove(itemChange);
                }
            }
        } else {
            ItemChange itemChange = new ItemChange(item2, item3, false);
            this.itemChain.add(itemChange);
        }
    }

    public boolean isRemovedChild(Item item2, Item item3) {
        boolean bl = false;
        int n2 = this.findItemChange(item3);
        if (0 <= n2) {
            ItemChange itemChange = this.itemChain.get(n2);
            bl = itemChange.isRemovedItem();
        }
        return bl;
    }
}

