/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.values;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.dp.util.CDataCursor;
import com.ibm.xml.xci.dp.values.ArrayCData;
import com.ibm.xml.xci.dp.values.BaseCData;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.serializer.XOutputWriter;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.io.IOException;
import java.io.Writer;

public abstract class CDataListBase
extends BaseCData {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public CDataListBase(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        super(xSSimpleTypeDefinition);
    }

    public String getString(int n2) {
        return this.itemAt(n2).getString(1);
    }

    public int length() {
        if (this.toString() != null) {
            return this.toString().length();
        }
        int n2 = 0;
        for (int i = 1; i <= this.getSize(); ++i) {
            n2 += (i > 1 ? 1 : 0) + this.itemAt(i).length();
        }
        return n2;
    }

    public char charAt(int n2) {
        if (this.toString() != null) {
            return this.toString().charAt(n2);
        }
        if (n2 >= 0) {
            int n3 = this.getSize();
            int n4 = 0;
            for (int i = 1; i <= n3; ++i) {
                int n5 = n2 - n4;
                if (this.itemAt(i).hasCharAt(n5)) {
                    return this.itemAt(i).charAt(n5);
                }
                if (i >= n3) continue;
                int n6 = this.itemAt(i).length();
                if (n5 == n6) {
                    return ' ';
                }
                n4 += 1 + this.itemAt(i).length();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public CharSequence subSequence(int n2, int n3) {
        if (this.toString() != null) {
            return this.toString().subSequence(n2, n3);
        }
        if (n2 >= 0) {
            int n4 = 0;
            for (int i = 1; i <= this.getSize(); ++i) {
                CData cData = this.itemAt(i);
                int n5 = n4;
                if (n2 >= (n4 += (i > 0 ? 1 : 0) + cData.length())) continue;
                if (i == this.getSize() || n3 < n4) {
                    return cData.subSequence(n2 - n5, n3 - n5);
                }
                return super.subSequence(n2, n3);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public int writeTo(Writer writer, boolean bl) throws IOException {
        writer.write(this.toString());
        return this.toString().length();
    }

    public String toString() {
        if (this.getSize() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.itemAt(1).getString(1));
        for (int i = 2; i <= this.getSize(); ++i) {
            stringBuilder.append(' ');
            stringBuilder.append(this.itemAt(i).getString(1));
        }
        return stringBuilder.toString();
    }

    public boolean isEmpty() {
        return this.getSize() == 0 || this.getSize() == 1 && this.itemAt(1).isEmpty();
    }

    public boolean hasCharAt(int n2) {
        if (n2 < 0) {
            return false;
        }
        if (this.toString() != null) {
            return n2 < this.toString().length();
        }
        int n3 = 0;
        for (int i = 1; i <= this.getSize(); ++i) {
            if (this.itemAt(i).hasCharAt(n2 - n3)) {
                return true;
            }
            n3 += (i > 0 ? 1 : 0) + this.itemAt(i).length();
        }
        return false;
    }

    public CharSequence subSequence(int n2) {
        if (this.toString() != null) {
            return this.toString().subSequence(n2, this.toString().length());
        }
        if (n2 >= 0) {
            int n3 = 0;
            for (int i = 1; i <= this.getSize(); ++i) {
                CData cData = this.itemAt(i);
                int n4 = n3;
                if (n2 >= (n3 += (i > 0 ? 1 : 0) + cData.length())) continue;
                if (i == this.getSize()) {
                    return cData.subSequence(n2 - n4);
                }
                return new ArrayCData(this, i, n2 - n4, this.getSize(), -1);
            }
        }
        throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_INVALIDSTARTVALUE", null));
    }

    public CharSequence lexicalValue() {
        return this.getOriginalLexicalValue() != null ? this.getOriginalLexicalValue() : this.toString();
    }

    public Cursor toCursor() {
        if (this.getSize() == 0) {
            return null;
        }
        return new CDataCursor(SessionContext.getStaticSimpleDataFactory(), this);
    }

    public Cursor toCursor(CursorFactory cursorFactory) {
        if (this.getSize() == 0) {
            return null;
        }
        return new CDataCursor(cursorFactory, this);
    }

    public void write(XOutputWriter xOutputWriter, EncodeContext encodeContext, boolean bl) throws IOException {
        if (this.getSize() == 0) {
            return;
        }
        this.itemAt(1).write(xOutputWriter, encodeContext, bl);
        for (int i = 2; i <= this.getSize(); ++i) {
            xOutputWriter.writeSpace();
            this.itemAt(i).write(xOutputWriter, encodeContext, bl);
        }
    }

    public void write(XOutputWriter xOutputWriter, int n2, int n3, EncodeContext encodeContext, boolean bl) throws IOException {
        xOutputWriter.write(this.toString(), n2, n3, encodeContext);
    }
}

