/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.values;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.CDataCursor;
import com.ibm.xml.xci.dp.values.AbstractCData;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public abstract class LazyBaseCData
extends AbstractCData {
    protected CData typedValue;
    private static final Logger logger = LoggerUtil.getLogger(LazyBaseCData.class);

    protected abstract CData parse();

    public LazyBaseCData() {
        this(null);
    }

    public LazyBaseCData(CData cData) {
        this.typedValue = cData;
    }

    public Bytes getBase64Binary(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getBase64Binary(n2);
    }

    public BigDecimal getBigDecimal(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getBigDecimal(n2);
    }

    public BigInteger getBigInteger(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getBigInteger(n2);
    }

    public boolean getBoolean(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getBoolean(n2);
    }

    public byte getByte(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getByte(n2);
    }

    public double getDouble(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getDouble(n2);
    }

    public Duration getDuration(int n2) throws ParseException {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getDuration(n2);
    }

    public float getFloat(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getFloat(n2);
    }

    public Bytes getHexBinary(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getHexBinary(n2);
    }

    public int getInt(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getInt(n2);
    }

    public long getLong(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getLong(n2);
    }

    public QName getQName(int n2, NamespaceContext namespaceContext) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getQName(n2, namespaceContext);
    }

    public String getQNameLocalPart(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getQNameLocalPart(n2);
    }

    public String getQNameNamespaceURI(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getQNameNamespaceURI(n2);
    }

    public String getQNamePrefix(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getQNamePrefix(n2);
    }

    public short getShort(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getShort(n2);
    }

    public int getSize() {
        if (this.getXSTypeDefinition().getVariety() == 1) {
            return 1;
        }
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getSize();
    }

    public String getString(int n2) {
        if (this.typedValue == null) {
            switch (this.getXSTypeDefinition().getBuiltInKind()) {
                case 2: 
                case 50: {
                    if (n2 != 1) {
                        throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
                    }
                    return StringChars.toString(this.getOriginalLexicalValue());
                }
            }
            this.typedValue = this.parse();
        }
        return this.typedValue.getString(n2);
    }

    public URI getURI(int n2) throws URISyntaxException {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getURI(n2);
    }

    public String getURIString(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getURIString(n2);
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(int n2) throws ParseException {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getXMLGregorianCalendar(n2);
    }

    public XSSimpleTypeDefinition getXSTypeDefinition(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getXSTypeDefinition(n2);
    }

    public CData itemAt(int n2) {
        if (n2 == 1 && this.getXSTypeDefinition().getVariety() == 1) {
            return this;
        }
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.itemAt(n2);
    }

    public Object getObject(int n2) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        return this.typedValue.getObject(n2);
    }

    public boolean mayContain(short s) {
        if (this.typedValue == null) {
            return s != 0;
        }
        return this.typedValue.mayContain(s);
    }

    public VolatileCData stripOriginalLexicalValue(boolean bl) {
        if (this.typedValue == null) {
            this.typedValue = this.parse();
        }
        if (bl) {
            return this.typedValue;
        }
        return this.typedValue.constant(bl);
    }

    public Cursor toCursor() {
        if (this.getXSTypeDefinition().getVariety() == 1) {
            return this;
        }
        if (this.getSize() == 0) {
            return null;
        }
        return new CDataCursor(SessionContext.getStaticSimpleDataFactory(), this);
    }

    public Cursor toCursor(CursorFactory cursorFactory) {
        if (this.getXSTypeDefinition().getVariety() == 1) {
            return this;
        }
        if (this.getSize() == 0) {
            return null;
        }
        return new CDataCursor(cursorFactory, this);
    }

    public void setTypedValue(CData cData) {
        this.typedValue = cData;
        if (LoggerUtil.isFineLoggable(logger)) {
            logger.logp(Level.FINE, logger.getName(), "setTypedValue", "TypedValue set externally.  Original text: " + this.getOriginalLexicalValue() + " typedValue.toString(): " + cData.toString() + " Type: " + TypeHelper.prettyPrint(cData.getXSTypeDefinition()));
        }
    }
}

