/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.values;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.util.EmptyCData;
import com.ibm.xml.xci.dp.util.XCIErrorHelper;
import com.ibm.xml.xci.dp.util.xml.QNameUtil;
import com.ibm.xml.xci.dp.values.ArrayCData;
import com.ibm.xml.xci.dp.values.BaseCData;
import com.ibm.xml.xci.dp.values.BaseCDataWithChars;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.errors.DynamicErrorException;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.internal.cast.CastUtilities;
import com.ibm.xml.xci.internal.values.Base64BinaryCData;
import com.ibm.xml.xci.internal.values.BigDecimalCData;
import com.ibm.xml.xci.internal.values.BigIntegerCData;
import com.ibm.xml.xci.internal.values.BooleanCData;
import com.ibm.xml.xci.internal.values.ByteCData;
import com.ibm.xml.xci.internal.values.DoubleCData;
import com.ibm.xml.xci.internal.values.DurationCData;
import com.ibm.xml.xci.internal.values.FloatCData;
import com.ibm.xml.xci.internal.values.HexBinaryCData;
import com.ibm.xml.xci.internal.values.IntCData;
import com.ibm.xml.xci.internal.values.LongCData;
import com.ibm.xml.xci.internal.values.QNameCData;
import com.ibm.xml.xci.internal.values.StoredCharsCData;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.internal.values.URICData;
import com.ibm.xml.xci.internal.values.XMLGregorianCalendarCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.datatypes.XSDecimal;
import com.ibm.xml.xml4j.api.s1.xs.datatypes.XSDouble;
import com.ibm.xml.xml4j.api.s1.xs.datatypes.XSFloat;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import com.ibm.xml.xml4j.internal.s1.util.XMLChar;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class TypedValueHelper {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = LoggerUtil.getLogger(TypedValueHelper.class);

    public static CData parseAtom(CharSequence charSequence, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext, boolean bl) {
        try {
            switch (xSSimpleTypeDefinition.getBuiltInKind()) {
                case 2: 
                case 50: {
                    if (!bl) {
                        return new StringCData(charSequence, xSSimpleTypeDefinition);
                    }
                    return new StringCData((String)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition), xSSimpleTypeDefinition);
                }
                case 21: {
                    if (!bl) {
                        return new StringCData(TypedValueHelper.replace(charSequence), xSSimpleTypeDefinition);
                    }
                    return new StringCData((String)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition), xSSimpleTypeDefinition);
                }
                case 36: {
                    if (!bl) {
                        return new ByteCData(TypedValueHelper.xmlToByte(charSequence), xSSimpleTypeDefinition);
                    }
                    XSDecimal xSDecimal = (XSDecimal)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition);
                    return new ByteCData(xSDecimal.getByte(), xSSimpleTypeDefinition);
                }
                case 34: {
                    if (!bl) {
                        return IntCData.toInt(TypedValueHelper.xmlToInt(charSequence), xSSimpleTypeDefinition);
                    }
                    XSDecimal xSDecimal = (XSDecimal)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition);
                    return IntCData.toInt(xSDecimal.getInt(), xSSimpleTypeDefinition);
                }
                case 35: {
                    if (!bl) {
                        int n2 = TypedValueHelper.xmlToInt(charSequence);
                        if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
                            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(n2), xSSimpleTypeDefinition.toString(), null);
                        }
                        return IntCData.toInt(n2, xSSimpleTypeDefinition);
                    }
                    XSDecimal xSDecimal = (XSDecimal)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition);
                    return IntCData.toInt(xSDecimal.getInt(), xSSimpleTypeDefinition);
                }
                case 40: {
                    if (!bl) {
                        int n3 = TypedValueHelper.xmlToInt(charSequence);
                        if (n3 > 65535 || n3 < 0) {
                            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(n3), xSSimpleTypeDefinition.toString(), null);
                        }
                        return IntCData.toInt(n3, xSSimpleTypeDefinition);
                    }
                    XSDecimal xSDecimal = (XSDecimal)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition);
                    return IntCData.toInt(xSDecimal.getInt(), xSSimpleTypeDefinition);
                }
                case 41: {
                    if (!bl) {
                        int n4 = TypedValueHelper.xmlToInt(charSequence);
                        if (n4 > 255 || n4 < 0) {
                            throw XCIErrorHelper.createBadTypeValueException(String.valueOf(n4), xSSimpleTypeDefinition.toString(), null);
                        }
                        return IntCData.toInt(n4, xSSimpleTypeDefinition);
                    }
                    XSDecimal xSDecimal = (XSDecimal)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition);
                    return IntCData.toInt(xSDecimal.getInt(), xSSimpleTypeDefinition);
                }
                case 33: 
                case 39: {
                    if (!bl) {
                        return new LongCData(TypedValueHelper.xmlToLong(charSequence), xSSimpleTypeDefinition);
                    }
                    XSDecimal xSDecimal = (XSDecimal)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition);
                    return new LongCData(xSDecimal.getLong(), xSSimpleTypeDefinition);
                }
                case 3: {
                    if (!bl) {
                        return new BooleanCData(TypedValueHelper.xmlToBoolean(charSequence), xSSimpleTypeDefinition);
                    }
                    Boolean bl2 = (Boolean)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition);
                    return new BooleanCData(bl2, xSSimpleTypeDefinition);
                }
                case 5: {
                    if (!bl) {
                        return new FloatCData(TypedValueHelper.xmlToFloat(charSequence), xSSimpleTypeDefinition);
                    }
                    XSFloat xSFloat = (XSFloat)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition);
                    return new FloatCData(xSFloat.getValue(), xSSimpleTypeDefinition);
                }
                case 6: {
                    if (!bl) {
                        return new DoubleCData(TypedValueHelper.xmlToDouble(charSequence), xSSimpleTypeDefinition);
                    }
                    XSDouble xSDouble = (XSDouble)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition);
                    return new DoubleCData(xSDouble.getValue(), xSSimpleTypeDefinition);
                }
                case 4: {
                    if (!bl) {
                        return new BigDecimalCData(TypedValueHelper.xmlToDecimal(charSequence), xSSimpleTypeDefinition);
                    }
                    XSDecimal xSDecimal = (XSDecimal)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition);
                    return new BigDecimalCData(xSDecimal.getBigDecimal(), xSSimpleTypeDefinition);
                }
                case 30: 
                case 31: 
                case 32: 
                case 37: 
                case 38: 
                case 42: {
                    if (!bl) {
                        return new BigIntegerCData(TypedValueHelper.xmlToInteger(charSequence), xSSimpleTypeDefinition);
                    }
                    XSDecimal xSDecimal = (XSDecimal)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition);
                    return new BigIntegerCData(xSDecimal.getBigInteger(), xSSimpleTypeDefinition);
                }
                case 17: {
                    if (!bl) {
                        return new Base64BinaryCData(TypedValueHelper.trim(charSequence), xSSimpleTypeDefinition);
                    }
                    CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition);
                    return new Base64BinaryCData(charSequence, xSSimpleTypeDefinition);
                }
                case 16: {
                    if (!bl) {
                        return new HexBinaryCData(TypedValueHelper.trim(charSequence), xSSimpleTypeDefinition);
                    }
                    CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition);
                    return new HexBinaryCData(charSequence, xSSimpleTypeDefinition);
                }
                case 18: {
                    if (!bl) {
                        return new URICData(TypedValueHelper.collapse(charSequence), xSSimpleTypeDefinition);
                    }
                    return new URICData((String)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition), xSSimpleTypeDefinition);
                }
                case 19: {
                    return new QNameCData(QNameUtil.toQName(namespaceContext, StringChars.toString(TypedValueHelper.trim(charSequence))), xSSimpleTypeDefinition);
                }
                case 22: {
                    if (!bl) {
                        return new StringCData(TypedValueHelper.collapse(charSequence), xSSimpleTypeDefinition);
                    }
                    return new StringCData((String)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition), xSSimpleTypeDefinition);
                }
                case 23: {
                    if (!bl) {
                        return new StringCData((String)CastUtilities.validate(StringChars.toString(charSequence), TypeRegistry.XSLANGUAGE), xSSimpleTypeDefinition);
                    }
                    return new StringCData((String)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition), xSSimpleTypeDefinition);
                }
                case 24: {
                    if (!bl) {
                        String string2 = StringChars.toString(TypedValueHelper.trim(charSequence));
                        if (XMLChar.isValidNmtoken(string2)) {
                            return new StringCData(string2, xSSimpleTypeDefinition);
                        }
                        throw XCIErrorHelper.createBadTypeValueException(string2, TypeHelper.prettyPrint(xSSimpleTypeDefinition), null);
                    }
                    return new StringCData((String)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition), xSSimpleTypeDefinition);
                }
                case 25: {
                    if (!bl) {
                        String string3 = StringChars.toString(TypedValueHelper.trim(charSequence));
                        if (XMLChar.isValidName(string3)) {
                            return new StringCData(string3, xSSimpleTypeDefinition);
                        }
                        throw XCIErrorHelper.createBadTypeValueException(string3, TypeHelper.prettyPrint(xSSimpleTypeDefinition), null);
                    }
                    return new StringCData((String)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition), xSSimpleTypeDefinition);
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    if (!bl) {
                        String string4 = StringChars.toString(TypedValueHelper.trim(charSequence));
                        if (XMLChar.isValidNCName(string4)) {
                            return new StringCData(string4, xSSimpleTypeDefinition);
                        }
                        throw XCIErrorHelper.createBadTypeValueException(string4, TypeHelper.prettyPrint(xSSimpleTypeDefinition), null);
                    }
                    return new StringCData((String)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition), xSSimpleTypeDefinition);
                }
                case 20: {
                    if (!bl) {
                        return new StringCData(TypedValueHelper.trim(charSequence), xSSimpleTypeDefinition);
                    }
                    return new StringCData((String)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition), xSSimpleTypeDefinition);
                }
                case 7: {
                    if (!bl) {
                        return new DurationCData(BaseCData.javaxFactory.newDuration(StringChars.toString(TypedValueHelper.trim(charSequence))), xSSimpleTypeDefinition);
                    }
                    return new DurationCData((Duration)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition), xSSimpleTypeDefinition);
                }
                case 46: {
                    if (!bl) {
                        return new DurationCData(BaseCData.javaxFactory.newDurationYearMonth(StringChars.toString(TypedValueHelper.trim(charSequence))), xSSimpleTypeDefinition);
                    }
                    return new DurationCData((Duration)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition), xSSimpleTypeDefinition);
                }
                case 47: {
                    if (!bl) {
                        return new DurationCData(BaseCData.javaxFactory.newDurationDayTime(StringChars.toString(TypedValueHelper.trim(charSequence))), xSSimpleTypeDefinition);
                    }
                    return new DurationCData((Duration)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition), xSSimpleTypeDefinition);
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    if (!bl) {
                        try {
                            XMLGregorianCalendar xMLGregorianCalendar = BaseCData.javaxFactory.newXMLGregorianCalendar(StringChars.toString(TypedValueHelper.trim(charSequence)));
                            if (TypedValueHelper.hasExpectedBuiltInKind(xSSimpleTypeDefinition.getBuiltInKind(), xMLGregorianCalendar)) {
                                return new XMLGregorianCalendarCData(xMLGregorianCalendar, xSSimpleTypeDefinition);
                            }
                            throw XCIErrorHelper.createBadTypeValueException(StringChars.toString(charSequence), xSSimpleTypeDefinition.toString(), null);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw XCIErrorHelper.createBadTypeValueException(StringChars.toString(charSequence), xSSimpleTypeDefinition.toString(), illegalArgumentException);
                        }
                    }
                    return new XMLGregorianCalendarCData((XMLGregorianCalendar)CastUtilities.validate(StringChars.toString(charSequence), xSSimpleTypeDefinition), xSSimpleTypeDefinition);
                }
            }
            throw new DynamicErrorException("XXTY0008", (CharSequence)(xSSimpleTypeDefinition.getName() + " kind:" + xSSimpleTypeDefinition.getBuiltInKind()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new XCIDynamicErrorException("ER_INVALID_CAST_NUMERIC", null, numberFormatException);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw XCIErrorHelper.createBadTypeValueException(StringChars.toString(charSequence), TypeHelper.prettyPrint(xSSimpleTypeDefinition), invalidDatatypeValueException);
        }
    }

    public static CData parseList(CharSequence charSequence, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext, boolean bl) {
        int n2 = charSequence.length();
        if (n2 > 0) {
            int n3 = 0;
            int n4 = 0;
            ArrayList<CData> arrayList = new ArrayList<CData>();
            while (n3 < n2) {
                for (n3 = n4; n3 < n2 && XMLChar.isSpace(charSequence.charAt(n3)); ++n3) {
                }
                if (n3 == n2) break;
                for (n4 = n3 + 1; n4 < n2 && !XMLChar.isSpace(charSequence.charAt(n4)); ++n4) {
                }
                arrayList.add(TypedValueHelper.parseAtom(charSequence.subSequence(n3, n4), xSSimpleTypeDefinition.getItemType(), namespaceContext, bl));
                n3 = n4 + 1;
            }
            CData[] cDataArray = new CData[arrayList.size()];
            cDataArray = arrayList.toArray(cDataArray);
            return new ArrayCData(cDataArray, xSSimpleTypeDefinition);
        }
        return new EmptyCData(xSSimpleTypeDefinition);
    }

    public static CData parse(SessionContext sessionContext, CharSequence charSequence, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext, boolean bl) {
        if (charSequence == null) {
            throw new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_NULLARG_CHARSEQ", null));
        }
        if (xSSimpleTypeDefinition == null) {
            throw new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_NULLARG_TYPE", null));
        }
        if (TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSSTRING)) {
            return new StringCData(charSequence, xSSimpleTypeDefinition);
        }
        if (xSSimpleTypeDefinition.getBuiltInKind() == 50) {
            return new StoredCharsCData(CharsBase.toChars(charSequence), xSSimpleTypeDefinition);
        }
        if (!bl && namespaceContext == null && !(charSequence instanceof CData)) {
            return new BaseCDataWithChars(xSSimpleTypeDefinition, CharsBase.toChars(charSequence).constant(true));
        }
        switch (xSSimpleTypeDefinition.getVariety()) {
            case 1: {
                if (charSequence instanceof CData) {
                    return CastUtilities.castAtomic(sessionContext.getSimpleDataFactory(), (CData)charSequence, xSSimpleTypeDefinition, namespaceContext, bl);
                }
                return new BaseCDataWithChars(xSSimpleTypeDefinition, CharsBase.toChars(charSequence).constant(false), TypedValueHelper.parseAtom(charSequence, xSSimpleTypeDefinition, namespaceContext, bl));
            }
            case 2: {
                return new BaseCDataWithChars(xSSimpleTypeDefinition, CharsBase.toChars(charSequence).constant(false), TypedValueHelper.parseList(charSequence, xSSimpleTypeDefinition, namespaceContext, bl));
            }
            case 3: {
                return new BaseCDataWithChars(xSSimpleTypeDefinition, CharsBase.toChars(charSequence).constant(false), TypedValueHelper.parseUnion(charSequence, xSSimpleTypeDefinition, namespaceContext, bl));
            }
        }
        throw new XCIIllegalArgumentException(XCIMessages.createXCIMessage("ER_NONATOMICARG_TYPE", null));
    }

    public static CData parseUnion(CharSequence charSequence, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext, boolean bl) {
        try {
            CastUtilities.validate(((Object)charSequence).toString(), xSSimpleTypeDefinition);
            return TypedValueHelper.parseAtom(charSequence, CastUtilities.validatedInfos.get().memberType, namespaceContext, false);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            if (LoggerUtil.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, logger.getName(), "parseUnion", "Data=" + ((Object)charSequence).toString() + " is not valid for type=" + xSSimpleTypeDefinition.toString());
            }
            if (bl) {
                throw XCIErrorHelper.createInternalException(invalidDatatypeValueException);
            }
            return new StoredCharsCData(StringChars.toChars(charSequence), xSSimpleTypeDefinition);
        }
    }

    public static boolean xmlToBoolean(CharSequence charSequence) {
        String string2 = StringChars.toString(TypedValueHelper.trim(charSequence));
        if (string2.equals("true") || string2.equals("1")) {
            return true;
        }
        if (string2.equals("false") || string2.equals("0")) {
            return false;
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{TypeRegistry.XSBOOLEAN.toString(), TypeRegistry.XSSTRING.toString()});
    }

    public static double xmlToDouble(CharSequence charSequence) {
        if ((charSequence = TypedValueHelper.trim(charSequence)).length() == 0) {
            throw new NumberFormatException(XCIMessages.createXCIMessage("ER_ZEROLENGTH", null));
        }
        String string2 = StringChars.toString(charSequence);
        if ("INF".equals(string2)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-INF".equals(string2)) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(string2);
    }

    public static float xmlToFloat(CharSequence charSequence) {
        if ((charSequence = TypedValueHelper.trim(charSequence)).length() == 0) {
            throw new NumberFormatException(XCIMessages.createXCIMessage("ER_ZEROLENGTH", null));
        }
        String string2 = StringChars.toString(charSequence);
        if ("INF".equals(string2)) {
            return Float.POSITIVE_INFINITY;
        }
        if ("-INF".equals(string2)) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(string2);
    }

    public static int xmlToInt(CharSequence charSequence) {
        charSequence = TypedValueHelper.trim(charSequence);
        try {
            if (charSequence.charAt(0) == '+') {
                charSequence = charSequence.subSequence(1, charSequence.length());
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new NumberFormatException(XCIMessages.createXCIMessage("ER_ZEROLENGTH", null));
        }
        return Integer.parseInt(StringChars.toString(charSequence));
    }

    public static long xmlToLong(CharSequence charSequence) {
        charSequence = TypedValueHelper.trim(charSequence);
        try {
            if (charSequence.charAt(0) == '+') {
                charSequence = charSequence.subSequence(1, charSequence.length());
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new NumberFormatException(XCIMessages.createXCIMessage("ER_ZEROLENGTH", null));
        }
        return Long.parseLong(StringChars.toString(charSequence));
    }

    public static short xmlToShort(CharSequence charSequence) {
        charSequence = TypedValueHelper.trim(charSequence);
        try {
            if (charSequence.charAt(0) == '+') {
                charSequence = charSequence.subSequence(1, charSequence.length());
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new NumberFormatException(XCIMessages.createXCIMessage("ER_ZEROLENGTH", null));
        }
        return Short.parseShort(StringChars.toString(charSequence));
    }

    public static byte xmlToByte(CharSequence charSequence) {
        charSequence = TypedValueHelper.trim(charSequence);
        try {
            if (charSequence.charAt(0) == '+') {
                charSequence = charSequence.subSequence(1, charSequence.length());
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new NumberFormatException(XCIMessages.createXCIMessage("ER_ZEROLENGTH", null));
        }
        return Byte.parseByte(StringChars.toString(charSequence));
    }

    public static BigDecimal xmlToDecimal(CharSequence charSequence) {
        if ((charSequence = TypedValueHelper.trim(charSequence)).length() == 0) {
            throw new NumberFormatException(XCIMessages.createXCIMessage("ER_ZEROLENGTH", null));
        }
        return new BigDecimal(StringChars.toString(charSequence));
    }

    public static BigInteger xmlToInteger(CharSequence charSequence) {
        charSequence = TypedValueHelper.trim(charSequence);
        try {
            if (charSequence.charAt(0) == '+') {
                charSequence = charSequence.subSequence(1, charSequence.length());
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new NumberFormatException(XCIMessages.createXCIMessage("ER_ZEROLENGTH", null));
        }
        return new BigInteger(StringChars.toString(charSequence));
    }

    public static CharSequence trim(CharSequence charSequence) {
        int n2;
        int n3;
        int n4 = charSequence.length() - 1;
        for (n3 = 0; n3 <= n4 && XMLChar.isSpace(charSequence.charAt(n3)); ++n3) {
        }
        for (n2 = n4; n2 >= n3 && XMLChar.isSpace(charSequence.charAt(n2)); --n2) {
        }
        if (n3 == 0 && n2 == n4) {
            return charSequence;
        }
        if (n3 > n4) {
            return "";
        }
        return charSequence.subSequence(n3, n2 + 1);
    }

    public static CharSequence replace(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i = 0; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c >= ' ' || c != '\t' && c != '\n' && c != '\r') continue;
            return TypedValueHelper.replace0(charSequence, i, n2);
        }
        return charSequence;
    }

    private static CharSequence replace0(CharSequence charSequence, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(n3);
        if (n2 > 0) {
            stringBuilder.append(charSequence, 0, n2);
        }
        stringBuilder.append(' ');
        while (++n2 < n3) {
            char c = charSequence.charAt(n2);
            if (c < ' ' && (c == '\t' || c == '\n' || c == '\r')) {
                stringBuilder.append(' ');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static CharSequence collapse(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i = 0; i < n2; ++i) {
            if (!XMLChar.isSpace(charSequence.charAt(i))) continue;
            return TypedValueHelper.collapse0(charSequence, i, n2);
        }
        return charSequence;
    }

    private static CharSequence collapse0(CharSequence charSequence, int n2, int n3) {
        char c;
        StringBuilder stringBuilder = null;
        boolean bl = false;
        if (n2 > 0) {
            bl = true;
            stringBuilder = new StringBuilder();
            stringBuilder.append(charSequence, 0, n2);
        } else {
            while (++n2 < n3) {
                c = charSequence.charAt(n2);
                if (XMLChar.isSpace(c)) continue;
                stringBuilder = new StringBuilder();
                stringBuilder.append(c);
                break;
            }
            if (n2 == n3) {
                return "";
            }
        }
        while (++n2 < n3) {
            c = charSequence.charAt(n2);
            if (!XMLChar.isSpace(c)) {
                if (bl) {
                    stringBuilder.append(' ');
                    bl = false;
                }
                stringBuilder.append(c);
                continue;
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    public static boolean hasExpectedBuiltInKind(int n2, XMLGregorianCalendar xMLGregorianCalendar) {
        QName qName = xMLGregorianCalendar.getXMLSchemaType();
        switch (n2) {
            case 8: {
                return DatatypeConstants.DATETIME == qName;
            }
            case 9: {
                return DatatypeConstants.TIME == qName;
            }
            case 10: {
                return DatatypeConstants.DATE == qName;
            }
            case 11: {
                return DatatypeConstants.GYEARMONTH == qName;
            }
            case 12: {
                return DatatypeConstants.GYEAR == qName;
            }
            case 13: {
                return DatatypeConstants.GMONTHDAY == qName;
            }
            case 14: {
                return DatatypeConstants.GDAY == qName;
            }
        }
        return DatatypeConstants.GMONTH == qName;
    }

    public static CData createCDataFromText(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        return new StringCData(string2, xSSimpleTypeDefinition);
    }
}

