/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.values.chars;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.bytes.BytesUtils;
import com.ibm.xml.xci.dp.values.chars.CharBufferChars;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.serializer.WriterToUTF8Buffered;
import com.ibm.xml.xci.serializer.XOutputWriter;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.internal.s1.util.XMLChar;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;

public abstract class CharsBase
implements Chars {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static Chars toChars(CharSequence charSequence) {
        if (charSequence == null || charSequence instanceof Chars) {
            return (Chars)charSequence;
        }
        if (charSequence instanceof String) {
            return new StringChars((String)charSequence);
        }
        return CharBufferChars.make(charSequence);
    }

    public boolean isEmpty() {
        return !this.hasCharAt(0);
    }

    public boolean hasCharAt(int n2) {
        return n2 >= 0 && n2 < this.length();
    }

    public CharSequence subSequence(int n2) {
        return this.subSequence(n2, this.length());
    }

    public int indexOf(CharSequence charSequence, int n2) {
        if (charSequence == null) {
            return 0;
        }
        int n3 = charSequence.length() - 1;
        if (n2 < 0 || n2 > 0 && !this.hasCharAt(n2 - 1)) {
            return -1;
        }
        if (n3 < 0) {
            return n2;
        }
        int n4 = n2 + n3;
        while (this.hasCharAt(n4)) {
            block5: {
                int n5 = n3;
                int n6 = n4;
                if (!this.hasCharAt(n6)) break;
                while (n5 >= 0) {
                    if (charSequence.charAt(n5--) == this.charAt(n6--)) continue;
                    break block5;
                }
                return n6 + 1;
            }
            ++n4;
        }
        return -1;
    }

    public boolean startsWith(CharSequence charSequence) {
        if (charSequence == null) {
            return true;
        }
        if (charSequence instanceof Chars) {
            Chars chars = (Chars)charSequence;
            int n2 = 0;
            while (chars.hasCharAt(n2)) {
                if (!this.hasCharAt(n2) || chars.charAt(n2) != this.charAt(n2)) {
                    return false;
                }
                ++n2;
            }
        } else {
            int n3 = charSequence.length();
            for (int i = 0; i < n3; ++i) {
                if (this.hasCharAt(i) && charSequence.charAt(i) == this.charAt(i)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean endsWith(CharSequence charSequence) {
        if (charSequence == null) {
            return true;
        }
        int n2 = this.length();
        int n3 = charSequence.length();
        if (n3 > n2) {
            return false;
        }
        if (n2 >= n3) {
            while (n3 > 0) {
                if (this.charAt(--n2) == charSequence.charAt(--n3)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean sameAs(CharSequence charSequence) {
        return charSequence != null && this.length() == charSequence.length() && this.endsWith(charSequence);
    }

    public boolean containsAt(CharSequence charSequence, int n2) {
        if (charSequence == null || charSequence.length() == 0) {
            return true;
        }
        int n3 = n2 + charSequence.length() - 1;
        if (!this.hasCharAt(n3)) {
            return false;
        }
        int n4 = n2;
        int n5 = 0;
        while (n4 <= n3) {
            if (this.charAt(n4) != charSequence.charAt(n5)) {
                return false;
            }
            ++n4;
            ++n5;
        }
        return true;
    }

    public char[] toCharArray() {
        return StringChars.toString(this.lexicalValue()).toCharArray();
    }

    public int toCharArray(char[] cArray, int n2) {
        String string2 = StringChars.toString(this.lexicalValue());
        int n3 = string2.length();
        string2.getChars(0, n3, cArray, n2);
        return n3;
    }

    public Reader toReader(boolean bl) {
        return new StringReader(StringChars.toString(this.lexicalValue()));
    }

    public void writeEncodedBytesTo(OutputStream outputStream, Charset charset, boolean bl) throws IOException {
        if (charset == null) {
            outputStream.write(StringChars.toString(this.lexicalValue()).getBytes());
        } else {
            outputStream.write(StringChars.toString(this.lexicalValue()).getBytes(charset.name()));
        }
    }

    public char charAt(int n2) {
        return this.lexicalValue().charAt(n2);
    }

    public int length() {
        return this.lexicalValue().length();
    }

    public CharSequence subSequence(int n2, int n3) {
        return this.lexicalValue().subSequence(n2, n3);
    }

    public int compareTo(Object object2) {
        if (this == object2) {
            return 0;
        }
        if (object2 instanceof Chars) {
            Chars chars = (Chars)object2;
            int n2 = 0;
            while (this.hasCharAt(n2) && chars.hasCharAt(n2)) {
                char c;
                char c2 = this.charAt(n2);
                if (c2 == (c = chars.charAt(n2))) {
                    ++n2;
                    continue;
                }
                if (c2 < c) {
                    return -1;
                }
                return 1;
            }
            if (this.hasCharAt(n2)) {
                return 1;
            }
            if (chars.hasCharAt(n2)) {
                return -1;
            }
            return 0;
        }
        throw new ClassCastException(XCIMessages.createXCIMessage("ER_COMPARECHARS", null));
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isOptimizedFor(String string2, short s) {
        return false;
    }

    public Chars constant(boolean bl) {
        if (this.isConstant()) {
            return this;
        }
        return new StringChars(StringChars.toString(this.lexicalValue()));
    }

    public Chars constant(String string2, short s, boolean bl) {
        return this.constant(bl);
    }

    public abstract CharSequence lexicalValue();

    public String toString() {
        return StringChars.toString(this.lexicalValue());
    }

    public boolean equals(Object object2) {
        return this == object2 || object2 != null && this.toString().equals(object2.toString());
    }

    public int hashCode() {
        return StringChars.toString(this.lexicalValue()).hashCode();
    }

    public static String toEncodedString(CData cData) {
        StringWriter stringWriter = new StringWriter();
        try {
            CharsBase.writeAttributeValueString(stringWriter, cData);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static void writeAttributeValueString(Appendable appendable, CData cData) throws IOException {
        if (!cData.mayContain((short)141)) {
            appendable.append("\"");
            appendable.append(cData);
            appendable.append("\"");
            return;
        }
        if (!cData.mayContain((short)139)) {
            appendable.append("'");
            appendable.append(cData);
            appendable.append("'");
            return;
        }
        appendable.append("\"");
        CharsBase.writeEncodedString(appendable, cData, (short)141);
        appendable.append("\"");
    }

    public static void writeEncodedString(Appendable appendable, Chars chars, short s) throws IOException {
        int n2 = chars.length();
        block11: for (int i = 0; i < n2; ++i) {
            char c = chars.charAt(i);
            switch (c) {
                case '<': {
                    if ((s & 1) > 0) {
                        appendable.append("&lt;");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '>': {
                    if ((s & 1) > 0) {
                        appendable.append("&gt;");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '\"': {
                    if ((s & 4) > 0) {
                        appendable.append("&quot;");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '\'': {
                    if ((s & 2) > 0) {
                        appendable.append("&apos;");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '&': {
                    appendable.append("&amp;");
                    continue block11;
                }
                case '\r': {
                    if ((s & 0x40) > 0) {
                        appendable.append("&#");
                        appendable.append(Integer.toString(c));
                        appendable.append(";");
                        continue block11;
                    }
                }
                case '\t': 
                case '\n': {
                    if ((s & 8) > 0) {
                        appendable.append("&#");
                        appendable.append(Integer.toString(c));
                        appendable.append(";");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\f': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    appendable.append("&#");
                    appendable.append(Integer.toString(c));
                    appendable.append(";");
                    continue block11;
                }
                case '\u0085': 
                case '\u2028': {
                    if ((s & 0x80) > 0) {
                        appendable.append("&#x");
                        appendable.append(Integer.toHexString(c));
                        appendable.append(";");
                        continue block11;
                    }
                }
                default: {
                    appendable.append(c);
                }
            }
        }
    }

    public static void writeEncodedString(Appendable appendable, CharSequence charSequence, short s) throws IOException {
        int n2 = charSequence.length();
        block11: for (int i = 0; i < n2; ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '<': {
                    if ((s & 1) > 0) {
                        appendable.append("&lt;");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '>': {
                    if ((s & 1) > 0) {
                        appendable.append("&gt;");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '\"': {
                    if ((s & 4) > 0) {
                        appendable.append("&quot;");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '\'': {
                    if ((s & 2) > 0) {
                        appendable.append("&apos;");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '&': {
                    appendable.append("&amp;");
                    continue block11;
                }
                case '\r': {
                    if ((s & 0x40) > 0) {
                        appendable.append("&#");
                        appendable.append(Integer.toString(c));
                        appendable.append(";");
                        continue block11;
                    }
                }
                case '\t': 
                case '\n': {
                    if ((s & 8) > 0) {
                        appendable.append("&#");
                        appendable.append(Integer.toString(c));
                        appendable.append(";");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\f': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    appendable.append("&#");
                    appendable.append(Integer.toString(c));
                    appendable.append(";");
                    continue block11;
                }
                case '\u0085': 
                case '\u2028': {
                    if ((s & 0x80) > 0) {
                        appendable.append("&#x");
                        appendable.append(Integer.toHexString(c));
                        appendable.append(";");
                        continue block11;
                    }
                }
                default: {
                    appendable.append(c);
                }
            }
        }
    }

    public boolean mayContain(short s) {
        return s != 0;
    }

    public Chars quote(short s) {
        if (this.mayContain(s)) {
            StringWriter stringWriter = new StringWriter();
            try {
                CharsBase.writeEncodedString((Appendable)stringWriter, CharBufferChars.make(this.lexicalValue()), s);
                stringWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new StringCData(stringWriter.toString(), TypeRegistry.XSSTRING);
        }
        return CharBufferChars.make(this.lexicalValue());
    }

    public boolean isSpace() {
        int n2 = this.length();
        for (int i = 0; i < n2; ++i) {
            if (XMLChar.isSpace(this.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void write(XOutputWriter xOutputWriter, EncodeContext encodeContext, boolean bl) throws IOException {
        xOutputWriter.write(this, encodeContext);
    }

    public void write(XOutputWriter xOutputWriter, int n2, int n3, EncodeContext encodeContext, boolean bl) throws IOException {
        xOutputWriter.write(this, n2, n3, encodeContext);
    }

    public int writeEncodedBytesTo(int n2, byte[] byArray, int n3, String string2, short s, boolean bl) {
        return this.quote(s).toEncodedBytes(string2).writeBytesTo(n2, byArray, n3, bl);
    }

    public int writeTo(Writer writer, boolean bl) throws IOException {
        String string2 = StringChars.toString(this.lexicalValue());
        writer.write(string2);
        return string2.length();
    }

    public int appendQuotedTo(Appendable appendable, short s, boolean bl) throws IOException {
        Chars chars = this.quote(s);
        assert (chars != null);
        appendable.append(chars);
        return chars.length();
    }

    public void writeEncodedBytesTo(OutputStream outputStream, String string2, short s, boolean bl) throws IOException {
        if (outputStream instanceof WriterToUTF8Buffered.AsOutputStream && string2 != null && string2.equals("UTF-8")) {
            WriterToUTF8Buffered.AsOutputStream asOutputStream = (WriterToUTF8Buffered.AsOutputStream)outputStream;
            WriterToUTF8Buffered writerToUTF8Buffered = asOutputStream.getAssociatedWriter();
            writerToUTF8Buffered.write(StringChars.toString(this.lexicalValue()));
            return;
        }
        this.quote(s).toEncodedBytes(string2).writeBytesTo(outputStream, bl);
    }

    public Bytes toEncodedBytes(String string2) {
        try {
            return BytesUtils.make(StringChars.toString(this.lexicalValue()).getBytes(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public int needsEscaping(byte[] byArray) {
        char c;
        int n2;
        int n3 = this.length();
        for (n2 = 0; n2 < n3 && (c = this.charAt(n2)) < byArray.length && byArray[c] == 0; ++n2) {
        }
        if (n2 == n3) {
            return -1;
        }
        return n2;
    }

    public int needsEscaping(int n2, int n3, byte[] byArray) {
        char c;
        int n4;
        for (n4 = n2; n4 < n3 && (c = this.charAt(n4)) < byArray.length && byArray[c] == 0; ++n4) {
        }
        if (n4 == n3) {
            return -1;
        }
        return n4;
    }
}

