/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.values.chars;

import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.dp.values.chars.WhitespaceCharsConstant;
import com.ibm.xml.xci.serializer.XOutputWriter;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;

public class CharsSimpleContent
extends CharsBase {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    VolatileCData cdata;
    Chars separator;
    static Chars defaultSep = WhitespaceCharsConstant.whitespaceConstants[1];

    public static Chars make(VolatileCData volatileCData, Chars chars) {
        XSSimpleTypeDefinition xSSimpleTypeDefinition = volatileCData.getXSTypeDefinition();
        VolatileCData volatileCData2 = xSSimpleTypeDefinition == TypeRegistry.XSSTRING || xSSimpleTypeDefinition == TypeRegistry.XSUNTYPEDATOMIC ? volatileCData : volatileCData.stripOriginalLexicalValue(false);
        return new CharsSimpleContent(volatileCData2, chars);
    }

    private CharsSimpleContent(VolatileCData volatileCData, Chars chars) {
        assert (volatileCData != null);
        assert (chars != null);
        this.cdata = volatileCData.stripOriginalLexicalValue(false);
        this.separator = chars;
    }

    public CharSequence lexicalValue() {
        CharSequence charSequence;
        if (this.cdata.getSize() == 1) {
            return this.cdata.getString(1);
        }
        if (this.cdata.isEmptySequence()) {
            charSequence = "";
        } else if (this.separator.isEmpty()) {
            charSequence = this.cdata.getString(1);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.cdata.getString(1));
            for (int i = 2; i <= this.cdata.getSize(); ++i) {
                stringBuilder.append(this.separator);
                stringBuilder.append(this.cdata.getString(i));
            }
            charSequence = stringBuilder;
        }
        return charSequence;
    }

    public int appendQuotedTo(Appendable appendable, short s, boolean bl) throws IOException {
        return super.appendQuotedTo(appendable, s, bl);
    }

    public int writeEncodedBytesTo(int n2, byte[] byArray, int n3, String string2, short s, boolean bl) {
        return super.writeEncodedBytesTo(n2, byArray, n3, string2, s, bl);
    }

    public void writeEncodedBytesTo(OutputStream outputStream, Charset charset, boolean bl) throws IOException {
        super.writeEncodedBytesTo(outputStream, charset, bl);
    }

    public void writeEncodedBytesTo(OutputStream outputStream, String string2, short s, boolean bl) throws IOException {
        super.writeEncodedBytesTo(outputStream, string2, s, bl);
    }

    public int writeTo(Writer writer, boolean bl) throws IOException {
        return super.writeTo(writer, bl);
    }

    public void write(XOutputWriter xOutputWriter, EncodeContext encodeContext, boolean bl) throws IOException {
        if (this.cdata.getSize() == 1) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition = this.cdata.getXSTypeDefinition();
            if (xSSimpleTypeDefinition == TypeRegistry.XSSTRING || xSSimpleTypeDefinition == TypeRegistry.XSUNTYPEDATOMIC) {
                this.cdata.write(xOutputWriter, encodeContext, bl);
            } else {
                xOutputWriter.write(this.cdata.getString(1), encodeContext);
            }
        } else {
            xOutputWriter.write(this.cdata.getString(1), encodeContext);
            for (int i = 2; i <= this.cdata.getSize(); ++i) {
                xOutputWriter.write(this.separator, encodeContext);
                xOutputWriter.write(this.cdata.getString(i), encodeContext);
            }
        }
    }

    public void write(XOutputWriter xOutputWriter, int n2, int n3, EncodeContext encodeContext, boolean bl) throws IOException {
        if (this.cdata.getSize() == 1) {
            this.cdata.write(xOutputWriter, n2, n3, encodeContext, bl);
            XSSimpleTypeDefinition xSSimpleTypeDefinition = this.cdata.getXSTypeDefinition();
            if (xSSimpleTypeDefinition == TypeRegistry.XSSTRING || xSSimpleTypeDefinition == TypeRegistry.XSUNTYPEDATOMIC) {
                this.cdata.write(xOutputWriter, n2, n3, encodeContext, bl);
            } else {
                xOutputWriter.write(this.cdata.getString(1), n2, n3, encodeContext);
            }
        } else {
            super.write(xOutputWriter, n2, n3, encodeContext, bl);
        }
    }

    public boolean isEmpty() {
        if (this.cdata.getSize() == 1) {
            return this.cdata.isEmpty();
        }
        return this.lexicalValue().length() == 0;
    }
}

