/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.values.chars;

import com.ibm.xml.xci.serializer.CharEscapeMaps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EncodeContext {
    NAME(0, CharEscapeMaps.NAME),
    PCDATA(33, CharEscapeMaps.ELEMENT),
    PCDATA_ROUNDTRIP(225, CharEscapeMaps.ELEMENT),
    ATTRIBUTE_SINGLE_QUOTE(139, CharEscapeMaps.ATTRIBUTE),
    ATTRIBUTE_DOUBLE_QUOTE(141, CharEscapeMaps.ATTRIBUTE),
    PI(0, CharEscapeMaps.PI),
    COMMENT(0, CharEscapeMaps.COMMENT),
    NAMESPACE(0, CharEscapeMaps.ATTRIBUTE),
    CDATASECTION(0, CharEscapeMaps.CDATA),
    NOTHING(0, CharEscapeMaps.NOTHING),
    HTML_NAME(NAME, false, true),
    HTML_PCDATA(PCDATA, false, true),
    HTML_PCDATA_ROUNDTRIP(PCDATA_ROUNDTRIP, false, true),
    HTML_ATTRIBUTE_SINGLE_QUOTE(ATTRIBUTE_SINGLE_QUOTE, false, true),
    HTML_ATTRIBUTE_DOUBLE_QUOTE(ATTRIBUTE_DOUBLE_QUOTE, false, true),
    HTML_PI(PI, false, true),
    HTML_COMMENT(COMMENT, false, true),
    HTML_NAMESPACE(NAMESPACE, false, true),
    HTML_CDATASECTION(CDATASECTION, false, true),
    HTML_NOTHING(NOTHING, false, true),
    ASCII_NAME(NAME, true, false),
    ASCII_PCDATA(PCDATA, true, false),
    ASCII_PCDATA_ROUNDTRIP(PCDATA_ROUNDTRIP, true, false),
    ASCII_ATTRIBUTE_SINGLE_QUOTE(ATTRIBUTE_SINGLE_QUOTE, true, false),
    ASCII_ATTRIBUTE_DOUBLE_QUOTE(ATTRIBUTE_DOUBLE_QUOTE, true, false),
    ASCII_PI(PI, true, false),
    ASCII_COMMENT(COMMENT, true, false),
    ASCII_NAMESPACE(NAMESPACE, true, false),
    ASCII_CDATASECTION(CDATASECTION, false, true),
    ASCII_NOTHING(NOTHING, false, true),
    HTML_ASCII_NAME(NAME, true, true),
    HTML_ASCII_PCDATA(PCDATA, true, true),
    HTML_ASCII_PCDATA_ROUNDTRIP(PCDATA_ROUNDTRIP, true, true),
    HTML_ASCII_ATTRIBUTE_SINGLE_QUOTE(ATTRIBUTE_SINGLE_QUOTE, true, true),
    HTML_ASCII_ATTRIBUTE_DOUBLE_QUOTE(ATTRIBUTE_DOUBLE_QUOTE, true, true),
    HTML_ASCII_PI(PI, true, true),
    HTML_ASCII_COMMENT(COMMENT, true, true),
    HTML_ASCII_NAMESPACE(NAMESPACE, true, true),
    HTML_ASCII_CDATASECTION(CDATASECTION, true, true),
    HTML_ASCII_NOTHING(NOTHING, true, true);

    public final short flags;
    public final CharEscapeMaps mapEnum;
    public final byte[] map;
    public final boolean isASCIIEncoding;
    public final boolean isHTML;
    public final EncodeContext base;
    public static final EncodeContext[] variantList;

    private EncodeContext(short s, CharEscapeMaps charEscapeMaps) {
        this.flags = s;
        this.isASCIIEncoding = false;
        this.isHTML = false;
        this.mapEnum = charEscapeMaps;
        this.map = charEscapeMaps.get(false, false);
        this.base = this;
    }

    private EncodeContext(EncodeContext encodeContext, boolean bl, boolean bl2) {
        this.base = encodeContext;
        this.flags = encodeContext.flags;
        this.isASCIIEncoding = bl;
        this.isHTML = bl2;
        this.mapEnum = encodeContext.mapEnum;
        this.map = this.mapEnum.get(bl, bl2);
    }

    private EncodeContext() {
        this.base = null;
        this.flags = 0;
        this.isASCIIEncoding = false;
        this.isHTML = false;
        this.mapEnum = null;
        this.map = null;
    }

    public EncodeContext getVariant(Variant variant) {
        return variantList[this.base.ordinal() + variant.offset];
    }

    public EncodeContext getContext(short s) {
        EncodeContext[] encodeContextArray;
        for (EncodeContext encodeContext : encodeContextArray = EncodeContext.values()) {
            if (s != encodeContext.flags) continue;
            return encodeContext;
        }
        return ASCII_PCDATA;
    }

    static {
        variantList = EncodeContext.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variant {
        XML(0),
        HTML(HTML_NAME.ordinal()),
        ASCII(ASCII_NAME.ordinal()),
        HTML_ASCII(HTML_ASCII_NAME.ordinal());

        final int offset;

        private Variant(int n3) {
            this.offset = n3;
        }
    }
}

