/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.values.chars;

import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.dp.values.chars.CharsReader;
import com.ibm.xml.xci.dp.values.chars.SubChars;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class ReaderChars
extends CharsBase {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static final int BUFFER_CHUNK_SIZE = 1024;
    private Reader reader;
    private int count;
    private StringWriter buffer;
    private boolean finished;

    public ReaderChars(Reader reader) {
        this.reader = reader;
    }

    private boolean loadUpTo(int n2, Writer writer) throws IOException {
        if (!this.finished && this.count <= n2) {
            int n3;
            int n4;
            char[] cArray = new char[1024];
            while ((n4 = this.reader.read(cArray, 0, n3 = Math.min(1024, n2 - this.count + 1))) >= 0) {
                writer.write(cArray, 0, n4);
                this.count += n4;
                if (this.count <= n2) continue;
            }
            this.finished = n4 < 0;
        }
        return this.count > n2;
    }

    public boolean hasCharAt(int n2) {
        try {
            if (this.count == 0 && this.buffer == null) {
                this.buffer = new StringWriter();
            }
            return this.loadUpTo(n2, this.buffer);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public CharSequence subSequence(int n2) {
        return new SubChars(this, n2);
    }

    public Reader toReader(boolean bl) {
        if (bl && this.count == 0) {
            return this.reader;
        }
        return new CharsReader(this);
    }

    public int writeTo(Writer writer, boolean bl) throws IOException {
        if (bl && this.count == 0) {
            this.loadUpTo(Integer.MAX_VALUE, writer);
        } else {
            if (this.count == 0 && this.buffer == null) {
                this.buffer = new StringWriter();
            }
            this.loadUpTo(Integer.MAX_VALUE, this.buffer);
            writer.write(this.toString());
        }
        return this.length();
    }

    public boolean isConstant() {
        return true;
    }

    public Chars constant(boolean bl) {
        return this;
    }

    public CharSequence subSequence(int n2, int n3) {
        return new SubChars(this, n2, n3);
    }

    public String toString() {
        try {
            if (this.buffer == null) {
                this.buffer = new StringWriter();
            }
            this.loadUpTo(0x7FFFFFFE, this.buffer);
            return this.buffer.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public CharSequence lexicalValue() {
        return this.toString();
    }
}

