/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.values.chars;

import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.serializer.XOutputWriter;
import java.io.IOException;
import java.io.Writer;

public class SubChars
extends CharsBase {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final Chars base;
    private final int subStart;
    private int subEnd;
    private boolean subEndVerified;

    public SubChars(Chars chars, int n2) {
        this.base = chars;
        this.subStart = n2;
        this.subEnd = Integer.MAX_VALUE;
    }

    public SubChars(Chars chars, int n2, int n3) {
        this.base = n2 >= n3 ? null : chars;
        this.subStart = n2;
        this.subEnd = n2 >= n3 ? n2 : n3;
    }

    private int realEnd() {
        if (!this.subEndVerified) {
            if (!this.base.hasCharAt(this.subEnd)) {
                this.subEnd = this.base.length();
            }
            this.subEndVerified = true;
        }
        return this.subEnd;
    }

    public boolean hasCharAt(int n2) {
        return this.base.hasCharAt(this.subStart + n2);
    }

    public CharSequence subSequence(int n2) {
        return this.base.subSequence(this.subStart + n2, this.realEnd());
    }

    public boolean startsWith(CharSequence charSequence) {
        if (charSequence == null) {
            return true;
        }
        int n2 = charSequence.length();
        if (n2 == 0) {
            return true;
        }
        return this.base.hasCharAt(this.subStart + n2 - 1) && this.base.containsAt(charSequence, this.subStart);
    }

    public boolean endsWith(CharSequence charSequence) {
        if (charSequence == null) {
            return true;
        }
        int n2 = charSequence.length();
        if (n2 == 0) {
            return true;
        }
        int n3 = this.realEnd() - n2;
        return n3 >= this.subStart ? this.base.containsAt(charSequence, n3) : false;
    }

    public boolean containsAt(CharSequence charSequence, int n2) {
        if (charSequence == null) {
            return true;
        }
        int n3 = charSequence.length();
        if (n3 == 0) {
            return true;
        }
        return this.subStart + n2 + n3 <= this.realEnd() && this.base.containsAt(charSequence, this.subStart + n2);
    }

    public char[] toCharArray() {
        int n2 = this.length();
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = this.charAt(this.subStart + i);
        }
        return cArray;
    }

    public int toCharArray(char[] cArray, int n2) {
        int n3 = this.length();
        for (int i = 0; i < n3; ++i) {
            cArray[i + n2] = this.charAt(this.subStart + i);
        }
        return n3;
    }

    public int writeTo(Writer writer, boolean bl) throws IOException {
        int n2 = this.length();
        for (int i = 0; i < n2; ++i) {
            writer.write(this.charAt(this.subStart + i));
        }
        return n2;
    }

    public boolean isConstant() {
        return this.base.isConstant();
    }

    public char charAt(int n2) {
        return this.base.charAt(this.subStart + n2);
    }

    public int length() {
        return this.realEnd() - this.subStart;
    }

    public CharSequence subSequence(int n2, int n3) {
        int n4 = this.subStart + n3;
        return this.base.subSequence(this.subStart + n2, this.base.hasCharAt(n4 - 1) ? n4 : this.realEnd());
    }

    public String toString() {
        return ((Object)this.base.subSequence(this.subStart, this.subEnd)).toString();
    }

    public CharSequence lexicalValue() {
        return this.base;
    }

    public void write(XOutputWriter xOutputWriter, EncodeContext encodeContext, boolean bl) throws IOException {
        xOutputWriter.write(this.base, this.subStart, this.realEnd(), encodeContext);
    }

    public void write(XOutputWriter xOutputWriter, int n2, int n3, EncodeContext encodeContext, boolean bl) throws IOException {
        xOutputWriter.write(this.base, this.subStart + n2, this.subStart + n3, encodeContext);
    }
}

