/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.dp.values.chars;

import com.ibm.xml.xci.dp.values.BaseCData;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.EncodeContext;
import com.ibm.xml.xci.dp.values.chars.SecuritySupport;
import com.ibm.xml.xci.dp.values.chars.StringChars;
import com.ibm.xml.xci.serializer.XOutputWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class WhitespaceCharsConstant
extends StringChars {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final byte[][] whitespaceConstantsByteArrays;
    public static final WhitespaceCharsConstant[] whitespaceConstants;
    public static final int MAXWHITESPACECONSTANTRUN = 20;
    public static final char[][] whitespaceConstantsCharArrays;
    public static final char[] s_systemLineSep;
    public static byte[] indentLineSepUTF8;
    public static WhitespaceCharsConstant newLineChar;

    public WhitespaceCharsConstant(String string2) {
        super(string2);
    }

    public boolean isSpace() {
        return true;
    }

    public Chars constant(boolean bl) {
        return this;
    }

    public boolean isConstant() {
        return true;
    }

    public boolean mayContain(short s) {
        return false;
    }

    public int appendQuotedTo(Appendable appendable, short s, boolean bl) throws IOException {
        appendable.append(this.string);
        return this.string.length();
    }

    public Chars quote(short s) {
        return this;
    }

    public int needsEscaping(byte[] byArray) {
        return -1;
    }

    public int needsEscaping(int n2, int n3, byte[] byArray) {
        return -1;
    }

    public void writeEncodedBytesTo(OutputStream outputStream, String string2, short s, boolean bl) throws IOException {
        int n2 = this.string.length();
        if (string2 != null && string2 == Chars.UTF8_String) {
            for (int i = 0; i < n2; ++i) {
                outputStream.write((byte)this.string.charAt(i));
            }
        } else {
            outputStream.write(this.string.getBytes(string2));
        }
    }

    public void write(XOutputWriter xOutputWriter, EncodeContext encodeContext, boolean bl) throws IOException {
        xOutputWriter.write(this.string, encodeContext);
    }

    public void write(XOutputWriter xOutputWriter, int n2, int n3, EncodeContext encodeContext, boolean bl) throws IOException {
        xOutputWriter.write(this.string, n2, n3, encodeContext);
    }

    static {
        whitespaceConstants = new WhitespaceCharsConstant[21];
        whitespaceConstantsCharArrays = new char[whitespaceConstants.length][];
        whitespaceConstantsByteArrays = new byte[whitespaceConstants.length][];
        int n2 = whitespaceConstants.length;
        for (int i = 0; i < n2; ++i) {
            char[] cArray = new char[i];
            for (int j = 0; j < i; ++j) {
                cArray[j] = 32;
            }
            WhitespaceCharsConstant.whitespaceConstantsCharArrays[i] = cArray;
            byte[] byArray = new byte[i];
            for (int j = 0; j < i; ++j) {
                byArray[j] = 32;
            }
            WhitespaceCharsConstant.whitespaceConstantsByteArrays[i] = byArray;
            WhitespaceCharsConstant.whitespaceConstants[i] = new JustSpaceWhitespaceFixedConstant(new String(whitespaceConstantsCharArrays[i]));
        }
        String string2 = SecuritySupport.getSystemProperty("line.separator");
        s_systemLineSep = string2.toCharArray();
        try {
            indentLineSepUTF8 = string2.getBytes(Chars.UTF8_String);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        newLineChar = new NewLineCharsConstant(new String(s_systemLineSep));
    }

    private static final class JustSpaceWhitespaceFixedConstant
    extends WhitespaceCharsConstant {
        private final int len;
        private final byte[] bytes;

        public JustSpaceWhitespaceFixedConstant(String string2) {
            super(string2);
            this.len = string2.length();
            this.bytes = whitespaceConstantsByteArrays[this.len];
        }

        public void writeEncodedBytesTo(OutputStream outputStream, String string2, short s, boolean bl) throws IOException {
            if (string2 != null && string2 == Chars.UTF8_String) {
                outputStream.write(this.bytes, 0, this.bytes.length);
            } else {
                outputStream.write(this.string.getBytes(string2));
            }
        }
    }

    public static final class JustSpaceWhitespace
    extends WhitespaceCharsConstant {
        private final int len;

        public JustSpaceWhitespace(String string2) {
            super(string2);
            this.len = string2.length();
        }

        public void writeEncodedBytesTo(OutputStream outputStream, String string2, short s, boolean bl) throws IOException {
            int n2 = this.string.length();
            if (string2 != null && string2 == Chars.UTF8_String) {
                if (n2 == 0) {
                    return;
                }
                if (n2 < whitespaceConstantsByteArrays.length) {
                    outputStream.write(whitespaceConstantsByteArrays[n2]);
                    return;
                }
            } else {
                outputStream.write(this.string.getBytes(string2));
            }
        }

        public void write(XOutputWriter xOutputWriter, EncodeContext encodeContext, boolean bl) throws IOException {
            xOutputWriter.write(' ', this.len, encodeContext);
        }

        public void write(XOutputWriter xOutputWriter, int n2, int n3, EncodeContext encodeContext, boolean bl) throws IOException {
            xOutputWriter.write(' ', n3 - n2, encodeContext);
        }
    }

    public static class NewLineCharsConstant
    extends WhitespaceCharsConstant {
        byte[] encodedChars = null;
        String encodingForEncodedChars = null;
        Charset encodingCharset = null;

        public NewLineCharsConstant(String string2) {
            super(string2);
        }

        public void writeEncodedBytesTo(OutputStream outputStream, String string2, short s, boolean bl) throws IOException {
            if (string2 == this.encodingForEncodedChars) {
                outputStream.write(this.encodedChars);
            } else {
                byte[] byArray = this.string.getBytes(string2);
                outputStream.write(byArray);
                if (this.encodingForEncodedChars == BaseCData.UTF8_String) {
                    this.encodingForEncodedChars = string2;
                    this.encodedChars = byArray;
                }
            }
        }

        public void write(XOutputWriter xOutputWriter, EncodeContext encodeContext, boolean bl) throws IOException {
            xOutputWriter.writeLineBreak();
        }

        public void write(XOutputWriter xOutputWriter, int n2, int n3, EncodeContext encodeContext, boolean bl) throws IOException {
            xOutputWriter.writeLineBreak();
        }

        public Chars quote(short s) {
            return this;
        }

        public int writeTo(Writer writer, boolean bl) throws IOException {
            return super.writeTo(writer, bl);
        }

        public int writeEncodedBytesTo(int n2, byte[] byArray, int n3, String string2, short s, boolean bl) {
            if (string2 == this.encodingForEncodedChars) {
                int n4 = this.encodedChars.length;
                System.arraycopy(this.encodedChars, 0, byArray, 0, n4);
                return n4;
            }
            try {
                byte[] byArray2 = this.string.getBytes(string2);
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                if (this.encodingForEncodedChars == BaseCData.UTF8_String) {
                    this.encodingForEncodedChars = string2;
                    this.encodedChars = byArray2;
                }
                return byArray2.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }

        public void writeEncodedBytesTo(OutputStream outputStream, Charset charset, boolean bl) throws IOException {
            if (charset == this.encodingCharset) {
                outputStream.write(this.encodedChars);
            } else {
                ByteBuffer byteBuffer = charset.encode(this.string);
                byte[] byArray = byteBuffer.array();
                outputStream.write(byArray);
                if (this.encodingCharset == BaseCData.UTF8) {
                    this.encodingCharset = charset;
                    this.encodedChars = byArray;
                }
            }
        }
    }
}

