/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.exec;

import com.ibm.xml.xapi.XCollectionResolver;
import com.ibm.xml.xapi.XResultResolver;
import com.ibm.xml.xapi.XTypeConstants;
import com.ibm.xml.xapi.XUnparsedTextResolver;
import com.ibm.xml.xapi.XViewException;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.TreeConstructionKind;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.values.BaseCData;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.DynamicContext2;
import com.ibm.xml.xci.exec.ErrorHandler;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.StaticContext;
import com.ibm.xml.xci.exec.XTypeUtils;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSModel;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Collator;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.URIResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDynamicContext
implements DynamicContext2,
Cloneable {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected NamespaceContext _namespaceContext;
    protected StaticContext _staticContext;
    protected HashMap<QName, Cursor> _bindings;
    protected HashMap<String, ExternalFunction> _functions;
    protected HashMap<String, Collator> _collators;
    protected VolatileCData _tz = null;
    protected ErrorHandler _errorHandler;
    protected URIResolver _sourceURIResolver;
    protected Hashtable<String, Boolean> _features = null;
    static final String NONMUTABLEWARNING = "BasicMutableDynamicContext should probably have been used here!";
    private final SessionContext _sessionContext;
    protected Result _primaryResult;
    protected String _baseOutputURI;
    protected XResultResolver _resultResolver;
    protected QName _XSLTInitialTemplate;
    protected QName _XSLTInitialMode;
    protected XCollectionResolver _collectionResolver;
    protected boolean _isValidating = false;
    protected XUnparsedTextResolver _unparsedTextResolver;
    private CursorFactory m_cursorFactory;
    protected TreeConstructionKind _treeConstructionKind;

    public BasicDynamicContext(SessionContext sessionContext) {
        this._sessionContext = sessionContext;
    }

    public BasicDynamicContext(SessionContext sessionContext, StaticContext staticContext) {
        this(sessionContext);
        this._staticContext = staticContext;
    }

    @Override
    public Cursor getVariableValue(QName qName) {
        if (qName == null || this._bindings == null) {
            return null;
        }
        return this._bindings.get(qName);
    }

    @Override
    public Executable getFunction(QName qName, int n2) {
        if (qName == null || this._functions == null) {
            return null;
        }
        String string2 = qName.toString() + ":" + n2;
        return this._functions.get(string2);
    }

    @Override
    public Collator getCollation(String string2) {
        return this._collators != null ? this._collators.get(string2) : null;
    }

    @Override
    public void bindCollation(String string2, Collator collator2) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public void removeCollation(String string2) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public VolatileCData getImplicitTimeZone() {
        if (this._tz == null) {
            CursorFactory cursorFactory = this.getSessionContext().getSimpleDataFactory();
            this._tz = cursorFactory.data(BaseCData.javaxFactory.newDuration(TimeZone.getDefault().getOffset(Calendar.getInstance().getTimeInMillis())), TypeRegistry.XSDAYTIMEDURATION, false);
        }
        return this._tz;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this._namespaceContext;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public StaticContext getStaticContext() {
        return this._staticContext;
    }

    @Override
    public void bindVariable(QName qName, Cursor cursor2) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public void bindFunction(QName qName, int n2, Executable executable) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public void bindFunction(QName qName, int n2, Method method) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public void bindFunction(QName qName, int n2, Method method, Object object2) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public void setImplicitTimeZone(VolatileCData volatileCData) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    public void setStaticContext(StaticContext staticContext) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public XSModel getXSModel() {
        return this.getSessionContext().getTypeRegistry().getXSModel();
    }

    @Override
    public URIResolver getSourceURIResolver() {
        return this._sourceURIResolver;
    }

    @Override
    public void setSourceURIResolver(URIResolver uRIResolver) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public boolean getFeature(String string2) {
        if (this._features == null) {
            return false;
        }
        Boolean bl = this._features.get(string2);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    @Override
    public void setFeature(String string2, boolean bl) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public SessionContext getSessionContext() {
        return this._sessionContext;
    }

    @Override
    public void setPrimaryResult(Result result2) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public Result getPrimaryResult() {
        return this._primaryResult;
    }

    @Override
    public void setBaseOutputURI(String string2) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public String getBaseOutputURI() {
        return this._baseOutputURI;
    }

    @Override
    public void setResultResolver(XResultResolver xResultResolver) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public XResultResolver getResultResolver() {
        return this._resultResolver;
    }

    @Override
    public void removeFunction(QName qName, int n2) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public boolean isFunctionBound(QName qName, int n2) {
        return this._functions != null && this._functions.containsKey(qName + ":" + n2);
    }

    @Override
    public void removeVariableBinding(QName qName) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public boolean isVariableBound(QName qName) {
        return this._bindings != null && this._bindings.containsKey(qName);
    }

    @Override
    public QName getXSLTInitialMode() {
        return this._XSLTInitialMode;
    }

    @Override
    public QName getXSLTInitialTemplate() {
        return this._XSLTInitialTemplate;
    }

    @Override
    public void setXSLTInitialMode(QName qName) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public void setXSLTInitialTemplate(QName qName) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public XCollectionResolver getCollectionResolver() {
        return this._collectionResolver;
    }

    @Override
    public void setCollectionResolver(XCollectionResolver xCollectionResolver) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public boolean getValidating() {
        return this._isValidating;
    }

    @Override
    public void setValidating(boolean bl) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public XUnparsedTextResolver getUnparsedTextResolver() {
        return this._unparsedTextResolver;
    }

    @Override
    public void setUnparsedTextResolver(XUnparsedTextResolver xUnparsedTextResolver) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BasicDynamicContext basicDynamicContext = (BasicDynamicContext)super.clone();
        if (this._bindings != null) {
            basicDynamicContext._bindings = (HashMap)this._bindings.clone();
        }
        if (this._collators != null) {
            basicDynamicContext._collators = (HashMap)this._collators.clone();
        }
        if (this._features != null) {
            basicDynamicContext._features = (Hashtable)this._features.clone();
        }
        if (this._functions != null) {
            basicDynamicContext._functions = (HashMap)this._functions.clone();
        }
        return basicDynamicContext;
    }

    private Cursor getCursor(Cursor cursor2, QName qName) {
        XSTypeDefinition xSTypeDefinition;
        if (cursor2 == null) {
            return null;
        }
        QName qName2 = cursor2.itemTypeName();
        if (qName2 != null && qName2.equals(qName)) {
            return cursor2;
        }
        XSSimpleTypeDefinition xSSimpleTypeDefinition = XTypeUtils.getBuiltInTypeForName(qName);
        boolean bl = true;
        if (xSSimpleTypeDefinition == null && (xSTypeDefinition = this.getTypeRegistry().getGlobalXSType(qName)) != null && xSTypeDefinition instanceof XSSimpleTypeDefinition) {
            xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSTypeDefinition;
            bl = false;
        }
        if (xSSimpleTypeDefinition == null) {
            return cursor2;
        }
        int n2 = (int)cursor2.contextSize();
        if (n2 <= 1) {
            switch (xSSimpleTypeDefinition.getBuiltInKind()) {
                case 2: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    return this.getCursorFactory().sequence((CharSequence)cursor2.itemTypedValue().getString(1), xSSimpleTypeDefinition, false);
                }
                case 18: {
                    return this.getCursorFactory().sequence((CharSequence)cursor2.itemTypedValue().getURIString(1), xSSimpleTypeDefinition, false);
                }
                case 3: {
                    if (bl) {
                        return this.getCursorFactory().sequence(cursor2.itemTypedValue().getBoolean(1), null, false);
                    }
                    return this.getCursorFactory().sequence(cursor2.itemTypedValue().getBoolean(1), xSSimpleTypeDefinition, false);
                }
                case 17: {
                    return this.getCursorFactory().sequence(cursor2.itemTypedValue().getBase64Binary(1), xSSimpleTypeDefinition, false);
                }
                case 16: {
                    return this.getCursorFactory().sequence(cursor2.itemTypedValue().getHexBinary(1), xSSimpleTypeDefinition, false);
                }
                case 5: {
                    if (bl) {
                        return this.getCursorFactory().sequence(cursor2.itemTypedValue().getFloat(1), (XSSimpleTypeDefinition)null, false);
                    }
                    return this.getCursorFactory().sequence(cursor2.itemTypedValue().getFloat(1), xSSimpleTypeDefinition, false);
                }
                case 6: {
                    if (bl) {
                        return this.getCursorFactory().sequence(cursor2.itemTypedValue().getDouble(1), null, false);
                    }
                    return this.getCursorFactory().sequence(cursor2.itemTypedValue().getDouble(1), xSSimpleTypeDefinition, false);
                }
                case 4: {
                    if (bl) {
                        return this.getCursorFactory().sequence(cursor2.itemTypedValue().getBigDecimal(1), null, false);
                    }
                    return this.getCursorFactory().sequence(cursor2.itemTypedValue().getBigDecimal(1), xSSimpleTypeDefinition, false);
                }
                case 30: {
                    if (bl) {
                        return this.getCursorFactory().sequence(cursor2.itemTypedValue().getBigInteger(1), null, false);
                    }
                    return this.getCursorFactory().sequence(cursor2.itemTypedValue().getBigInteger(1), xSSimpleTypeDefinition, false);
                }
                case 31: 
                case 32: 
                case 37: 
                case 38: 
                case 42: {
                    return this.getCursorFactory().sequence(cursor2.itemTypedValue().getBigInteger(1), xSSimpleTypeDefinition, false);
                }
                case 33: 
                case 39: {
                    return this.getCursorFactory().sequence(cursor2.itemTypedValue().getLong(1), xSSimpleTypeDefinition, false);
                }
                case 34: 
                case 40: {
                    return this.getCursorFactory().sequence(cursor2.itemTypedValue().getInt(1), xSSimpleTypeDefinition, false);
                }
                case 35: 
                case 41: {
                    return this.getCursorFactory().sequence(cursor2.itemTypedValue().getShort(1), xSSimpleTypeDefinition, false);
                }
                case 36: {
                    if (bl) {
                        return this.getCursorFactory().sequence(cursor2.itemTypedValue().getByte(1), (XSSimpleTypeDefinition)null, false);
                    }
                    return this.getCursorFactory().sequence(cursor2.itemTypedValue().getByte(1), xSSimpleTypeDefinition, false);
                }
                case 19: {
                    if (bl) {
                        return this.getCursorFactory().sequence(cursor2.itemTypedValue().getQName(1, null), null, false);
                    }
                    return this.getCursorFactory().sequence(cursor2.itemTypedValue().getQName(1, null), xSSimpleTypeDefinition, false);
                }
                case 7: {
                    try {
                        return this.getCursorFactory().sequence(cursor2.itemTypedValue().getDuration(1), xSSimpleTypeDefinition, false);
                    }
                    catch (Exception exception) {
                        throw new XViewException(exception.getMessage(), exception.getCause());
                    }
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    try {
                        return this.getCursorFactory().sequence(cursor2.itemTypedValue().getXMLGregorianCalendar(1), xSSimpleTypeDefinition, false);
                    }
                    catch (Exception exception) {
                        throw new XViewException(exception.getMessage(), exception.getCause());
                    }
                }
            }
        } else {
            switch (xSSimpleTypeDefinition.getBuiltInKind()) {
                case 2: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    CharSequence[] charSequenceArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        cursor2.toPosition(i + 1);
                        charSequenceArray[i] = cursor2.itemTypedValue().getString(1);
                    }
                    return this.getCursorFactory().sequence(charSequenceArray, xSSimpleTypeDefinition, false);
                }
                case 18: {
                    CharSequence[] charSequenceArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        cursor2.toPosition(i + 1);
                        charSequenceArray[i] = cursor2.itemTypedValue().getURIString(1);
                    }
                    return this.getCursorFactory().sequence(charSequenceArray, xSSimpleTypeDefinition, false);
                }
                case 3: {
                    boolean[] blArray = new boolean[n2];
                    for (int i = 0; i < n2; ++i) {
                        cursor2.toPosition(i + 1);
                        blArray[i] = cursor2.itemTypedValue().getBoolean(1);
                    }
                    if (bl) {
                        return this.getCursorFactory().sequence(blArray, null, false);
                    }
                    return this.getCursorFactory().sequence(blArray, xSSimpleTypeDefinition, false);
                }
                case 17: {
                    Cursor cursor3 = this.getCursorFactory().sequence(cursor2.itemTypedValue().getBase64Binary(1), xSSimpleTypeDefinition, false);
                    for (int i = 2; i <= n2; ++i) {
                        cursor2.toPosition(i);
                        Cursor cursor4 = this.getCursorFactory().sequence(cursor2.itemTypedValue().getBase64Binary(1), xSSimpleTypeDefinition, false);
                        cursor3 = cursor3.sequenceConcat(cursor4, cursor3.profile(), cursor3.futureProfile(), false, false, true, false);
                    }
                    return cursor3;
                }
                case 16: {
                    Cursor cursor5 = this.getCursorFactory().sequence(cursor2.itemTypedValue().getHexBinary(1), xSSimpleTypeDefinition, false);
                    for (int i = 2; i <= n2; ++i) {
                        cursor2.toPosition(i);
                        Cursor cursor6 = this.getCursorFactory().sequence(cursor2.itemTypedValue().getHexBinary(1), xSSimpleTypeDefinition, false);
                        cursor5 = cursor5.sequenceConcat(cursor6, cursor5.profile(), cursor5.futureProfile(), false, false, true, false);
                    }
                    return cursor5;
                }
                case 5: {
                    float[] fArray = new float[n2];
                    for (int i = 0; i < n2; ++i) {
                        cursor2.toPosition(i + 1);
                        fArray[i] = cursor2.itemTypedValue().getFloat(1);
                    }
                    if (bl) {
                        return this.getCursorFactory().sequence(fArray, (XSSimpleTypeDefinition)null, false);
                    }
                    return this.getCursorFactory().sequence(fArray, xSSimpleTypeDefinition, false);
                }
                case 6: {
                    double[] dArray = new double[n2];
                    for (int i = 0; i < n2; ++i) {
                        cursor2.toPosition(i + 1);
                        dArray[i] = cursor2.itemTypedValue().getDouble(1);
                    }
                    if (bl) {
                        return this.getCursorFactory().sequence(dArray, null, false);
                    }
                    return this.getCursorFactory().sequence(dArray, xSSimpleTypeDefinition, false);
                }
                case 4: {
                    BigDecimal[] bigDecimalArray = new BigDecimal[n2];
                    for (int i = 0; i < n2; ++i) {
                        cursor2.toPosition(i + 1);
                        bigDecimalArray[i] = cursor2.itemTypedValue().getBigDecimal(1);
                    }
                    if (bl) {
                        return this.getCursorFactory().sequence(bigDecimalArray, null, false);
                    }
                    return this.getCursorFactory().sequence(bigDecimalArray, xSSimpleTypeDefinition, false);
                }
                case 30: {
                    BigInteger[] bigIntegerArray = new BigInteger[n2];
                    for (int i = 0; i < n2; ++i) {
                        cursor2.toPosition(i + 1);
                        bigIntegerArray[i] = cursor2.itemTypedValue().getBigInteger(1);
                    }
                    if (bl) {
                        return this.getCursorFactory().sequence(bigIntegerArray, null, false);
                    }
                    return this.getCursorFactory().sequence(bigIntegerArray, xSSimpleTypeDefinition, false);
                }
                case 31: 
                case 32: 
                case 37: 
                case 38: 
                case 42: {
                    BigInteger[] bigIntegerArray = new BigInteger[n2];
                    for (int i = 0; i < n2; ++i) {
                        cursor2.toPosition(i + 1);
                        bigIntegerArray[i] = cursor2.itemTypedValue().getBigInteger(1);
                    }
                    return this.getCursorFactory().sequence(bigIntegerArray, xSSimpleTypeDefinition, false);
                }
                case 33: 
                case 39: {
                    long[] lArray = new long[n2];
                    for (int i = 0; i < n2; ++i) {
                        cursor2.toPosition(i + 1);
                        lArray[i] = cursor2.itemTypedValue().getLong(1);
                    }
                    return this.getCursorFactory().sequence(lArray, xSSimpleTypeDefinition, false);
                }
                case 34: 
                case 40: {
                    int[] nArray = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        cursor2.toPosition(i + 1);
                        nArray[i] = cursor2.itemTypedValue().getInt(1);
                    }
                    return this.getCursorFactory().sequence(nArray, xSSimpleTypeDefinition, false);
                }
                case 35: 
                case 41: {
                    short[] sArray = new short[n2];
                    for (int i = 0; i < n2; ++i) {
                        cursor2.toPosition(i + 1);
                        sArray[i] = cursor2.itemTypedValue().getShort(1);
                    }
                    return this.getCursorFactory().sequence(sArray, xSSimpleTypeDefinition, false);
                }
                case 36: {
                    byte[] byArray = new byte[n2];
                    for (int i = 0; i < n2; ++i) {
                        cursor2.toPosition(i + 1);
                        byArray[i] = cursor2.itemTypedValue().getByte(1);
                    }
                    if (bl) {
                        return this.getCursorFactory().sequence(byArray, (XSSimpleTypeDefinition)null, false);
                    }
                    return this.getCursorFactory().sequence(byArray, xSSimpleTypeDefinition, false);
                }
                case 19: {
                    QName[] qNameArray = new QName[n2];
                    for (int i = 0; i < n2; ++i) {
                        cursor2.toPosition(i + 1);
                        qNameArray[i] = cursor2.itemTypedValue().getQName(1, null);
                    }
                    if (bl) {
                        return this.getCursorFactory().sequence(qNameArray, null, false);
                    }
                    return this.getCursorFactory().sequence(qNameArray, xSSimpleTypeDefinition, false);
                }
                case 7: {
                    try {
                        Duration[] durationArray = new Duration[n2];
                        for (int i = 0; i < n2; ++i) {
                            cursor2.toPosition(i + 1);
                            durationArray[i] = cursor2.itemTypedValue().getDuration(1);
                        }
                        return this.getCursorFactory().sequence(durationArray, xSSimpleTypeDefinition, false);
                    }
                    catch (Exception exception) {
                        throw new XViewException(exception.getMessage(), exception.getCause());
                    }
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    try {
                        XMLGregorianCalendar[] xMLGregorianCalendarArray = new XMLGregorianCalendar[n2];
                        for (int i = 0; i < n2; ++i) {
                            cursor2.toPosition(i + 1);
                            xMLGregorianCalendarArray[i] = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
                        }
                        return this.getCursorFactory().sequence(xMLGregorianCalendarArray, xSSimpleTypeDefinition, false);
                    }
                    catch (Exception exception) {
                        throw new XViewException(exception.getMessage(), exception.getCause());
                    }
                }
            }
        }
        return cursor2;
    }

    protected CursorFactory getCursorFactory() {
        if (this.m_cursorFactory == null) {
            this.m_cursorFactory = this.getSessionContext().getSimpleDataFactory();
        }
        return this.m_cursorFactory;
    }

    public void setupBindings(Map<String, String> map2, Map<String, String> map3) {
        QName qName;
        String string2;
        Object object2;
        Object object3;
        if (this._functions != null) {
            for (Map.Entry<Object, Object> entry : this._functions.entrySet()) {
                object3 = (String)entry.getKey();
                object2 = (ExternalFunction)entry.getValue();
                string2 = null;
                if (map2 != null) {
                    string2 = map2.get(object3);
                }
                qName = string2 != null ? QName.valueOf(string2) : XTypeConstants.UNTYPEDATOMIC_QNAME;
                ((ExternalFunction)object2).setType(qName);
            }
        }
        if (this._bindings != null) {
            for (Map.Entry<Object, Object> entry : this._bindings.entrySet()) {
                object3 = (QName)entry.getKey();
                object2 = (Cursor)entry.getValue();
                string2 = null;
                if (map3 != null) {
                    string2 = map3.get(((QName)object3).toString());
                }
                qName = null;
                if (string2 != null) {
                    qName = QName.valueOf(string2);
                }
                if (qName == null) continue;
                Cursor cursor2 = this.getCursor((Cursor)object2, qName);
                this._bindings.put((QName)object3, cursor2);
            }
        }
    }

    public TypeRegistry getTypeRegistry() {
        return this._sessionContext.getTypeRegistry();
    }

    @Override
    public TreeConstructionKind getTreeConstructionKind() {
        return this._treeConstructionKind;
    }

    @Override
    public void setTreeConstructionKind(TreeConstructionKind treeConstructionKind) {
        assert (false) : "BasicMutableDynamicContext should probably have been used here!";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExternalFunction
    implements Executable {
        QName m_name;
        Executable m_execu;
        int m_arity;
        QName m_type;

        public ExternalFunction(QName qName, int n2, Executable executable) {
            this.m_name = qName;
            this.m_arity = n2;
            this.m_execu = executable;
        }

        @Override
        public Cursor execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
            Cursor cursor3 = this.m_execu.execute(cursor2, dynamicContext, profile, cursorArray);
            return BasicDynamicContext.this.getCursor(cursor3, this.m_type);
        }

        @Override
        public void execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray, Result result2) {
            Cursor cursor3 = this.execute(cursor2, dynamicContext, profile, cursorArray);
            cursor3.copyToResult(result2, null, false, true);
        }

        @Override
        public void execute(Cursor cursor2, Cursor.Area area, Cursor cursor3, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
            if (cursor3 == null) {
                throw new XCIIllegalArgumentException("ER_NULL_CURSOR_RESULT", (String[])null);
            }
            Cursor cursor4 = this.execute(cursor2, dynamicContext, profile, cursorArray);
            if (cursor4 != null) {
                cursor3.addCopy(area, cursor4);
                cursor4.release();
            }
        }

        @Override
        public Map<String, Object> getProperties() {
            return null;
        }

        public void setType(QName qName) {
            this.m_type = qName;
        }
    }
}

