/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.exec;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.StaticContext;
import java.util.Map;
import javax.xml.transform.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicGenericExecutable
implements Executable {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Executable[] _dataProviderExecutableList;
    private Executable _defaultExecutable;
    private StaticContext _context;

    public BasicGenericExecutable(Executable[] executableArray, StaticContext staticContext) {
        this._dataProviderExecutableList = executableArray;
        this._context = staticContext;
    }

    public Executable getExecutable(int n2) {
        return this._dataProviderExecutableList == null || n2 < 0 || n2 >= this._dataProviderExecutableList.length ? null : this._dataProviderExecutableList[n2];
    }

    @Override
    public Cursor execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
        if (null != cursor2) {
            if (!cursor2.canBeSpecialized()) {
                return this._defaultExecutable.execute(cursor2, dynamicContext, profile, null);
            }
            int n2 = cursor2.dataProviderSubID();
            Executable executable = this.getExecutable(n2);
            if (null != executable) {
                return executable.execute(cursor2, dynamicContext, profile, null);
            }
        }
        if (null == this._defaultExecutable) {
            return null;
        }
        return this._defaultExecutable.execute(cursor2, dynamicContext, profile, null);
    }

    @Override
    public void execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray, Result result2) {
        Cursor cursor3 = this.execute(cursor2, dynamicContext, profile, cursorArray);
        cursor3.copyToResult(result2, null, false, true);
    }

    @Override
    public void execute(Cursor cursor2, Cursor.Area area, Cursor cursor3, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
        if (cursor3 == null) {
            throw new XCIIllegalArgumentException("ER_NULL_CURSOR_RESULT", (String[])null);
        }
        Cursor cursor4 = this.execute(cursor2, dynamicContext, profile, cursorArray);
        if (cursor4 != null) {
            cursor3.addCopy(area, cursor4);
            cursor4.release();
        }
    }

    public StaticContext getStaticContext() {
        return this._context;
    }

    public void setStaticContext(StaticContext staticContext) {
        this._context = staticContext;
    }

    public Executable getDefaultExecutable() {
        return this._defaultExecutable;
    }

    public void setDefaultExecutable(Executable executable) {
        this._defaultExecutable = executable;
    }

    void setDataProviderExecutableList(Executable[] executableArray) {
        this._dataProviderExecutableList = executableArray;
    }

    public boolean areAllPrepared() {
        if (this._dataProviderExecutableList == null) {
            return false;
        }
        for (Executable executable : this._dataProviderExecutableList) {
            if (executable != null) continue;
            return false;
        }
        return true;
    }

    public boolean canExecute() {
        if (this._dataProviderExecutableList == null) {
            return false;
        }
        for (Executable executable : this._dataProviderExecutableList) {
            if (executable == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> getProperties() {
        return null;
    }
}

