/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.exec;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XCollectionResolver;
import com.ibm.xml.xapi.XItemView;
import com.ibm.xml.xapi.XMessageHandler;
import com.ibm.xml.xapi.XProcessException;
import com.ibm.xml.xapi.XResultResolver;
import com.ibm.xml.xapi.XSequenceCursor;
import com.ibm.xml.xapi.XTypeConstants;
import com.ibm.xml.xapi.XUnparsedTextResolver;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.TreeConstructionKind;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.exec.BasicDynamicContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.ErrorHandler;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.StaticContext;
import com.ibm.xml.xci.exec.XFactoryUtils;
import com.ibm.xml.xci.exec.XTypeUtils;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Collator;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class BasicMutableDynamicContext
extends BasicDynamicContext {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2011. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = LoggerUtil.getLogger(BasicMutableDynamicContext.class);

    public BasicMutableDynamicContext(SessionContext sessionContext) {
        super(sessionContext);
    }

    public BasicMutableDynamicContext(SessionContext sessionContext, StaticContext staticContext) {
        super(sessionContext, staticContext);
    }

    public void bindVariable(QName qName, Cursor cursor2) {
        if (qName != null) {
            if (this._bindings == null) {
                this._bindings = new HashMap();
            }
            this._bindings.put(qName, cursor2);
        }
    }

    public void unbindVariables(boolean bl) {
        if (this._bindings != null) {
            if (bl) {
                Collection collection2 = this._bindings.values();
                for (Cursor cursor2 : collection2) {
                    if (cursor2 == null) continue;
                    cursor2.release();
                }
            }
            this._bindings.clear();
        }
    }

    public void bindFunction(QName qName, int n2, Executable executable) {
        if (qName != null) {
            Object object2;
            String string2;
            if (this._functions == null) {
                this._functions = new HashMap();
            }
            if (this._functions.get(string2 = qName.toString() + ":" + n2) != null) {
                object2 = XCIMessages.createXCIMessage("WARN_DUPLICATE_FUNCTION", new Object[]{qName, n2});
                ErrorHandler errorHandler = this.getErrorHandler();
                if (errorHandler != null) {
                    errorHandler.report(-1, XMessageHandler.MsgType.WARNING, (String)object2, null, false);
                }
                logger.logp(Level.WARNING, logger.getName(), "bindFunction(QName, int, Executable)", (String)object2, new Object[]{qName, n2, executable});
            }
            object2 = new BasicDynamicContext.ExternalFunction(qName, n2, executable);
            this._functions.put(string2, object2);
        }
    }

    public void bindFunction(QName qName, int n2, Method method) {
        if (qName != null) {
            Object object2;
            Object object3;
            String string2;
            if (this._functions == null) {
                this._functions = new HashMap();
            }
            if (this._functions.get(string2 = qName.toString() + ":" + n2) != null) {
                object3 = XCIMessages.createXCIMessage("WARN_DUPLICATE_FUNCTION", new Object[]{qName, n2});
                object2 = this.getErrorHandler();
                if (object2 != null) {
                    object2.report(-1, XMessageHandler.MsgType.WARNING, (String)object3, null, false);
                }
                logger.logp(Level.WARNING, logger.getName(), "bindFunction(QName, int, Method)", (String)object3, new Object[]{qName, n2, method});
            }
            object3 = new JavaMethodExecutable(qName, method);
            object2 = new BasicDynamicContext.ExternalFunction(qName, n2, (Executable)object3);
            this._functions.put(string2, object2);
        }
    }

    public void bindFunction(QName qName, int n2, Method method, Object object2) {
        if (qName != null) {
            Object object3;
            Object object4;
            if (this._functions == null) {
                this._functions = new HashMap();
            }
            String string2 = qName.toString() + ":" + n2;
            if (object2 == null) {
                throw new NullPointerException(XCIMessages.createXCIMessage("ER_EXT_FUNC_NO_INSTANCE_OBJECT", new String[]{method.getName(), method.getDeclaringClass().getName(), Integer.toString(method.getParameterTypes().length)}));
            }
            if (this._functions.get(string2) != null) {
                object4 = XCIMessages.createXCIMessage("WARN_DUPLICATE_FUNCTION", new Object[]{qName, n2});
                object3 = this.getErrorHandler();
                if (object3 != null) {
                    object3.report(-1, XMessageHandler.MsgType.WARNING, (String)object4, null, false);
                }
                logger.logp(Level.WARNING, logger.getName(), "bindFunction(QName, int, Method, Object)", (String)object4, new Object[]{qName, n2, method, object2});
            }
            object4 = new JavaMethodExecutable(qName, method, object2);
            object3 = new BasicDynamicContext.ExternalFunction(qName, n2, (Executable)object4);
            this._functions.put(string2, object3);
        }
    }

    public void bindCollation(String string2, Collator collator2) {
        if (this._collators == null) {
            this._collators = new HashMap();
        }
        this._collators.put(string2, collator2);
    }

    public void removeCollation(String string2) {
        if (this._collators != null) {
            this._collators.remove(string2);
        }
    }

    public void setImplicitTimeZone(VolatileCData volatileCData) {
        this._tz = volatileCData;
    }

    public void setStaticContext(StaticContext staticContext) {
        this._staticContext = staticContext;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this._namespaceContext = namespaceContext;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public void setSourceURIResolver(URIResolver uRIResolver) {
        this._sourceURIResolver = uRIResolver;
    }

    public void setFeature(String string2, boolean bl) {
        if (this._features == null) {
            this._features = new Hashtable();
        }
        this._features.put(string2, bl);
    }

    public void setPrimaryResult(Result result2) {
        this._primaryResult = result2;
    }

    public void setBaseOutputURI(String string2) {
        this._baseOutputURI = string2;
    }

    public void setResultResolver(XResultResolver xResultResolver) {
        this._resultResolver = xResultResolver;
    }

    public void removeFunction(QName qName, int n2) {
        if (this._functions != null) {
            String string2 = qName.toString() + ":" + n2;
            this._functions.remove(string2);
        }
    }

    public void removeVariableBinding(QName qName) {
        if (this._bindings != null) {
            this._bindings.remove(qName);
        }
    }

    public void setXSLTInitialMode(QName qName) {
        this._XSLTInitialMode = qName;
    }

    public void setXSLTInitialTemplate(QName qName) {
        this._XSLTInitialTemplate = qName;
    }

    public void setCollectionResolver(XCollectionResolver xCollectionResolver) {
        this._collectionResolver = xCollectionResolver;
    }

    public void setValidating(boolean bl) {
        this._isValidating = bl;
    }

    public void setUnparsedTextResolver(XUnparsedTextResolver xUnparsedTextResolver) {
        this._unparsedTextResolver = xUnparsedTextResolver;
    }

    public static Object[] getJavaArgs(Cursor[] cursorArray, Class[] classArray, String string2, String string3) throws Exception {
        if (cursorArray.length != classArray.length) {
            throw new XCIDynamicErrorException("ER_EXT_FUNC_WRONG_NUMBER_ARGS", new String[]{string2, string3, Integer.toString(classArray.length), Integer.toString(cursorArray.length)});
        }
        Object[] objectArray = new Object[cursorArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz;
            Class clazz2 = classArray[i];
            Cursor cursor2 = cursorArray[i + 0];
            if (clazz2.equals(Node.class)) {
                objectArray[i] = XFactoryUtils.getNode(cursor2);
                continue;
            }
            if (clazz2.equals(XItemView.class)) {
                clazz = XFactoryUtils.getSequenceCursor(cursor2, false);
                objectArray[i] = clazz == null ? null : clazz.getSingletonItem();
                continue;
            }
            if (clazz2.equals(XSequenceCursor.class)) {
                objectArray[i] = XFactoryUtils.getSequenceCursor(cursor2, true);
                continue;
            }
            if (clazz2.equals(NodeList.class)) {
                objectArray[i] = XFactoryUtils.getNodeList(cursor2);
                continue;
            }
            if (clazz2.equals(NodeIterator.class)) {
                objectArray[i] = XFactoryUtils.getNodeIterator(cursor2);
                continue;
            }
            if (cursor2 != null && clazz2.equals(cursor2.exportAsClass("exportdatatobject"))) {
                objectArray[i] = cursor2.exportAs("exportdatatobject", false);
                continue;
            }
            if (clazz2.isArray()) {
                XSTypeDefinition xSTypeDefinition;
                clazz = clazz2.getComponentType();
                if (clazz.equals(Byte.TYPE) && cursor2 != null) {
                    xSTypeDefinition = cursor2.itemXSType();
                    if (xSTypeDefinition.derivedFromType(TypeRegistry.XSBASE64BINARY, (short)3)) {
                        objectArray[i] = BasicMutableDynamicContext.getByteArray(cursor2.itemTypedValue().getBase64Binary(1));
                        continue;
                    }
                    if (xSTypeDefinition.derivedFromType(TypeRegistry.XSHEXBINARY, (short)3)) {
                        objectArray[i] = BasicMutableDynamicContext.getByteArray(cursor2.itemTypedValue().getHexBinary(1));
                        continue;
                    }
                    objectArray[i] = BasicMutableDynamicContext.getSequenceArgument(cursor2, clazz);
                    continue;
                }
                if (clazz.isArray()) {
                    if (clazz.getComponentType().equals(Byte.TYPE) && cursor2 != null) {
                        int n2;
                        byte[][] byArrayArray;
                        xSTypeDefinition = cursor2.itemXSType();
                        if (xSTypeDefinition.derivedFromType(TypeRegistry.XSBASE64BINARY, (short)3)) {
                            cursor2 = cursor2.fork(false);
                            byArrayArray = new byte[(int)cursor2.contextSize()][];
                            n2 = 0;
                            do {
                                byArrayArray[n2] = BasicMutableDynamicContext.getByteArray(cursor2.itemTypedValue().getBase64Binary(1));
                            } while (++n2 < byArrayArray.length && cursor2.toNext());
                            objectArray[i] = byArrayArray;
                            cursor2.release();
                            continue;
                        }
                        if (xSTypeDefinition.derivedFromType(TypeRegistry.XSHEXBINARY, (short)3)) {
                            cursor2 = cursor2.fork(false);
                            byArrayArray = new byte[(int)cursor2.contextSize()][];
                            n2 = 0;
                            do {
                                byArrayArray[n2] = BasicMutableDynamicContext.getByteArray(cursor2.itemTypedValue().getHexBinary(1));
                            } while (++n2 < byArrayArray.length && cursor2.toNext());
                            objectArray[i] = byArrayArray;
                            cursor2.release();
                            continue;
                        }
                        objectArray[i] = BasicMutableDynamicContext.getSequenceArgument(cursor2, clazz);
                        continue;
                    }
                    objectArray[i] = BasicMutableDynamicContext.getSequenceArgument(cursor2, clazz);
                    continue;
                }
                objectArray[i] = BasicMutableDynamicContext.getSequenceArgument(cursor2, clazz);
                continue;
            }
            if (cursor2 == null) {
                if (!clazz2.isPrimitive()) {
                    objectArray[i] = null;
                    continue;
                }
                throw new XProcessException(XCIMessages.createXMLMessage("ER_EXT_FUNC_INVALID_ARG", new Object[]{String.valueOf(i + 1), string2, string3, "null", clazz2.getName()}), null);
            }
            objectArray[i] = BasicMutableDynamicContext.getAtomicArgument(cursor2.itemTypedValue(), clazz2);
        }
        return objectArray;
    }

    public static byte[] getByteArray(Bytes bytes2) {
        byte[] byArray = new byte[(int)bytes2.byteLength()];
        bytes2.writeBytesTo(0, byArray, 0, false);
        return byArray;
    }

    public static Object getAtomicArgument(VolatileCData volatileCData, Class clazz) {
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return volatileCData.getBoolean(1);
        }
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return volatileCData.getByte(1);
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return volatileCData.getShort(1);
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return volatileCData.getInt(1);
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return volatileCData.getLong(1);
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return Float.valueOf(volatileCData.getFloat(1));
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return volatileCData.getDouble(1);
        }
        if (clazz.equals(String.class)) {
            return volatileCData.getString(1);
        }
        if (clazz.equals(BigDecimal.class)) {
            return volatileCData.getBigDecimal(1);
        }
        if (clazz.equals(BigInteger.class)) {
            return volatileCData.getBigInteger(1);
        }
        if (clazz.equals(QName.class)) {
            return volatileCData.getQName(1, null);
        }
        if (clazz.equals(XMLGregorianCalendar.class)) {
            try {
                return volatileCData.getXMLGregorianCalendar(1);
            }
            catch (ParseException parseException) {
                throw new XProcessException(parseException.getMessage(), parseException);
            }
        }
        if (clazz.equals(Duration.class)) {
            try {
                return volatileCData.getDuration(1);
            }
            catch (ParseException parseException) {
                throw new XProcessException(parseException.getMessage(), parseException);
            }
        }
        return volatileCData.getObject(1);
    }

    public static Object getSequenceArgument(Cursor cursor2, Class clazz) {
        Object[] objectArray;
        int n2 = 0;
        if (cursor2 != null) {
            n2 = (int)cursor2.contextSize();
            cursor2 = cursor2.fork(false);
        }
        if (clazz.equals(Boolean.TYPE)) {
            boolean[] blArray = new boolean[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                blArray[i] = volatileCData.getBoolean(1);
                cursor2.toNext();
            }
            objectArray = blArray;
        } else if (clazz.equals(Boolean.class)) {
            Boolean[] booleanArray = new Boolean[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                booleanArray[i] = volatileCData.getBoolean(1);
                cursor2.toNext();
            }
            objectArray = booleanArray;
        } else if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            byte[] byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                byArray[i] = volatileCData.getByte(1);
                cursor2.toNext();
            }
            objectArray = byArray;
        } else if (clazz.equals(Byte.class)) {
            Byte[] byteArray = new Byte[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                byteArray[i] = volatileCData.getByte(1);
                cursor2.toNext();
            }
            objectArray = byteArray;
        } else if (clazz.equals(Short.TYPE)) {
            short[] sArray = new short[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                sArray[i] = volatileCData.getShort(1);
                cursor2.toNext();
            }
            objectArray = sArray;
        } else if (clazz.equals(Short.class)) {
            Short[] shortArray = new Short[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                shortArray[i] = volatileCData.getShort(1);
                cursor2.toNext();
            }
            objectArray = shortArray;
        } else if (clazz.equals(Integer.TYPE)) {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                nArray[i] = volatileCData.getInt(1);
                cursor2.toNext();
            }
            objectArray = nArray;
        } else if (clazz.equals(Integer.class)) {
            Integer[] integerArray = new Integer[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                integerArray[i] = volatileCData.getInt(1);
                cursor2.toNext();
            }
            objectArray = integerArray;
        } else if (clazz.equals(Long.TYPE)) {
            long[] lArray = new long[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                lArray[i] = volatileCData.getLong(1);
                cursor2.toNext();
            }
            objectArray = lArray;
        } else if (clazz.equals(Long.class)) {
            Long[] longArray = new Long[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                longArray[i] = volatileCData.getLong(1);
                cursor2.toNext();
            }
            objectArray = longArray;
        } else if (clazz.equals(Float.TYPE)) {
            float[] fArray = new float[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                fArray[i] = volatileCData.getFloat(1);
                cursor2.toNext();
            }
            objectArray = fArray;
        } else if (clazz.equals(Float.class)) {
            Float[] floatArray = new Float[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                floatArray[i] = Float.valueOf(volatileCData.getFloat(1));
                cursor2.toNext();
            }
            objectArray = floatArray;
        } else if (clazz.equals(Double.TYPE)) {
            double[] dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                dArray[i] = volatileCData.getDouble(1);
                cursor2.toNext();
            }
            objectArray = dArray;
        } else if (clazz.equals(Double.class)) {
            Double[] doubleArray = new Double[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                doubleArray[i] = volatileCData.getDouble(1);
                cursor2.toNext();
            }
            objectArray = doubleArray;
        } else if (clazz.equals(String.class)) {
            String[] stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                stringArray[i] = volatileCData.getString(1);
                cursor2.toNext();
            }
            objectArray = stringArray;
        } else if (clazz.equals(BigDecimal.class)) {
            BigDecimal[] bigDecimalArray = new BigDecimal[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                bigDecimalArray[i] = volatileCData.getBigDecimal(1);
                cursor2.toNext();
            }
            objectArray = bigDecimalArray;
        } else if (clazz.equals(BigInteger.class)) {
            BigInteger[] bigIntegerArray = new BigInteger[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                bigIntegerArray[i] = volatileCData.getBigInteger(1);
                cursor2.toNext();
            }
            objectArray = bigIntegerArray;
        } else if (clazz.equals(QName.class)) {
            QName[] qNameArray = new QName[n2];
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                qNameArray[i] = volatileCData.getQName(1, null);
                cursor2.toNext();
            }
            objectArray = qNameArray;
        } else if (clazz.equals(XMLGregorianCalendar.class)) {
            try {
                XMLGregorianCalendar[] xMLGregorianCalendarArray = new XMLGregorianCalendar[n2];
                for (int i = 0; i < n2; ++i) {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    xMLGregorianCalendarArray[i] = volatileCData.getXMLGregorianCalendar(1);
                    cursor2.toNext();
                }
                objectArray = xMLGregorianCalendarArray;
            }
            catch (ParseException parseException) {
                throw new XProcessException(parseException.getMessage(), parseException);
            }
        } else if (clazz.equals(Duration.class)) {
            try {
                Duration[] durationArray = new Duration[n2];
                for (int i = 0; i < n2; ++i) {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    durationArray[i] = volatileCData.getDuration(1);
                    cursor2.toNext();
                }
                objectArray = durationArray;
            }
            catch (ParseException parseException) {
                throw new XProcessException(parseException.getMessage(), parseException);
            }
        } else if (clazz.equals(Node.class)) {
            Node[] nodeArray = new Node[n2];
            for (int i = 0; i < n2; ++i) {
                nodeArray[i] = XFactoryUtils.getNode(cursor2);
                cursor2.toNext();
            }
            objectArray = nodeArray;
        } else {
            Object[] objectArray2 = (Object[])Array.newInstance(clazz, n2);
            for (int i = 0; i < n2; ++i) {
                VolatileCData volatileCData = cursor2.itemTypedValue();
                objectArray2[i] = volatileCData.getObject(1);
                cursor2.toNext();
            }
            objectArray = objectArray2;
        }
        if (cursor2 != null) {
            cursor2.release();
        }
        return objectArray;
    }

    public static Cursor getResult(Object object2, Method method, DynamicContext dynamicContext, QName qName) {
        if (object2 == null) {
            return null;
        }
        boolean bl = dynamicContext.getValidating();
        SessionContext sessionContext = dynamicContext.getSessionContext();
        Class<?> clazz = method.getReturnType();
        if (clazz.equals(Node.class)) {
            return XFactoryUtils.getCursor((Node)object2, sessionContext, bl);
        }
        if (clazz.equals(NodeList.class)) {
            return XFactoryUtils.getCursor((NodeList)object2, sessionContext, bl);
        }
        if (clazz.equals(NodeIterator.class)) {
            return XFactoryUtils.getCursor((NodeIterator)object2, sessionContext, bl);
        }
        if (clazz.equals(XItemView.class)) {
            return XFactoryUtils.getCursor((XItemView)object2, true);
        }
        if (clazz.equals(XSequenceCursor.class)) {
            return XFactoryUtils.getCursor((XSequenceCursor)object2, true);
        }
        return BasicMutableDynamicContext.getCursor(object2, qName, dynamicContext);
    }

    public static Cursor getCursor(Object object2, QName qName, DynamicContext dynamicContext) {
        boolean bl = dynamicContext.getValidating();
        SessionContext sessionContext = dynamicContext.getSessionContext();
        CursorFactory cursorFactory = sessionContext.getSimpleDataFactory();
        TypeRegistry typeRegistry = sessionContext.getTypeRegistry();
        if (object2 instanceof XSequenceCursor) {
            XSequenceCursor xSequenceCursor = (XSequenceCursor)object2;
            if (xSequenceCursor.isAtomic() && qName != null) {
                List<XItemView> list = xSequenceCursor.exportAsList();
                Cursor cursor2 = null;
                if (list.size() > 0) {
                    XItemView xItemView = list.get(0);
                    QName qName2 = xItemView.getValueTypeName();
                    cursor2 = qName2.equals(qName) ? XFactoryUtils.getCursor(xItemView, true) : BasicMutableDynamicContext.getCursorFromXViewItem(xItemView, qName, cursorFactory, typeRegistry);
                    for (int i = 1; i < list.size(); ++i) {
                        xItemView = list.get(i);
                        qName2 = xItemView.getValueTypeName();
                        cursor2 = qName2.equals(qName) ? cursor2.sequenceConcat(XFactoryUtils.getCursor(xItemView, true), cursor2.profile(), cursor2.futureProfile(), false, false, true, false) : BasicMutableDynamicContext.getCursorFromXViewItem(xItemView, qName2, cursorFactory, typeRegistry);
                    }
                }
                return cursor2;
            }
            return XFactoryUtils.getCursor(xSequenceCursor, true);
        }
        if (object2 instanceof XItemView) {
            XItemView xItemView = (XItemView)object2;
            if (xItemView.isAtomic() && qName != null) {
                QName qName3 = xItemView.getValueTypeName();
                if (qName3.equals(qName)) {
                    return XFactoryUtils.getCursor(xItemView, true);
                }
                return BasicMutableDynamicContext.getCursorFromXViewItem(xItemView, qName, cursorFactory, typeRegistry);
            }
            return XFactoryUtils.getCursor(xItemView, true);
        }
        if (object2 instanceof String) {
            return cursorFactory.sequence((CharSequence)((String)object2), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSSTRING, typeRegistry), false);
        }
        if (object2 instanceof Boolean) {
            return cursorFactory.sequence((Boolean)object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSBOOLEAN, typeRegistry), false);
        }
        if (object2 instanceof Byte) {
            return cursorFactory.sequence((Byte)object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSBYTE, typeRegistry), false);
        }
        if (object2 instanceof Short) {
            return cursorFactory.sequence((Short)object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSSHORT, typeRegistry), false);
        }
        if (object2 instanceof Integer) {
            return cursorFactory.sequence((Integer)object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSINT, typeRegistry), false);
        }
        if (object2 instanceof Long) {
            return cursorFactory.sequence((Long)object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSLONG, typeRegistry), false);
        }
        if (object2 instanceof Float) {
            return cursorFactory.sequence(((Float)object2).floatValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSFLOAT, typeRegistry), false);
        }
        if (object2 instanceof Double) {
            return cursorFactory.sequence((Double)object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDOUBLE, typeRegistry), false);
        }
        if (object2 instanceof BigDecimal) {
            return cursorFactory.sequence((BigDecimal)object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDECIMAL, typeRegistry), false);
        }
        if (object2 instanceof BigInteger) {
            return cursorFactory.sequence((BigInteger)object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSINTEGER, typeRegistry), false);
        }
        if (object2 instanceof QName) {
            return cursorFactory.sequence((QName)object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSQNAME, typeRegistry), false);
        }
        if (object2 instanceof XMLGregorianCalendar) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition;
            try {
                QName qName4 = ((XMLGregorianCalendar)object2).getXMLSchemaType();
                xSSimpleTypeDefinition = BasicMutableDynamicContext.getSimpleTypeDefinition(qName4, typeRegistry);
            }
            catch (IllegalStateException illegalStateException) {
                xSSimpleTypeDefinition = TypeRegistry.XSDATETIME;
            }
            return cursorFactory.sequence((XMLGregorianCalendar)object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, xSSimpleTypeDefinition, typeRegistry), false);
        }
        if (object2 instanceof Duration) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition;
            try {
                QName qName5 = new QName("http://www.w3.org/2001/XMLSchema", ((Duration)object2).getXMLSchemaType().getLocalPart());
                xSSimpleTypeDefinition = BasicMutableDynamicContext.getSimpleTypeDefinition(qName5, typeRegistry);
            }
            catch (IllegalStateException illegalStateException) {
                xSSimpleTypeDefinition = TypeRegistry.XSDURATION;
            }
            return cursorFactory.sequence((Duration)object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, xSSimpleTypeDefinition, typeRegistry), false);
        }
        if (object2 instanceof Node) {
            return XFactoryUtils.getCursor((Node)object2, sessionContext, bl);
        }
        if (object2 instanceof NodeList) {
            return XFactoryUtils.getCursor((NodeList)object2, sessionContext, bl);
        }
        if (object2 instanceof NodeIterator) {
            return XFactoryUtils.getCursor((NodeIterator)object2, sessionContext, bl);
        }
        if (object2 instanceof Source) {
            return XFactoryUtils.getDocument((Source)object2, sessionContext, bl, dynamicContext.getErrorHandler(), false);
        }
        if (object2.getClass().isArray()) {
            Class<?> clazz = object2.getClass().getComponentType();
            if (clazz.equals(Boolean.TYPE)) {
                return cursorFactory.sequence((boolean[])object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSBOOLEAN, typeRegistry), false);
            }
            if (clazz.equals(Byte.TYPE)) {
                return cursorFactory.sequence((byte[])object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSBYTE, typeRegistry), false);
            }
            if (clazz.equals(Short.TYPE)) {
                return cursorFactory.sequence((short[])object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSSHORT, typeRegistry), false);
            }
            if (clazz.equals(Integer.TYPE)) {
                return cursorFactory.sequence((int[])object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSINT, typeRegistry), false);
            }
            if (clazz.equals(Long.TYPE)) {
                return cursorFactory.sequence((long[])object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSLONG, typeRegistry), false);
            }
            if (clazz.equals(Float.TYPE)) {
                return cursorFactory.sequence((float[])object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSFLOAT, typeRegistry), false);
            }
            if (clazz.equals(Double.TYPE)) {
                return cursorFactory.sequence((double[])object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDOUBLE, typeRegistry), false);
            }
            if (clazz.equals(String.class)) {
                return cursorFactory.sequence((String[])object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSSTRING, typeRegistry), false);
            }
            if (clazz.equals(BigDecimal.class)) {
                return cursorFactory.sequence((BigDecimal[])object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDECIMAL, typeRegistry), false);
            }
            if (clazz.equals(BigInteger.class)) {
                return cursorFactory.sequence((BigInteger[])object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSINTEGER, typeRegistry), false);
            }
            if (clazz.equals(QName.class)) {
                return cursorFactory.sequence((QName[])object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSQNAME, typeRegistry), false);
            }
            if (clazz.equals(XMLGregorianCalendar.class)) {
                return cursorFactory.sequence((XMLGregorianCalendar[])object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDATETIME, typeRegistry), false);
            }
            if (clazz.equals(Duration.class)) {
                return cursorFactory.sequence((Duration[])object2, BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDURATION, typeRegistry), false);
            }
            if (clazz.isArray()) {
                if ((clazz = clazz.getComponentType()).equals(Byte.TYPE)) {
                    byte[][] byArray = (byte[][])object2;
                    if (byArray.length == 0) {
                        return null;
                    }
                    XSSimpleTypeDefinition xSSimpleTypeDefinition = BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSHEXBINARY, typeRegistry);
                    Cursor cursor3 = cursorFactory.sequence(byArray[0], xSSimpleTypeDefinition, false);
                    for (int i = 1; i < byArray.length; ++i) {
                        Cursor cursor4 = cursorFactory.sequence(byArray[i], xSSimpleTypeDefinition, false);
                        cursor3 = cursor3.sequenceConcat(cursor4, cursor3.profile(), cursor3.futureProfile(), false, false, true, false);
                    }
                    return cursor3;
                }
                return cursorFactory.sequence(object2);
            }
            return cursorFactory.sequence(object2);
        }
        return cursorFactory.sequence(object2);
    }

    public static XSSimpleTypeDefinition getSimpleTypeDefinition(QName qName, XSSimpleTypeDefinition xSSimpleTypeDefinition, TypeRegistry typeRegistry) {
        if (qName == null) {
            return xSSimpleTypeDefinition;
        }
        return BasicMutableDynamicContext.getSimpleTypeDefinition(qName, typeRegistry);
    }

    public static XSSimpleTypeDefinition getSimpleTypeDefinition(QName qName, TypeRegistry typeRegistry) {
        BasicMutableDynamicContext.checkType(qName);
        XSSimpleTypeDefinition xSSimpleTypeDefinition = XTypeUtils.getSimpleTypeForName(qName, typeRegistry);
        if (xSSimpleTypeDefinition != null) {
            return xSSimpleTypeDefinition;
        }
        throw new XCIDynamicErrorException("ER_API_NOT_SIMPLE_ATOMIC", new String[]{qName.toString()});
    }

    public static void checkType(QName qName) {
        if (qName == null) {
            throw new XCIDynamicErrorException("ER_NULLARG_TYPE");
        }
    }

    public static Cursor getCursorFromXViewItem(XItemView xItemView, QName qName, CursorFactory cursorFactory, TypeRegistry typeRegistry) {
        XTypeConstants.Type type2 = xItemView.getValueType();
        switch (type2) {
            case STRING: 
            case UNTYPEDATOMIC: 
            case NORMALIZEDSTRING: 
            case TOKEN: 
            case LANGUAGE: 
            case NAME: 
            case NMTOKEN: 
            case NCNAME: 
            case ID: 
            case IDREF: 
            case ENTITY: {
                return cursorFactory.sequence((CharSequence)xItemView.getStringValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSSTRING, typeRegistry), false);
            }
            case BOOLEAN: {
                return cursorFactory.sequence(xItemView.getBooleanValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSBOOLEAN, typeRegistry), false);
            }
            case BYTE: {
                return cursorFactory.sequence(xItemView.getByteValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSBYTE, typeRegistry), false);
            }
            case SHORT: 
            case UNSIGNEDBYTE: {
                return cursorFactory.sequence(xItemView.getShortValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSSHORT, typeRegistry), false);
            }
            case INT: 
            case UNSIGNEDSHORT: {
                return cursorFactory.sequence(xItemView.getIntValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSINT, typeRegistry), false);
            }
            case LONG: 
            case UNSIGNEDINT: {
                return cursorFactory.sequence(xItemView.getLongValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSLONG, typeRegistry), false);
            }
            case FLOAT: {
                return cursorFactory.sequence(xItemView.getFloatValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSFLOAT, typeRegistry), false);
            }
            case DOUBLE: {
                return cursorFactory.sequence(xItemView.getDoubleValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDOUBLE, typeRegistry), false);
            }
            case DECIMAL: {
                return cursorFactory.sequence(xItemView.getDecimalValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDECIMAL, typeRegistry), false);
            }
            case INTEGER: 
            case NONNEGATIVEINTEGER: 
            case NONPOSITIVEINTEGER: 
            case NEGATIVEINTEGER: 
            case POSITIVEINTEGER: 
            case UNSIGNEDLONG: {
                return cursorFactory.sequence(xItemView.getIntegerValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSINTEGER, typeRegistry), false);
            }
            case HEXBINARY: {
                return cursorFactory.sequence(xItemView.getHexBinaryValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSHEXBINARY, typeRegistry), false);
            }
            case BASE64BINARY: {
                return cursorFactory.sequence(xItemView.getBase64BinaryValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSBASE64BINARY, typeRegistry), false);
            }
            case QNAME: {
                return cursorFactory.sequence(xItemView.getQNameValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSQNAME, typeRegistry), false);
            }
            case NOTATION: {
                return cursorFactory.sequence(xItemView.getNotationValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSNOTATION, typeRegistry), false);
            }
            case DATE: {
                return cursorFactory.sequence(xItemView.getDateValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDATETIME, typeRegistry), false);
            }
            case DATETIME: {
                return cursorFactory.sequence(xItemView.getDateTimeValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDATETIME, typeRegistry), false);
            }
            case TIME: {
                return cursorFactory.sequence(xItemView.getTimeValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDATETIME, typeRegistry), false);
            }
            case GDAY: {
                return cursorFactory.sequence(xItemView.getGDayValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDATETIME, typeRegistry), false);
            }
            case GMONTH: {
                return cursorFactory.sequence(xItemView.getGMonthValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDATETIME, typeRegistry), false);
            }
            case GMONTHDAY: {
                return cursorFactory.sequence(xItemView.getGMonthDayValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDATETIME, typeRegistry), false);
            }
            case GYEAR: {
                return cursorFactory.sequence(xItemView.getGYearValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDATETIME, typeRegistry), false);
            }
            case GYEARMONTH: {
                return cursorFactory.sequence(xItemView.getGYearMonthValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDATETIME, typeRegistry), false);
            }
            case DURATION: {
                return cursorFactory.sequence(xItemView.getDurationValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDURATION, typeRegistry), false);
            }
            case DAYTIMEDURATION: {
                return cursorFactory.sequence(xItemView.getDayTimeDurationValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDURATION, typeRegistry), false);
            }
            case YEARMONTHDURATION: {
                return cursorFactory.sequence(xItemView.getYearMonthDurationValue(), BasicMutableDynamicContext.getSimpleTypeDefinition(qName, TypeRegistry.XSDURATION, typeRegistry), false);
            }
        }
        return XFactoryUtils.getCursor(xItemView, true);
    }

    public void setTreeConstructionKind(TreeConstructionKind treeConstructionKind) {
        this._treeConstructionKind = treeConstructionKind;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JavaMethodExecutable
    implements Executable {
        static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2010. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
        QName m_name;
        Method m_method;
        QName m_type;
        Object m_instanceObject;

        public JavaMethodExecutable(QName qName, Method method) {
            this.m_name = qName;
            this.m_method = method;
        }

        public JavaMethodExecutable(QName qName, Method method, Object object2) {
            this.m_name = qName;
            this.m_method = method;
            this.m_instanceObject = object2;
        }

        public void setType(QName qName) {
            this.m_type = qName;
        }

        public QName getName() {
            return this.m_name;
        }

        public int getArity() {
            return this.m_method.getParameterTypes().length;
        }

        public Method getMethod() {
            return this.m_method;
        }

        @Override
        public Cursor execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
            try {
                Object object2 = null;
                if (!Modifier.isStatic(this.m_method.getModifiers())) {
                    if (this.m_instanceObject != null) {
                        object2 = this.m_instanceObject;
                    } else {
                        throw new XCIDynamicErrorException("ER_EXT_FUNC_NO_INSTANCE_OBJECT", new String[]{this.m_method.getName(), this.m_method.getDeclaringClass().getName(), Integer.toString(this.m_method.getParameterTypes().length)});
                    }
                }
                Object[] objectArray = BasicMutableDynamicContext.getJavaArgs(cursorArray, this.m_method.getParameterTypes(), this.m_method.getName(), this.m_method.getDeclaringClass().getName());
                Object object3 = this.m_method.invoke(object2, objectArray);
                return BasicMutableDynamicContext.getResult(object3, this.m_method, dynamicContext, this.m_type);
            }
            catch (XProcessException xProcessException) {
                throw xProcessException;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                RuntimeException runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
                throw new XProcessException(runtimeException.getMessage(), runtimeException);
            }
            catch (Exception exception) {
                throw new XProcessException(exception.getMessage(), exception);
            }
        }

        @Override
        public void execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray, Result result2) {
            Cursor cursor3 = this.execute(cursor2, dynamicContext, profile, cursorArray);
            cursor3.copyToResult(result2, null, false, true);
        }

        @Override
        public void execute(Cursor cursor2, Cursor.Area area, Cursor cursor3, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
            if (cursor3 == null) {
                throw new XCIDynamicErrorException("ER_INTERNAL_ERROR", new String[]{"Cursor result must not be null!"});
            }
            Cursor cursor4 = this.execute(cursor2, dynamicContext, profile, cursorArray);
            if (cursor4 != null) {
                cursor3.addCopy(area, cursor4);
                cursor4.release();
            }
        }

        @Override
        public Map<String, Object> getProperties() {
            return null;
        }
    }
}

