/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.exec;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.base.AbstractCursor;
import com.ibm.xml.xci.dp.base.AbstractSimpleDelegatingCursor;
import com.ibm.xml.xci.dp.serialize.SerializedCData;
import com.ibm.xml.xci.errors.XCIIllegalArgumentException;
import com.ibm.xml.xci.exec.Axis;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.NamespaceListCursor;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import com.ibm.xml.xci.res.XCIMessages;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutableForAxesDefault
implements Executable {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private StaticContext _context;
    private Axis _axes;
    private NodeTest _nodeTest;
    public boolean shouldProxy = !AbstractCursor.useOldSequenceMethod;
    static final Cursor.Profile MINIMAL_PLUS_TOPARENT = Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_PARENT);
    static final Cursor.Profile MINIMAL_PLUS_TOSELF = Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_SELF);
    static final Cursor.Profile TOPARENT_TOSELF_PROFILE = MINIMAL_PLUS_TOSELF.union(Cursor.Profile.TO_PARENT);

    public ExecutableForAxesDefault(Axis axis, NodeTest nodeTest, StaticContext staticContext) {
        this._axes = axis;
        this._nodeTest = nodeTest;
        this._context = staticContext;
    }

    public Axis getAxes() {
        return this._axes;
    }

    public NodeTest getNodeTest() {
        return this._nodeTest;
    }

    @Override
    public Cursor execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
        AxisCursorBase axisCursorBase;
        Axis axis = this.getAxes();
        NodeTest nodeTest = this.getNodeTest();
        switch (axis) {
            case CHILD: {
                Cursor cursor3 = cursor2.fork(true, profile.union(Cursor.Profile.MINIMAL_NAVIGATION).union(Cursor.Profile.TO_NODE_TEST), profile);
                if (cursor3.toChildren(nodeTest)) {
                    return cursor3;
                }
                return null;
            }
            case ATTRIBUTECHILD: {
                axisCursorBase = new AttributeChildCursor(cursor2);
                break;
            }
            case SELF: {
                Cursor cursor4 = cursor2.fork(true, profile.union(Cursor.Profile.TO_SELF), profile);
                if (cursor4.toSelf() && (this._nodeTest == null || this._nodeTest.test(cursor4))) {
                    return cursor4;
                }
                return null;
            }
            case PARENT: {
                Cursor cursor5 = cursor2.fork(true, profile.union(Cursor.Profile.TO_PARENT), profile);
                if (cursor5.toParent() && (this._nodeTest == null || this._nodeTest.test(cursor5))) {
                    return cursor5;
                }
                return null;
            }
            case ANCESTOR: {
                axisCursorBase = new AncestorCursor(cursor2, false);
                break;
            }
            case ANCESTORORSELF: {
                axisCursorBase = new AncestorCursor(cursor2, true);
                break;
            }
            case ATTRIBUTE: {
                Cursor cursor6 = cursor2.fork(true, profile, cursor2.futureProfile());
                if (cursor6.toAttributes(nodeTest)) {
                    return cursor6;
                }
                return null;
            }
            case DESCENDANT: {
                axisCursorBase = nodeTest == null ? new DescendantCursor(cursor2) : new TypedDescendantCursor(cursor2);
                break;
            }
            case DESCENDANTORSELF: {
                axisCursorBase = nodeTest == null ? new DescendantOrSelfCursor(cursor2) : new TypedDescendantOrSelfCursor(cursor2);
                break;
            }
            case DESCENDANTSFROMROOT: {
                cursor2 = cursor2.fork(true, profile, cursor2.futureProfile());
                if (cursor2.toRoot()) {
                    axisCursorBase = nodeTest == null ? new DescendantCursor(cursor2) : new TypedDescendantCursor(cursor2);
                    break;
                }
                return null;
            }
            case DESCENDANTSORSELFFROMROOT: {
                cursor2 = cursor2.fork(true, profile, cursor2.futureProfile());
                if (cursor2.toRoot()) {
                    axisCursorBase = nodeTest == null ? new DescendantOrSelfCursor(cursor2) : new TypedDescendantOrSelfCursor(cursor2);
                    break;
                }
                return null;
            }
            case FOLLOWING: {
                axisCursorBase = new FollowingCursor(cursor2);
                break;
            }
            case PRECEDING: {
                axisCursorBase = new PrecedingCursor(cursor2);
                break;
            }
            case FOLLOWINGSIBLING: {
                axisCursorBase = new FollowingSiblingCursor(cursor2);
                break;
            }
            case PRECEDINGSIBLING: {
                axisCursorBase = new PrecedingSiblingCursor(cursor2);
                break;
            }
            case NAMESPACE: {
                if (cursor2.itemKind() != 1) {
                    return null;
                }
                NamespaceListCursor namespaceListCursor = new NamespaceListCursor(cursor2.factory(), cursor2, nodeTest);
                return namespaceListCursor.contextSize() == 0L ? null : namespaceListCursor;
            }
            case NAMESPACEDECLS: {
                Cursor cursor7 = cursor2.fork(true, profile, cursor2.futureProfile());
                if (cursor7.toNamespaceDecls()) {
                    return cursor7;
                }
                cursor7.release();
                return null;
            }
            case NAMESPACEWITHINELEMENT: {
                Cursor cursor8 = cursor2.fork(true, profile, cursor2.futureProfile());
                if (cursor8.toNamespaceDecls()) {
                    return cursor8;
                }
                cursor8.release();
                return null;
            }
            default: {
                throw new UnsupportedOperationException(XCIMessages.createXCIMessage("ER_UNSUPPORTEDAXIS", new String[]{axis.toString()}));
            }
        }
        return ((AxisCursorBase)axisCursorBase).init(profile) ? this.doProxy(axis, axisCursorBase, profile, false, null) : null;
    }

    @Override
    public void execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray, Result result2) {
        Cursor cursor3 = this.execute(cursor2, dynamicContext, profile, cursorArray);
        cursor3.copyToResult(result2, null, false, true);
    }

    @Override
    public void execute(Cursor cursor2, Cursor.Area area, Cursor cursor3, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
        if (cursor3 == null) {
            throw new XCIIllegalArgumentException("ER_NULL_CURSOR_RESULT", (String[])null);
        }
        Cursor cursor4 = this.execute(cursor2, dynamicContext, profile, cursorArray);
        if (cursor4 != null) {
            cursor3.addCopy(area, cursor4);
            cursor4.release();
        }
    }

    public Cursor doProxy(Axis axis, AxisCursorBase axisCursorBase, Cursor.Profile profile, boolean bl, Map<String, Object> map2) {
        Cursor cursor2 = axisCursorBase;
        if (this.shouldProxy && !profile.containedIn(axisCursorBase.profile())) {
            Cursor.Profile profile2 = axisCursorBase.futureProfile();
            if (axisCursorBase.contextIsOrdered(false)) {
                cursor2 = cursor2.factory().proxy(cursor2, profile, false, null, null);
            } else {
                Cursor cursor3 = axisCursorBase.isPureReverse() ? this.reverseGeneric(axisCursorBase, profile, profile2) : axisCursorBase;
                cursor2 = cursor3.factory().proxy(cursor3, profile, false, null, null);
            }
        }
        return cursor2;
    }

    private Cursor reverseGeneric(Cursor cursor2, Cursor.Profile profile, Cursor.Profile profile2) {
        Cursor cursor3 = cursor2.fork(true);
        cursor3.toSelf();
        if (cursor2.toNext()) {
            do {
                Cursor cursor4 = cursor2.fork(true);
                cursor4.toSelf();
                cursor3 = cursor4.sequenceConcat(cursor3, profile, profile2, true, true);
            } while (cursor2.toNext());
        }
        cursor2.release();
        return cursor3;
    }

    public StaticContext getStaticContext() {
        return this._context;
    }

    public Executable getDefaultExecutable() {
        return null;
    }

    public void setDefaultExecutable(Executable executable) {
    }

    private Executable prepareAxisExec(Cursor cursor2, Axis axis) {
        int n2;
        SessionContext sessionContext = cursor2.factory().getSessionContext();
        Executable executable = null;
        if (null != sessionContext && (n2 = cursor2.dataProviderSubID()) >= 0) {
            Preparer preparer = sessionContext.getPreparer(n2);
            executable = preparer.prepare(axis, null, this._context, -1);
        }
        if (executable == null) {
            executable = new ExecutableForAxesDefault(axis, null, this._context);
        }
        assert (executable != null);
        return executable;
    }

    @Override
    public Map<String, Object> getProperties() {
        return null;
    }

    class FollowingCursor
    extends AxisCursorWithStackBase {
        FollowingCursor(Cursor cursor2) {
            super(cursor2);
        }

        boolean init(Cursor.Profile profile) {
            Object object2;
            Cursor cursor2;
            Cursor cursor3;
            Cursor cursor4 = cursor3 = this.getDelegate();
            Cursor.Profile profile2 = profile.union(Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_NODE_TEST).union(Cursor.Profile.TO_PARENT));
            Executable executable = ExecutableForAxesDefault.this.prepareAxisExec(cursor3, Axis.FOLLOWINGSIBLING);
            Cursor cursor5 = executable.execute(cursor3, null, profile.union(Cursor.Profile.MINIMAL_NAVIGATION).union(Cursor.Profile.TO_NODE_TEST).union(Cursor.Profile.TO_PARENT), null);
            Stack<Cursor> stack = new Stack<Cursor>();
            while (true) {
                if (cursor5 != null) {
                    stack.push(cursor5);
                }
                if (!(cursor2 = cursor3.fork(true, profile.union(Cursor.Profile.TO_FOLLOWING_SIBLINGS).union(Cursor.Profile.TO_PARENT), cursor3.futureProfile())).toParent()) break;
                if (cursor3 != cursor4) {
                    cursor3.release();
                }
                cursor3 = cursor2;
                object2 = ExecutableForAxesDefault.this.prepareAxisExec(cursor3, Axis.FOLLOWINGSIBLING);
                cursor5 = object2.execute(cursor2, null, profile2, null);
            }
            cursor2.release();
            while (!stack.isEmpty()) {
                cursor2 = (Cursor)stack.pop();
                this._levelStack.push(cursor2);
            }
            if (this.itemKind() == 2) {
                cursor2 = this.getDelegate();
                object2 = cursor2.fork(true, profile.union(Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_PARENT).union(Cursor.Profile.TO_NODE_TEST)), cursor3.futureProfile().union(Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_PARENT).union(Cursor.Profile.TO_NODE_TEST)));
                if (object2.toParent()) {
                    this.pushChildren((Cursor)object2);
                }
                object2.release();
            }
            if (this._levelStack.isEmpty()) {
                return false;
            }
            cursor2 = (Cursor)this._levelStack.peek();
            object2 = cursor2.fork(true, MINIMAL_PLUS_TOSELF.union(Cursor.Profile.TO_NODE_TEST), cursor2.futureProfile());
            object2.toSelf();
            this.setDelegate((Cursor)object2);
            boolean bl = this.toNext();
            if (!bl) {
                this.release();
            }
            return bl;
        }

        public boolean coreToNext() {
            if (this._levelStack.isEmpty()) {
                return false;
            }
            Cursor cursor2 = (Cursor)this._levelStack.peek();
            Cursor cursor3 = cursor2.fork(true, MINIMAL_PLUS_TOSELF.union(Cursor.Profile.TO_NODE_TEST), cursor2.futureProfile());
            cursor3.toSelf();
            Cursor cursor4 = this.getDelegate();
            cursor4.release();
            this.setDelegate(cursor3);
            if (!cursor2.toNext()) {
                cursor2.release();
                this._levelStack.pop();
            }
            this.pushChildren(this.getDelegate());
            return true;
        }

        public void release() {
            Stack stack = this._levelStack;
            Cursor cursor2 = this.getDelegate();
            int n2 = stack.size();
            for (int i = n2 - 1; i >= 0; --i) {
                Cursor cursor3 = (Cursor)stack.pop();
                if (cursor2 == cursor3) continue;
                cursor3.release();
            }
            assert (stack.size() == 0);
            super.release();
        }

        public boolean toNext() {
            if (this.hasNavigated) {
                return this.getDelegate().toNext();
            }
            while (this.coreToNext()) {
                if (ExecutableForAxesDefault.this._nodeTest != null && !ExecutableForAxesDefault.this._nodeTest.test(this.getDelegate())) continue;
                return true;
            }
            return false;
        }

        private boolean pushChildren(Cursor cursor2) {
            Cursor cursor3 = cursor2.fork(true, Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_NODE_TEST), cursor2.futureProfile().union(Cursor.Profile.MINIMAL_NAVIGATION).union(Cursor.Profile.TO_NODE_TEST));
            if (cursor3.toChildren(null)) {
                this._levelStack.push(cursor3);
                return true;
            }
            cursor3.release();
            return false;
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            Cursor cursor2 = this.getDelegate().fork(true, profile.union(MINIMAL_PLUS_TOSELF).union(Cursor.Profile.TO_NODE_TEST), profile2.union(Cursor.Profile.MINIMAL_NAVIGATION).union(Cursor.Profile.TO_NODE_TEST));
            cursor2.toSelf();
            FollowingCursor followingCursor = new FollowingCursor(cursor2);
            followingCursor.forkStack(this._levelStack, profile, profile2);
            return followingCursor;
        }
    }

    class PrecedingCursor
    extends AxisCursorWithStackBase {
        private Stack<Boolean> isPrecedingSiblingCursorStack;

        PrecedingCursor(Cursor cursor2) {
            super(cursor2);
            this.isPrecedingSiblingCursorStack = new Stack();
        }

        boolean init(Cursor.Profile profile) {
            Cursor cursor2;
            Cursor cursor3;
            Cursor cursor4 = cursor3 = this.getDelegate();
            Executable executable = ExecutableForAxesDefault.this.prepareAxisExec(cursor3, Axis.PRECEDINGSIBLING);
            if (executable instanceof ExecutableForAxesDefault) {
                ((ExecutableForAxesDefault)executable).shouldProxy = false;
            }
            Cursor cursor5 = executable.execute(cursor3, null, profile, null);
            Stack<Cursor> stack = new Stack<Cursor>();
            while (true) {
                if (cursor5 != null) {
                    stack.push(cursor5);
                }
                if (!(cursor2 = cursor3.fork(true, MINIMAL_PLUS_TOPARENT, cursor3.futureProfile())).toParent()) break;
                if (cursor3 != cursor4) {
                    cursor3.release();
                }
                cursor3 = cursor2;
                cursor5 = executable.execute(cursor3, null, cursor2.profile(), null);
            }
            cursor2.release();
            while (!stack.isEmpty()) {
                cursor2 = (Cursor)stack.pop();
                this._levelStack.push(cursor2);
                this.isPrecedingSiblingCursorStack.push(true);
                this.pushLastChildren(cursor2);
            }
            if (this._levelStack.isEmpty()) {
                return false;
            }
            cursor2 = (Cursor)this._levelStack.peek();
            Cursor cursor6 = cursor2.fork(true, MINIMAL_PLUS_TOSELF.union(Cursor.Profile.TO_NODE_TEST), cursor2.futureProfile());
            cursor6.toSelf();
            this.setDelegate(cursor6);
            boolean bl = this.toNext();
            if (!bl) {
                this.release();
            }
            return bl;
        }

        public void release() {
            Stack stack = this._levelStack;
            Cursor cursor2 = this.getDelegate();
            int n2 = stack.size();
            for (int i = n2 - 1; i >= 0; --i) {
                Cursor cursor3 = (Cursor)stack.pop();
                this.isPrecedingSiblingCursorStack.pop();
                if (cursor2 == cursor3) continue;
                cursor3.release();
            }
            assert (stack.size() == 0);
            if (null != cursor2) {
                cursor2.release();
            }
            this._levelStack = null;
            this.isPrecedingSiblingCursorStack = null;
        }

        public boolean contextIsOrdered(boolean bl) {
            return false;
        }

        boolean isPureReverse() {
            return false;
        }

        public boolean coreToNext() {
            if (this._levelStack.isEmpty()) {
                return false;
            }
            Cursor cursor2 = (Cursor)this._levelStack.peek();
            Cursor cursor3 = cursor2.fork(true, Cursor.Profile.MINIMAL_NAVIGATION, cursor2.futureProfile());
            cursor3.toSelf();
            Cursor cursor4 = this.getDelegate();
            cursor4.release();
            this.setDelegate(cursor3);
            if (this.specialToPrevious(cursor2, this.isPrecedingSiblingCursorStack.peek())) {
                this.pushLastChildren(cursor2);
            } else {
                cursor2.release();
                cursor2 = (Cursor)this._levelStack.pop();
                this.isPrecedingSiblingCursorStack.pop();
            }
            return true;
        }

        public boolean toNext() {
            if (this.hasNavigated) {
                return this.getDelegate().toNext();
            }
            while (this.coreToNext()) {
                if (ExecutableForAxesDefault.this._nodeTest != null && !ExecutableForAxesDefault.this._nodeTest.test(this.getDelegate())) continue;
                return true;
            }
            return false;
        }

        private void pushLastChildren(Cursor cursor2) {
            Cursor cursor3 = cursor2.fork(true, Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_PREVIOUS).union(Cursor.Profile.TO_NODE_TEST), cursor2.futureProfile().union(Cursor.Profile.TO_PREVIOUS).union(Cursor.Profile.TO_NODE_TEST));
            while (cursor3.toChildren(null)) {
                this.runToEnd(cursor3);
                this._levelStack.push(cursor3);
                this.isPrecedingSiblingCursorStack.push(false);
                cursor3 = cursor3.fork(true, Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_PREVIOUS).union(Cursor.Profile.TO_NODE_TEST), cursor3.futureProfile().union(Cursor.Profile.TO_PREVIOUS));
            }
            cursor3.release();
        }

        private boolean specialToPrevious(Cursor cursor2, boolean bl) {
            if (bl) {
                return cursor2.toNext();
            }
            return cursor2.toPrevious();
        }

        private void runToEnd(Cursor cursor2) {
            while (cursor2.toNext()) {
            }
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            Cursor cursor2 = this.getDelegate().fork(true, profile, profile2);
            cursor2.toSelf();
            PrecedingCursor precedingCursor = new PrecedingCursor(cursor2);
            precedingCursor.forkStack(this._levelStack, profile, profile2);
            precedingCursor.isPrecedingSiblingCursorStack = (Stack)this.isPrecedingSiblingCursorStack.clone();
            return precedingCursor;
        }
    }

    public class SelfCursor
    extends AxisCursorBase {
        private final Cursor.Profile SELF_PROFILE;

        SelfCursor(Cursor cursor2) {
            super(cursor2);
            this.SELF_PROFILE = Cursor.Profile.TO_SELF.union(Cursor.Profile.TO_PREVIOUS).union(Cursor.Profile.TO_POSITION).union(Cursor.Profile.SIZE);
        }

        public boolean contextIsOrdered(boolean bl) {
            return true;
        }

        boolean init(Cursor.Profile profile) {
            Cursor cursor2 = this.getDelegate();
            if ((cursor2 = cursor2.fork(true, Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_SELF), cursor2.futureProfile())).toSelf() && (ExecutableForAxesDefault.this._nodeTest == null || ExecutableForAxesDefault.this._nodeTest.test(cursor2))) {
                this.setDelegate(cursor2);
                return true;
            }
            cursor2.release();
            return false;
        }

        public boolean toNext() {
            if (this.hasNavigated) {
                return this.getDelegate().toNext();
            }
            return false;
        }

        public long contextSize() {
            if (this.hasNavigated) {
                return this.getDelegate().contextSize();
            }
            return 1L;
        }

        public boolean contextIsSingleton() {
            if (this.hasNavigated) {
                return this.getDelegate().contextIsSingleton();
            }
            return true;
        }

        public boolean toPrevious() {
            if (this.hasNavigated) {
                return this.getDelegate().toPrevious();
            }
            return false;
        }

        public boolean toPosition(long l) {
            if (this.hasNavigated) {
                return this.getDelegate().toPosition(l);
            }
            return l == 1L;
        }

        public Cursor.Profile profile() {
            if (this.hasNavigated) {
                return this.getDelegate().profile();
            }
            return this.SELF_PROFILE.union(this.getDelegate().profile());
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            Cursor cursor2 = this.getDelegate().fork(true, profile, profile2);
            cursor2.toSelf();
            return new SelfCursor(cursor2);
        }
    }

    public class NamespaceCursor
    extends AxisCursorBase {
        private Set prefixes;
        Cursor currentElementCursor;
        private final Cursor.Profile NAMESPACE_REQUIREMENTS;

        NamespaceCursor(Cursor cursor2) {
            super(cursor2);
            this.prefixes = new HashSet();
            this.NAMESPACE_REQUIREMENTS = Cursor.Profile.TO_PARENT.union(Cursor.Profile.MINIMAL_NAVIGATION);
        }

        public boolean contextIsOrdered(boolean bl) {
            return true;
        }

        boolean init(Cursor.Profile profile) {
            Cursor cursor2 = this.getDelegate();
            this.currentElementCursor = cursor2.fork(true, MINIMAL_PLUS_TOPARENT, cursor2.futureProfile());
            do {
                Cursor cursor3;
                if ((cursor3 = this.currentElementCursor.fork(true, MINIMAL_PLUS_TOPARENT, this.currentElementCursor.futureProfile())).toNamespaceDecls()) {
                    do {
                        VolatileCData volatileCData;
                        String string2;
                        String string3 = string2 = (volatileCData = cursor3.itemName()) == null ? "" : volatileCData.getQName(1, null).getLocalPart();
                        if (!this.prefixes.add(string2)) continue;
                        if (ExecutableForAxesDefault.this._nodeTest != null) {
                            if (!ExecutableForAxesDefault.this._nodeTest.test(cursor3)) continue;
                            this.setDelegate(cursor3);
                            return true;
                        }
                        this.setDelegate(cursor3);
                        return true;
                    } while (cursor3.toNext());
                }
                cursor3.release();
            } while (this.currentElementCursor.toParent());
            this.currentElementCursor.release();
            return false;
        }

        public boolean toNext() {
            String string2;
            VolatileCData volatileCData;
            if (this.hasNavigated) {
                return this.getDelegate().toNext();
            }
            if (this.currentElementCursor == null) {
                return false;
            }
            Cursor cursor2 = this.getDelegate();
            Cursor cursor3 = cursor2.fork(true);
            while (cursor2.toNext()) {
                volatileCData = cursor2.itemName();
                string2 = volatileCData == null ? "" : volatileCData.getQName(1, null).getLocalPart();
                if (!this.prefixes.add(string2)) continue;
                if (ExecutableForAxesDefault.this._nodeTest != null) {
                    if (!ExecutableForAxesDefault.this._nodeTest.test(cursor2)) continue;
                    cursor3.release();
                    this.setDelegate(cursor2);
                    return true;
                }
                cursor3.release();
                this.setDelegate(cursor2);
                return true;
            }
            cursor2.release();
            this.setDelegate(cursor3);
            if (this.currentElementCursor.toParent()) {
                do {
                    if ((cursor2 = this.currentElementCursor.fork(true, Cursor.Profile.MINIMAL_NAVIGATION, this.currentElementCursor.futureProfile())).toNamespaceDecls()) {
                        do {
                            String string3 = string2 = (volatileCData = cursor2.itemName()) == null ? "" : volatileCData.getQName(1, null).getLocalPart();
                            if (!this.prefixes.add(string2)) continue;
                            if (ExecutableForAxesDefault.this._nodeTest != null) {
                                if (!ExecutableForAxesDefault.this._nodeTest.test(cursor2)) continue;
                                cursor3.release();
                                this.setDelegate(cursor2);
                                return true;
                            }
                            cursor3.release();
                            this.setDelegate(cursor2);
                            return true;
                        } while (cursor2.toNext());
                    }
                    cursor2.release();
                } while (this.currentElementCursor.toParent());
                this.currentElementCursor.release();
                this.currentElementCursor = null;
            }
            return false;
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            NamespaceCursor namespaceCursor = new NamespaceCursor(this.getDelegate().fork(false, profile.union(this.NAMESPACE_REQUIREMENTS), profile2.union(this.NAMESPACE_REQUIREMENTS)));
            namespaceCursor.currentElementCursor = this.currentElementCursor.fork(false, profile.union(this.NAMESPACE_REQUIREMENTS), profile2.union(this.NAMESPACE_REQUIREMENTS));
            namespaceCursor.prefixes.addAll(this.prefixes);
            return namespaceCursor;
        }

        public void release() {
            if (this.currentElementCursor != null) {
                this.currentElementCursor.release();
                this.currentElementCursor = null;
            }
            super.release();
        }
    }

    public class FollowingSiblingCursor
    extends AxisCursorBase {
        public FollowingSiblingCursor(Cursor cursor2) {
            super(cursor2);
        }

        public boolean contextIsOrdered(boolean bl) {
            return true;
        }

        boolean init(Cursor.Profile profile) {
            Cursor cursor2 = this.getDelegate();
            Cursor cursor3 = cursor2.fork(true, profile.union(Cursor.Profile.TO_FOLLOWING_SIBLINGS.union(Cursor.Profile.TO_NODE_TEST)), cursor2.futureProfile());
            if (cursor3.toFollowingSiblings(ExecutableForAxesDefault.this._nodeTest)) {
                this.setDelegate(cursor3);
                return true;
            }
            cursor3.release();
            return false;
        }

        public boolean toNext() {
            return this.getDelegate().toNext();
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            return new FollowingSiblingCursor(this.getDelegate().fork(false, profile.union(Cursor.Profile.MINIMAL_STREAMING_NAVIGATION), profile2.union(Cursor.Profile.MINIMAL_STREAMING_NAVIGATION)));
        }

        public void release() {
            super.release();
        }
    }

    public class PrecedingSiblingCursor
    extends AxisCursorBase {
        public PrecedingSiblingCursor(Cursor cursor2) {
            super(cursor2);
        }

        public boolean contextIsOrdered(boolean bl) {
            return false;
        }

        boolean isPureReverse() {
            return true;
        }

        boolean init(Cursor.Profile profile) {
            Cursor cursor2 = this.getDelegate();
            if (cursor2.itemKind() == 2) {
                return false;
            }
            Cursor cursor3 = cursor2.factory().proxy(cursor2.fork(false), profile.union(Cursor.Profile.TO_PRECEDING_SIBLINGS.union(Cursor.Profile.TO_NODE_TEST)), true, null, null);
            if (cursor3.toPrecedingSiblings(ExecutableForAxesDefault.this._nodeTest)) {
                this.setDelegate(cursor3);
                return true;
            }
            cursor3.release();
            return false;
        }

        public boolean toNext() {
            return this.getDelegate().toNext();
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            return new PrecedingSiblingCursor(this.getDelegate().fork(false, profile, profile2));
        }
    }

    public class ParentCursor
    extends AxisCursorBase {
        private final Cursor.Profile PARENT_PROFILE;

        ParentCursor(Cursor cursor2) {
            super(cursor2);
            this.PARENT_PROFILE = Cursor.Profile.TO_SELF.union(Cursor.Profile.TO_PREVIOUS).union(Cursor.Profile.TO_POSITION).union(Cursor.Profile.SIZE);
        }

        boolean init(Cursor.Profile profile) {
            Cursor cursor2 = this.getDelegate();
            if ((cursor2 = cursor2.fork(true, profile.union(Cursor.Profile.TO_PARENT), cursor2.futureProfile())).toParent() && (ExecutableForAxesDefault.this._nodeTest == null || ExecutableForAxesDefault.this._nodeTest.test(cursor2))) {
                this.setDelegate(cursor2);
                return true;
            }
            cursor2.release();
            return false;
        }

        public boolean toNext() {
            if (this.hasNavigated) {
                return this.getDelegate().toNext();
            }
            return false;
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            Cursor cursor2 = this.getDelegate().fork(true, profile.union(Cursor.Profile.TO_SELF), profile2);
            cursor2.toSelf();
            return new ParentCursor(cursor2);
        }

        public long contextSize() {
            if (this.hasNavigated) {
                return this.getDelegate().contextSize();
            }
            return 1L;
        }

        public boolean toPosition(long l) {
            if (this.hasNavigated) {
                return this.getDelegate().toPosition(l);
            }
            return l == 1L;
        }

        public Cursor.Profile profile() {
            if (this.hasNavigated) {
                return this.getDelegate().profile();
            }
            return this.PARENT_PROFILE.union(this.getDelegate().profile());
        }

        public boolean contextIsSingleton() {
            if (this.hasNavigated) {
                return this.getDelegate().contextIsSingleton();
            }
            return true;
        }
    }

    public class AncestorCursor
    extends AxisCursorBase {
        boolean _isSelf;

        AncestorCursor(Cursor cursor2, boolean bl) {
            super(cursor2);
            this._isSelf = false;
            this._isSelf = bl;
        }

        public boolean contextIsOrdered(boolean bl) {
            return false;
        }

        boolean isPureReverse() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean init(Cursor.Profile profile) {
            Cursor cursor2 = this.getDelegate();
            cursor2 = cursor2.fork(true, TOPARENT_TOSELF_PROFILE, cursor2.futureProfile());
            boolean bl = false;
            this.setDelegate(cursor2);
            try {
                if (!this._isSelf && !cursor2.toParent()) {
                    boolean bl2 = false;
                    return bl2;
                }
                cursor2.toSelf();
                do {
                    if (ExecutableForAxesDefault.this._nodeTest != null) {
                        if (!ExecutableForAxesDefault.this._nodeTest.test(cursor2)) continue;
                        this.setDelegate(cursor2);
                        bl = true;
                    } else {
                        this.setDelegate(cursor2);
                        bl = true;
                    }
                    break;
                } while (cursor2.toParent());
            }
            finally {
                if (!bl) {
                    this.release();
                }
            }
            return bl;
        }

        public boolean toNext() {
            if (this.hasNavigated) {
                return this.getDelegate().toNext();
            }
            Cursor cursor2 = this.getDelegate();
            Cursor cursor3 = cursor2.fork(true, MINIMAL_PLUS_TOPARENT, cursor2.futureProfile());
            while (cursor3.toParent()) {
                if (ExecutableForAxesDefault.this._nodeTest != null) {
                    if (!ExecutableForAxesDefault.this._nodeTest.test(cursor3)) continue;
                    cursor2.release();
                    this.setDelegate(cursor3);
                    return true;
                }
                cursor2.release();
                this.setDelegate(cursor3);
                return true;
            }
            cursor3.release();
            return false;
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(true, profile, profile2);
            }
            Cursor cursor2 = this.getDelegate().fork(true, profile.union(MINIMAL_PLUS_TOSELF.union(Cursor.Profile.TO_PARENT)), profile2.union(MINIMAL_PLUS_TOPARENT));
            cursor2.toSelf();
            return new AncestorCursor(cursor2, this._isSelf);
        }

        public void release() {
            super.release();
        }
    }

    public class AttributeChildCursor
    extends AxisCursorBase {
        Cursor attrCursor;
        Cursor childCursor;
        long contextPos;
        long contextSize;

        public AttributeChildCursor(Cursor cursor2) {
            super(cursor2);
            this.attrCursor = null;
            this.childCursor = null;
            this.contextPos = 0L;
            this.contextSize = -1L;
        }

        public Cursor.Profile profile() {
            return this.getDelegate().profile();
        }

        public Cursor.Profile profileLimit() {
            return this.futureProfile();
        }

        public Cursor.Profile futureProfile() {
            return this.getDelegate().futureProfile();
        }

        public boolean isDocOrdered() {
            return true;
        }

        boolean init(Cursor.Profile profile) {
            this.contextSize = -1L;
            this.contextPos = 0L;
            Cursor cursor2 = this.getDelegate();
            Cursor cursor3 = cursor2.fork(true, Cursor.Profile.RANDOM_ACCESS, cursor2.futureProfile().union(Cursor.Profile.RANDOM_ACCESS));
            if (cursor3.toAttributes(ExecutableForAxesDefault.this._nodeTest)) {
                this.attrCursor = cursor3;
                this.setDelegate(cursor3);
                this.contextPos = 1L;
                cursor3 = cursor2.fork(true, Cursor.Profile.RANDOM_ACCESS, cursor2.futureProfile().union(Cursor.Profile.RANDOM_ACCESS));
            } else {
                this.attrCursor = null;
            }
            if (cursor3.toChildren(ExecutableForAxesDefault.this._nodeTest)) {
                this.childCursor = cursor3;
                if (0L == this.contextPos) {
                    this.setDelegate(cursor3);
                    this.contextPos = 1L;
                }
            } else {
                this.childCursor = null;
            }
            if (this.contextPos == 0L) {
                if (this.attrCursor != null) {
                    this.attrCursor.release();
                }
                if (this.childCursor != null) {
                    this.childCursor.release();
                }
                return false;
            }
            return true;
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            return new AttributeChildCursor(profile, profile2, this);
        }

        private AttributeChildCursor(Cursor.Profile profile, Cursor.Profile profile2, AttributeChildCursor attributeChildCursor) {
            boolean bl;
            super(attributeChildCursor.getDelegate().fork(false, profile, profile2));
            this.attrCursor = null;
            this.childCursor = null;
            this.contextPos = 0L;
            this.contextSize = -1L;
            boolean bl2 = bl = attributeChildCursor.getDelegate() == attributeChildCursor.attrCursor;
            if (attributeChildCursor.attrCursor != null) {
                Cursor cursor2 = bl ? this.getDelegate() : (this.attrCursor = attributeChildCursor.attrCursor == null ? null : attributeChildCursor.attrCursor.fork(false, profile, profile2));
            }
            if (attributeChildCursor.childCursor != null) {
                this.childCursor = !bl ? this.getDelegate() : (attributeChildCursor.childCursor == null ? null : attributeChildCursor.childCursor.fork(false, profile, profile2));
            }
            this.contextSize = attributeChildCursor.contextSize;
            this.contextPos = attributeChildCursor.contextPos;
        }

        public boolean toNext() {
            Cursor cursor2 = this.getDelegate();
            if (this.hasNavigated) {
                return cursor2.toNext();
            }
            if (cursor2.toNext()) {
                ++this.contextPos;
                return true;
            }
            if (cursor2 == this.attrCursor && this.childCursor != null) {
                this.setDelegate(this.childCursor);
                ++this.contextPos;
                return true;
            }
            this.contextSize = this.contextPos;
            return false;
        }

        public long contextPosition() {
            return this.contextPos;
        }

        public long contextSize() {
            if (this.contextSize == -1L) {
                Cursor cursor2 = this.fork(false, this.profile(), this.futureProfile());
                while (cursor2.toNext()) {
                }
                this.contextSize = cursor2.contextSize();
            }
            assert (this.contextSize > 0L);
            return this.contextSize;
        }

        public boolean toPrevious() {
            Cursor cursor2 = this.getDelegate();
            if (this.hasNavigated) {
                return cursor2.toPrevious();
            }
            if (cursor2.toPrevious()) {
                --this.contextPos;
                return true;
            }
            if (cursor2 == this.childCursor && this.attrCursor != null) {
                this.setDelegate(this.attrCursor);
                cursor2.toPosition(--this.contextPos);
                return true;
            }
            assert (this.contextPos == 0L);
            return false;
        }

        public boolean toPosition(long l) {
            long l2;
            Cursor cursor2 = this.getDelegate();
            if (this.hasNavigated) {
                return cursor2.toPrevious();
            }
            long l3 = l2 = this.attrCursor == null ? 0L : this.attrCursor.contextSize();
            if (l <= l2 && this.attrCursor.toPosition(this.contextPos = l)) {
                if (null != this.childCursor) {
                    this.childCursor.toPosition(1L);
                }
                this.setDelegate(this.attrCursor);
                this.contextPos = l;
                return true;
            }
            if (this.childCursor.toPosition(l - l2)) {
                if (null != this.attrCursor) {
                    this.attrCursor.toPosition(l2);
                }
                this.setDelegate(this.childCursor);
                this.contextPos = l;
                return true;
            }
            return false;
        }

        public void release() {
            Cursor cursor2 = this.getDelegate();
            if (this.attrCursor != null && this.attrCursor != cursor2) {
                this.attrCursor.release();
            }
            if (this.childCursor != null && this.childCursor != cursor2) {
                this.childCursor.release();
            }
            super.release();
        }

        public boolean contextIsSingleton() {
            return (this.attrCursor == null || this.childCursor == null) && this.getDelegate().contextIsSingleton();
        }
    }

    class AttributeCursor
    extends AxisCursorBase {
        public AttributeCursor(Cursor cursor2) {
            super(cursor2);
        }

        public Cursor.Profile profile() {
            return this.getDelegate().profile();
        }

        public Cursor.Profile profileLimit() {
            return this.futureProfile();
        }

        public Cursor.Profile futureProfile() {
            return this.getDelegate().futureProfile();
        }

        public boolean isDocOrdered() {
            return true;
        }

        boolean init(Cursor.Profile profile) {
            Cursor cursor2 = this.getDelegate();
            if ((cursor2 = cursor2.fork(true, Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_NODE_TEST), cursor2.futureProfile())).toAttributes(ExecutableForAxesDefault.this._nodeTest)) {
                this.setDelegate(cursor2);
                return true;
            }
            cursor2.release();
            return false;
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            return new AttributeCursor(this.getDelegate().fork(false, profile, profile2));
        }

        public long contextPosition() {
            return this.getDelegate().contextPosition();
        }

        public long contextSize() {
            return this.getDelegate().contextSize();
        }

        public boolean toPosition(long l) {
            return this.getDelegate().toPosition(l);
        }
    }

    class TypedDescendantCursor
    extends DescendantCursor {
        TypedDescendantCursor(Cursor cursor2) {
            super(cursor2);
        }

        boolean init(Cursor.Profile profile) {
            if (this.getDelegate().itemKind() == 2) {
                return false;
            }
            Cursor cursor2 = this.getDelegate();
            cursor2 = this.getDelegate().fork(true, Cursor.Profile.MINIMAL_NAVIGATION, cursor2.futureProfile());
            if (!cursor2.toChildren(null)) {
                return false;
            }
            this._levelStack.push(cursor2);
            if (!ExecutableForAxesDefault.this._nodeTest.test(cursor2)) {
                return this.toNext();
            }
            this.setDelegate(cursor2);
            return true;
        }

        public boolean toNext() {
            if (this.hasNavigated) {
                return this.getDelegate().toNext();
            }
            Cursor cursor2 = this.getDelegate().fork(true);
            while (this._levelStack.size() > 0) {
                if (!super.toNext() || !ExecutableForAxesDefault.this._nodeTest.test(this)) continue;
                cursor2.release();
                return true;
            }
            cursor2.toSelf();
            this.setDelegate(cursor2);
            return false;
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            Cursor cursor2 = this.getDelegate().fork(true, profile.union(MINIMAL_PLUS_TOSELF), profile2.union(MINIMAL_PLUS_TOSELF));
            cursor2.toSelf();
            TypedDescendantCursor typedDescendantCursor = new TypedDescendantCursor(cursor2);
            typedDescendantCursor.forkStack(this._levelStack, profile.union(MINIMAL_PLUS_TOSELF), profile2.union(MINIMAL_PLUS_TOSELF));
            return typedDescendantCursor;
        }
    }

    class TypedDescendantOrSelfCursor
    extends DescendantOrSelfCursor {
        boolean _ex;

        TypedDescendantOrSelfCursor(Cursor cursor2) {
            super(cursor2);
        }

        boolean init(Cursor.Profile profile) {
            Cursor cursor2 = this.getDelegate();
            cursor2 = cursor2.fork(true, profile.union(MINIMAL_PLUS_TOSELF), cursor2.futureProfile());
            this._levelStack.push(cursor2);
            if (!cursor2.toSelf() || !ExecutableForAxesDefault.this._nodeTest.test(cursor2)) {
                boolean bl = this.toNext();
                if (!bl) {
                    this.release();
                }
                return bl;
            }
            this.setDelegate(cursor2);
            return true;
        }

        public boolean toNext() {
            if (this.hasNavigated) {
                return this.getDelegate().toNext();
            }
            Cursor cursor2 = this.getDelegate().fork(true);
            while (this._levelStack.size() > 0) {
                if (!super.toNext() || !ExecutableForAxesDefault.this._nodeTest.test(this)) continue;
                cursor2.release();
                return true;
            }
            cursor2.toSelf();
            this.setDelegate(cursor2);
            return false;
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            Cursor cursor2 = this.getDelegate();
            TypedDescendantOrSelfCursor typedDescendantOrSelfCursor = new TypedDescendantOrSelfCursor(cursor2);
            typedDescendantOrSelfCursor.forkStack(this._levelStack, profile, profile2);
            typedDescendantOrSelfCursor.setDelegate((Cursor)typedDescendantOrSelfCursor._levelStack.peek());
            return typedDescendantOrSelfCursor;
        }
    }

    class DescendantCursor
    extends AxisCursorWithStackBase {
        DescendantCursor(Cursor cursor2) {
            super(cursor2);
        }

        boolean init(Cursor.Profile profile) {
            this.hasNavigated = false;
            if (this.getDelegate().itemKind() == 2) {
                return false;
            }
            Cursor cursor2 = this.getDelegate();
            if (!(cursor2 = cursor2.fork(true, profile.union(MINIMAL_PLUS_TOSELF), cursor2.futureProfile())).toSelf()) {
                this.release();
                return false;
            }
            this._levelStack.push(cursor2);
            this.setDelegate(cursor2);
            boolean bl = this.toNext();
            if (!bl) {
                this.release();
            }
            return bl;
        }

        public void release() {
            Stack stack = this._levelStack;
            Cursor cursor2 = this.getDelegate();
            int n2 = stack.size();
            for (int i = n2 - 1; i >= 0; --i) {
                Cursor cursor3 = (Cursor)stack.pop();
                if (cursor2 == cursor3) continue;
                cursor3.release();
            }
            assert (stack.size() == 0);
            super.release();
        }

        public boolean toNext() {
            if (this.hasNavigated) {
                return this.getDelegate().toNext();
            }
            if (this._levelStack.isEmpty()) {
                return false;
            }
            Cursor cursor2 = (Cursor)this._levelStack.peek();
            Cursor cursor3 = cursor2.fork(true, Cursor.Profile.MINIMAL_NAVIGATION, cursor2.futureProfile().union(Cursor.Profile.MINIMAL_NAVIGATION));
            if (cursor3.toChildren(null)) {
                this._levelStack.push(cursor3);
                this.setDelegate(cursor3);
                return true;
            }
            cursor3.release();
            while (true) {
                if (cursor2.toNext()) {
                    this.setDelegate(cursor2);
                    return true;
                }
                this._levelStack.pop();
                if (this._levelStack.isEmpty()) {
                    this.setDelegate(cursor2);
                    return false;
                }
                cursor2.release();
                cursor2 = (Cursor)this._levelStack.peek();
            }
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            Cursor cursor2 = this.getDelegate().fork(true, profile.union(MINIMAL_PLUS_TOSELF), profile2.union(MINIMAL_PLUS_TOSELF));
            cursor2.toSelf();
            DescendantCursor descendantCursor = new DescendantCursor(cursor2);
            descendantCursor.forkStack(this._levelStack, profile.union(MINIMAL_PLUS_TOSELF), profile2.union(MINIMAL_PLUS_TOSELF));
            return descendantCursor;
        }
    }

    class DescendantOrSelfCursor
    extends DescendantCursor {
        DescendantOrSelfCursor(Cursor cursor2) {
            super(cursor2);
        }

        public boolean isDocOrdered() {
            return true;
        }

        boolean init(Cursor.Profile profile) {
            this.hasNavigated = false;
            Cursor cursor2 = this.getDelegate();
            if (!(cursor2 = cursor2.fork(true, profile.union(Cursor.Profile.MINIMAL_NAVIGATION.union(Cursor.Profile.TO_SELF)), cursor2.futureProfile())).toSelf()) {
                return false;
            }
            this._levelStack.push(cursor2);
            this.setDelegate(cursor2);
            return true;
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            Cursor cursor2 = this.getDelegate().fork(true, profile.union(MINIMAL_PLUS_TOSELF), profile2.union(MINIMAL_PLUS_TOSELF));
            cursor2.toSelf();
            DescendantOrSelfCursor descendantOrSelfCursor = new DescendantOrSelfCursor(cursor2);
            descendantOrSelfCursor.forkStack(this._levelStack, profile.union(MINIMAL_PLUS_TOSELF), profile2.union(MINIMAL_PLUS_TOSELF));
            return descendantOrSelfCursor;
        }
    }

    class ChildrenCursor
    extends AxisCursorBase {
        public ChildrenCursor(Cursor cursor2) {
            super(cursor2);
        }

        public Cursor.Profile profile() {
            return this.getDelegate().profile();
        }

        public Cursor.Profile profileLimit() {
            return this.futureProfile();
        }

        public Cursor.Profile futureProfile() {
            return this.getDelegate().futureProfile();
        }

        public boolean isDocOrdered() {
            return true;
        }

        boolean init(Cursor.Profile profile) {
            Cursor cursor2 = this.getDelegate();
            if ((cursor2 = cursor2.fork(true, Cursor.Profile.MINIMAL_NAVIGATION, cursor2.futureProfile())).toChildren(ExecutableForAxesDefault.this._nodeTest)) {
                this.setDelegate(cursor2);
                return true;
            }
            cursor2.release();
            return false;
        }

        public Cursor fork(boolean bl, Cursor.Profile profile, Cursor.Profile profile2) {
            if (bl || this.hasNavigated) {
                return super.fork(bl, profile, profile2);
            }
            return new ChildrenCursor(this.getDelegate().fork(false, profile, profile2));
        }

        public long contextPosition() {
            return this.getDelegate().contextPosition();
        }

        public long contextSize() {
            return this.getDelegate().contextSize();
        }

        public boolean toPosition(long l) {
            return this.getDelegate().toPosition(l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class DefaultExecutableAxisCursor
    extends AbstractSimpleDelegatingCursor {
        private final Cursor.Profile MISSING_FEATURES;

        public DefaultExecutableAxisCursor(Cursor cursor2) {
            super(cursor2);
            this.MISSING_FEATURES = Cursor.Profile.SIZE.union(Cursor.Profile.POSITION).union(Cursor.Profile.TO_POSITION).union(Cursor.Profile.TO_PREVIOUS);
        }

        @Override
        public Cursor.Profile profile() {
            return this.getDelegate().profile().difference(this.MISSING_FEATURES);
        }

        @Override
        public Cursor.Profile profileLimit() {
            return this.futureProfile();
        }

        @Override
        public Cursor.Profile futureProfile() {
            return this.getDelegate().futureProfile().difference(this.MISSING_FEATURES);
        }

        boolean isPureReverse() {
            return false;
        }

        @Override
        public Cursor documentOrder(Cursor.Profile profile, Cursor.Profile profile2, boolean bl) {
            if (this.contextIsOrdered(true)) {
                if (!bl) {
                    return this.fork(false, profile, this.futureProfile());
                }
                return this;
            }
            Cursor cursor2 = ExecutableForAxesDefault.this.reverseGeneric(this, profile, profile2);
            return cursor2;
        }

        @Override
        public long contextPosition() {
            assert (false);
            return -1L;
        }

        @Override
        public long contextSize() {
            assert (false);
            return -1L;
        }

        @Override
        public boolean toPosition(long l) {
            assert (false);
            return false;
        }

        @Override
        public VolatileCData serialize(Map<String, Object> map2) {
            return new SerializedCData(this, map2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AxisCursorWithStackBase
    extends AxisCursorBase {
        protected Stack<Cursor> _levelStack;

        public AxisCursorWithStackBase(Cursor cursor2) {
            super(cursor2);
            this._levelStack = new Stack();
        }

        protected void forkStack(Stack<Cursor> stack, Cursor.Profile profile, Cursor.Profile profile2) {
            if (stack != null) {
                int n2 = stack.size();
                for (int i = 0; i < n2; ++i) {
                    Cursor cursor2 = (Cursor)stack.get(i);
                    Cursor cursor3 = cursor2.fork(false, cursor2.profile(), cursor2.futureProfile());
                    this._levelStack.push(cursor3);
                }
            }
        }
    }

    abstract class AxisCursorBase
    extends DefaultExecutableAxisCursor {
        boolean hasNavigated;

        public AxisCursorBase(Cursor cursor2) {
            super(cursor2);
            this.hasNavigated = false;
        }

        protected void simpleDumpNode() {
            VolatileCData volatileCData;
            System.out.print("result node of type " + Cursor.KINDS[this.itemKind()]);
            if (this.itemName() != null && this.itemName().toString().length() > 0) {
                System.out.print(", is named: " + this.itemName());
            }
            if (null != (volatileCData = this.itemTypedValue()) && volatileCData.toString() != null && volatileCData.toString().trim().length() > 0) {
                System.out.print(", with a value of: " + volatileCData.toString().trim());
            } else if (this.itemKind() == 3) {
                System.out.print(" (whitespace)");
            }
            System.out.println();
        }

        abstract boolean init(Cursor.Profile var1);

        public boolean toPrevious() {
            assert (false) : XCIMessages.createXCIMessage("ER_UNSUPPORTED_OPERATION", new String[]{"Profile.TO_PREVIOUS"});
            return false;
        }

        protected void navigate() {
            this.hasNavigated = true;
        }
    }
}

