/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.exec;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.Axis;
import com.ibm.xml.xci.exec.BasicGenericExecutable;
import com.ibm.xml.xci.exec.CompilationParameters;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.ExecutableForAxesDefault;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import com.ibm.xml.xci.res.XCIMessages;
import java.io.File;
import java.io.StringReader;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class GenericPreparer
implements Preparer {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private final SessionContext _sessionContext;
    public static final boolean greedy = false;

    public GenericPreparer(SessionContext sessionContext) {
        this._sessionContext = sessionContext;
    }

    public Executable prepare(Axis axis, NodeTest nodeTest, StaticContext staticContext, int n2) {
        BasicGenericExecutable basicGenericExecutable = this.prepareBasicGenericExecutable(axis, nodeTest, staticContext, n2);
        return basicGenericExecutable;
    }

    protected BasicGenericExecutable prepareBasicGenericExecutable(Axis axis, NodeTest nodeTest, StaticContext staticContext, int n2) {
        int n3 = this._sessionContext.getDataProviderCount();
        BasicGenericExecutable basicGenericExecutable = new BasicGenericExecutable(null, staticContext);
        Executable[] executableArray = null;
        LazyExecutableForDefault lazyExecutableForDefault = new LazyExecutableForDefault(axis, nodeTest, staticContext, n2);
        basicGenericExecutable.setDefaultExecutable(lazyExecutableForDefault);
        for (int i = 0; i < n3; ++i) {
            if (i == n2) continue;
            if (executableArray == null) {
                executableArray = new Executable[n3];
            }
            executableArray[i] = new LazyExecutable(axis, nodeTest, staticContext, n2, i, executableArray, lazyExecutableForDefault);
        }
        basicGenericExecutable.setDataProviderExecutableList(executableArray);
        return basicGenericExecutable;
    }

    public Executable prepare(Source source, StaticContext staticContext, int n2) {
        return this.prepareBasicGenericExecutable(source, staticContext, n2);
    }

    protected BasicGenericExecutable prepareBasicGenericExecutable(Source source, StaticContext staticContext, int n2) {
        int n3 = this._sessionContext.getDataProviderCount();
        BasicGenericExecutable basicGenericExecutable = new BasicGenericExecutable(null, staticContext);
        Executable[] executableArray = null;
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            Preparer preparer;
            if (i == n2 || (preparer = this._sessionContext.getPreparer(i, true)) == null) continue;
            if (executableArray == null) {
                executableArray = new Executable[n3];
            }
            executableArray[i] = preparer.prepare(source, staticContext, n2);
            if (bl || executableArray[i] == null) continue;
            bl = true;
        }
        if (bl) {
            basicGenericExecutable.setDataProviderExecutableList(executableArray);
        }
        return basicGenericExecutable;
    }

    public Executable prepare(String string2, StaticContext staticContext, int n2) {
        StreamSource streamSource = new StreamSource(new StringReader(string2));
        return this.prepare(streamSource, staticContext, n2);
    }

    public Executable load(String string2) {
        throw new RuntimeException(XCIMessages.createXCIMessage("ER_UNSUPPORTEDLOAD", null));
    }

    public Executable load(CompilationParameters compilationParameters) throws ClassNotFoundException {
        throw new RuntimeException(XCIMessages.createXCIMessage("ER_UNSUPPORTEDLOAD", null));
    }

    public boolean compile(Source source, File file, StaticContext staticContext, String string2, int n2) {
        throw new RuntimeException(XCIMessages.createXCIMessage("ER_UNSUPPORTEDCOMPILE", null));
    }

    public boolean compile(Source source, StaticContext staticContext, CompilationParameters compilationParameters, int n2) {
        throw new RuntimeException(XCIMessages.createXCIMessage("ER_UNSUPPORTEDCOMPILE", null));
    }

    public boolean compile(String string2, File file, StaticContext staticContext, String string3, int n2) {
        throw new RuntimeException(XCIMessages.createXCIMessage("ER_UNSUPPORTEDCOMPILE", null));
    }

    public boolean compile(String string2, StaticContext staticContext, CompilationParameters compilationParameters, int n2) {
        throw new RuntimeException(XCIMessages.createXCIMessage("ER_UNSUPPORTEDCOMPILE", null));
    }

    public SessionContext getSessionContext() {
        return this._sessionContext;
    }

    public class LazyExecutableForDefault
    extends LazyExecutable {
        private Executable realdefaultExecutable;

        public LazyExecutableForDefault(Axis axis, NodeTest nodeTest, StaticContext staticContext, int n2) {
            super(axis, null, nodeTest, staticContext, n2, -1, null, null);
        }

        public LazyExecutableForDefault(Source source, NodeTest nodeTest, StaticContext staticContext, int n2, int n3, Executable[] executableArray) {
            super(null, source, nodeTest, staticContext, n2, n3, executableArray, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Executable fetchAndSetRealExecutable() {
            if (!this.haveTriedToFetch) {
                LazyExecutableForDefault lazyExecutableForDefault = this;
                synchronized (lazyExecutableForDefault) {
                    if (!this.haveTriedToFetch) {
                        if (this.source != null) {
                            return null;
                        }
                        this.realdefaultExecutable = new ExecutableForAxesDefault(this.axis, this.nodeTest, this.staticContext);
                        this.haveTriedToFetch = true;
                    }
                }
            }
            return this.realdefaultExecutable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LazyExecutable
    implements Executable {
        protected final Axis axis;
        protected final Source source;
        protected final NodeTest nodeTest;
        protected final StaticContext staticContext;
        protected final int preparerId;
        protected final int regIndex;
        protected final Executable[] dpExecutableList;
        protected final LazyExecutableForDefault defaultExecutable;
        protected boolean haveTriedToFetch;

        private LazyExecutable(Axis axis, Source source, NodeTest nodeTest, StaticContext staticContext, int n2, int n3, Executable[] executableArray, LazyExecutableForDefault lazyExecutableForDefault) {
            this.axis = axis;
            this.source = source;
            this.nodeTest = nodeTest;
            this.staticContext = staticContext;
            this.preparerId = n2;
            this.regIndex = n3;
            this.dpExecutableList = executableArray;
            this.defaultExecutable = lazyExecutableForDefault;
            this.haveTriedToFetch = false;
        }

        public LazyExecutable(Axis axis, NodeTest nodeTest, StaticContext staticContext, int n2, int n3, Executable[] executableArray, LazyExecutableForDefault lazyExecutableForDefault) {
            this(axis, null, nodeTest, staticContext, n2, n3, executableArray, lazyExecutableForDefault);
        }

        public LazyExecutable(Source source, NodeTest nodeTest, StaticContext staticContext, int n2, int n3, Executable[] executableArray, LazyExecutableForDefault lazyExecutableForDefault) {
            this(null, source, nodeTest, staticContext, n2, n3, executableArray, lazyExecutableForDefault);
        }

        @Override
        public Cursor execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
            Executable executable = this.fetchAndSetRealExecutable();
            return executable.execute(cursor2, dynamicContext, profile, cursorArray);
        }

        @Override
        public void execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray, Result result2) {
            Cursor cursor3 = this.execute(cursor2, dynamicContext, profile, cursorArray);
            cursor3.copyToResult(result2, null, false, true);
        }

        @Override
        public void execute(Cursor cursor2, Cursor.Area area, Cursor cursor3, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
            Executable executable = this.fetchAndSetRealExecutable();
            executable.execute(cursor2, area, cursor3, dynamicContext, profile, cursorArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Executable fetchAndSetRealExecutable() {
            if (!this.haveTriedToFetch) {
                LazyExecutable lazyExecutable = this;
                synchronized (lazyExecutable) {
                    if (!this.haveTriedToFetch) {
                        Preparer preparer = GenericPreparer.this._sessionContext.getPreparer(this.regIndex);
                        if (preparer != null) {
                            this.dpExecutableList[this.regIndex] = this.source != null ? preparer.prepare(this.source, this.staticContext, this.preparerId) : preparer.prepare(this.axis, this.nodeTest, this.staticContext, this.preparerId);
                            if (this.dpExecutableList[this.regIndex] != null) {
                                this.haveTriedToFetch = true;
                                return this.dpExecutableList[this.regIndex];
                            }
                            this.dpExecutableList[this.regIndex] = this.defaultExecutable.fetchAndSetRealExecutable();
                            this.haveTriedToFetch = true;
                            return this.defaultExecutable;
                        }
                        this.dpExecutableList[this.regIndex] = this.defaultExecutable.fetchAndSetRealExecutable();
                        this.haveTriedToFetch = true;
                        return this.defaultExecutable;
                    }
                }
            }
            return this.dpExecutableList[this.regIndex];
        }

        @Override
        public Map<String, Object> getProperties() {
            return null;
        }
    }
}

