/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.cast;

import com.ibm.xml.xci.internal.cast.CastUtilities;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CastJV2Boolean {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean jVToBoolean(float f2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        boolean bl2;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSBOOLEAN, (short)2));
        boolean bl3 = bl2 = (double)f2 != 0.0 && !Float.isNaN(f2);
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSBOOLEAN)) {
            return bl2;
        }
        CastUtilities.validate(String.valueOf(bl2), xSSimpleTypeDefinition);
        return bl2;
    }

    public static boolean jVToBoolean(double d, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        boolean bl2;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSBOOLEAN, (short)2));
        boolean bl3 = bl2 = d != 0.0 && !Double.isNaN(d);
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSBOOLEAN)) {
            return bl2;
        }
        CastUtilities.validate(String.valueOf(bl2), xSSimpleTypeDefinition);
        return bl2;
    }

    public static boolean jVToBoolean(BigDecimal bigDecimal, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        boolean bl2;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSBOOLEAN, (short)2));
        boolean bl3 = bl2 = bigDecimal.compareTo(BigDecimal.ZERO) != 0;
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSBOOLEAN)) {
            return bl2;
        }
        CastUtilities.validate(String.valueOf(bl2), xSSimpleTypeDefinition);
        return bl2;
    }

    public static boolean jVToBoolean(BigInteger bigInteger, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        boolean bl2;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSBOOLEAN, (short)2));
        boolean bl3 = bl2 = !bigInteger.equals(BigInteger.ZERO);
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSBOOLEAN)) {
            return bl2;
        }
        CastUtilities.validate(String.valueOf(bl2), xSSimpleTypeDefinition);
        return bl2;
    }

    public static boolean jVToBoolean(long l, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        boolean bl2;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSBOOLEAN, (short)2));
        boolean bl3 = bl2 = l != 0L;
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSBOOLEAN)) {
            return bl2;
        }
        CastUtilities.validate(String.valueOf(bl2), xSSimpleTypeDefinition);
        return bl2;
    }

    public static boolean jVToBoolean(short s, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        boolean bl2;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSBOOLEAN, (short)2));
        boolean bl3 = bl2 = s != 0;
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSBOOLEAN)) {
            return bl2;
        }
        CastUtilities.validate(String.valueOf(bl2), xSSimpleTypeDefinition);
        return bl2;
    }

    public static boolean jVToBoolean(byte by2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        boolean bl2;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSBOOLEAN, (short)2));
        boolean bl3 = bl2 = by2 != 0;
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSBOOLEAN)) {
            return bl2;
        }
        CastUtilities.validate(String.valueOf(bl2), xSSimpleTypeDefinition);
        return bl2;
    }

    public static boolean jVToBoolean(int n2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        boolean bl2;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSBOOLEAN, (short)2));
        boolean bl3 = bl2 = n2 != 0;
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSBOOLEAN)) {
            return bl2;
        }
        CastUtilities.validate(String.valueOf(bl2), xSSimpleTypeDefinition);
        return bl2;
    }

    public static boolean jVToBoolean(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSBOOLEAN, (short)2));
        return (Boolean)CastUtilities.validate(string2, xSSimpleTypeDefinition);
    }
}

