/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.cast;

import com.ibm.xml.xci.internal.cast.CastUtilities;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.datatypes.XSDecimal;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CastJV2Integer {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static BigInteger jVToInteger(float f2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSINTEGER, (short)2));
        BigInteger bigInteger = new BigDecimal(f2).toBigInteger();
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSINTEGER)) {
            return bigInteger;
        }
        CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition);
        return bigInteger;
    }

    public static int jVToInt(float f2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSINT, (short)2));
        BigInteger bigInteger = new BigDecimal(f2).toBigInteger();
        return ((XSDecimal)CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition)).getInt();
    }

    public static short jVToShort(float f2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSHORT, (short)2));
        BigInteger bigInteger = new BigDecimal(f2).toBigInteger();
        return ((XSDecimal)CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition)).getShort();
    }

    public static long jVToLong(float f2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSLONG, (short)2));
        BigInteger bigInteger = new BigDecimal(f2).toBigInteger();
        return ((XSDecimal)CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition)).getLong();
    }

    public static byte jVToByte(float f2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSBYTE, (short)2));
        BigInteger bigInteger = new BigDecimal(f2).toBigInteger();
        return ((XSDecimal)CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition)).getByte();
    }

    public static BigInteger jVToInteger(double d, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSINTEGER, (short)2));
        BigInteger bigInteger = new BigDecimal(d).toBigInteger();
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSINTEGER)) {
            return bigInteger;
        }
        CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition);
        return bigInteger;
    }

    public static int jVToInt(double d, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSINT, (short)2));
        BigInteger bigInteger = new BigDecimal(d).toBigInteger();
        return ((XSDecimal)CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition)).getInt();
    }

    public static short jVToShort(double d, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSHORT, (short)2));
        BigInteger bigInteger = new BigDecimal(d).toBigInteger();
        return ((XSDecimal)CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition)).getShort();
    }

    public static long jVToLong(double d, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSLONG, (short)2));
        BigInteger bigInteger = new BigDecimal(d).toBigInteger();
        return ((XSDecimal)CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition)).getLong();
    }

    public static byte jVToByte(double d, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSBYTE, (short)2));
        BigInteger bigInteger = new BigDecimal(d).toBigInteger();
        return ((XSDecimal)CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition)).getByte();
    }

    public static BigInteger jVToInteger(BigDecimal bigDecimal, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSINTEGER, (short)2));
        BigInteger bigInteger = bigDecimal.toBigInteger();
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSINTEGER)) {
            return bigInteger;
        }
        CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition);
        return bigInteger;
    }

    public static int jVToInt(BigDecimal bigDecimal, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSINT, (short)2));
        BigInteger bigInteger = bigDecimal.toBigInteger();
        return ((XSDecimal)CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition)).getInt();
    }

    public static short jVToShort(BigDecimal bigDecimal, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSHORT, (short)2));
        BigInteger bigInteger = bigDecimal.toBigInteger();
        return ((XSDecimal)CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition)).getShort();
    }

    public static long jVToLong(BigDecimal bigDecimal, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSLONG, (short)2));
        BigInteger bigInteger = bigDecimal.toBigInteger();
        return ((XSDecimal)CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition)).getLong();
    }

    public static byte jVToByte(BigDecimal bigDecimal, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSBYTE, (short)2));
        BigInteger bigInteger = bigDecimal.toBigInteger();
        return ((XSDecimal)CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition)).getByte();
    }

    public static BigInteger jVToInteger(boolean bl, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl2) throws InvalidDatatypeValueException {
        BigInteger bigInteger;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSINTEGER, (short)2));
        BigInteger bigInteger2 = bigInteger = bl ? BigInteger.ONE : BigInteger.ZERO;
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSINTEGER)) {
            return bigInteger;
        }
        CastUtilities.validate(bigInteger.toString(), xSSimpleTypeDefinition);
        return bigInteger;
    }

    public static int jVToInt(boolean bl, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl2) throws InvalidDatatypeValueException {
        int n2;
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSINTEGER, (short)2));
        int n3 = n2 = bl ? 1 : 0;
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSINT)) {
            return n2;
        }
        CastUtilities.validate(Integer.toString(n2), xSSimpleTypeDefinition);
        return n2;
    }

    public static short jVToShort(boolean bl, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl2) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSHORT, (short)2));
        short s = (short)(bl ? 1 : 0);
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSSHORT)) {
            return s;
        }
        CastUtilities.validate(Integer.toString(s), xSSimpleTypeDefinition);
        return s;
    }

    public static long jVToLong(boolean bl, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl2) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSLONG, (short)2));
        long l = bl ? 1 : 0;
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSLONG)) {
            return l;
        }
        CastUtilities.validate(Long.toString(l), xSSimpleTypeDefinition);
        return l;
    }

    public static byte jVToByte(boolean bl, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl2) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSLONG, (short)2));
        byte by2 = (byte)(bl ? 1 : 0);
        if (xSSimpleTypeDefinition.equals(TypeRegistry.XSBYTE)) {
            return by2;
        }
        CastUtilities.validate(Long.toString(by2), xSSimpleTypeDefinition);
        return by2;
    }

    public static BigInteger jVToInteger(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSINTEGER, (short)2));
        return ((XSDecimal)CastUtilities.validate(string2, xSSimpleTypeDefinition)).getBigInteger();
    }

    public static int jVToInt(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSINT, (short)2));
        return ((XSDecimal)CastUtilities.validate(string2, xSSimpleTypeDefinition)).getInt();
    }

    public static short jVToShort(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSSHORT, (short)2));
        return ((XSDecimal)CastUtilities.validate(string2, xSSimpleTypeDefinition)).getShort();
    }

    public static long jVToLong(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSLONG, (short)2));
        return ((XSDecimal)CastUtilities.validate(string2, xSSimpleTypeDefinition)).getShort();
    }

    public static byte jVToByte(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        assert (xSSimpleTypeDefinition.derivedFromType(TypeRegistry.XSBYTE, (short)2));
        return ((XSDecimal)CastUtilities.validate(string2, xSSimpleTypeDefinition)).getByte();
    }
}

