/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xci.internal.cast;

import com.ibm.xml.jaxp.util.JAXPFactoryHelper;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.dp.type.CastTable;
import com.ibm.xml.xci.dp.type.TypeHelper;
import com.ibm.xml.xci.dp.values.BaseCDataWithChars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.internal.cast.CastJV2Boolean;
import com.ibm.xml.xci.internal.cast.CastJV2Decimal;
import com.ibm.xml.xci.internal.cast.CastJV2Double;
import com.ibm.xml.xci.internal.cast.CastJV2Duration;
import com.ibm.xml.xci.internal.cast.CastJV2Float;
import com.ibm.xml.xci.internal.cast.CastJV2Integer;
import com.ibm.xml.xci.internal.cast.CastJV2QName;
import com.ibm.xml.xci.internal.cast.CastJV2String;
import com.ibm.xml.xci.internal.cast.CastJV2XMLGregorianCalendar;
import com.ibm.xml.xci.internal.cast.XValidationContext;
import com.ibm.xml.xci.internal.values.Base64BinaryCData;
import com.ibm.xml.xci.internal.values.HexBinaryCData;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import com.ibm.xml.xml4j.internal.s1.impl.dv.ValidatedInfo;
import com.ibm.xml.xml4j.internal.s1.impl.dv.ValidationContext;
import com.ibm.xml.xml4j.internal.s1.impl.dv.XSSimpleType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.text.ParseException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class CastUtilities {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2008, 2009. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final XValidationContext validationContext;
    public static final ThreadLocal<ValidatedInfo> validatedInfos;
    public static final long UNSIGNED_INT_MAX_VALUE = 0xFFFFFFFFL;
    public static final int UNSIGNED_SHORT_MAX_VALUE = 65535;
    public static final short UNSIGNED_BYTE_MAX_VALUE = 255;
    public static final float BYTE_MAX_AS_FLOAT = 128.0f;
    public static final float BYTE_MIN_AS_FLOAT = -129.0f;
    public static final double BYTE_MAX_AS_DOUBLE = 128.0;
    public static final double BYTE_MIN_AS_DOUBLE = -129.0;
    public static final float SHORT_MAX_AS_FLOAT = 32768.0f;
    public static final float SHORT_MIN_AS_FLOAT = -32769.0f;
    public static final double SHORT_MAX_AS_DOUBLE = 32768.0;
    public static final double SHORT_MIN_AS_DOUBLE = -32769.0;
    public static final float INT_MAX_AS_FLOAT = 2.1474836E9f;
    public static final float INT_MIN_AS_FLOAT = -2.1474836E9f;
    public static final double INT_MAX_AS_DOUBLE = 2.147483648E9;
    public static final double INT_MIN_AS_DOUBLE = -2.147483649E9;
    public static final float LONG_MAX_AS_FLOAT = 9.223372E18f;
    public static final float LONG_MIN_AS_FLOAT = -9.223372E18f;
    public static final double LONG_MAX_AS_DOUBLE = 9.223372036854776E18;
    public static final double LONG_MIN_AS_DOUBLE = -9.223372036854776E18;
    public static final DatatypeFactory javaxFactory;

    public static XSSimpleTypeDefinition getCalendarType(XMLGregorianCalendar xMLGregorianCalendar) {
        QName qName = xMLGregorianCalendar.getXMLSchemaType();
        if (qName.equals(DatatypeConstants.DATETIME)) {
            return TypeRegistry.XSDATETIME;
        }
        if (qName.equals(DatatypeConstants.DATE)) {
            return TypeRegistry.XSDATE;
        }
        if (qName.equals(DatatypeConstants.TIME)) {
            return TypeRegistry.XSTIME;
        }
        if (qName.equals(DatatypeConstants.GDAY)) {
            return TypeRegistry.XSGDAY;
        }
        if (qName.equals(DatatypeConstants.GMONTH)) {
            return TypeRegistry.XSGMONTH;
        }
        if (qName.equals(DatatypeConstants.GYEAR)) {
            return TypeRegistry.XSGYEAR;
        }
        if (qName.equals(DatatypeConstants.GMONTHDAY)) {
            return TypeRegistry.XSGMONTHDAY;
        }
        if (qName.equals(DatatypeConstants.GYEARMONTH)) {
            return TypeRegistry.XSGYEARMONTH;
        }
        return null;
    }

    public static String typeString(int n2) {
        switch (n2) {
            case 2: {
                return "xs:string";
            }
            case 5: {
                return "xs:float";
            }
            case 6: {
                return "xs:double";
            }
            case 4: {
                return "xs:decimal";
            }
            case 30: {
                return "xs:integer";
            }
            case 7: {
                return "xs:duration";
            }
            case 8: {
                return "xs:dateTime";
            }
            case 9: {
                return "xs:time";
            }
            case 10: {
                return "xs:date";
            }
            case 11: {
                return "xs:gYearMonth";
            }
            case 12: {
                return "xs:gYear";
            }
            case 13: {
                return "xs:gMonthDay";
            }
            case 14: {
                return "xs:gDay";
            }
            case 15: {
                return "xs:gMonth";
            }
            case 3: {
                return "xs:boolean";
            }
            case 17: {
                return "xs:base64Binary";
            }
            case 16: {
                return "xs:hexBinary";
            }
            case 18: {
                return "xs:anyURI";
            }
            case 19: {
                return "xs:qName";
            }
            case 20: {
                return "xs:notation";
            }
            case 33: {
                return "xs:long";
            }
            case 34: {
                return "xs:int";
            }
            case 35: {
                return "xs:short";
            }
            case 36: {
                return "xs:byte";
            }
            case 38: {
                return "xs:unsignedLong";
            }
            case 39: {
                return "xs:unsignedInt";
            }
            case 40: {
                return "xs:unsignedShort";
            }
            case 41: {
                return "xs:unsignedByte";
            }
            case 31: {
                return "xs:nonPositiveInteger";
            }
            case 37: {
                return "xs:nonNegativeInteger";
            }
            case 42: {
                return "xs:positiveInteger";
            }
            case 32: {
                return "xs:negativeInteger";
            }
            case 21: {
                return "xs:normalizedString";
            }
            case 22: {
                return "xs:token";
            }
            case 23: {
                return "xs:language";
            }
            case 24: {
                return "xs:nmtoken";
            }
            case 25: {
                return "xs:name";
            }
            case 26: {
                return "xs:ncname";
            }
            case 27: {
                return "xs:id";
            }
            case 28: {
                return "xs:idref";
            }
            case 29: {
                return "xs:entity";
            }
        }
        return "";
    }

    static String padToFourDigitString(int n2) {
        String string2 = Integer.toString(Math.abs(n2));
        if (string2.length() == 1) {
            string2 = "000" + string2;
        } else if (string2.length() == 2) {
            string2 = "00" + string2;
        } else if (string2.length() == 3) {
            string2 = "0" + string2;
        }
        string2 = n2 < 0 ? "-" + string2 : string2;
        return string2;
    }

    static String padToTwoDigitString(int n2) {
        String string2 = Integer.toString(n2);
        return string2.length() == 1 ? "0" + string2 : string2;
    }

    public static CData castAtomic(CursorFactory cursorFactory, VolatileCData volatileCData, XSSimpleTypeDefinition xSSimpleTypeDefinition, NamespaceContext namespaceContext, boolean bl) {
        assert (!volatileCData.isEmptySequence() && volatileCData.getSize() == 1);
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = volatileCData.getXSTypeDefinition();
        assert (TypeHelper.isAtomic(xSSimpleTypeDefinition2));
        if (TypeHelper.isEqual(xSSimpleTypeDefinition2, xSSimpleTypeDefinition)) {
            return volatileCData.constant(false);
        }
        if (TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition2, TypeRegistry.XSSTRING) && TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSUNTYPEDATOMIC) || TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition2, TypeRegistry.XSUNTYPEDATOMIC) && TypeHelper.isEqualToBuiltInType(xSSimpleTypeDefinition, TypeRegistry.XSSTRING)) {
            return new StringCData(volatileCData.getString(1), xSSimpleTypeDefinition);
        }
        if (CastTable.getSimplePrimitiveType(xSSimpleTypeDefinition2) == CastTable.getSimplePrimitiveType(xSSimpleTypeDefinition)) {
            if (xSSimpleTypeDefinition2.derivedFromType(xSSimpleTypeDefinition, (short)2)) {
                return new BaseCDataWithChars(xSSimpleTypeDefinition, volatileCData);
            }
            if (bl) {
                XSSimpleType xSSimpleType = (XSSimpleType)xSSimpleTypeDefinition;
                try {
                    ValidatedInfo validatedInfo = validatedInfos.get();
                    validatedInfo.reset();
                    xSSimpleType.validate(volatileCData.getString(1), (ValidationContext)validationContext, validatedInfo);
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), xSSimpleTypeDefinition2.toString()}, invalidDatatypeValueException);
                }
            }
            return new BaseCDataWithChars(xSSimpleTypeDefinition, volatileCData);
        }
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 2: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 50: {
                String string2 = volatileCData.getString(1);
                if (!xSSimpleTypeDefinition.equals(TypeRegistry.XSSTRING) && !xSSimpleTypeDefinition.equals((short)50)) {
                    try {
                        CastUtilities.validate(string2, xSSimpleTypeDefinition);
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition.toString(), volatileCData.getXSTypeDefinition().toString()});
                    }
                }
                return cursorFactory.data((CharSequence)string2, xSSimpleTypeDefinition, true);
            }
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                return cursorFactory.data(volatileCData.getBigInteger(1), xSSimpleTypeDefinition, bl);
            }
            case 4: {
                return cursorFactory.data(volatileCData.getBigDecimal(1), xSSimpleTypeDefinition, bl);
            }
            case 33: {
                return cursorFactory.data(volatileCData.getLong(1), xSSimpleTypeDefinition, bl);
            }
            case 34: {
                return cursorFactory.data(volatileCData.getInt(1), xSSimpleTypeDefinition, bl);
            }
            case 35: {
                return cursorFactory.data(volatileCData.getShort(1), xSSimpleTypeDefinition, bl);
            }
            case 36: {
                return cursorFactory.data(volatileCData.getByte(1), xSSimpleTypeDefinition, bl);
            }
            case 6: {
                return cursorFactory.data(volatileCData.getDouble(1), xSSimpleTypeDefinition, bl);
            }
            case 5: {
                return cursorFactory.data(volatileCData.getFloat(1), xSSimpleTypeDefinition, bl);
            }
            case 3: {
                return cursorFactory.data(volatileCData.getBoolean(1), xSSimpleTypeDefinition, bl);
            }
            case 16: {
                return cursorFactory.data(volatileCData.getHexBinary(1), xSSimpleTypeDefinition, bl);
            }
            case 17: {
                return cursorFactory.data(volatileCData.getBase64Binary(1), xSSimpleTypeDefinition, bl);
            }
            case 19: {
                return cursorFactory.data(volatileCData.getQName(1, namespaceContext), xSSimpleTypeDefinition, bl);
            }
            case 18: {
                return cursorFactory.data((CharSequence)volatileCData.getURIString(1), xSSimpleTypeDefinition, bl);
            }
            case 7: 
            case 46: 
            case 47: {
                if (CastTable.primitiveCastableAs(xSSimpleTypeDefinition2, xSSimpleTypeDefinition) == CastTable.Castable.NO) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{xSSimpleTypeDefinition2.toString(), xSSimpleTypeDefinition.toString()});
                }
                try {
                    return cursorFactory.data(volatileCData.getDuration(1), xSSimpleTypeDefinition, bl);
                }
                catch (ParseException parseException) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition2.toString(), xSSimpleTypeDefinition.toString()}, parseException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition2.toString(), xSSimpleTypeDefinition.toString()}, illegalArgumentException);
                }
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                XMLGregorianCalendar xMLGregorianCalendar;
                if (CastTable.primitiveCastableAs(xSSimpleTypeDefinition2, xSSimpleTypeDefinition) == CastTable.Castable.NO) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{xSSimpleTypeDefinition2.toString(), xSSimpleTypeDefinition.toString()});
                }
                try {
                    xMLGregorianCalendar = volatileCData.getXMLGregorianCalendar(1);
                }
                catch (ParseException parseException) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition2.toString(), xSSimpleTypeDefinition.toString()}, parseException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition2.toString(), xSSimpleTypeDefinition.toString()}, illegalArgumentException);
                }
                try {
                    return cursorFactory.data(xMLGregorianCalendar, xSSimpleTypeDefinition, bl);
                }
                catch (XCIDynamicErrorException xCIDynamicErrorException) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST_DERIVED", new String[]{xSSimpleTypeDefinition2.toString(), xSSimpleTypeDefinition.toString()});
                }
            }
            case 20: {
                if (CastTable.primitiveCastableAs(xSSimpleTypeDefinition2, xSSimpleTypeDefinition) == CastTable.Castable.NO) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{xSSimpleTypeDefinition2.toString(), xSSimpleTypeDefinition.toString()});
                }
                if (TypeHelper.isEqual(xSSimpleTypeDefinition2, TypeRegistry.XSNOTATION) || TypeHelper.isEqual(xSSimpleTypeDefinition, TypeRegistry.XSNOTATION)) {
                    throw new XCIDynamicErrorException("ER_INVALID_CAST_NOTATION", new String[0]);
                }
                return cursorFactory.data(volatileCData.getQName(1, namespaceContext), xSSimpleTypeDefinition, bl);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{xSSimpleTypeDefinition2.toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, float f2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 6: {
                return cursorFactory.data(CastJV2Double.jVToDouble(f2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 4: {
                return cursorFactory.data(CastJV2Decimal.jVToDecimal(f2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 30: {
                return cursorFactory.data(CastJV2Integer.jVToInteger(f2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 34: {
                return cursorFactory.data(CastJV2Integer.jVToInt(f2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 35: {
                return cursorFactory.data(CastJV2Integer.jVToShort(f2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 33: {
                return cursorFactory.data(CastJV2Integer.jVToLong(f2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 36: {
                return cursorFactory.data(CastJV2Integer.jVToByte(f2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 3: {
                return cursorFactory.data(CastJV2Boolean.jVToBoolean(f2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 2: 
            case 50: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(f2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{TypeRegistry.XSFLOAT.toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, BigInteger bigInteger, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 6: {
                return cursorFactory.data(CastJV2Double.jVToDouble(bigInteger, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 5: {
                return cursorFactory.data(CastJV2Float.jVToFloat(bigInteger, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 4: {
                return cursorFactory.data(CastJV2Decimal.jVToDecimal(bigInteger, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 3: {
                return cursorFactory.data(CastJV2Boolean.jVToBoolean(bigInteger, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 2: 
            case 50: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(bigInteger, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{TypeRegistry.XSINTEGER.toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, int n2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 6: {
                return cursorFactory.data(CastJV2Double.jVToDouble(n2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 5: {
                return cursorFactory.data(CastJV2Float.jVToFloat(n2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 4: {
                return cursorFactory.data(CastJV2Decimal.jVToDecimal(n2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 3: {
                return cursorFactory.data(CastJV2Boolean.jVToBoolean(n2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 2: 
            case 50: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(n2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{TypeRegistry.XSINT.toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, short s, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 6: {
                return cursorFactory.data(CastJV2Double.jVToDouble(s, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 5: {
                return cursorFactory.data(CastJV2Float.jVToFloat(s, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 4: {
                return cursorFactory.data(CastJV2Decimal.jVToDecimal(s, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 3: {
                return cursorFactory.data(CastJV2Boolean.jVToBoolean(s, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 2: 
            case 50: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(s, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{TypeRegistry.XSSHORT.toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, long l, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 6: {
                return cursorFactory.data(CastJV2Double.jVToDouble(l, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 5: {
                return cursorFactory.data(CastJV2Float.jVToFloat(l, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 4: {
                return cursorFactory.data(CastJV2Decimal.jVToDecimal(l, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 3: {
                return cursorFactory.data(CastJV2Boolean.jVToBoolean(l, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 2: 
            case 50: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(l, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{TypeRegistry.XSLONG.toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, byte by2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 6: {
                return cursorFactory.data(CastJV2Double.jVToDouble(by2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 5: {
                return cursorFactory.data(CastJV2Float.jVToFloat(by2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 4: {
                return cursorFactory.data(CastJV2Decimal.jVToDecimal(by2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 3: {
                return cursorFactory.data(CastJV2Boolean.jVToBoolean(by2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 2: 
            case 50: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(by2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{TypeRegistry.XSBYTE.toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, double d, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 5: {
                return cursorFactory.data(CastJV2Float.jVToFloat(d, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 4: {
                return cursorFactory.data(CastJV2Decimal.jVToDecimal(d, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 30: {
                return cursorFactory.data(CastJV2Integer.jVToInteger(d, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 34: {
                return cursorFactory.data(CastJV2Integer.jVToInt(d, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 35: {
                return cursorFactory.data(CastJV2Integer.jVToShort(d, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 33: {
                return cursorFactory.data(CastJV2Integer.jVToLong(d, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 36: {
                return cursorFactory.data(CastJV2Integer.jVToByte(d, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 3: {
                return cursorFactory.data(CastJV2Boolean.jVToBoolean(d, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 2: 
            case 50: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(d, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{TypeRegistry.XSDOUBLE.toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition, Cursor cursor2, boolean bl) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 6: {
                return cursorFactory.data(CastJV2Double.jVToDouble(string2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 5: {
                return cursorFactory.data(CastJV2Float.jVToFloat(string2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 4: {
                return cursorFactory.data(CastJV2Decimal.jVToDecimal(string2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 30: {
                return cursorFactory.data(CastJV2Integer.jVToInteger(string2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 34: {
                return cursorFactory.data(CastJV2Integer.jVToInt(string2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 33: {
                return cursorFactory.data(CastJV2Integer.jVToLong(string2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 35: {
                return cursorFactory.data(CastJV2Integer.jVToShort(string2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 36: {
                return cursorFactory.data(CastJV2Integer.jVToByte(string2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 3: {
                return cursorFactory.data(CastJV2Boolean.jVToBoolean(string2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 19: {
                return cursorFactory.data(CastJV2QName.jVToQName(string2, xSSimpleTypeDefinition, cursor2, bl), xSSimpleTypeDefinition, false);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return cursorFactory.data(CastJV2XMLGregorianCalendar.jVToXMLGregorianCalendar(string2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 7: 
            case 46: 
            case 47: {
                return cursorFactory.data(CastJV2Duration.jVToDuration(string2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 16: {
                return new HexBinaryCData(string2, xSSimpleTypeDefinition);
            }
            case 17: {
                return new Base64BinaryCData(string2, xSSimpleTypeDefinition);
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(string2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{TypeRegistry.XSSTRING.toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, boolean bl, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl2) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 6: {
                return cursorFactory.data(CastJV2Double.jVToDouble(bl, xSSimpleTypeDefinition, bl2), xSSimpleTypeDefinition, false);
            }
            case 5: {
                return cursorFactory.data(CastJV2Float.jVToFloat(bl, xSSimpleTypeDefinition, bl2), xSSimpleTypeDefinition, false);
            }
            case 4: {
                return cursorFactory.data(CastJV2Decimal.jVToDecimal(bl, xSSimpleTypeDefinition, bl2), xSSimpleTypeDefinition, false);
            }
            case 30: {
                return cursorFactory.data(CastJV2Integer.jVToInteger(bl, xSSimpleTypeDefinition, bl2), xSSimpleTypeDefinition, false);
            }
            case 34: {
                return cursorFactory.data(CastJV2Integer.jVToInt(bl, xSSimpleTypeDefinition, bl2), xSSimpleTypeDefinition, false);
            }
            case 35: {
                return cursorFactory.data(CastJV2Integer.jVToShort(bl, xSSimpleTypeDefinition, bl2), xSSimpleTypeDefinition, false);
            }
            case 33: {
                return cursorFactory.data(CastJV2Integer.jVToLong(bl, xSSimpleTypeDefinition, bl2), xSSimpleTypeDefinition, false);
            }
            case 36: {
                return cursorFactory.data(CastJV2Integer.jVToByte(bl, xSSimpleTypeDefinition, bl2), xSSimpleTypeDefinition, false);
            }
            case 2: 
            case 50: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(bl, xSSimpleTypeDefinition, bl2), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{TypeRegistry.XSBOOLEAN.toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, BigDecimal bigDecimal, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 5: {
                return cursorFactory.data(CastJV2Float.jVToFloat(bigDecimal, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 6: {
                return cursorFactory.data(CastJV2Double.jVToDouble(bigDecimal, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 30: {
                return cursorFactory.data(CastJV2Integer.jVToInteger(bigDecimal, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 34: {
                return cursorFactory.data(CastJV2Integer.jVToInt(bigDecimal, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 35: {
                return cursorFactory.data(CastJV2Integer.jVToShort(bigDecimal, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 33: {
                return cursorFactory.data(CastJV2Integer.jVToLong(bigDecimal, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 36: {
                return cursorFactory.data(CastJV2Integer.jVToByte(bigDecimal, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 3: {
                return cursorFactory.data(CastJV2Boolean.jVToBoolean(bigDecimal, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 2: 
            case 50: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(bigDecimal, xSSimpleTypeDefinition, false), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{TypeRegistry.XSDECIMAL.toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, XMLGregorianCalendar xMLGregorianCalendar, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 2: 
            case 50: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(xMLGregorianCalendar, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return cursorFactory.data(CastJV2XMLGregorianCalendar.jVToXMLGregorianCalendar(xMLGregorianCalendar, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{xMLGregorianCalendar.getXMLSchemaType().toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, Duration duration2, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 2: 
            case 50: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(duration2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
            case 7: 
            case 46: 
            case 47: {
                return cursorFactory.data(CastJV2Duration.jVToDuration(duration2, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{duration2.getXMLSchemaType().toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, URI uRI, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 2: 
            case 50: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(uRI, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{TypeRegistry.XSANYURI.toString(), xSSimpleTypeDefinition.toString()});
    }

    public static CData convert(CursorFactory cursorFactory, QName qName, XSSimpleTypeDefinition xSSimpleTypeDefinition, boolean bl) throws InvalidDatatypeValueException {
        switch (xSSimpleTypeDefinition.getBuiltInKind()) {
            case 2: 
            case 50: {
                return cursorFactory.data((CharSequence)CastJV2String.jVToString(qName, xSSimpleTypeDefinition, bl), xSSimpleTypeDefinition, false);
            }
        }
        throw new XCIDynamicErrorException("ER_INVALID_CAST", new String[]{TypeRegistry.XSQNAME.toString(), xSSimpleTypeDefinition.toString()});
    }

    public static Object validate(String string2, XSSimpleTypeDefinition xSSimpleTypeDefinition) throws InvalidDatatypeValueException {
        ValidatedInfo validatedInfo = validatedInfos.get();
        validatedInfo.reset();
        return ((XSSimpleType)xSSimpleTypeDefinition).validate(string2, (ValidationContext)validationContext, validatedInfo);
    }

    static {
        DatatypeFactory datatypeFactory;
        validationContext = new XValidationContext(null);
        validatedInfos = new ThreadLocal<ValidatedInfo>(){

            @Override
            protected ValidatedInfo initialValue() {
                return new ValidatedInfo();
            }
        };
        try {
            datatypeFactory = JAXPFactoryHelper.newDatatypeFactory();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            datatypeFactory = null;
        }
        javaxFactory = datatypeFactory;
    }
}

